/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.awt.EventQueue;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;

public abstract class Invoker
implements Disposable {
    private static final int THRESHOLD = Integer.MAX_VALUE;
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final AtomicInteger UID = new AtomicInteger();
    private final Map<AsyncPromise<?>, ProgressIndicatorBase> indicators;
    private final AtomicInteger count;
    private final ThreeState useReadAction;
    private final String description;
    private volatile boolean disposed;

    private Invoker(@NotNull String prefix2, @NotNull Disposable parent, @NotNull ThreeState useReadAction) {
        if (prefix2 == null) {
            Invoker.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            Invoker.$$$reportNull$$$0(1);
        }
        if (useReadAction == null) {
            Invoker.$$$reportNull$$$0(2);
        }
        this.indicators = new ConcurrentHashMap();
        this.count = new AtomicInteger();
        this.description = "Invoker." + UID.getAndIncrement() + "." + prefix2 + (String)(useReadAction != ThreeState.UNSURE ? ".ReadAction=" + useReadAction : "") + ": " + parent;
        this.useReadAction = useReadAction;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public String toString() {
        return this.description;
    }

    public void dispose() {
        this.disposed = true;
        while (!this.indicators.isEmpty()) {
            this.indicators.keySet().forEach(AsyncPromise::cancel);
        }
    }

    public boolean isValidThread() {
        if (this.useReadAction != ThreeState.NO) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        return application == null || !application.isReadAccessAllowed();
    }

    @NotNull
    public final <T> CancellablePromise<T> compute(@NotNull Supplier<? extends T> task2) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(3);
        }
        return this.promise(new Task<T>(task2));
    }

    @NotNull
    public final <T> CancellablePromise<T> computeLater(@NotNull Supplier<? extends T> task2) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(4);
        }
        return this.computeLater(task2, 0);
    }

    @NotNull
    public final <T> CancellablePromise<T> computeLater(@NotNull Supplier<? extends T> task2, int delay) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(5);
        }
        return this.promise(new Task<T>(task2), delay);
    }

    @NotNull
    public final CancellablePromise<?> invoke(@NotNull Runnable task2) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(6);
        }
        return this.compute(new Wrapper(task2));
    }

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task2) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(7);
        }
        return this.invokeLater(task2, 0);
    }

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task2, int delay) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(8);
        }
        return this.computeLater(new Wrapper(task2), delay);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public final CancellablePromise<?> runOrInvokeLater(@NotNull Runnable task2) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(9);
        }
        return this.invoke(task2);
    }

    public final int getTaskCount() {
        return this.disposed ? 0 : this.count.get();
    }

    abstract void offer(@NotNull Runnable var1, int var2);

    private void offerSafely(@NotNull Task<?> task2, int attempt, int delay) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(10);
        }
        try {
            this.count.incrementAndGet();
            this.offer(() -> this.invokeSafely(task2, attempt), delay);
        }
        catch (RejectedExecutionException exception) {
            this.count.decrementAndGet();
            if (LOG.isTraceEnabled()) {
                LOG.debug("Executor is shutdown");
            }
            task2.promise.setError("shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSafely(@NotNull Task<?> task2, int attempt) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(11);
        }
        try {
            if (task2.canInvoke(this.disposed)) {
                if (ApplicationManager.getApplication() == null) {
                    task2.run();
                } else if (this.useReadAction != ThreeState.YES || EventQueue.isDispatchThread()) {
                    ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)this.indicator(task2.promise));
                } else if (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(task2, this.indicator(task2.promise))) {
                    this.offerRestart(task2, attempt);
                    return;
                }
                task2.setResult();
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException exception) {
            this.offerRestart(task2, attempt);
        }
        catch (Throwable throwable) {
            try {
                LOG.error(throwable);
            }
            finally {
                task2.promise.setError(throwable);
            }
        }
        finally {
            this.count.decrementAndGet();
        }
    }

    private void offerRestart(@NotNull Task<?> task2, int attempt) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(12);
        }
        if (task2.canRestart(this.disposed, attempt)) {
            this.offerSafely(task2, attempt + 1, 10);
            if (LOG.isTraceEnabled()) {
                LOG.debug("Task is restarted");
            }
        }
    }

    @NotNull
    private <T> CancellablePromise<T> promise(@NotNull Task<T> task2) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(13);
        }
        if (!this.isValidThread()) {
            return this.promise(task2, 0);
        }
        this.count.incrementAndGet();
        this.invokeSafely(task2, 0);
        AsyncPromise asyncPromise = task2.promise;
        if (asyncPromise == null) {
            Invoker.$$$reportNull$$$0(14);
        }
        return asyncPromise;
    }

    @NotNull
    private <T> CancellablePromise<T> promise(@NotNull Task<T> task2, int delay) {
        if (task2 == null) {
            Invoker.$$$reportNull$$$0(15);
        }
        if (delay < 0) {
            throw new IllegalArgumentException("delay must be non-negative: " + delay);
        }
        if (task2.canInvoke(this.disposed)) {
            this.offerSafely(task2, 0, delay);
        }
        AsyncPromise asyncPromise = task2.promise;
        if (asyncPromise == null) {
            Invoker.$$$reportNull$$$0(16);
        }
        return asyncPromise;
    }

    @NotNull
    private ProgressIndicatorBase indicator(@NotNull AsyncPromise<?> promise) {
        ProgressIndicatorBase indicator2;
        if (promise == null) {
            Invoker.$$$reportNull$$$0(17);
        }
        if ((indicator2 = this.indicators.get(promise)) == null) {
            indicator2 = new ProgressIndicatorBase(true, false);
            ProgressIndicatorBase old = this.indicators.put(promise, indicator2);
            if (old != null) {
                LOG.error("the same task is running in parallel");
            }
            promise.onProcessed(done -> this.indicators.remove(promise).cancel());
        }
        ProgressIndicatorBase progressIndicatorBase = indicator2;
        if (progressIndicatorBase == null) {
            Invoker.$$$reportNull$$$0(18);
        }
        return progressIndicatorBase;
    }

    private static void schedule(ScheduledExecutorService executor, Runnable runnable2, int delay) {
        if (delay > 0) {
            executor.schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
        } else {
            executor.execute(runnable2);
        }
    }

    @NotNull
    public static Invoker forEventDispatchThread(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(19);
        }
        return new EDT(parent);
    }

    @NotNull
    public static Invoker forBackgroundPoolWithReadAction(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(20);
        }
        return new Background(parent, ThreeState.YES, 8);
    }

    @NotNull
    public static Invoker forBackgroundPoolWithoutReadAction(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(21);
        }
        return new Background(parent, ThreeState.NO, 8);
    }

    @NotNull
    public static Invoker forBackgroundThreadWithReadAction(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(22);
        }
        return new Background(parent, ThreeState.YES, 1);
    }

    @NotNull
    public static Invoker forBackgroundThreadWithoutReadAction(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(23);
        }
        return new Background(parent, ThreeState.NO, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useReadAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/Invoker";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/Invoker";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "promise";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeLater";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runOrInvokeLater";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "offerSafely";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeSafely";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "offerRestart";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "promise";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "indicator";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forEventDispatchThread";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "forBackgroundPoolWithReadAction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "forBackgroundPoolWithoutReadAction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "forBackgroundThreadWithReadAction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forBackgroundThreadWithoutReadAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Background
    extends Invoker {
        private final Set<Thread> threads;
        private final ScheduledExecutorService executor;

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent) {
            if (parent == null) {
                Background.$$$reportNull$$$0(0);
            }
            this(parent, true);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent, int maxThreads) {
            if (parent == null) {
                Background.$$$reportNull$$$0(1);
            }
            this(parent, ThreeState.YES, maxThreads);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent, boolean useReadAction) {
            if (parent == null) {
                Background.$$$reportNull$$$0(2);
            }
            this(parent, ThreeState.fromBoolean((boolean)useReadAction));
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent, @NotNull ThreeState useReadAction) {
            if (parent == null) {
                Background.$$$reportNull$$$0(3);
            }
            if (useReadAction == null) {
                Background.$$$reportNull$$$0(4);
            }
            this(parent, useReadAction, 1);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public Background(@NotNull Disposable parent, @NotNull ThreeState useReadAction, int maxThreads) {
            if (parent == null) {
                Background.$$$reportNull$$$0(5);
            }
            if (useReadAction == null) {
                Background.$$$reportNull$$$0(6);
            }
            super((String)(maxThreads != 1 ? "Pool(" + maxThreads + ")" : "Thread"), parent, useReadAction);
            this.threads = ContainerUtil.newConcurrentSet();
            this.executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)this.toString(), (int)maxThreads);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.executor.shutdown();
        }

        @Override
        public boolean isValidThread() {
            return this.threads.contains(Thread.currentThread()) && super.isValidThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            if (runnable2 == null) {
                Background.$$$reportNull$$$0(7);
            }
            Invoker.schedule(this.executor, () -> {
                Thread thread = Thread.currentThread();
                if (!this.threads.add(thread)) {
                    LOG.error("current thread is already used");
                } else {
                    try {
                        runnable2.run();
                    }
                    finally {
                        if (!this.threads.remove(thread)) {
                            LOG.error("current thread is already removed");
                        }
                    }
                }
            }, delay);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useReadAction";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/concurrency/Invoker$Background";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static final class BackgroundThread
    extends Invoker {
        private final ScheduledExecutorService executor;
        private volatile Thread thread;

        public BackgroundThread(@NotNull Disposable parent) {
            if (parent == null) {
                BackgroundThread.$$$reportNull$$$0(0);
            }
            super("Background.Thread", parent, ThreeState.YES);
            this.executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)this.toString(), (int)1);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.executor.shutdown();
        }

        @Override
        public boolean isValidThread() {
            return this.thread == Thread.currentThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            if (runnable2 == null) {
                BackgroundThread.$$$reportNull$$$0(1);
            }
            Invoker.schedule(this.executor, () -> {
                if (this.thread != null) {
                    LOG.error("unexpected thread: " + this.thread);
                }
                try {
                    this.thread = Thread.currentThread();
                    runnable2.run();
                }
                finally {
                    this.thread = null;
                }
            }, delay);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/concurrency/Invoker$BackgroundThread";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class EDT
    extends Invoker {
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
        public EDT(@NotNull Disposable parent) {
            if (parent == null) {
                EDT.$$$reportNull$$$0(0);
            }
            super("EDT", parent, ThreeState.UNSURE);
        }

        @Override
        public boolean isValidThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            if (runnable2 == null) {
                EDT.$$$reportNull$$$0(1);
            }
            if (delay > 0) {
                EdtExecutorService.getScheduledExecutorInstance().schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                EdtExecutorService.getInstance().execute(runnable2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/concurrency/Invoker$EDT";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Wrapper
    implements Obsolescent,
    Supplier<Void> {
        private final Runnable task;

        Wrapper(@NotNull Runnable task2) {
            if (task2 == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            this.task = task2;
        }

        @Override
        public Void get() {
            this.task.run();
            return null;
        }

        public boolean isObsolete() {
            return this.task instanceof Obsolescent && ((Obsolescent)this.task).isObsolete();
        }

        public String toString() {
            return this.task.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/Invoker$Wrapper", "<init>"));
        }
    }

    static final class Task<T>
    implements Runnable {
        final AsyncPromise<T> promise;
        private final Supplier<? extends T> supplier;
        private volatile T result;

        Task(@NotNull Supplier<? extends T> supplier2) {
            if (supplier2 == null) {
                Task.$$$reportNull$$$0(0);
            }
            this.promise = new AsyncPromise();
            this.supplier = supplier2;
        }

        boolean canRestart(boolean disposed, int attempt) {
            if (LOG.isTraceEnabled()) {
                LOG.debug("Task is canceled");
            }
            if (attempt < Integer.MAX_VALUE) {
                return this.canInvoke(disposed);
            }
            LOG.warn("Task is always canceled: " + this.supplier);
            this.promise.setError("timeout");
            return false;
        }

        boolean canInvoke(boolean disposed) {
            Obsolescent obsolescent;
            if (this.promise.isDone()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("Promise is cancelled: ", new Object[]{this.promise.isCancelled()});
                }
                return false;
            }
            if (disposed) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("Invoker is disposed");
                }
                this.promise.setError("disposed");
                return false;
            }
            if (this.supplier instanceof Obsolescent && (obsolescent = (Obsolescent)this.supplier).isObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("Task is obsolete");
                }
                this.promise.setError("obsolete");
                return false;
            }
            return true;
        }

        void setResult() {
            this.promise.setResult(this.result);
        }

        @Override
        public void run() {
            this.result = this.supplier.get();
        }

        public String toString() {
            return "Invoker.Task: " + this.supplier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/util/concurrency/Invoker$Task", "<init>"));
        }
    }
}

