/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.tree.Reference;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StructureTreeModel<Structure extends AbstractTreeStructure>
extends AbstractTreeModel
implements Disposable,
InvokerSupplier,
ChildrenProvider<TreeNode> {
    private static final TreePath ROOT_INVALIDATED = new TreePath(new DefaultMutableTreeNode());
    private static final Logger LOG = Logger.getInstance(StructureTreeModel.class);
    private final Reference<Node> root;
    private final String description;
    private final Invoker invoker;
    private final Structure structure;
    private volatile Comparator<? super Node> comparator;

    public StructureTreeModel(@NotNull Structure structure, @NotNull Disposable parent) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            StructureTreeModel.$$$reportNull$$$0(1);
        }
        this(structure, null, parent);
    }

    public StructureTreeModel(@NotNull Structure structure, @Nullable Comparator<? super NodeDescriptor<?>> comparator2, @NotNull Disposable parent) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            StructureTreeModel.$$$reportNull$$$0(3);
        }
        this(structure, comparator2, Invoker.forBackgroundThreadWithReadAction(parent), parent);
    }

    public StructureTreeModel(@NotNull Structure structure, @Nullable Comparator<? super NodeDescriptor<?>> comparator2, @NotNull Invoker invoker, @NotNull Disposable parent) {
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(4);
        }
        if (invoker == null) {
            StructureTreeModel.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            StructureTreeModel.$$$reportNull$$$0(6);
        }
        this.root = new Reference();
        this.structure = structure;
        this.description = StructureTreeModel.format(structure.toString());
        this.invoker = invoker;
        this.comparator = comparator2 == null ? null : StructureTreeModel.wrapToNodeComparator(comparator2);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    private static Comparator<? super Node> wrapToNodeComparator(@NotNull Comparator<? super NodeDescriptor<?>> comparator2) {
        if (comparator2 == null) {
            StructureTreeModel.$$$reportNull$$$0(7);
        }
        Comparator comparator3 = (node1, node2) -> comparator2.compare((NodeDescriptor<?>)node1.getDescriptor(), (NodeDescriptor<?>)node2.getDescriptor());
        if (comparator3 == null) {
            StructureTreeModel.$$$reportNull$$$0(8);
        }
        return comparator3;
    }

    public final void setComparator(@Nullable Comparator<? super NodeDescriptor<?>> comparator2) {
        if (this.disposed) {
            return;
        }
        if (comparator2 != null) {
            this.comparator = StructureTreeModel.wrapToNodeComparator(comparator2);
            this.invalidate();
        } else if (this.comparator != null) {
            this.comparator = null;
            this.invalidate();
        }
    }

    public void dispose() {
        this.comparator = null;
        Node node = this.root.set(null);
        if (node != null) {
            node.dispose();
        }
        this.treeStructureChanged(null, null, null);
        super.dispose();
    }

    @Override
    @NotNull
    public final Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            StructureTreeModel.$$$reportNull$$$0(9);
        }
        return invoker;
    }

    private boolean isValidThread() {
        if (this.invoker.isValidThread()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException("StructureTreeModel is used from unexpected thread"));
        return false;
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull Function<? super Structure, ? extends Result> function) {
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(10);
        }
        AsyncPromise promise = new AsyncPromise();
        this.invoker.invoke(() -> {
            Object result2;
            if (!this.disposed && (result2 = function.apply((Structure)this.structure)) != null) {
                promise.setResult(result2);
            }
            if (!promise.isDone()) {
                promise.cancel();
            }
        }).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            StructureTreeModel.$$$reportNull$$$0(11);
        }
        return asyncPromise;
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull TreePath path2, @NotNull Function<? super Node, ? extends Result> function) {
        Object component2;
        if (path2 == null) {
            StructureTreeModel.$$$reportNull$$$0(12);
        }
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(13);
        }
        if ((component2 = path2.getLastPathComponent()) instanceof Node) {
            Node node = (Node)component2;
            return this.onValidThread(__ -> this.disposed || this.isNodeRemoved(node) ? null : function.apply(node));
        }
        Promise promise = Promises.rejectedPromise((String)("unexpected node: " + component2));
        if (promise == null) {
            StructureTreeModel.$$$reportNull$$$0(14);
        }
        return promise;
    }

    @NotNull
    private <Result> Promise<Result> onValidThread(@NotNull Object element2, @NotNull Function<? super Node, ? extends Result> function) {
        if (element2 == null) {
            StructureTreeModel.$$$reportNull$$$0(15);
        }
        if (function == null) {
            StructureTreeModel.$$$reportNull$$$0(16);
        }
        return this.onValidThread(struct -> {
            Node node = this.root.get();
            if (node == null) {
                return null;
            }
            if (node.matches(element2)) {
                return function.apply(node);
            }
            ArrayDeque<Object> stack = new ArrayDeque<Object>();
            Object e = element2;
            while (e != null) {
                stack.push(e);
                e = struct.getParentElement(e);
            }
            if (!node.matches(stack.pop())) {
                return null;
            }
            while (!stack.isEmpty()) {
                if ((node = node.findChild(stack.pop())) != null) continue;
                return null;
            }
            return function.apply(node);
        });
    }

    @NotNull
    public final Promise<?> invalidate() {
        return this.onValidThread(__ -> this.invalidateInternal(null, true));
    }

    @NotNull
    public final Promise<TreePath> invalidate(@NotNull TreePath path2, boolean structure) {
        if (path2 == null) {
            StructureTreeModel.$$$reportNull$$$0(17);
        }
        return this.onValidThread(path2, (? super Node node) -> this.invalidateInternal((Node)node, structure));
    }

    @NotNull
    public final Promise<TreePath> invalidate(@NotNull Object element2, boolean structure) {
        if (element2 == null) {
            StructureTreeModel.$$$reportNull$$$0(18);
        }
        return this.onValidThread(element2, (? super Node node) -> this.invalidateInternal((Node)node, structure));
    }

    @Nullable
    private TreePath invalidateInternal(@Nullable Node node, boolean structure) {
        assert (this.invoker.isValidThread());
        while (node != null && !this.isValid(node)) {
            if (LOG.isTraceEnabled()) {
                LOG.debug("invalid element cannot be updated: ", new Object[]{node});
            }
            node = (Node)node.getParent();
            structure = true;
        }
        if (node == null) {
            node = this.root.get();
            if (node != null) {
                node.invalidate();
            }
            this.root.invalidate();
            if (LOG.isTraceEnabled()) {
                LOG.debug("root invalidated: ", new Object[]{node});
            }
            this.treeStructureChanged(null, null, null);
            return ROOT_INVALIDATED;
        }
        boolean updated = node.update();
        if (structure) {
            node.invalidate();
            TreePath path2 = TreePathUtil.pathToTreeNode(node);
            this.treeStructureChanged(path2, null, null);
            return path2;
        }
        if (updated) {
            TreePath path3 = TreePathUtil.pathToTreeNode(node);
            this.treeNodesChanged(path3, null, null);
            return path3;
        }
        return null;
    }

    public final void expand(@NotNull Object element2, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        if (element2 == null) {
            StructureTreeModel.$$$reportNull$$$0(19);
        }
        if (tree == null) {
            StructureTreeModel.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(21);
        }
        this.promiseVisitor(element2).onSuccess(visitor -> TreeUtil.expand((JTree)tree, (TreeVisitor)visitor, (Consumer)consumer));
    }

    public final void makeVisible(@NotNull Object element2, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        if (element2 == null) {
            StructureTreeModel.$$$reportNull$$$0(22);
        }
        if (tree == null) {
            StructureTreeModel.$$$reportNull$$$0(23);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(24);
        }
        this.promiseVisitor(element2).onSuccess(visitor -> TreeUtil.makeVisible((JTree)tree, (TreeVisitor)visitor, (Consumer)consumer));
    }

    public final void select(@NotNull Object element2, @NotNull JTree tree, @NotNull Consumer<? super TreePath> consumer) {
        if (element2 == null) {
            StructureTreeModel.$$$reportNull$$$0(25);
        }
        if (tree == null) {
            StructureTreeModel.$$$reportNull$$$0(26);
        }
        if (consumer == null) {
            StructureTreeModel.$$$reportNull$$$0(27);
        }
        this.promiseVisitor(element2).onSuccess(visitor -> TreeUtil.promiseSelect((JTree)tree, (TreeVisitor)visitor).onSuccess(consumer));
    }

    @NotNull
    public final Promise<TreeVisitor> promiseVisitor(@NotNull Object element2) {
        if (element2 == null) {
            StructureTreeModel.$$$reportNull$$$0(28);
        }
        return this.onValidThread(struct -> new TreeVisitor.ByTreePath(TreePathUtil.pathToCustomNode(element2, arg_0 -> ((AbstractTreeStructure)struct).getParentElement(arg_0)), node -> node instanceof Node ? ((Node)node).getElement() : null));
    }

    public final TreeNode getRoot() {
        if (this.disposed || !this.isValidThread()) {
            return null;
        }
        if (!this.root.isValid()) {
            Node newRoot = this.getValidRoot();
            this.root.set(newRoot);
            if (LOG.isTraceEnabled()) {
                LOG.debug("root updated: ", new Object[]{newRoot});
            }
        }
        return this.root.get();
    }

    private Node getNode(Object object, boolean validateChildren) {
        if (this.disposed || !(object instanceof Node) || !this.isValidThread()) {
            return null;
        }
        Node node = (Node)object;
        if (this.isNodeRemoved(node)) {
            return null;
        }
        if (validateChildren) {
            this.validateChildren(node);
        }
        return node;
    }

    private void validateChildren(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(29);
        }
        if (!node.children.isValid()) {
            List<Node> newChildren = this.getValidChildren(node);
            List<Node> oldChildren = node.children.set(newChildren);
            if (oldChildren != null) {
                oldChildren.forEach(child2 -> child2.setParent(null));
            }
            if (newChildren != null) {
                newChildren.forEach(child2 -> child2.setParent(node));
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("children updated: ", new Object[]{node});
            }
        }
    }

    private boolean isNodeRemoved(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(30);
        }
        return !node.isNodeAncestor(this.root.get());
    }

    @Override
    public final List<TreeNode> getChildren(Object object) {
        List<Node> list2;
        Node node = this.getNode(object, true);
        List<Node> list3 = list2 = node == null ? null : node.children.get();
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        list2.forEach(rec$ -> ((Node)rec$).update());
        return Collections.unmodifiableList(list2);
    }

    public final int getChildCount(Object object) {
        Node node = this.getNode(object, true);
        return node == null ? 0 : node.getChildCount();
    }

    public final TreeNode getChild(Object object, int index2) {
        Node node = this.getNode(object, true);
        return node == null ? null : node.getChildAt(index2);
    }

    public final boolean isLeaf(Object object) {
        Node node = this.getNode(object, false);
        return node == null || node.isLeaf(this::validateChildren);
    }

    public final int getIndexOfChild(Object object, Object child2) {
        return object instanceof Node && child2 instanceof Node ? ((Node)object).getIndex((TreeNode)child2) : -1;
    }

    private boolean isValid(@NotNull Node node) {
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(31);
        }
        return StructureTreeModel.isValid(this.structure, node.getElement());
    }

    private static boolean isValid(@NotNull AbstractTreeStructure structure, Object element2) {
        AbstractTreeNode node;
        if (structure == null) {
            StructureTreeModel.$$$reportNull$$$0(32);
        }
        if (element2 == null) {
            return false;
        }
        if (element2 instanceof AbstractTreeNode && null == (node = (AbstractTreeNode)element2).getValue()) {
            return false;
        }
        if (element2 instanceof ValidateableNode && !(node = (ValidateableNode)element2).isValid()) {
            return false;
        }
        return structure.isValid(element2);
    }

    @Nullable
    private Node getValidRoot() {
        Object element2 = this.structure.getRootElement();
        if (!StructureTreeModel.isValid(this.structure, element2)) {
            return null;
        }
        Node newNode = new Node((AbstractTreeStructure)this.structure, element2, null);
        Node oldNode = this.root.get();
        if (oldNode != null && oldNode.canReuse(newNode, element2)) {
            return oldNode;
        }
        return newNode;
    }

    @Nullable
    private List<Node> getValidChildren(@NotNull Node node) {
        NodeDescriptor<?> descriptor2;
        if (node == null) {
            StructureTreeModel.$$$reportNull$$$0(33);
        }
        if ((descriptor2 = node.getDescriptor()) == null) {
            return null;
        }
        Object parent = descriptor2.getElement();
        if (!StructureTreeModel.isValid(this.structure, parent)) {
            return null;
        }
        Object[] elements = this.structure.getChildElements(parent);
        if (elements.length == 0) {
            return null;
        }
        ArrayList<Node> list2 = new ArrayList<Node>(elements.length);
        for (Object object : elements) {
            ProgressManager.checkCanceled();
            if (!StructureTreeModel.isValid(this.structure, object)) continue;
            list2.add(new Node((AbstractTreeStructure)this.structure, object, descriptor2));
        }
        Comparator<? super Node> comparator2 = this.comparator;
        if (comparator2 != null) {
            try {
                list2.sort(comparator2);
            }
            catch (IllegalArgumentException exception) {
                StringBuilder sb = new StringBuilder("unexpected sorting failed in ");
                sb.append(this);
                for (Node next : list2) {
                    sb.append('\n').append(next);
                }
                LOG.error(sb.toString(), (Throwable)exception);
            }
        }
        HashMap map2 = new HashMap();
        node.getChildren().forEach(child2 -> {
            ProgressManager.checkCanceled();
            Object element2 = child2.getElement();
            if (element2 != null) {
                map2.put(element2, child2);
            }
        });
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            ProgressManager.checkCanceled();
            Node node2 = (Node)list2.get(i2);
            Node oldNode = (Node)map2.get(node2.getElement());
            if (oldNode == null || !oldNode.canReuse(node2, null)) continue;
            list2.set(i2, oldNode);
        }
        return list2;
    }

    @Deprecated
    public final TreeNode getRootImmediately() {
        if (!this.root.isValid()) {
            this.root.set(this.getValidRoot());
        }
        return this.root.get();
    }

    public String toString() {
        return this.description;
    }

    @NotNull
    private static String format(@NotNull String prefix2) {
        if (prefix2 == null) {
            StructureTreeModel.$$$reportNull$$$0(34);
        }
        for (StackTraceElement element2 : new Exception().getStackTrace()) {
            if (StructureTreeModel.class.getName().equals(element2.getClassName())) continue;
            String string = prefix2 + " @ " + element2.getFileName() + " : " + element2.getLineNumber();
            if (string == null) {
                StructureTreeModel.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = prefix2;
        if (string == null) {
            StructureTreeModel.$$$reportNull$$$0(36);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/StructureTreeModel";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 21: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToNodeComparator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "onValidThread";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapToNodeComparator";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 35: 
            case 36: {
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "makeVisible";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "promiseVisitor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "validateChildren";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isNodeRemoved";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getValidChildren";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node
    extends DefaultMutableTreeNode
    implements LeafState.Supplier {
        private final Reference<List<Node>> children;
        private LeafState leafState;
        private final int hashCode;

        private Node(@NotNull AbstractTreeStructure structure, @NotNull Object element2, NodeDescriptor<?> parent) {
            if (structure == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                Node.$$$reportNull$$$0(1);
            }
            this(structure.createDescriptor(element2, parent), structure.getLeafState(element2), element2.hashCode());
        }

        private Node(@NotNull NodeDescriptor descriptor2, @NotNull LeafState leafState, int hashCode) {
            if (descriptor2 == null) {
                Node.$$$reportNull$$$0(2);
            }
            if (leafState == null) {
                Node.$$$reportNull$$$0(3);
            }
            super(descriptor2, leafState != LeafState.ALWAYS);
            this.children = new Reference();
            this.hashCode = hashCode;
            this.setLeafState(leafState);
            this.update();
        }

        private void dispose() {
            this.setParent(null);
            List list2 = this.children.set(null);
            if (list2 != null) {
                list2.forEach(Node::dispose);
            }
        }

        private boolean canReuse(@NotNull Node node, Object element2) {
            if (node == null) {
                Node.$$$reportNull$$$0(4);
            }
            if (this.allowsChildren != node.allowsChildren || this.hashCode != node.hashCode) {
                return false;
            }
            if (element2 != null && !this.matches(element2)) {
                return false;
            }
            this.userObject = node.userObject;
            this.setLeafState(this.leafState);
            return true;
        }

        private boolean update() {
            NodeDescriptor<?> descriptor2 = this.getDescriptor();
            return descriptor2 != null && descriptor2.update();
        }

        private void invalidate() {
            if (this.leafState != LeafState.ALWAYS) {
                this.children.invalidate();
                if (LOG.isTraceEnabled()) {
                    LOG.debug("node invalidated: ", new Object[]{this});
                }
                this.getChildren().forEach(Node::invalidate);
            }
        }

        private boolean matches(@NotNull Object element2) {
            if (element2 == null) {
                Node.$$$reportNull$$$0(5);
            }
            return this.matches(element2, element2.hashCode());
        }

        private boolean matches(@NotNull Object element2, int hashCode) {
            if (element2 == null) {
                Node.$$$reportNull$$$0(6);
            }
            return this.hashCode == hashCode && element2.equals(this.getElement());
        }

        private Node findChild(@NotNull Object element2) {
            List<Node> list2;
            if (element2 == null) {
                Node.$$$reportNull$$$0(7);
            }
            if ((list2 = this.children.get()) != null) {
                int hashCode;
                Node result2;
                if (!list2.isEmpty() && (result2 = (Node)ContainerUtil.find(list2, arg_0 -> Node.lambda$findChild$0(element2, hashCode = element2.hashCode(), arg_0))) != null) {
                    return result2;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.debug("node '", new Object[]{this.getElement(), "' have no child: ", element2});
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.debug("node '", new Object[]{this.getElement(), "' have no loaded children"});
            }
            return null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children.get();
            List<Node> list3 = list2 != null ? list2 : Collections.emptyList();
            if (list3 == null) {
                Node.$$$reportNull$$$0(8);
            }
            return list3;
        }

        private NodeDescriptor<?> getDescriptor() {
            Object object = this.getUserObject();
            return object instanceof NodeDescriptor ? (NodeDescriptor)object : null;
        }

        private Object getElement() {
            NodeDescriptor<?> descriptor2 = this.getDescriptor();
            return descriptor2 == null ? null : descriptor2.getElement();
        }

        @Override
        public void setUserObject(Object object) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public void setAllowsChildren(boolean value2) {
            throw new UnsupportedOperationException("cannot modify node");
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException("cannot clone node");
        }

        @Override
        public void insert(MutableTreeNode child2, int index2) {
            throw new UnsupportedOperationException("cannot insert node");
        }

        @Override
        public void remove(int index2) {
            throw new UnsupportedOperationException("cannot remove node");
        }

        public Enumeration children() {
            return Collections.enumeration(this.getChildren());
        }

        @Override
        public TreeNode getChildAt(int index2) {
            List<Node> list2 = this.getChildren();
            return 0 <= index2 && index2 < list2.size() ? (TreeNode)list2.get(index2) : null;
        }

        @Override
        public int getChildCount() {
            return this.getChildren().size();
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf(null);
        }

        private boolean isLeaf(@Nullable Consumer<? super Node> validator) {
            if (null == this.getParent()) {
                return false;
            }
            if (this.leafState == LeafState.ALWAYS) {
                return true;
            }
            if (this.leafState == LeafState.NEVER) {
                return false;
            }
            if (this.leafState == LeafState.DEFAULT && validator != null) {
                validator.accept(this);
            }
            return this.children.isValid() && super.isLeaf();
        }

        private void setLeafState(@NotNull LeafState leafState) {
            if (leafState == null) {
                Node.$$$reportNull$$$0(9);
            }
            this.leafState = leafState;
            if (leafState == LeafState.ALWAYS) {
                this.children.set(null);
            }
        }

        @Override
        public int getIndex(@NotNull TreeNode child2) {
            if (child2 == null) {
                Node.$$$reportNull$$$0(10);
            }
            return child2 instanceof Node && this.isNodeChild(child2) ? this.getChildren().indexOf(child2) : -1;
        }

        @NotNull
        public LeafState getLeafState() {
            LeafState leafState = this.leafState;
            if (leafState == null) {
                Node.$$$reportNull$$$0(11);
            }
            return leafState;
        }

        private static /* synthetic */ boolean lambda$findChild$0(Object element2, int hashCode, Node node) {
            return node.matches(element2, hashCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "structure";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leafState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/StructureTreeModel$Node";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/StructureTreeModel$Node";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeafState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "canReuse";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findChild";
                    break;
                }
                case 8: 
                case 11: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setLeafState";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

