/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.stripe;

import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.RegionPainter;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorStripePainter
extends RegionPainter.Image {
    private final boolean mySingleValue;
    private final Alignment myAlignment;
    private Value[] myArray;
    private int myArraySize;
    private int myImageY;
    private int myImageHeight;
    private int myMax = Integer.MAX_VALUE;
    private int myMin = 1;
    private int myGap;

    public ErrorStripePainter(boolean single) {
        this(single, Alignment.CENTER);
    }

    ErrorStripePainter(boolean single, @Nullable Alignment style) {
        this.mySingleValue = single;
        this.myAlignment = style;
    }

    int getMaximalThickness() {
        return this.myMax;
    }

    public void setMaximalThickness(int thickness) {
        if (this.myMax != thickness) {
            this.myMax = thickness;
            this.invalidate();
        }
    }

    int getMinimalThickness() {
        return this.myMin;
    }

    public void setMinimalThickness(int thickness) {
        if (thickness < 1) {
            thickness = 1;
        }
        if (this.myMin != thickness) {
            this.myMin = thickness;
            this.invalidate();
        }
    }

    int getErrorStripeGap() {
        return this.myGap;
    }

    public void setErrorStripeGap(int gap) {
        if (gap < 0) {
            gap = 0;
        }
        if (this.myGap != gap) {
            this.myGap = gap;
            this.invalidate();
        }
    }

    public int findIndex(int x, int y) {
        int index2;
        if (0 < this.myImageHeight && this.myImageY <= y && (index2 = this.myArraySize * (y - this.myImageY) / this.myImageHeight) < this.myArraySize) {
            return index2;
        }
        return -1;
    }

    int getErrorStripeCount() {
        return this.myArraySize;
    }

    public void setErrorStripeCount(int count) {
        if (count < 0) {
            count = 0;
        }
        if (this.myArray == null) {
            this.myArray = new Value[count];
        } else if (this.myArray.length < count) {
            this.myArray = (Value[])ArrayUtil.realloc((Object[])this.myArray, (int)count, Value[]::new);
        }
        if (this.myArraySize != count) {
            this.myArraySize = count;
            this.invalidate();
        }
    }

    public boolean isModified() {
        for (int index2 = 0; index2 < this.myArraySize; ++index2) {
            Value value2 = this.myArray[index2];
            if (value2 == null || !value2.myModified) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (int index2 = 0; index2 < this.myArraySize; ++index2) {
            Value value2 = this.myArray[index2];
            if (value2 == null) continue;
            value2.set(null);
        }
    }

    public void clear(int index2) {
        Value value2 = this.getValue(index2, false);
        if (value2 != null) {
            value2.set(null);
        }
    }

    ErrorStripe getErrorStripe(int index2) {
        Value value2 = this.getValue(index2, false);
        return value2 == null ? null : value2.get();
    }

    void setErrorStripe(int index2, ErrorStripe stripe) {
        Value value2 = this.getValue(index2, stripe != null);
        if (value2 != null) {
            value2.set(stripe);
        }
    }

    public void addErrorStripe(int index2, ErrorStripe stripe) {
        Value value2 = this.getValue(index2, stripe != null);
        if (value2 != null) {
            value2.add(stripe);
        }
    }

    private Value getValue(int index2, boolean create2) {
        if (0 > index2 || index2 >= this.myArraySize) {
            return null;
        }
        if (create2 && null == this.myArray[index2]) {
            this.myArray[index2] = this.mySingleValue ? new SingleValue() : new ComplexValue();
        }
        return this.myArray[index2];
    }

    private int getOffset(int height, int thickness) {
        if (height > thickness) {
            if (this.myAlignment == Alignment.CENTER) {
                return (height - thickness) / 2;
            }
            if (this.myAlignment == Alignment.BOTTOM) {
                return height - thickness;
            }
        }
        return 0;
    }

    private void updateImage(BufferedImage image, boolean force) {
        int width = ImageUtil.getUserWidth((Image)image);
        int height = ImageUtil.getUserHeight((Image)image);
        Graphics2D g = image.createGraphics();
        this.myImageHeight = 0;
        int max = height / this.myArraySize;
        int min = this.myMin + this.myGap;
        if (max < min) {
            max = height / min;
            int currentIndex = 0;
            SingleValue currentValue = new SingleValue();
            for (int index2 = 0; index2 < this.myArraySize; ++index2) {
                Value value2 = this.myArray[index2];
                int i2 = index2 * max / this.myArraySize;
                if (i2 > currentIndex) {
                    currentValue.paint(g, 0, this.myImageHeight, width, min, force);
                    this.myImageHeight += min;
                    currentIndex = i2;
                    currentValue.myStripe = value2 == null ? null : value2.get();
                    currentValue.myModified = value2 != null && value2.myModified;
                } else if (value2 != null) {
                    ErrorStripe stripe = value2.get();
                    if (stripe != null && stripe.compareTo(currentValue.myStripe) < 0) {
                        currentValue.myStripe = stripe;
                    }
                    if (value2.myModified) {
                        currentValue.myModified = true;
                    }
                }
                if (value2 == null) continue;
                value2.myModified = false;
            }
            currentValue.paint(g, 0, this.myImageHeight, width, min, force);
            this.myImageHeight += min;
        } else {
            if (max > this.myMax) {
                max = Math.max(this.myMax, min);
            }
            for (int index3 = 0; index3 < this.myArraySize; ++index3) {
                Value value3 = this.myArray[index3];
                if (value3 != null) {
                    value3.paint(g, 0, this.myImageHeight, width, max, force);
                    value3.myModified = false;
                }
                this.myImageHeight += max;
            }
        }
        g.dispose();
    }

    protected void updateImage(BufferedImage image) {
        if (this.isModified()) {
            this.updateImage(image, false);
        }
    }

    protected BufferedImage createImage(int width, int height) {
        BufferedImage image;
        BufferedImage bufferedImage = image = this.myArraySize == 0 ? null : super.createImage(width, height);
        if (image != null) {
            this.updateImage(image, true);
        }
        return image;
    }

    public void paint(@NotNull Graphics2D g, int x, int y, int width, int height, Object object) {
        if (g == null) {
            ErrorStripePainter.$$$reportNull$$$0(0);
        }
        this.myImageY = y;
        super.paint(g, x, y, width, height, object);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/stripe/ErrorStripePainter", "paint"));
    }

    private final class ComplexValue
    extends Value {
        private TreeSet<ErrorStripe> mySet;

        private ComplexValue() {
        }

        @Override
        boolean set(ErrorStripe stripe) {
            if (this.add(stripe)) {
                return true;
            }
            if (this.mySet == null || this.mySet.isEmpty()) {
                return false;
            }
            this.mySet.clear();
            this.myModified = true;
            return true;
        }

        @Override
        boolean add(ErrorStripe stripe) {
            if (stripe == null) {
                return false;
            }
            if (this.mySet == null) {
                this.mySet = new TreeSet();
            }
            this.mySet.add(stripe);
            this.myModified = true;
            return true;
        }

        @Override
        ErrorStripe get() {
            if (this.mySet == null) {
                return null;
            }
            Iterator<ErrorStripe> iterator2 = this.mySet.iterator();
            return iterator2.hasNext() ? iterator2.next() : null;
        }

        @Override
        void paint(Graphics2D g, int x, int y, int width, int height) {
            Iterator<ErrorStripe> iterator2;
            if (this.mySet != null && (iterator2 = this.mySet.iterator()).hasNext()) {
                int thickness;
                int n = thickness = ErrorStripePainter.this.myAlignment != null ? ErrorStripePainter.this.myMin + ErrorStripePainter.this.myGap : height;
                if (thickness < height) {
                    int count = Math.min(height / thickness, this.mySet.size());
                    y += ErrorStripePainter.this.getOffset(height, thickness * count);
                    do {
                        g.setColor(iterator2.next().getColor());
                        g.fillRect(x, y, width, thickness - ErrorStripePainter.this.myGap);
                        y += thickness;
                    } while (--count > 0 && iterator2.hasNext());
                } else {
                    g.setColor(iterator2.next().getColor());
                    g.fillRect(x, y, width, thickness - ErrorStripePainter.this.myGap);
                }
            }
        }
    }

    private final class SingleValue
    extends Value {
        private ErrorStripe myStripe;

        private SingleValue() {
        }

        @Override
        boolean set(ErrorStripe stripe) {
            if (stripe == null ? this.myStripe == null : stripe.equals(this.myStripe)) {
                return false;
            }
            this.myStripe = stripe;
            this.myModified = true;
            return true;
        }

        @Override
        boolean add(ErrorStripe stripe) {
            if (stripe == null || stripe.compareTo(this.myStripe) >= 0) {
                return false;
            }
            this.myStripe = stripe;
            this.myModified = true;
            return true;
        }

        @Override
        ErrorStripe get() {
            return this.myStripe;
        }

        @Override
        void paint(Graphics2D g, int x, int y, int width, int height) {
            if (this.myStripe != null) {
                int thickness = ErrorStripePainter.this.myAlignment != null ? ErrorStripePainter.this.myMin + ErrorStripePainter.this.myGap : height;
                g.setColor(this.myStripe.getColor());
                g.fillRect(x, y += ErrorStripePainter.this.getOffset(height, thickness), width, thickness - ErrorStripePainter.this.myGap);
            }
        }
    }

    private static abstract class Value {
        boolean myModified;

        private Value() {
        }

        abstract boolean set(ErrorStripe var1);

        abstract boolean add(ErrorStripe var1);

        abstract ErrorStripe get();

        abstract void paint(Graphics2D var1, int var2, int var3, int var4, int var5);

        void paint(Graphics2D g, int x, int y, int width, int height, boolean force) {
            if (force || this.myModified) {
                if (!force) {
                    Composite old = g.getComposite();
                    g.setComposite(AlphaComposite.Clear);
                    g.fillRect(x, y, width, height);
                    g.setComposite(old);
                }
                this.paint(g, x, y, width, height);
            }
        }
    }

    public static enum Alignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

