/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Consumer;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class PopupTreeAdapter<T>
implements PopupChooserBuilder.PopupComponentAdapter<T> {
    private final PopupChooserBuilder myBuilder;
    private final JTree myTree;

    PopupTreeAdapter(PopupChooserBuilder builder2, JTree tree) {
        this.myBuilder = builder2;
        this.myTree = tree;
    }

    public JComponent getComponent() {
        return this.myTree;
    }

    public void setItemChosenCallback(Consumer<? super T> callback2) {
        this.myBuilder.setItemChoosenCallback(() -> {
            TreePath path2 = this.myTree.getSelectionModel().getLeadSelectionPath();
            Object component2 = path2.getLastPathComponent();
            if (component2 != null) {
                callback2.consume(component2);
            }
        });
    }

    public void setItemsChosenCallback(Consumer<? super Set<T>> callback2) {
        this.myBuilder.setItemChoosenCallback(() -> {
            HashSet<Object> selection = new HashSet<Object>();
            for (TreePath path2 : this.myTree.getSelectionModel().getSelectionPaths()) {
                Object component2 = path2.getLastPathComponent();
                if (component2 == null) continue;
                selection.add(component2);
            }
            if (!selection.isEmpty()) {
                callback2.consume(selection);
            }
        });
    }

    public JScrollPane createScrollPane() {
        TreeUtil.expandAll((JTree)this.myTree);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (this.myTree.getSelectionCount() == 0) {
            this.myTree.setSelectionRow(0);
        }
        if (this.myTree.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(this.myTree.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(this.myTree.getPreferredSize());
        }
        if (this.myBuilder.isAutoselectOnMouseMove()) {
            this.myTree.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        Point p = e.getPoint();
                        int index2 = PopupTreeAdapter.this.myTree.getRowForLocation(p.x, p.y);
                        PopupTreeAdapter.this.myTree.setSelectionRow(index2);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
        }
        return scrollPane;
    }
}

