/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.popup.util.PopupImplUtil;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PopupListAdapter<T>
implements PopupChooserBuilder.PopupComponentAdapter<T> {
    private final JList<T> myList;
    private final PopupChooserBuilder<T> myBuilder;
    private ListWithFilter<T> myListWithFilter;

    PopupListAdapter(PopupChooserBuilder<T> builder2, JList<T> list2) {
        this.myBuilder = builder2;
        this.myList = list2;
    }

    public JComponent getComponent() {
        return this.myList;
    }

    public void setRenderer(ListCellRenderer<? super T> renderer) {
        this.myList.setCellRenderer(renderer);
    }

    public void setItemChosenCallback(Consumer<? super T> callback2) {
        this.myBuilder.setItemChoosenCallback(() -> {
            T selectedValue = this.myList.getSelectedValue();
            if (selectedValue != null) {
                callback2.consume(selectedValue);
            }
        });
    }

    public void setItemsChosenCallback(Consumer<? super Set<T>> callback2) {
        this.myBuilder.setItemChoosenCallback(() -> {
            List<T> list2 = this.myList.getSelectedValuesList();
            callback2.consume((Object)(list2 != null ? new HashSet<T>(list2) : Collections.emptySet()));
        });
    }

    public JScrollPane createScrollPane() {
        return this.myListWithFilter.getScrollPane();
    }

    public boolean hasOwnScrollPane() {
        return true;
    }

    @Nullable
    public BooleanFunction<KeyEvent> getKeyEventHandler() {
        return InputEvent::isConsumed;
    }

    public JComponent buildFinalComponent() {
        this.myListWithFilter = (ListWithFilter)ListWithFilter.wrap(this.myList, (JScrollPane)((Object)new MyListWrapper(this.myList)), (Function)this.myBuilder.getItemsNamer());
        this.myListWithFilter.setAutoPackHeight(this.myBuilder.isAutoPackHeightOnFiltering());
        return this.myListWithFilter;
    }

    public void addMouseListener(MouseListener listener2) {
        this.myList.addMouseListener(listener2);
    }

    public void autoSelect() {
        JList<T> list2 = this.myList;
        if (list2.getSelectedIndex() == -1) {
            list2.setSelectedIndex(0);
        }
    }

    public ListComponentUpdater getBackgroundUpdater() {
        return new JBListUpdater((JBList)this.myList);
    }

    public void setSelectedValue(T preselection, boolean shouldScroll) {
        this.myList.setSelectedValue(preselection, shouldScroll);
    }

    public void setItemSelectedCallback(Consumer<? super T> c) {
        this.myList.addListSelectionListener(e -> {
            T selectedValue = this.myList.getSelectedValue();
            c.consume(selectedValue);
        });
    }

    public void setSelectionMode(int selection) {
        this.myList.setSelectionMode(selection);
    }

    public boolean checkResetFilter() {
        return this.myListWithFilter.resetFilter();
    }

    private final class MyListWrapper
    extends JBScrollPane
    implements DataProvider {
        private final JList<T> myList;

        private MyListWrapper(JList<T> list2) {
            super(-1);
            list2.setVisibleRowCount(PopupListAdapter.this.myBuilder.getVisibleRowCount());
            this.setViewportView(list2);
            if (PopupListAdapter.this.myBuilder.isAutoselectOnMouseMove()) {
                ListUtil.installAutoSelectOnMouseMove(list2);
            }
            ScrollingUtil.installActions(list2);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myList = list2;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyListWrapper.$$$reportNull$$$0(0);
            }
            return PopupImplUtil.getDataImplForList(this.myList, dataId);
        }

        public void setBorder(Border border) {
            if (this.myList != null) {
                this.myList.setBorder(border);
            }
        }

        public void requestFocus() {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myList, true));
        }

        public synchronized void addMouseListener(MouseListener l) {
            this.myList.addMouseListener(l);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ui/popup/PopupListAdapter$MyListWrapper", "getData"));
        }
    }
}

