/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.ui.UISettings;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.DirectDataBufferInt;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.StatsCounters;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.EmptyIcon;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;
import sun.awt.image.WritableRasterNative;

final class NST {
    private static final Logger LOG = Logger.getInstance(NST.class);
    private static final String ourRegistryKeyTouchbar = "ide.mac.touchbar.use";
    private static NSTLibrary ourNSTLibrary = null;
    private static final String MIN_OS_VERSION = "10.12.2";

    NST() {
    }

    static boolean isSupportedOS() {
        return SystemInfo.isMac && SystemInfo.isOsVersionAtLeast((String)MIN_OS_VERSION);
    }

    static void loadLibrary() {
        block13: {
            try {
                if (!NST.isSupportedOS()) {
                    LOG.info("OS doesn't support touchbar, skip nst loading");
                    break block13;
                }
                if (GraphicsEnvironment.isHeadless()) {
                    LOG.info("The graphics environment is headless, skip nst loading");
                    break block13;
                }
                if (!SystemProperties.getBooleanProperty((String)ourRegistryKeyTouchbar, (boolean)true)) {
                    LOG.info("system property 'ide.mac.touchbar.use' is set to false, skip nst loading");
                    break block13;
                }
                if (!JnaLoader.isLoaded()) {
                    LOG.info("JNA library is unavailable, skip nst loading");
                    break block13;
                }
                if (!Helpers.isTouchBarServerRunning()) {
                    LOG.info("touchbar-server isn't running, skip nst loading");
                    break block13;
                }
                try {
                    NST.loadLibraryImpl();
                }
                catch (Throwable e) {
                    LOG.error("Failed to load nst library for touchbar: ", e);
                }
                if (ourNSTLibrary != null) {
                    try {
                        ID test = ourNSTLibrary.createTouchBar("test", uid -> ID.NIL, null);
                        if (test == null || test.equals((Object)ID.NIL)) {
                            LOG.error("Failed to create native touchbar object, result is null");
                            ourNSTLibrary = null;
                            break block13;
                        }
                        ourNSTLibrary.releaseNativePeer(test);
                        LOG.info("nst library works properly, successfully created and released native touchbar object");
                    }
                    catch (Throwable e) {
                        LOG.error("nst library was loaded, but can't be used: ", e);
                        ourNSTLibrary = null;
                    }
                    break block13;
                }
                LOG.error("nst library wasn't loaded");
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    static NSTLibrary loadLibraryImpl() {
        Path lib = PathManager.findBinFile((String)"libnst64.dylib");
        assert (lib != null) : "NST lib missing; bin=" + Arrays.toString(new File(PathManager.getBinPath()).list());
        ourNSTLibrary = (NSTLibrary)Native.load((String)lib.toString(), NSTLibrary.class, Collections.singletonMap("jna.encoding", "UTF8"));
        return ourNSTLibrary;
    }

    static boolean isAvailable() {
        return ourNSTLibrary != null;
    }

    static ID createTouchBar(String name, NSTLibrary.ItemCreator creator, String escID) {
        return ourNSTLibrary.createTouchBar(name, creator, escID);
    }

    static void releaseNativePeer(ID nativePeer) {
        ourNSTLibrary.releaseNativePeer(nativePeer);
    }

    static void setTouchBar(@Nullable Window window, ID touchBarNativePeer) {
        long nsViewPtr;
        block10: {
            nsViewPtr = 0L;
            if (window != null) {
                Object peer = AWTAccessor.getComponentAccessor().getPeer(window);
                if (peer != null && peer.getClass().getName().equals("sun.lwawt.LWWindowPeer")) {
                    try {
                        Method methodGetPlatformWindow = peer.getClass().getMethod("getPlatformWindow", new Class[0]);
                        Object platformWindow = methodGetPlatformWindow.invoke(peer, new Object[0]);
                        if (platformWindow != null && platformWindow.getClass().getName().equals("sun.lwawt.macosx.CPlatformWindow")) {
                            Method methodGetContentView = platformWindow.getClass().getMethod("getContentView", new Class[0]);
                            Object contentView = methodGetContentView.invoke(platformWindow, new Object[0]);
                            Method methodGetAWTView = contentView.getClass().getMethod("getAWTView", new Class[0]);
                            nsViewPtr = (Long)methodGetAWTView.invoke(contentView, new Object[0]);
                            break block10;
                        }
                        LOG.debug("platformWindow of frame peer isn't instance of sun.lwawt.macosx.CPlatformWindow, class of platformWindow: %s", new Object[]{platformWindow != null ? platformWindow.getClass() : "null"});
                    }
                    catch (NoSuchMethodException e) {
                        LOG.debug((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LOG.debug((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        LOG.debug((Throwable)e);
                    }
                } else if (peer == null) {
                    LOG.debug("frame peer is null, window: %s", new Object[]{window});
                } else {
                    LOG.debug("frame peer isn't instance of sun.lwawt.LWWindowPeer, class of peer: %s", new Object[]{peer.getClass()});
                }
            }
        }
        ourNSTLibrary.setTouchBar(new ID(nsViewPtr), touchBarNativePeer);
    }

    static void selectItemsToShow(ID tbObj, String[] ids, int count) {
        ourNSTLibrary.selectItemsToShow(tbObj, ids, count);
    }

    static void setPrincipal(ID tbObj, String uid) {
        ourNSTLibrary.setPrincipal(tbObj, uid);
    }

    static ID createButton(String uid, int buttWidth, int buttFlags, String text2, String hint, int isHintDisabled, @Nullable Pair<Pointer, Dimension> raster, NSTLibrary.Action action2) {
        return ourNSTLibrary.createButton(uid, buttWidth, buttFlags, text2, hint, isHintDisabled, raster == null ? null : (Pointer)raster.getFirst(), raster == null ? 0 : ((Dimension)raster.getSecond()).width, raster == null ? 0 : ((Dimension)raster.getSecond()).height, action2);
    }

    static ID createScrubber(String uid, int itemWidth, NSTLibrary.ScrubberDelegate delegate2, NSTLibrary.ScrubberCacheUpdater updater, @NotNull List<? extends TBItemScrubber.ItemData> items, int visibleItems, @Nullable TouchBarStats stats) {
        Pair<Pointer, Integer> mem;
        if (items == null) {
            NST.$$$reportNull$$$0(0);
        }
        return ourNSTLibrary.createScrubber(uid, itemWidth, delegate2, updater, (mem = NST._packItems(items, visibleItems, false, true)) == null ? null : (Pointer)mem.getFirst(), mem == null ? 0 : (Integer)mem.getSecond());
    }

    static ID createGroupItem(String uid, ID[] items) {
        return ourNSTLibrary.createGroupItem(uid, items == null || items.length == 0 ? null : items, items == null ? 0 : items.length);
    }

    static void updateButton(ID buttonObj, int updateOptions, int buttWidth, int buttonFlags, String text2, String hint, int isHintDisabled, @Nullable Pair<Pointer, Dimension> raster, NSTLibrary.Action action2) {
        ourNSTLibrary.updateButton(buttonObj, updateOptions, buttWidth, buttonFlags, text2, hint, isHintDisabled, raster == null ? null : (Pointer)raster.getFirst(), raster == null ? 0 : ((Dimension)raster.getSecond()).width, raster == null ? 0 : ((Dimension)raster.getSecond()).height, action2);
    }

    static void setArrowImage(ID buttObj, @Nullable Icon arrow) {
        BufferedImage img = NST._getImg4ByteRGBA(arrow);
        Pointer raster4ByteRGBA = NST._getRaster(img);
        int w = NST._getImgW(img);
        int h = NST._getImgH(img);
        ourNSTLibrary.setArrowImage(buttObj, raster4ByteRGBA, w, h);
    }

    private static Pointer _makeIndices(Collection<Integer> indices) {
        if (indices == null || indices.isEmpty()) {
            return null;
        }
        int step2 = Native.getNativeSize(Integer.class);
        Pointer mem = new Pointer(Native.malloc((long)((long)indices.size() * (long)step2)));
        int offset = 0;
        for (Integer i2 : indices) {
            mem.setInt((long)offset, i2.intValue());
            offset += step2;
        }
        return mem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateScrubberItems(TBItemScrubber scrubber, int fromIndex, int itemsCount, boolean withImages, boolean withText) {
        long startNs = withImages && scrubber.getStats() != null ? System.nanoTime() : 0L;
        @NotNull List<TBItemScrubber.ItemData> items = scrubber.getItems();
        Pair<Pointer, Integer> mem = NST._packItems(items.subList(fromIndex, fromIndex + itemsCount), itemsCount, withImages, withText);
        TBItemScrubber tBItemScrubber = scrubber;
        synchronized (tBItemScrubber) {
            if (scrubber.myNativePeer.equals((Object)ID.NIL)) {
                return;
            }
            ourNSTLibrary.updateScrubberItems(scrubber.myNativePeer, mem == null ? null : (Pointer)mem.getFirst(), mem == null ? 0 : (Integer)mem.getSecond(), fromIndex);
        }
        if (withImages && scrubber.getStats() != null) {
            scrubber.getStats().incrementCounter(StatsCounters.scrubberIconsProcessingDurationNs, System.nanoTime() - startNs);
        }
    }

    static void enableScrubberItems(ID scrubObj, Collection<Integer> indices, boolean enabled) {
        if (indices == null || indices.isEmpty() || scrubObj == ID.NIL || scrubObj == null) {
            return;
        }
        Pointer mem = NST._makeIndices(indices);
        ourNSTLibrary.enableScrubberItems(scrubObj, mem, indices.size(), enabled);
    }

    static void showScrubberItem(ID scrubObj, Collection<Integer> indices, boolean show2, boolean inverseOthers) {
        if (scrubObj == ID.NIL || scrubObj == null) {
            return;
        }
        Pointer mem = NST._makeIndices(indices);
        ourNSTLibrary.showScrubberItems(scrubObj, mem, indices == null ? 0 : indices.size(), show2, inverseOthers);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Pair<Pointer, Integer> _packItems(@NotNull List<? extends TBItemScrubber.ItemData> items, int visibleItems, boolean withImages, boolean withText) {
        if (items == null) {
            NST.$$$reportNull$$$0(1);
        }
        if (items.isEmpty()) {
            return null;
        }
        long ptr = 0L;
        try {
            int byteCount = 2;
            int c = 0;
            for (TBItemScrubber.ItemData itemData : items) {
                if (c++ >= visibleItems) {
                    byteCount += 6;
                    continue;
                }
                int textSize = 2 + (withText && itemData.getTextBytes() != null && itemData.getTextBytes().length > 0 ? itemData.getTextBytes().length + 1 : 0);
                byteCount += textSize;
                if (withImages && itemData.darkIcon == null && itemData.getIcon() != null && !(itemData.getIcon() instanceof EmptyIcon) && itemData.getIcon().getIconWidth() > 0 && itemData.getIcon().getIconHeight() > 0) {
                    itemData.darkIcon = (Icon)ReadAction.compute(() -> IconLoader.getDarkIcon((Icon)id2.getIcon(), (boolean)true));
                }
                if (withImages && itemData.darkIcon != null) {
                    itemData.fMulX = NST.getIconScaleForTouchbar(itemData.darkIcon);
                    itemData.scaledWidth = Math.round((float)itemData.darkIcon.getIconWidth() * itemData.fMulX);
                    itemData.scaledHeight = Math.round((float)itemData.darkIcon.getIconHeight() * itemData.fMulX);
                    int n = itemData.scaledWidth * itemData.scaledHeight * 4;
                    int totalSize = n + 4;
                    byteCount += totalSize;
                    continue;
                }
                byteCount += 4;
            }
            ptr = Native.malloc((long)byteCount);
            Pointer result2 = new Pointer(ptr);
            result2.setShort(0L, (short)items.size());
            int n = 2;
            c = 0;
            for (TBItemScrubber.ItemData itemData : items) {
                byte[] txtBytes;
                void var9_11;
                if (c++ >= visibleItems) {
                    result2.setShort((long)var9_11, (short)0);
                    result2.setShort((long)(var9_11 + 2), (short)0);
                    result2.setShort((long)(var9_11 + 4), (short)0);
                    var9_11 += 6;
                    continue;
                }
                byte[] byArray = txtBytes = withText ? itemData.getTextBytes() : null;
                if (txtBytes != null && txtBytes.length > 0) {
                    result2.setShort((long)var9_11, (short)txtBytes.length);
                    result2.write((long)(var9_11 += 2), txtBytes, 0, txtBytes.length);
                    result2.setByte((long)(var9_11 += txtBytes.length), (byte)0);
                    ++var9_11;
                } else {
                    result2.setShort((long)var9_11, (short)0);
                    var9_11 += 2;
                }
                if (withImages && itemData.darkIcon != null) {
                    var9_11 += NST._writeIconRaster(itemData.darkIcon, itemData.fMulX, result2, (int)var9_11, byteCount);
                    continue;
                }
                boolean hasIcon = itemData.getIcon() != null && !(itemData.getIcon() instanceof EmptyIcon) && itemData.getIcon().getIconWidth() > 0 && itemData.getIcon().getIconHeight() > 0;
                result2.setShort((long)var9_11, hasIcon ? (short)1 : 0);
                result2.setShort((long)(var9_11 + 2), (short)0);
                var9_11 += 4;
            }
            return Pair.create((Object)result2, (Object)byteCount);
        }
        catch (Throwable e) {
            if (ptr != 0L) {
                Native.free((long)ptr);
            }
            LOG.debug(e);
            return null;
        }
    }

    static Pair<Pointer, Dimension> get4ByteRGBARaster(@Nullable Icon icon2) {
        if (icon2 == null || icon2.getIconHeight() <= 0 || icon2.getIconWidth() <= 0) {
            return null;
        }
        float fMulX = NST.getIconScaleForTouchbar(icon2);
        @NotNull BufferedImage img = NST._getImg4ByteRGBA(icon2, fMulX);
        return Pair.create((Object)NST._getRaster(img), (Object)new Dimension(img.getWidth(), img.getHeight()));
    }

    private static Pointer _getRaster(BufferedImage img) {
        if (img == null) {
            return null;
        }
        DataBuffer db = img.getRaster().getDataBuffer();
        DirectDataBufferInt dbb = (DirectDataBufferInt)db;
        return dbb.myMemory;
    }

    private static int _getImgW(BufferedImage img) {
        return img == null ? 0 : img.getWidth();
    }

    private static int _getImgH(BufferedImage img) {
        return img == null ? 0 : img.getHeight();
    }

    private static BufferedImage _getImg4ByteRGBA(Icon icon2, float scale) {
        if (icon2 == null || icon2.getIconHeight() <= 0 || icon2.getIconWidth() <= 0) {
            return null;
        }
        int w = Math.round((float)icon2.getIconWidth() * scale);
        int h = Math.round((float)icon2.getIconHeight() * scale);
        int memLength = w * h * 4;
        Memory memory = new Memory((long)memLength);
        return NST._drawIconIntoMemory(icon2, scale, (Pointer)memory, 0);
    }

    private static float getIconScaleForTouchbar(@NotNull Icon icon2) {
        if (icon2 == null) {
            NST.$$$reportNull$$$0(2);
        }
        return UISettings.getInstance().getPresentationMode() ? 40.0f / (float)icon2.getIconHeight() : (icon2.getIconHeight() < 24 ? 2.5f : 44.0f / (float)icon2.getIconHeight());
    }

    private static BufferedImage _getImg4ByteRGBA(@Nullable Icon icon2) {
        if (icon2 == null || icon2.getIconHeight() <= 0 || icon2.getIconWidth() <= 0) {
            return null;
        }
        float fMulX = NST.getIconScaleForTouchbar(icon2);
        return NST._getImg4ByteRGBA(icon2, fMulX);
    }

    private static int _writeIconRaster(@NotNull Icon icon2, float scale, @NotNull Pointer memory, int offset, int totalMemoryBytes) throws Exception {
        if (icon2 == null) {
            NST.$$$reportNull$$$0(3);
        }
        if (memory == null) {
            NST.$$$reportNull$$$0(4);
        }
        int w = Math.round((float)icon2.getIconWidth() * scale);
        int h = Math.round((float)icon2.getIconHeight() * scale);
        if (w <= 0 || h <= 0) {
            throw new Exception("Incorrect icon sizes: " + icon2.getIconWidth() + "x" + icon2.getIconHeight() + ", scale=" + scale);
        }
        int rasterSizeInBytes = w * h * 4;
        int totalSize = rasterSizeInBytes + 4;
        if (offset + totalSize > totalMemoryBytes) {
            throw new Exception("Incorrect memory offset: offset=" + offset + ", rasterSize=" + rasterSizeInBytes + ", totalMemoryBytes=" + totalMemoryBytes);
        }
        memory.setShort((long)offset, (short)w);
        memory.setShort((long)(offset += 2), (short)h);
        NST._drawIconIntoMemory(icon2, scale, memory, offset += 2);
        return totalSize;
    }

    @NotNull
    private static BufferedImage _drawIconIntoMemory(@NotNull Icon icon2, float scale, @NotNull Pointer memory, int offset) {
        if (icon2 == null) {
            NST.$$$reportNull$$$0(5);
        }
        if (memory == null) {
            NST.$$$reportNull$$$0(6);
        }
        int w = Math.round((float)icon2.getIconWidth() * scale);
        int h = Math.round((float)icon2.getIconHeight() * scale);
        int rasterSizeInBytes = w * h * 4;
        memory.setMemory((long)offset, (long)rasterSizeInBytes, (byte)0);
        DirectDataBufferInt dataBuffer = new DirectDataBufferInt(memory, rasterSizeInBytes, offset);
        DirectColorModel colorModel = new DirectColorModel(ColorModel.getRGBdefault().getColorSpace(), 32, 255, 65280, 0xFF0000, -16777216, false, 3);
        SampleModel sm = colorModel.createCompatibleSampleModel(w, h);
        WritableRasterNative raster = WritableRasterNative.createNativeRaster(sm, dataBuffer);
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        Graphics2D g = image.createGraphics();
        g.scale(scale, scale);
        g.setComposite(AlphaComposite.SrcOver);
        icon2.paintIcon(null, g, 0, 0);
        g.dispose();
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            NST.$$$reportNull$$$0(7);
        }
        return bufferedImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/NST";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/NST";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "_drawIconIntoMemory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScrubber";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_packItems";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIconScaleForTouchbar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "_writeIconRaster";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "_drawIconIntoMemory";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

