/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FNKeyAction
extends DumbAwareAction {
    private static final boolean SHOW_ACTION_TEMPLATE_TEXT = Boolean.getBoolean("touchbar.fn.mode.show.template");
    private final int myFN;
    private final Map<Integer, String[]> myCache = new HashMap<Integer, String[]>();
    private AnAction myAction;
    private boolean myIsActionDisabled;

    private String @Nullable [] getActionsIds(int modifiers) {
        KeymapManager manager2 = KeymapManager.getInstance();
        if (manager2 == null) {
            return null;
        }
        @NotNull Keymap keymap2 = manager2.getActiveKeymap();
        String[] result2 = this.myCache.get(modifiers);
        if (result2 != null) {
            return result2;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112 + this.myFN - 1, modifiers);
        result2 = keymap2.getActionIds(keyStroke);
        this.myCache.put(modifiers, result2);
        return result2;
    }

    FNKeyAction(int FN) {
        this.myFN = Math.max(1, Math.min(FN, 12));
    }

    int getFN() {
        return this.myFN;
    }

    boolean isActionDisabled() {
        return this.myIsActionDisabled;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FNKeyAction.$$$reportNull$$$0(0);
        }
        if (this.myAction == null || this.myIsActionDisabled) {
            Helpers.emulateKeyPress(112 + this.myFN - 1);
            return;
        }
        this.myAction.actionPerformed(e);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FNKeyAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(true);
        e.getPresentation().setText("");
        this.myIsActionDisabled = false;
        this.myAction = null;
        String[] ids = this.getActionsIds(TouchBarsManager.getLastModifiersEx());
        if (ids == null || ids.length < 1) {
            return;
        }
        int c = 0;
        this.myAction = e.getActionManager().getAction(ids[c]);
        while (this.myAction == null && c + 1 < ids.length) {
            e.getActionManager().getAction(ids[++c]);
        }
        if (this.myAction == null) {
            return;
        }
        this.myAction.update(e);
        this.myIsActionDisabled = !e.getPresentation().isEnabled();
        e.getPresentation().setEnabledAndVisible(true);
        String text2 = e.getPresentation().getText();
        if (SHOW_ACTION_TEMPLATE_TEXT || text2 == null || text2.isEmpty()) {
            e.getPresentation().setText(this.myAction.getTemplateText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ui/mac/touchbar/FNKeyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

