/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CtxDialogs {
    private static final Logger LOG = Logger.getInstance(CtxDialogs.class);
    private static final boolean EXPAND_OPTION_BUTTONS = Boolean.getBoolean("touchbar.dialogs.expand.option.button");
    private static final int BUTTON_MIN_WIDTH_DLG = 107;
    private static final int BUTTON_BORDER = 16;
    private static final int BUTTON_IMAGE_MARGIN = 2;

    CtxDialogs() {
    }

    @Nullable
    static Disposable showDialogButtons(@NotNull Container contentPane) {
        ActionGroup actionGroup2;
        TouchbarDataKeys.ActionDesc groupDesc;
        if (contentPane == null) {
            CtxDialogs.$$$reportNull$$$0(0);
        }
        HashMap<TouchbarDataKeys.DlgButtonDesc, JButton> buttonMap = new HashMap<TouchbarDataKeys.DlgButtonDesc, JButton>();
        HashMap<Component, ActionGroup> actions2 = new HashMap<Component, ActionGroup>();
        CtxDialogs._findAllTouchbarProviders(actions2, buttonMap, contentPane);
        if (buttonMap.isEmpty() && actions2.isEmpty()) {
            return null;
        }
         @Nullable TouchBar.CrossEscInfo crossEscInfo = null;
        if (!actions2.isEmpty() && ((groupDesc = (TouchbarDataKeys.ActionDesc)(actionGroup2 = (ActionGroup)actions2.values().iterator().next()).getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY)) == null || groupDesc.isReplaceEsc())) {
            crossEscInfo = new TouchBar.CrossEscInfo(true, false);
        }
        LOG.debug("show actions of dialog '%s', south-buttons count=%d, content actions count=%d", new Object[]{contentPane, buttonMap.size(), actions2.size()});
        Customizer customizations = new Customizer(crossEscInfo, null);
        ActionGroup ag = CtxDialogs.buildDialogButtonsGroup(buttonMap, actions2, customizations);
        TouchBarsManager.registerAndShow((Component)contentPane, ag, customizations);
        return () -> {
            LOG.debug("hide actions of dialog '%s'", new Object[]{contentPane});
            TouchBarsManager.unregister(contentPane);
        };
    }

    private static void _findAllTouchbarProviders(@NotNull Map<Component, ActionGroup> out, @NotNull Map<TouchbarDataKeys.DlgButtonDesc, JButton> out2, @NotNull Container root) {
        if (out == null) {
            CtxDialogs.$$$reportNull$$$0(1);
        }
        if (out2 == null) {
            CtxDialogs.$$$reportNull$$$0(2);
        }
        if (root == null) {
            CtxDialogs.$$$reportNull$$$0(3);
        }
        JBIterable iter = ((JBTreeTraverser)UIUtil.uiTraverser((Component)root).expandAndFilter(c -> c.isVisible())).traverse();
        for (Component component2 : iter) {
            ActionGroup actions2;
            TouchbarDataKeys.DlgButtonDesc desc;
            if (component2 instanceof JButton && (desc = (TouchbarDataKeys.DlgButtonDesc)UIUtil.getClientProperty((Object)component2, (Key)TouchbarDataKeys.DIALOG_BUTTON_DESCRIPTOR_KEY)) != null) {
                out2.put(desc, (JButton)component2);
            }
            DataProvider dp = null;
            if (component2 instanceof DataProvider) {
                dp = (DataProvider)((Object)component2);
            } else if (component2 instanceof JComponent) {
                dp = DataManager.getDataProvider((JComponent)((JComponent)component2));
            }
            if (dp == null || (actions2 = (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData(dp)) == null) continue;
            out.put(component2, actions2);
        }
    }

    private static ActionGroup buildDialogButtonsGroup(@Nullable Map<TouchbarDataKeys.DlgButtonDesc, JButton> unorderedButtons, @Nullable Map<Component, ActionGroup> actions2, @NotNull Customizer customizations) {
        List<TouchbarDataKeys.DlgButtonDesc> orderedSouthButtons;
        if (customizations == null) {
            CtxDialogs.$$$reportNull$$$0(4);
        }
        boolean hasSouthPanelButtons = unorderedButtons != null && !unorderedButtons.isEmpty();
        byte prio = -1;
        ModalityStateEx ms = LaterInvocator.getCurrentModalityState();
        DefaultActionGroup result2 = new DefaultActionGroup();
        if (EXPAND_OPTION_BUTTONS && hasSouthPanelButtons) {
            for (JButton jb : unorderedButtons.values()) {
                JBOptionButton ob;
                Action[] opts;
                if (!(jb instanceof JBOptionButton) || (opts = (ob = (JBOptionButton)jb).getOptions()) == null) continue;
                for (Action action2 : opts) {
                    AnAction anAct;
                    if (action2 == null || (anAct = CtxDialogs._createAnAction(action2, (JButton)ob, true)) == null) continue;
                    result2.add(anAct);
                    byte actPriority = prio = (byte)(prio - 1);
                    customizations.addCustomization(anAct, (parent, b, pres) -> {
                        b.setModality(ms);
                        b.setComponent((Component)ob);
                        b.setPriority(actPriority);
                        b.setText(pres.getText());
                        b.setIcon(null);
                        b.setLayout(107, 32768, 2, 16);
                    });
                }
            }
        }
        if (actions2 != null && !actions2.isEmpty()) {
            ActionGroup ag = actions2.values().iterator().next();
            TouchbarDataKeys.ActionDesc groupDesc = (TouchbarDataKeys.ActionDesc)ag.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            if (!hasSouthPanelButtons || groupDesc != null && groupDesc.isCombineWithDlgButtons()) {
                HashMap<Action, Integer> act2Priority = new HashMap<Action, Integer>();
                AnAction[] children2 = ag.getChildren(null);
                for (Action action3 : children2) {
                    prio = (byte)(prio - 1);
                    act2Priority.put(action3, Integer.valueOf(prio));
                }
                result2.add((AnAction)ag);
                customizations.addGroupCustomization(ag, (parentInfo, butt, presentation2) -> {
                    Integer p = (Integer)act2Priority.get(butt.getAnAction());
                    if (p != null) {
                        butt.setPriority((byte)(p & 0xFF));
                    }
                    TouchbarDataKeys.ActionDesc pd = parentInfo == null ? null : parentInfo.getDesc();
                    butt.setIconAndTextFromPresentation(presentation2, pd == null ? groupDesc : pd);
                    butt.setModality(ms);
                    TouchbarDataKeys.ActionDesc actionDesc = (TouchbarDataKeys.ActionDesc)butt.getAnAction().getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
                    if (actionDesc != null && actionDesc.getContextComponent() != null) {
                        butt.setComponent(actionDesc.getContextComponent());
                    }
                });
            }
        }
        if ((orderedSouthButtons = CtxDialogs._extractOrderedButtons(unorderedButtons)) != null) {
            for (TouchbarDataKeys.DlgButtonDesc desc : orderedSouthButtons) {
                JButton jb = unorderedButtons.get(desc);
                AnAction anAct = CtxDialogs._createAnAction(jb.getAction(), jb, false);
                if (anAct == null) continue;
                result2.add(anAct);
                byte actPriority = prio = (byte)((byte)(prio - 1));
                customizations.addCustomization(anAct, (parent, b, pres) -> {
                    b.setModality(ms);
                    b.setComponent(jb);
                    b.setPriority(actPriority);
                    b.setText(pres.getText());
                    b.setIcon(null);
                    b.setLayout(107, 32768, 2, 16);
                    boolean isDefault = desc.isDefault();
                    if (!isDefault) {
                        boolean bl = jb.getAction() != null ? jb.getAction().getValue("DefaultAction") != null : (isDefault = jb.isDefaultButton());
                    }
                    if (isDefault) {
                        b.setColored();
                    }
                });
                customizations.addDescriptor(anAct, desc);
            }
        }
        return result2;
    }

    private static AnAction _createAnAction(final @Nullable Action action2, final @NotNull JButton fromButton, final boolean useTextFromAction) {
        Object anAct;
        if (fromButton == null) {
            CtxDialogs.$$$reportNull$$$0(5);
        }
        Object object = anAct = action2 == null ? null : action2.getValue("AnAction");
        if (anAct == null) {
            return new DumbAwareAction(){
                {
                    this.setEnabledInModalContext(true);
                    if (useTextFromAction) {
                        Object name = action2 == null ? fromButton.getText() : action2.getValue("Name");
                        this.getTemplatePresentation().setText(name instanceof String ? (String)name : "");
                    }
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (action2 == null) {
                        fromButton.doClick();
                        return;
                    }
                    action2.actionPerformed(new ActionEvent(fromButton, 1001, null));
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(action2 == null ? fromButton.isEnabled() : action2.isEnabled());
                    if (!useTextFromAction) {
                        e.getPresentation().setText((String)DialogWrapper.extractMnemonic((String)fromButton.getText()).second);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxDialogs$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if (!(anAct instanceof AnAction)) {
            return null;
        }
        return (AnAction)anAct;
    }

    @Nullable
    private static List<TouchbarDataKeys.DlgButtonDesc> _extractOrderedButtons(@Nullable Map<TouchbarDataKeys.DlgButtonDesc, JButton> unorderedButtons) {
        if (unorderedButtons == null || unorderedButtons.isEmpty()) {
            return null;
        }
        ArrayList<TouchbarDataKeys.DlgButtonDesc> main2 = new ArrayList<TouchbarDataKeys.DlgButtonDesc>();
        ArrayList<TouchbarDataKeys.DlgButtonDesc> secondary = new ArrayList<TouchbarDataKeys.DlgButtonDesc>();
        for (Map.Entry<TouchbarDataKeys.DlgButtonDesc, JButton> entry2 : unorderedButtons.entrySet()) {
            TouchbarDataKeys.DlgButtonDesc jbdesc = entry2.getKey();
            if (jbdesc == null) continue;
            if (jbdesc.isMainGroup()) {
                main2.add(jbdesc);
                continue;
            }
            secondary.add(jbdesc);
        }
        Comparator<TouchbarDataKeys.DlgButtonDesc> cmp = Comparator.comparingInt(TouchbarDataKeys.DlgButtonDesc::getOrder);
        main2.sort(cmp);
        secondary.sort(cmp);
        return ContainerUtil.concat(secondary, main2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizations";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromButton";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxDialogs";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogButtons";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "_findAllTouchbarProviders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDialogButtonsGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "_createAnAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

