/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.docking.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DockManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class DockManagerImpl
extends DockManager
implements PersistentStateComponent<Element> {
    private final Project myProject;
    private final Map<String, DockContainerFactory> myFactories;
    private final Set<DockContainer> myContainers;
    private final Map<DockContainer, DockWindow> containerToWindow;
    private MyDragSession myCurrentDragSession;
    private final BusyObject.Impl myBusyObject;
    private int myWindowIdCounter;
    private Element myLoadedState;
    public static final Key<Boolean> SHOW_NORTH_PANEL = Key.create((String)"SHOW_NORTH_PANEL");
    public static final Key<String> WINDOW_DIMENSION_KEY = Key.create((String)"WINDOW_DIMENSION_KEY");

    public DockManagerImpl(@NotNull Project project) {
        if (project == null) {
            DockManagerImpl.$$$reportNull$$$0(0);
        }
        this.myFactories = new HashMap<String, DockContainerFactory>();
        this.myContainers = new HashSet<DockContainer>();
        this.containerToWindow = new HashMap<DockContainer, DockWindow>();
        this.myBusyObject = new BusyObject.Impl(){

            @Override
            public boolean isReady() {
                return DockManagerImpl.this.myCurrentDragSession == null;
            }
        };
        this.myWindowIdCounter = 1;
        this.myProject = project;
    }

    public void register(@NotNull DockContainer container) {
        if (container == null) {
            DockManagerImpl.$$$reportNull$$$0(1);
        }
        if (container instanceof Disposable) {
            this.register(container, (Disposable)container);
        } else {
            this.myContainers.add(container);
        }
    }

    public void register(final @NotNull DockContainer container, @NotNull Disposable parentDisposable) {
        if (container == null) {
            DockManagerImpl.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            DockManagerImpl.$$$reportNull$$$0(3);
        }
        this.myContainers.add(container);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                DockManagerImpl.this.myContainers.remove(container);
            }
        });
    }

    public void register(final @NotNull String id2, @NotNull DockContainerFactory factory2, @NotNull Disposable parentDisposable) {
        if (id2 == null) {
            DockManagerImpl.$$$reportNull$$$0(4);
        }
        if (factory2 == null) {
            DockManagerImpl.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            DockManagerImpl.$$$reportNull$$$0(6);
        }
        this.myFactories.put(id2, factory2);
        if (parentDisposable != this.myProject) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    DockManagerImpl.this.myFactories.remove(id2);
                }
            });
        }
        this.readStateFor(id2);
    }

    public void readState() {
        for (String id2 : this.myFactories.keySet()) {
            this.readStateFor(id2);
        }
    }

    @NotNull
    public Set<DockContainer> getContainers() {
        HashSet<DockContainer> result2 = new HashSet<DockContainer>(this.myContainers.size() + this.containerToWindow.size());
        result2.addAll(this.myContainers);
        result2.addAll(this.containerToWindow.keySet());
        Set<DockContainer> set2 = Collections.unmodifiableSet(result2);
        if (set2 == null) {
            DockManagerImpl.$$$reportNull$$$0(7);
        }
        return set2;
    }

    public IdeFrame getIdeFrame(@NotNull DockContainer container) {
        Component parent;
        if (container == null) {
            DockManagerImpl.$$$reportNull$$$0(8);
        }
        return (parent = UIUtil.findUltimateParent((Component)container.getContainerComponent())) instanceof IdeFrame ? (IdeFrame)parent : null;
    }

    public String getDimensionKeyForFocus(@NotNull String key) {
        Component owner;
        if (key == null) {
            DockManagerImpl.$$$reportNull$$$0(9);
        }
        if ((owner = IdeFocusManager.getInstance((Project)this.myProject).getFocusOwner()) == null) {
            return key;
        }
        DockWindow window = this.containerToWindow.get(this.getContainerFor(owner, dockContainer2 -> true));
        return window != null ? key + "#" + window.myId : key;
    }

    public DockContainer getContainerFor(Component c) {
        return this.getContainerFor(c, dockContainer2 -> true);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public DockContainer getContainerFor(@Nullable Component c, @NotNull Predicate<DockContainer> filter) {
        if (filter == null) {
            DockManagerImpl.$$$reportNull$$$0(10);
        }
        if (c == null) {
            return null;
        }
        for (DockContainer eachContainer : this.getAllContainers()) {
            if (!SwingUtilities.isDescendingFrom(c, eachContainer.getContainerComponent()) || !filter.test(eachContainer)) continue;
            return eachContainer;
        }
        Component parent = UIUtil.findUltimateParent((Component)c);
        for (DockContainer eachContainer : this.getAllContainers()) {
            if (parent != UIUtil.findUltimateParent((Component)eachContainer.getContainerComponent()) || !filter.test(eachContainer)) continue;
            return eachContainer;
        }
        return null;
    }

    public DragSession createDragSession(MouseEvent mouseEvent, @NotNull DockableContent content2) {
        if (content2 == null) {
            DockManagerImpl.$$$reportNull$$$0(11);
        }
        this.stopCurrentDragSession();
        for (DockContainer each : this.getAllContainers()) {
            DockWindow window;
            if (!each.isEmpty() || !each.isDisposeWhenEmpty() || (window = this.containerToWindow.get(each)) == null) continue;
            window.setTransparent(true);
        }
        this.myCurrentDragSession = new MyDragSession(mouseEvent, content2);
        return this.myCurrentDragSession;
    }

    public void stopCurrentDragSession() {
        if (this.myCurrentDragSession != null) {
            this.myCurrentDragSession.cancelSession();
            this.myCurrentDragSession = null;
            this.myBusyObject.onReady();
            for (DockContainer each : this.getAllContainers()) {
                DockWindow window;
                if (each.isEmpty() || (window = this.containerToWindow.get(each)) == null) continue;
                window.setTransparent(false);
            }
        }
    }

    private ActionCallback getReady() {
        return this.myBusyObject.getReady((Object)this);
    }

    @Nullable
    private DockContainer findContainerFor(RelativePoint point, @NotNull DockableContent<?> content2) {
        RelativeRectangle rec;
        if (content2 == null) {
            DockManagerImpl.$$$reportNull$$$0(12);
        }
        ArrayList<DockContainer> containers = new ArrayList<DockContainer>(this.getContainers());
        containers.remove(this.myCurrentDragSession.myStartDragContainer);
        containers.add(0, this.myCurrentDragSession.myStartDragContainer);
        for (DockContainer each : containers) {
            rec = each.getAcceptArea();
            if (!rec.contains(point) || !each.getContentResponse(content2, point).canAccept()) continue;
            return each;
        }
        for (DockContainer each : containers) {
            rec = each.getAcceptAreaFallback();
            if (!rec.contains(point) || !each.getContentResponse(content2, point).canAccept()) continue;
            return each;
        }
        return null;
    }

    private DockContainerFactory getFactory(String type) {
        assert (this.myFactories.containsKey(type)) : "No factory for content type=" + type;
        return this.myFactories.get(type);
    }

    public void createNewDockContainerFor(@NotNull DockableContent<?> content2, @NotNull RelativePoint point) {
        boolean isNorthPanelAvailable;
        if (content2 == null) {
            DockManagerImpl.$$$reportNull$$$0(13);
        }
        if (point == null) {
            DockManagerImpl.$$$reportNull$$$0(14);
        }
        DockContainer container = this.getFactory(content2.getDockContainerType()).createContainer(content2);
        DockWindow window = this.createWindowFor(DockManagerImpl.getWindowDimensionKey(content2), null, container);
        boolean bl = isNorthPanelAvailable = content2 instanceof EditorTabbedContainer.DockableEditor ? ((EditorTabbedContainer.DockableEditor)content2).isNorthPanelAvailable() : DockManagerImpl.isNorthPanelVisible(UISettings.getInstance());
        if (isNorthPanelAvailable) {
            window.setupNorthPanel();
        }
        Dimension size = content2.getPreferredSize();
        Point showPoint = point.getScreenPoint();
        showPoint.x -= size.width / 2;
        showPoint.y -= size.height / 2;
        Rectangle target2 = new Rectangle(showPoint, size);
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)target2);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)target2);
        window.setLocation(target2.getLocation());
        window.myDockContentUiContainer.setPreferredSize(target2.getSize());
        window.show(false);
        window.getFrame().pack();
        container.add(content2, new RelativePoint(target2.getLocation()));
        SwingUtilities.invokeLater(() -> window.myUiContainer.setPreferredSize(null));
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> createNewDockContainerFor(@NotNull VirtualFile file2, @NotNull FileEditorManagerImpl fileEditorManager) {
        if (file2 == null) {
            DockManagerImpl.$$$reportNull$$$0(15);
        }
        if (fileEditorManager == null) {
            DockManagerImpl.$$$reportNull$$$0(16);
        }
        DockContainer container = this.getFactory("file-editors").createContainer(null);
        DockWindow window = this.createWindowFor(DockManagerImpl.getWindowDimensionKey(file2), null, container);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            window.show(true);
        }
        EditorWindow editorWindow = ((DockableEditorTabbedContainer)container).getSplitters().getOrCreateCurrentWindow(file2);
        Pair<FileEditor[], FileEditorProvider[]> result2 = fileEditorManager.openFileImpl2(editorWindow, file2, true);
        boolean isNorthPanelAvailable = DockManagerImpl.isNorthPanelAvailable((FileEditor[])result2.first);
        if (isNorthPanelAvailable) {
            window.setupNorthPanel();
        }
        container.add((DockableContent)EditorTabbedContainer.createDockableEditor(this.myProject, null, file2, new Presentation(file2.getName()), editorWindow, isNorthPanelAvailable), null);
        SwingUtilities.invokeLater(() -> window.myUiContainer.setPreferredSize(null));
        Pair<FileEditor[], FileEditorProvider[]> pair = result2;
        if (pair == null) {
            DockManagerImpl.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @Nullable
    private static String getWindowDimensionKey(@NotNull DockableContent<?> content2) {
        if (content2 == null) {
            DockManagerImpl.$$$reportNull$$$0(18);
        }
        if (content2 instanceof EditorTabbedContainer.DockableEditor) {
            VirtualFile contentFile = ((EditorTabbedContainer.DockableEditor)content2).getFile();
            return DockManagerImpl.getWindowDimensionKey(contentFile);
        }
        return null;
    }

    @Nullable
    private static String getWindowDimensionKey(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockManagerImpl.$$$reportNull$$$0(19);
        }
        return (String)WINDOW_DIMENSION_KEY.get((UserDataHolder)file2);
    }

    @NotNull
    private DockWindow createWindowFor(@Nullable String dimensionKey, @Nullable String id2, @NotNull DockContainer container) {
        if (container == null) {
            DockManagerImpl.$$$reportNull$$$0(20);
        }
        String windowId = id2 != null ? id2 : Integer.toString(this.myWindowIdCounter++);
        DockWindow window = new DockWindow(dimensionKey, windowId, this.myProject, container, container instanceof DockContainer.Dialog);
        this.containerToWindow.put(container, window);
        DockWindow dockWindow = window;
        if (dockWindow == null) {
            DockManagerImpl.$$$reportNull$$$0(21);
        }
        return dockWindow;
    }

    public static boolean isNorthPanelVisible(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            DockManagerImpl.$$$reportNull$$$0(22);
        }
        return uiSettings.getShowNavigationBar() && !uiSettings.getPresentationMode();
    }

    public static boolean isNorthPanelAvailable(FileEditor @NotNull [] editors2) {
        if (editors2 == null) {
            DockManagerImpl.$$$reportNull$$$0(23);
        }
        boolean defaultNorthPanelVisible = DockManagerImpl.isNorthPanelVisible(UISettings.getInstance());
        for (FileEditor editor : editors2) {
            if (!SHOW_NORTH_PANEL.isIn((UserDataHolder)editor)) continue;
            return (Boolean)SHOW_NORTH_PANEL.get((UserDataHolder)editor, (Object)defaultNorthPanelVisible);
        }
        return defaultNorthPanelVisible;
    }

    public Element getState() {
        Element root = new Element("state");
        for (DockContainer each : this.getAllContainers()) {
            DockWindow eachWindow = this.containerToWindow.get(each);
            if (eachWindow == null || !(each instanceof DockContainer.Persistent)) continue;
            DockContainer.Persistent eachContainer = (DockContainer.Persistent)each;
            Element eachWindowElement = new Element("window");
            String id2 = eachWindow.myId;
            if (id2 != null) {
                eachWindowElement.setAttribute("id", id2);
            }
            eachWindowElement.setAttribute("withNorthPanel", Boolean.toString(eachWindow.myNorthPanelAvailable));
            Element content2 = new Element("content");
            content2.setAttribute("type", eachContainer.getDockContainerType());
            content2.addContent(eachContainer.getState());
            eachWindowElement.addContent(content2);
            root.addContent(eachWindowElement);
        }
        return root;
    }

    @NotNull
    private Iterable<DockContainer> getAllContainers() {
        Iterable iterable = ContainerUtil.concat(this.myContainers, this.containerToWindow.keySet());
        if (iterable == null) {
            DockManagerImpl.$$$reportNull$$$0(24);
        }
        return iterable;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DockManagerImpl.$$$reportNull$$$0(25);
        }
        this.myLoadedState = state;
    }

    private void readStateFor(@NotNull String type) {
        if (type == null) {
            DockManagerImpl.$$$reportNull$$$0(26);
        }
        if (this.myLoadedState == null) {
            return;
        }
        for (Element windowElement : this.myLoadedState.getChildren("window")) {
            DockContainerFactory factory2;
            String eachType;
            Element eachContent = windowElement.getChild("content");
            if (eachContent == null || !type.equals(eachType = eachContent.getAttributeValue("type")) || !this.myFactories.containsKey(eachType) || !((factory2 = this.myFactories.get(eachType)) instanceof DockContainerFactory.Persistent)) continue;
            DockContainer container = ((DockContainerFactory.Persistent)factory2).loadContainerFrom(eachContent);
            String withNorthPanelStr = windowElement.getAttributeValue("withNorthPanel", Boolean.toString(true));
            boolean withNorthPanel = Boolean.valueOf(withNorthPanelStr);
            DockWindow window = this.createWindowFor(null, windowElement.getAttributeValue("id"), container);
            if (withNorthPanel) {
                window.setupNorthPanel();
            }
            UIUtil.invokeLaterIfNeeded(window::show);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 17: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 17: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/docking/impl/DockManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/docking/impl/DockManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewDockContainerFor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createWindowFor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContainers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 7: 
            case 17: 
            case 21: 
            case 24: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIdeFrame";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDimensionKeyForFocus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContainerFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDragSession";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findContainerFor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createNewDockContainerFor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getWindowDimensionKey";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createWindowFor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isNorthPanelVisible";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isNorthPanelAvailable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readStateFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 17: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class DockWindow
    extends FrameWrapper
    implements IdeEventQueue.EventDispatcher {
        private final String myId;
        private boolean myNorthPanelAvailable;
        private final DockContainer myContainer;
        private final VerticalBox myNorthPanel;
        private final Map<String, IdeRootPaneNorthExtension> myNorthExtensions;
        private final NonOpaquePanel myUiContainer;
        private final JPanel myCenterPanel;
        private final JPanel myDockContentUiContainer;

        private DockWindow(@Nullable String dimensionKey, @NotNull String id2, @NotNull Project project, DockContainer container, boolean isDialog) {
            Window frame;
            StatusBar statusBar2;
            if (project == null) {
                DockWindow.$$$reportNull$$$0(0);
            }
            if (container == null) {
                DockWindow.$$$reportNull$$$0(1);
            }
            super(project, (String)(dimensionKey != null ? dimensionKey : "dock-window-" + id2), isDialog);
            this.myNorthPanel = new VerticalBox();
            this.myNorthExtensions = new LinkedHashMap<String, IdeRootPaneNorthExtension>();
            this.myCenterPanel = new JPanel(new BorderLayout(0, 2));
            this.myId = id2;
            this.myContainer = container;
            this.setProject(project);
            if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !(container instanceof DockContainer.Dialog) && (statusBar2 = WindowManager.getInstance().getStatusBar(project)) != null && (frame = this.getFrame()) instanceof IdeFrame) {
                this.setStatusBar(statusBar2.createChild((IdeFrame)frame));
            }
            this.myUiContainer = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myCenterPanel.setOpaque(false);
            this.myDockContentUiContainer = new JPanel(new BorderLayout());
            this.myDockContentUiContainer.setOpaque(false);
            this.myDockContentUiContainer.add((Component)this.myContainer.getContainerComponent(), "Center");
            this.myCenterPanel.add((Component)this.myDockContentUiContainer, "Center");
            this.myUiContainer.add((Component)this.myCenterPanel, (Object)"Center");
            statusBar2 = this.getStatusBar();
            if (statusBar2 != null) {
                this.myUiContainer.add((Component)statusBar2.getComponent(), (Object)"South");
            }
            this.setComponent((JComponent)this.myUiContainer);
            IdeEventQueue.getInstance().addPostprocessor(this, this);
            this.myContainer.addListener(new DockContainer.Listener(){

                public void contentRemoved(Object key) {
                    DockManagerImpl.this.getReady().doWhenDone(() -> {
                        if (DockWindow.this.myContainer.isEmpty()) {
                            DockWindow.this.close();
                            DockManagerImpl.this.myContainers.remove(DockWindow.this.myContainer);
                        }
                    });
                }
            }, (Disposable)this);
        }

        private void setupNorthPanel() {
            this.myCenterPanel.add((Component)this.myNorthPanel, "North");
            this.myNorthPanelAvailable = true;
            DockManagerImpl.this.myProject.getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, uiSettings -> this.updateNorthPanel(DockManagerImpl.isNorthPanelVisible(uiSettings)));
            this.updateNorthPanel(DockManagerImpl.isNorthPanelVisible(UISettings.getInstance()));
        }

        @Override
        protected IdeRootPaneNorthExtension getNorthExtension(String key) {
            return this.myNorthExtensions.get(key);
        }

        private void updateNorthPanel(boolean visible) {
            if (ApplicationManager.getApplication().isUnitTestMode() || !this.myNorthPanelAvailable) {
                return;
            }
            this.myNorthPanel.setVisible(!(this.myContainer instanceof DockContainer.Dialog) && visible);
            HashSet<String> processedKeys = new HashSet<String>();
            for (Object each : IdeRootPaneNorthExtension.EP_NAME.getExtensionList((AreaInstance)DockManagerImpl.this.myProject)) {
                processedKeys.add(each.getKey());
                if (this.myNorthExtensions.containsKey(each.getKey())) continue;
                IdeRootPaneNorthExtension toInstall = each.copy();
                this.myNorthExtensions.put(toInstall.getKey(), toInstall);
                this.myNorthPanel.add((Component)toInstall.getComponent());
            }
            Iterator<String> existing = this.myNorthExtensions.keySet().iterator();
            while (existing.hasNext()) {
                Object each;
                each = existing.next();
                if (processedKeys.contains(each)) continue;
                IdeRootPaneNorthExtension toRemove2 = this.myNorthExtensions.get(each);
                this.myNorthPanel.remove((Component)toRemove2.getComponent());
                existing.remove();
                if (!(toRemove2 instanceof Disposable)) continue;
                Disposer.dispose((Disposable)((Disposable)toRemove2));
            }
            this.myNorthPanel.revalidate();
            this.myNorthPanel.repaint();
        }

        public void setTransparent(boolean transparent) {
            if (transparent) {
                WindowManagerEx.getInstanceEx().setAlphaModeEnabled(this.getFrame(), true);
                WindowManagerEx.getInstanceEx().setAlphaModeRatio(this.getFrame(), 0.5f);
            } else {
                WindowManagerEx.getInstanceEx().setAlphaModeEnabled(this.getFrame(), true);
                WindowManagerEx.getInstanceEx().setAlphaModeRatio(this.getFrame(), 0.0f);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            DockManagerImpl.this.containerToWindow.remove(this.myContainer);
            for (IdeRootPaneNorthExtension each : this.myNorthExtensions.values()) {
                if (!(each instanceof Disposable)) continue;
                Disposer.dispose((Disposable)((Disposable)each));
            }
            this.myNorthExtensions.clear();
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e == null) {
                DockWindow.$$$reportNull$$$0(2);
            }
            if (e instanceof KeyEvent && DockManagerImpl.this.myCurrentDragSession != null) {
                DockManagerImpl.this.stopCurrentDragSession();
            }
            return false;
        }

        @Override
        @NotNull
        protected JFrame createJFrame(@NotNull IdeFrame parent) {
            if (parent == null) {
                DockWindow.$$$reportNull$$$0(3);
            }
            JFrame frame = super.createJFrame(parent);
            this.installListeners(frame);
            JFrame jFrame = frame;
            if (jFrame == null) {
                DockWindow.$$$reportNull$$$0(4);
            }
            return jFrame;
        }

        @Override
        @NotNull
        protected JDialog createJDialog(@NotNull IdeFrame parent) {
            if (parent == null) {
                DockWindow.$$$reportNull$$$0(5);
            }
            JDialog frame = super.createJDialog(parent);
            this.installListeners(frame);
            JDialog jDialog = frame;
            if (jDialog == null) {
                DockWindow.$$$reportNull$$$0(6);
            }
            return jDialog;
        }

        private void installListeners(@NotNull Window frame) {
            if (frame == null) {
                DockWindow.$$$reportNull$$$0(7);
            }
            final UiNotifyConnector uiNotifyConnector = this.myContainer instanceof Activatable ? new UiNotifyConnector((Component)((RootPaneContainer)((Object)frame)).getContentPane(), (Activatable)this.myContainer) : null;
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DockWindow.this.myContainer.closeAll();
                    if (uiNotifyConnector != null) {
                        Disposer.dispose((Disposable)uiNotifyConnector);
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/docking/impl/DockManagerImpl$DockWindow";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/docking/impl/DockManagerImpl$DockWindow";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJFrame";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "dispatch";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createJFrame";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createJDialog";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "installListeners";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyDragSession
    implements DragSession {
        private final JDialog myWindow;
        private Image myDragImage;
        private final Image myDefaultDragImage;
        @NotNull
        private final DockableContent myContent;
        private DockContainer myStartDragContainer;
        private DockContainer myCurrentOverContainer;
        private final JLabel myImageContainer;

        private MyDragSession(@NotNull MouseEvent me, DockableContent content2) {
            if (content2 == null) {
                MyDragSession.$$$reportNull$$$0(0);
            }
            this.myWindow = new JDialog(UIUtil.getWindow((Component)me.getComponent()));
            this.myWindow.setUndecorated(true);
            this.myContent = content2;
            this.myStartDragContainer = DockManagerImpl.this.getContainerFor(me.getComponent());
            BufferedImage buffer = ImageUtil.toBufferedImage((Image)content2.getPreviewImage());
            double requiredSize2 = 220.0;
            double width = buffer.getWidth(null);
            double height = buffer.getHeight(null);
            double ratio = width > height ? requiredSize2 / width : requiredSize2 / height;
            this.myDragImage = this.myDefaultDragImage = buffer.getScaledInstance((int)(width * ratio), (int)(height * ratio), 4);
            this.myImageContainer = new JLabel(new Icon(){

                @Override
                public int getIconWidth() {
                    return MyDragSession.this.myDefaultDragImage.getWidth(MyDragSession.this.myWindow);
                }

                @Override
                public int getIconHeight() {
                    return MyDragSession.this.myDefaultDragImage.getHeight(MyDragSession.this.myWindow);
                }

                @Override
                public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                    StartupUiUtil.drawImage((Graphics)g, (Image)MyDragSession.this.myDefaultDragImage, (int)x, (int)y, (ImageObserver)MyDragSession.this.myWindow);
                }
            });
            this.myWindow.setContentPane(this.myImageContainer);
            this.setLocationFrom(me);
            this.myWindow.setVisible(true);
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            windowManager.setAlphaModeEnabled(this.myWindow, true);
            windowManager.setAlphaModeRatio(this.myWindow, 0.1f);
        }

        private void setLocationFrom(MouseEvent me) {
            Point showPoint = me.getPoint();
            SwingUtilities.convertPointToScreen(showPoint, me.getComponent());
            Dimension size = this.myImageContainer.getSize();
            showPoint.x -= size.width / 2;
            showPoint.y -= size.height / 2;
            this.myWindow.setBounds(new Rectangle(showPoint, size));
        }

        @NotNull
        public DockContainer.ContentResponse getResponse(MouseEvent e) {
            RelativePoint point = new RelativePoint(e);
            for (DockContainer each : DockManagerImpl.this.getAllContainers()) {
                DockContainer.ContentResponse response;
                RelativeRectangle rec = each.getAcceptArea();
                if (!rec.contains(point) || !(response = each.getContentResponse(this.myContent, point)).canAccept()) continue;
                DockContainer.ContentResponse contentResponse = response;
                if (contentResponse == null) {
                    MyDragSession.$$$reportNull$$$0(1);
                }
                return contentResponse;
            }
            DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                MyDragSession.$$$reportNull$$$0(2);
            }
            return contentResponse;
        }

        public void process(MouseEvent e) {
            RelativePoint point = new RelativePoint(e);
            Image img = null;
            if (e.getID() == 506) {
                DockContainer over = DockManagerImpl.this.findContainerFor(point, this.myContent);
                if (this.myCurrentOverContainer != null && this.myCurrentOverContainer != over) {
                    this.myCurrentOverContainer.resetDropOver(this.myContent);
                    this.myCurrentOverContainer = null;
                }
                if (this.myCurrentOverContainer == null && over != null) {
                    this.myCurrentOverContainer = over;
                    img = this.myCurrentOverContainer.startDropOver(this.myContent, point);
                }
                if (this.myCurrentOverContainer != null) {
                    img = this.myCurrentOverContainer.processDropOver(this.myContent, point);
                }
                if (img == null) {
                    img = this.myDefaultDragImage;
                }
                if (img != this.myDragImage) {
                    this.myDragImage = img;
                    this.myImageContainer.setIcon((Icon)IconUtil.createImageIcon(this.myDragImage));
                    this.myWindow.pack();
                }
                this.setLocationFrom(e);
            } else if (e.getID() == 502) {
                if (this.myCurrentOverContainer == null) {
                    DockManagerImpl.this.createNewDockContainerFor(this.myContent, point);
                } else {
                    this.myCurrentOverContainer.add(this.myContent, point);
                }
                DockManagerImpl.this.stopCurrentDragSession();
            }
        }

        public void cancel() {
            DockManagerImpl.this.stopCurrentDragSession();
        }

        private void cancelSession() {
            this.myWindow.dispose();
            if (this.myCurrentOverContainer != null) {
                this.myCurrentOverContainer.resetDropOver(this.myContent);
                this.myCurrentOverContainer = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/docking/impl/DockManagerImpl$MyDragSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/docking/impl/DockManagerImpl$MyDragSession";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

