/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.User32Ex;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinReg;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import javax.swing.SwingUtilities;

public final class WinFocusStealer
implements AWTEventListener {
    private static final Logger LOG = Logger.getInstance(WinFocusStealer.class);
    private static final int DEFAULT_TIMEOUT_MS = 200000;
    private final boolean myEnabled;
    private Boolean myUpdateScheduled;

    private WinFocusStealer() {
        if (JnaLoader.isLoaded()) {
            this.myEnabled = true;
            this.doUpdate(false);
            SwingUtilities.invokeLater(() -> Toolkit.getDefaultToolkit().addAWTEventListener(this, 133176L));
        } else {
            this.myEnabled = false;
            LOG.info("JNA isn't available, focus stealing logic is disabled");
        }
    }

    public static void setFocusStealingEnabled(boolean value2) {
        WinFocusStealer stealer = (WinFocusStealer)ApplicationManager.getApplication().getService(WinFocusStealer.class);
        if (stealer != null && stealer.myEnabled) {
            stealer.update(value2);
        }
    }

    private void update(boolean enabled) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting focus stealing status to '" + enabled + "'");
            }
            this.doUpdate(enabled);
        });
    }

    private void doUpdate(boolean enabled) {
        int currentTimeout;
        this.myUpdateScheduled = null;
        int targetTimeout = 0;
        if (!enabled) {
            targetTimeout = WinFocusStealer.readRegistryTimeoutValue();
        }
        if ((currentTimeout = WinFocusStealer.readCurrentTimeoutValue()) != targetTimeout && !WinFocusStealer.writeCurrentTimeoutValue(targetTimeout)) {
            this.myUpdateScheduled = enabled;
        }
    }

    private static int readRegistryTimeoutValue() {
        int targetTimeout = 200000;
        try {
            targetTimeout = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"Control Panel\\Desktop", (String)"ForegroundLockTimeout");
            if (LOG.isDebugEnabled()) {
                LOG.debug("ForegroundLockTimeout read from registry: " + targetTimeout);
            }
        }
        catch (Exception e) {
            LOG.warn("Error getting ForegroundLockTimeout from registry, assuming default value of " + targetTimeout, (Throwable)e);
        }
        return targetTimeout;
    }

    private static int readCurrentTimeoutValue() {
        int currentTimeout = 200000;
        try {
            WinDef.UINTByReference result2 = new WinDef.UINTByReference();
            if (User32Ex.INSTANCE.SystemParametersInfo(new WinDef.UINT(8192L), new WinDef.UINT(), result2, new WinDef.UINT())) {
                currentTimeout = result2.getValue().intValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Current foreground lock timeout: " + currentTimeout);
                }
            } else {
                LOG.warn("Failed to get foreground lock timeout using SystemParametersInfo, assuming default value of " + currentTimeout);
            }
        }
        catch (Exception e) {
            LOG.warn("Error getting foreground lock timeout using SystemParametersInfo, assuming default value of " + currentTimeout, (Throwable)e);
        }
        return currentTimeout;
    }

    private static boolean writeCurrentTimeoutValue(int value2) {
        try {
            if (User32Ex.INSTANCE.SystemParametersInfo(new WinDef.UINT(8193L), new WinDef.UINT(), new WinDef.UINT((long)value2), new WinDef.UINT())) {
                LOG.info("Foreground lock timeout set to " + value2);
                return true;
            }
            LOG.debug("Failed to set foreground lock timeout to " + value2 + ", will retry on next window activation");
            return false;
        }
        catch (Exception e) {
            LOG.warn("Error setting foreground lock timeout using SystemParametersInfo", (Throwable)e);
            return true;
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (this.myUpdateScheduled != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detected user interaction, trying to update focus stealing status to '" + this.myUpdateScheduled + "'");
            }
            this.doUpdate(this.myUpdateScheduled);
        }
    }
}

