/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Conditions;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;

public class TreeSpeedSearch
extends SpeedSearchBase<JTree> {
    protected boolean myCanExpand;
    private static final Convertor<TreePath, String> TO_STRING = path2 -> path2.getLastPathComponent().toString();
    private final Convertor<? super TreePath, String> myToStringConvertor;
    public static final Convertor<TreePath, String> NODE_DESCRIPTOR_TOSTRING = path2 -> {
        NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getLastUserObject(NodeDescriptor.class, (TreePath)path2);
        if (descriptor2 != null) {
            return descriptor2.toString();
        }
        return (String)TO_STRING.convert(path2);
    };

    public TreeSpeedSearch(JTree tree, Convertor<? super TreePath, String> toStringConvertor) {
        this(tree, toStringConvertor, false);
    }

    public TreeSpeedSearch(JTree tree) {
        this(tree, TO_STRING);
    }

    public TreeSpeedSearch(Tree tree, Convertor<? super TreePath, String> toString2) {
        this(tree, toString2, false);
    }

    public TreeSpeedSearch(Tree tree, Convertor<? super TreePath, String> toString2, boolean canExpand) {
        this((JTree)tree, toString2, canExpand);
    }

    public TreeSpeedSearch(JTree tree, Convertor<? super TreePath, String> toString2, boolean canExpand) {
        super(tree);
        this.setComparator(new SpeedSearchComparator(false, true));
        this.myToStringConvertor = toString2;
        this.myCanExpand = canExpand;
        new MySelectAllAction(tree, this).registerCustomShortcutSet(tree, null);
    }

    public void setCanExpand(boolean canExpand) {
        this.myCanExpand = canExpand;
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        TreeUtil.selectPath((JTree)((JTree)this.myComponent), (TreePath)((TreePath)element2));
    }

    @Override
    protected int getSelectedIndex() {
        if (this.myCanExpand) {
            return this.allPaths().indexOf(Conditions.equalTo((Object)((JTree)this.myComponent).getSelectionPath()));
        }
        int[] selectionRows = ((JTree)this.myComponent).getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    @NotNull
    protected final ListIterator<Object> getElementIterator(int startingViewIndex) {
        ListIterator<Object> listIterator = ((ArrayList)this.allPaths().addAllTo(new ArrayList())).listIterator(startingViewIndex);
        if (listIterator == null) {
            TreeSpeedSearch.$$$reportNull$$$0(0);
        }
        return listIterator;
    }

    @Override
    protected final int getElementCount() {
        return this.allPaths().size();
    }

    @NotNull
    protected JBIterable<TreePath> allPaths() {
        return TreeSpeedSearch.allPaths((JTree)this.getComponent(), this.myCanExpand);
    }

    @NotNull
    static JBIterable<TreePath> allPaths(JTree tree, boolean expand) {
        JBIterable paths;
        if (expand) {
            paths = TreeUtil.treePathTraverser((JTree)tree).traverse();
        } else {
            Object[] arr = new TreePath[tree.getRowCount()];
            for (int i2 = 0; i2 < arr.length; ++i2) {
                arr[i2] = tree.getPathForRow(i2);
            }
            paths = JBIterable.of((Object[])arr);
        }
        JBIterable jBIterable = paths.filter(o -> !(o.getLastPathComponent() instanceof LoadingNode));
        if (jBIterable == null) {
            TreeSpeedSearch.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @Override
    protected String getElementText(Object element2) {
        TreePath path2 = (TreePath)element2;
        String string = (String)this.myToStringConvertor.convert((Object)path2);
        if (string == null) {
            return (String)TO_STRING.convert((Object)path2);
        }
        return string;
    }

    @NotNull
    private List<TreePath> findAllFilteredElements(String s) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(0);
        while (it.hasNext()) {
            Object element2 = it.next();
            if (!this.isMatchingElement(element2, _s)) continue;
            paths.add((TreePath)element2);
        }
        ArrayList<TreePath> arrayList = paths;
        if (arrayList == null) {
            TreeSpeedSearch.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/TreeSpeedSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIterator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "allPaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredElements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JTree myTree;
        @NotNull
        private final TreeSpeedSearch mySearch;

        MySelectAllAction(@NotNull JTree tree, @NotNull TreeSpeedSearch search2) {
            if (tree == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search2 == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myTree = tree;
            this.mySearch = search2;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myTree.getSelectionModel().getSelectionMode() == 4);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean alreadySelected;
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(3);
            }
            TreeSelectionModel sm = this.myTree.getSelectionModel();
            String query2 = this.mySearch.getEnteredPrefix();
            if (query2 == null) {
                return;
            }
            List<TreePath> filtered2 = this.mySearch.findAllFilteredElements(query2);
            if (filtered2.isEmpty()) {
                return;
            }
            boolean bl = alreadySelected = sm.getSelectionCount() == filtered2.size() && ContainerUtil.and(filtered2, path2 -> sm.isPathSelected((TreePath)path2));
            if (alreadySelected) {
                TreePath anchor2 = this.myTree.getAnchorSelectionPath();
                sm.setSelectionPath(anchor2);
                this.myTree.setAnchorSelectionPath(anchor2);
                this.mySearch.findAndSelectElement(query2);
            } else {
                TreePath currentElement = (TreePath)this.mySearch.findElement(query2);
                TreePath anchor3 = (TreePath)ObjectUtils.chooseNotNull((Object)currentElement, (Object)filtered2.get(0));
                sm.setSelectionPaths(TreePathUtil.toTreePathArray(filtered2));
                this.myTree.setAnchorSelectionPath(anchor3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "search";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/TreeSpeedSearch$MySelectAllAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

