/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class TreeExpandCollapse {
    public static void collapse(JTree tree) {
        TreePath selectionPath = tree.getSelectionPath();
        tree.collapsePath(selectionPath);
    }

    public static void expand(JTree tree) {
        TreePath selectionPath = tree.getSelectionPath();
        tree.expandPath(selectionPath);
    }

    public static void expandAll(JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            paths = new TreePath[]{new TreePath(tree.getModel().getRoot())};
        }
        for (TreePath path2 : paths) {
            new ExpandContext(300, 10).expand(tree, path2);
        }
    }

    private static class ExpandContext {
        private final int myLevelsLeft;
        private int myExpansionLimit;

        ExpandContext(int expansionLimit, int levelsLeft) {
            this.myExpansionLimit = expansionLimit;
            this.myLevelsLeft = levelsLeft;
        }

        public int expand(JTree tree, TreePath path2) {
            if (this.myLevelsLeft == 0) {
                return this.myExpansionLimit;
            }
            TreeModel model2 = tree.getModel();
            Object node = path2.getLastPathComponent();
            int levelDecrement = 0;
            if (!tree.isExpanded(path2) && !model2.isLeaf(node)) {
                tree.expandPath(path2);
                levelDecrement = 1;
                --this.myExpansionLimit;
            }
            for (int i2 = 0; i2 < model2.getChildCount(node); ++i2) {
                Object child2 = model2.getChild(node, i2);
                if (model2.isLeaf(child2)) continue;
                ExpandContext childContext = new ExpandContext(this.myExpansionLimit, this.myLevelsLeft - levelDecrement);
                this.myExpansionLimit = childContext.expand(tree, path2.pathByAddingChild(child2));
                if (this.myExpansionLimit > 0) continue;
                return 0;
            }
            return this.myExpansionLimit;
        }
    }
}

