/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.IconDescriptionBundleEP;
import com.intellij.ui.IconManager;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.IconWrapperWithToolTip;
import com.intellij.ui.IconWrapperWithToolTipComposite;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.RasterizedImageDataLoader;
import com.intellij.ui.ScalableIconWrapperWithToolTip;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CoreIconManager
implements IconManager,
CoreAwareIconManager {
    private static final List<IconLayer> iconLayers = new CopyOnWriteArrayList<IconLayer>();
    private static final int FLAGS_LOCKED = 2048;
    private static final Logger LOG = Logger.getInstance(CoreIconManager.class);

    @NotNull
    public Icon getStubIcon() {
        Icon icon2 = AllIcons.Actions.Stub;
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    @NotNull
    public Icon getIcon(@NotNull String path2, @NotNull Class<?> aClass) {
        if (path2 == null) {
            CoreIconManager.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            CoreIconManager.$$$reportNull$$$0(2);
        }
        Icon icon2 = IconLoader.getIcon((String)path2, aClass);
        IconDescriptionLoader tooltip2 = new IconDescriptionLoader(path2);
        if (icon2 instanceof ScalableIcon) {
            return new ScalableIconWrapperWithToolTip((ScalableIcon)icon2, (Supplier<String>)tooltip2);
        }
        return new IconWrapperWithToolTip(icon2, tooltip2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Icon loadRasterizedIcon(@NotNull String path2, @NotNull ClassLoader classLoader, long cacheKey, int n) {
        void flags;
        if (path2 == null) {
            CoreIconManager.$$$reportNull$$$0(3);
        }
        if (classLoader == null) {
            CoreIconManager.$$$reportNull$$$0(4);
        }
        assert (!path2.isEmpty() && path2.charAt(0) != '/');
        return new IconWithToolTipImpl(path2, CoreIconManager.createRasterizedImageDataLoader(path2, classLoader, cacheKey, (int)flags));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ImageDataLoader createRasterizedImageDataLoader(@NotNull String path2, @NotNull ClassLoader classLoader, long cacheKey, int n) {
        void imageFlags;
        if (path2 == null) {
            CoreIconManager.$$$reportNull$$$0(5);
        }
        if (classLoader == null) {
            CoreIconManager.$$$reportNull$$$0(6);
        }
        long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
        Pair patchedPath = IconLoader.patchPath((String)path2, (ClassLoader)classLoader);
        String effectivePath = path2;
        if (patchedPath != null) {
            String string = effectivePath = ((String)patchedPath.first).startsWith("/") ? ((String)patchedPath.first).substring(1) : (String)patchedPath.first;
            if (patchedPath.second != null) {
                classLoader = (ClassLoader)patchedPath.second;
            }
        }
        RasterizedImageDataLoader resolver = new RasterizedImageDataLoader(effectivePath, classLoader, cacheKey, (int)imageFlags);
        if (startTime != -1L) {
            IconLoadMeasurer.findIcon.end(startTime);
        }
        RasterizedImageDataLoader rasterizedImageDataLoader = resolver;
        if (rasterizedImageDataLoader == null) {
            CoreIconManager.$$$reportNull$$$0(7);
        }
        return rasterizedImageDataLoader;
    }

    @NotNull
    public Icon createEmptyIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(8);
        }
        EmptyIcon emptyIcon = EmptyIcon.create((Icon)icon2);
        if (emptyIcon == null) {
            CoreIconManager.$$$reportNull$$$0(9);
        }
        return emptyIcon;
    }

    @NotNull
    public <T> Icon createDeferredIcon(@Nullable Icon base, T param, @NotNull Function<? super T, ? extends Icon> iconProducer) {
        if (iconProducer == null) {
            CoreIconManager.$$$reportNull$$$0(10);
        }
        Icon icon2 = IconDeferrer.getInstance().defer(base, param, iconProducer);
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(11);
        }
        return icon2;
    }

    public void registerIconLayer(int flagMask, @NotNull Icon icon2) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(12);
        }
        for (IconLayer iconLayer : iconLayers) {
            if (iconLayer.flagMask != flagMask) continue;
            return;
        }
        iconLayers.add(new IconLayer(flagMask, icon2));
    }

    @NotNull
    public Icon tooltipOnlyIfComposite(@NotNull Icon icon2) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(13);
        }
        return new IconWrapperWithToolTipComposite(icon2);
    }

    @NotNull
    public RowIcon createRowIcon(int iconCount, RowIcon.Alignment alignment) {
        return new com.intellij.ui.RowIcon(iconCount, alignment);
    }

    @NotNull
    public RowIcon createRowIcon(Icon ... icons) {
        if (icons == null) {
            CoreIconManager.$$$reportNull$$$0(14);
        }
        return new com.intellij.ui.RowIcon(icons);
    }

    @NotNull
    public com.intellij.ui.RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon2, int flags) {
        if (instance == null) {
            CoreIconManager.$$$reportNull$$$0(15);
        }
        ArrayList<Icon> layersFromProviders = new ArrayList<Icon>();
        for (Object provider2 : IconLayerProvider.EP_NAME.getExtensionList()) {
            Icon layerIcon = provider2.getLayerIcon(instance, BitUtil.isSet((int)flags, (int)2048));
            if (layerIcon == null) continue;
            layersFromProviders.add(layerIcon);
        }
        if (flags != 0 || !layersFromProviders.isEmpty()) {
            ArrayList<Icon> iconLayers = new ArrayList<Icon>();
            for (IconLayer l : CoreIconManager.iconLayers) {
                if (!BitUtil.isSet((int)flags, (int)l.flagMask)) continue;
                iconLayers.add(l.icon);
            }
            iconLayers.addAll(layersFromProviders);
            LayeredIcon layeredIcon = new LayeredIcon(1 + iconLayers.size());
            layeredIcon.setIcon(icon2, 0);
            for (int i2 = 0; i2 < iconLayers.size(); ++i2) {
                Icon icon1 = (Icon)iconLayers.get(i2);
                layeredIcon.setIcon(icon1, i2 + 1);
            }
            icon2 = layeredIcon;
        }
        com.intellij.ui.RowIcon baseIcon = new com.intellij.ui.RowIcon(2);
        baseIcon.setIcon(icon2, 0);
        com.intellij.ui.RowIcon rowIcon = baseIcon;
        if (rowIcon == null) {
            CoreIconManager.$$$reportNull$$$0(16);
        }
        return rowIcon;
    }

    @NotNull
    public Icon createOffsetIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(17);
        }
        return new OffsetIcon(icon2);
    }

    @NotNull
    public Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            CoreIconManager.$$$reportNull$$$0(18);
        }
        if (color == null) {
            CoreIconManager.$$$reportNull$$$0(19);
        }
        Icon icon2 = IconUtil.colorize(g, source, color);
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(20);
        }
        return icon2;
    }

    @NotNull
    public Icon createLayered(Icon ... icons) {
        if (icons == null) {
            CoreIconManager.$$$reportNull$$$0(21);
        }
        return new LayeredIcon(icons);
    }

    @NotNull
    public Icon getIcon(@NotNull VirtualFile file2, int flags, @Nullable Project project) {
        if (file2 == null) {
            CoreIconManager.$$$reportNull$$$0(22);
        }
        Icon icon2 = IconUtil.getIcon(file2, flags, project);
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(23);
        }
        return icon2;
    }

    @NotNull
    public Runnable wakeUpNeo(@NotNull Object reason) {
        if (reason == null) {
            CoreIconManager.$$$reportNull$$$0(24);
        }
        Runnable runnable2 = MacUtil.wakeUpNeo((Object)reason);
        if (runnable2 == null) {
            CoreIconManager.$$$reportNull$$$0(25);
        }
        return runnable2;
    }

    @Nullable
    private static String findIconDescription(@NotNull String path2) {
        String pathWithoutExt;
        if (path2 == null) {
            CoreIconManager.$$$reportNull$$$0(26);
        }
        String key = "icon." + ((pathWithoutExt = Strings.trimEnd((String)path2, (String)".svg")).startsWith("/") ? pathWithoutExt.substring(1) : pathWithoutExt).replace('/', '.') + ".tooltip";
        Ref result2 = new Ref();
        IconDescriptionBundleEP.EP_NAME.processWithPluginDescriptor((ep2, descriptor2) -> {
            ResourceBundle bundle;
            String description;
            ClassLoader classLoader;
            ClassLoader classLoader2 = classLoader = descriptor2 == null ? null : descriptor2.getPluginClassLoader();
            if (classLoader == null) {
                classLoader = CoreIconManager.class.getClassLoader();
            }
            if ((description = AbstractBundle.messageOrNull((ResourceBundle)(bundle = DynamicBundle.INSTANCE.getResourceBundle(ep2.resourceBundle, classLoader)), (String)key, (Object[])new Object[0])) != null) {
                result2.set((Object)description);
            }
        });
        if (result2.get() == null && Registry.is((String)"ide.icon.tooltips.trace.missing", (boolean)false)) {
            LOG.info("Icon tooltip requested but not found for " + path2);
        }
        return (String)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CoreIconManager";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconProducer";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CoreIconManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRasterizedImageDataLoader";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeferredIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayeredIcon";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "colorize";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "wakeUpNeo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadRasterizedIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRasterizedImageDataLoader";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDeferredIcon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerIconLayer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tooltipOnlyIfComposite";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRowIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLayeredIcon";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createOffsetIcon";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "colorize";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createLayered";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "wakeUpNeo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findIconDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IconDescriptionLoader
    implements Supplier<String> {
        private final String myPath;
        private String myResult;
        private boolean myCalculated;

        private IconDescriptionLoader(String path2) {
            this.myPath = path2;
        }

        @Override
        public String get() {
            if (!this.myCalculated) {
                this.myResult = CoreIconManager.findIconDescription(this.myPath);
                this.myCalculated = true;
            }
            return this.myResult;
        }
    }

    private static final class IconLayer {
        private final int flagMask;
        @NotNull
        private final Icon icon;

        private IconLayer(int flagMask, @NotNull Icon icon2) {
            if (icon2 == null) {
                IconLayer.$$$reportNull$$$0(0);
            }
            BitUtil.assertOneBitMask((int)flagMask);
            this.flagMask = flagMask;
            this.icon = icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/CoreIconManager$IconLayer", "<init>"));
        }
    }

    private static final class IconWithToolTipImpl
    extends IconLoader.CachedImageIcon
    implements IconWithToolTip {
        private String result;
        private boolean isTooltipCalculated;

        IconWithToolTipImpl(@NotNull String originalPath, @NotNull ImageDataLoader resolver) {
            if (originalPath == null) {
                IconWithToolTipImpl.$$$reportNull$$$0(0);
            }
            if (resolver == null) {
                IconWithToolTipImpl.$$$reportNull$$$0(1);
            }
            super(originalPath, resolver, null, null);
        }

        @Override
        @NlsContexts.Tooltip
        @Nullable
        public String getToolTip(boolean composite2) {
            if (!this.isTooltipCalculated) {
                this.result = CoreIconManager.findIconDescription(Objects.requireNonNull(this.getOriginalPath()));
                this.isTooltipCalculated = true;
            }
            return this.result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolver";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/CoreIconManager$IconWithToolTipImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

