/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.spellchecker.quickfixes.DictionarySuggestionProvider;
import com.intellij.spellchecker.quickfixes.LazySuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends LazySuggestions
implements SpellCheckerQuickFix {
    public RenameTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getFamilyName() {
        String string = RenameTo.getFixName();
        if (string == null) {
            RenameTo.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static DictionarySuggestionProvider findProvider() {
        for (Object extension2 : NameSuggestionProvider.EP_NAME.getExtensionList()) {
            if (!(extension2 instanceof DictionarySuggestionProvider)) continue;
            return (DictionarySuggestionProvider)((Object)extension2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement psiElement;
        DictionarySuggestionProvider provider2;
        if (project == null) {
            RenameTo.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            RenameTo.$$$reportNull$$$0(2);
        }
        if ((provider2 = RenameTo.findProvider()) != null) {
            provider2.setActive(true);
        }
        if ((psiElement = descriptor2.getPsiElement()) == null) {
            return;
        }
        Editor editor = this.getEditor(psiElement, project);
        if (editor == null) {
            return;
        }
        SimpleDataContext.Builder builder2 = SimpleDataContext.builder();
        if (editor instanceof EditorWindow) {
            builder2.add(CommonDataKeys.EDITOR, editor);
            builder2.add(CommonDataKeys.PSI_ELEMENT, psiElement);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement data2 = (PsiElement)new TextEditorPsiDataProvider().getData(CommonDataKeys.PSI_ELEMENT.getName(), editor, editor.getCaretModel().getCurrentCaret());
            builder2.add(CommonDataKeys.PSI_ELEMENT, data2);
        }
        Boolean selectAll2 = (Boolean)editor.getUserData(RenameHandlerRegistry.SELECT_ALL);
        try {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)true);
            DataContext dataContext = builder2.setParent(EditorUtil.getEditorDataContext(editor)).build();
            RenameElementAction action2 = new RenameElementAction();
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"", (DataContext)dataContext);
            action2.actionPerformed(event);
            if (provider2 != null) {
                provider2.setActive(false);
            }
        }
        finally {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)selectAll2);
        }
    }

    @Nls
    public static String getFixName() {
        return SpellCheckerBundle.message("rename.to", new Object[0]);
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    @Nullable
    protected Editor getEditor(PsiElement element2, @NotNull Project project) {
        if (project == null) {
            RenameTo.$$$reportNull$$$0(3);
        }
        return InjectedLanguageUtil.findInjectionHost(element2) != null ? InjectedLanguageUtil.openEditorFor(element2.getContainingFile(), project) : FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

