/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WordSplitter
extends BaseSplitter {
    private static final WordSplitter INSTANCE = new WordSplitter();
    @NonNls
    private static final Pattern SPECIAL = Pattern.compile("&\\p{Alnum}{2};?|#\\p{Alnum}{3,6}|0x\\p{Alnum}?");

    public static WordSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text2, @NotNull TextRange range2, Consumer<TextRange> consumer) {
        if (range2 == null) {
            WordSplitter.$$$reportNull$$$0(0);
        }
        if (text2 == null || range2.getLength() <= 1) {
            return;
        }
        try {
            Matcher specialMatcher = SPECIAL.matcher(WordSplitter.newBombedCharSequence(text2));
            specialMatcher.region(range2.getStartOffset(), range2.getEndOffset());
            if (specialMatcher.find()) {
                TextRange found = new TextRange(specialMatcher.start(), specialMatcher.end());
                WordSplitter.addWord(consumer, true, found);
            } else {
                IdentifierSplitter.getInstance().split(text2, range2, consumer);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spellchecker/inspections/WordSplitter", "split"));
    }
}

