/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.LanguageSpellchecking;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.Consumer;
import com.intellij.util.containers.CollectionFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpellCheckingInspection
extends LocalInspectionTool {
    public static final String SPELL_CHECKING_INSPECTION_TOOL_NAME = "SpellCheckingInspection";
    public boolean processCode = true;
    public boolean processLiterals = true;
    public boolean processComments = true;

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element2) {
        Language language;
        SpellcheckingStrategy strategy;
        if (element2 != null && (strategy = SpellCheckingInspection.getSpellcheckingStrategy(element2, language = element2.getLanguage())) instanceof SuppressibleSpellcheckingStrategy) {
            SuppressQuickFix[] suppressQuickFixArray = ((SuppressibleSpellcheckingStrategy)strategy).getSuppressActions(element2, this.getShortName());
            if (suppressQuickFixArray == null) {
                SpellCheckingInspection.$$$reportNull$$$0(0);
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(element2);
        if (suppressQuickFixArray == null) {
            SpellCheckingInspection.$$$reportNull$$$0(1);
        }
        return suppressQuickFixArray;
    }

    private static SpellcheckingStrategy getSpellcheckingStrategy(@NotNull PsiElement element2, @NotNull Language language) {
        if (element2 == null) {
            SpellCheckingInspection.$$$reportNull$$$0(2);
        }
        if (language == null) {
            SpellCheckingInspection.$$$reportNull$$$0(3);
        }
        for (SpellcheckingStrategy strategy : LanguageSpellchecking.INSTANCE.allForLanguage(language)) {
            if (!strategy.isMyContext(element2)) continue;
            return strategy;
        }
        return null;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element2) {
        Language language;
        SpellcheckingStrategy strategy;
        if (element2 == null) {
            SpellCheckingInspection.$$$reportNull$$$0(4);
        }
        if ((strategy = SpellCheckingInspection.getSpellcheckingStrategy(element2, language = element2.getLanguage())) instanceof SuppressibleSpellcheckingStrategy) {
            return ((SuppressibleSpellcheckingStrategy)strategy).isSuppressedFor(element2, this.getShortName());
        }
        return super.isSuppressedFor(element2);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return SPELL_CHECKING_INSPECTION_TOOL_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(5);
        }
        final SpellCheckerManager manager2 = SpellCheckerManager.getInstance(holder.getProject());
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (holder.getResultCount() > 1000) {
                    return;
                }
                ASTNode node = element2.getNode();
                if (node == null) {
                    return;
                }
                Language language = element2.getLanguage();
                IElementType elementType = node.getElementType();
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
                if (parserDefinition != null && (parserDefinition.getStringLiteralElements().contains(elementType) ? !SpellCheckingInspection.this.processLiterals : (parserDefinition.getCommentTokens().contains(elementType) ? !SpellCheckingInspection.this.processComments : !SpellCheckingInspection.this.processCode))) {
                    return;
                }
                PsiFile containingFile = element2.getContainingFile();
                if (containingFile != null && Boolean.TRUE.equals(containingFile.getUserData(InjectedLanguageManager.FRANKENSTEIN_INJECTION))) {
                    return;
                }
                SpellCheckingInspection.tokenize(element2, language, new MyTokenConsumer(manager2, holder, LanguageNamesValidation.INSTANCE.forLanguage(language)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spellchecker/inspections/SpellCheckingInspection$1", "visitElement"));
            }
        };
    }

    public static void tokenize(@NotNull PsiElement element2, @NotNull Language language, TokenConsumer consumer) {
        SpellcheckingStrategy factoryByLanguage;
        if (element2 == null) {
            SpellCheckingInspection.$$$reportNull$$$0(6);
        }
        if (language == null) {
            SpellCheckingInspection.$$$reportNull$$$0(7);
        }
        if ((factoryByLanguage = SpellCheckingInspection.getSpellcheckingStrategy(element2, language)) == null) {
            return;
        }
        Tokenizer tokenizer = factoryByLanguage.getTokenizer(element2);
        tokenizer.tokenize(element2, consumer);
    }

    private static void addBatchDescriptor(PsiElement element2, @NotNull TextRange textRange, @NotNull ProblemsHolder holder) {
        if (textRange == null) {
            SpellCheckingInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(9);
        }
        LocalQuickFix[] fixes = SpellcheckingStrategy.getDefaultBatchFixes();
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element2, textRange, fixes, false);
        holder.registerProblem(problemDescriptor);
    }

    private static void addRegularDescriptor(PsiElement element2, @NotNull TextRange textRange, @NotNull ProblemsHolder holder, boolean useRename, String wordWithTypo) {
        SpellcheckingStrategy strategy;
        if (textRange == null) {
            SpellCheckingInspection.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            SpellCheckingInspection.$$$reportNull$$$0(11);
        }
        LocalQuickFix[] fixes = (strategy = SpellCheckingInspection.getSpellcheckingStrategy(element2, element2.getLanguage())) != null ? strategy.getRegularFixes(element2, textRange, useRename, wordWithTypo) : SpellcheckingStrategy.getDefaultRegularFixes(useRename, wordWithTypo, element2, textRange);
        ProblemDescriptor problemDescriptor = SpellCheckingInspection.createProblemDescriptor(element2, textRange, fixes, true);
        holder.registerProblem(problemDescriptor);
    }

    private static ProblemDescriptor createProblemDescriptor(PsiElement element2, TextRange textRange, LocalQuickFix[] fixes, boolean onTheFly) {
        String description = SpellCheckerBundle.message("typo.in.word.ref", new Object[0]);
        return new ProblemDescriptorBase(element2, element2, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, textRange, onTheFly, onTheFly);
    }

    public JComponent createOptionsPanel() {
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.code", new Object[0]), (InspectionProfileEntry)this, "processCode"));
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.literals", new Object[0]), (InspectionProfileEntry)this, "processLiterals"));
        verticalBox.add((Component)new SingleCheckboxOptionsPanel(SpellCheckerBundle.message("process.comments", new Object[0]), (InspectionProfileEntry)this, "processComments"));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)verticalBox, "North");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/inspections/SpellCheckingInspection";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/inspections/SpellCheckingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpellcheckingStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBatchDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addRegularDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyTokenConsumer
    extends TokenConsumer
    implements Consumer<TextRange> {
        private final Set<String> myAlreadyChecked = CollectionFactory.createSmallMemoryFootprintSet();
        private final SpellCheckerManager myManager;
        private final ProblemsHolder myHolder;
        private final NamesValidator myNamesValidator;
        private PsiElement myElement;
        private String myText;
        private boolean myUseRename;
        private int myOffset;

        MyTokenConsumer(SpellCheckerManager manager2, ProblemsHolder holder, NamesValidator namesValidator) {
            this.myManager = manager2;
            this.myHolder = holder;
            this.myNamesValidator = namesValidator;
        }

        @Override
        public void consumeToken(PsiElement element2, String text2, boolean useRename, int offset, TextRange rangeToCheck, Splitter splitter) {
            this.myElement = element2;
            this.myText = text2;
            this.myUseRename = useRename;
            this.myOffset = offset;
            splitter.split(text2, rangeToCheck, this);
        }

        public void consume(TextRange range2) {
            String word = range2.substring(this.myText);
            if (!this.myHolder.isOnTheFly() && this.myAlreadyChecked.contains(word)) {
                return;
            }
            boolean keyword = this.myNamesValidator.isKeyword(word, this.myElement.getProject());
            if (keyword) {
                return;
            }
            if (this.myManager.hasProblem(word)) {
                Tokenizer tokenizer;
                SpellcheckingStrategy strategy = SpellCheckingInspection.getSpellcheckingStrategy(this.myElement, this.myElement.getLanguage());
                Tokenizer tokenizer2 = tokenizer = strategy != null ? strategy.getTokenizer(this.myElement) : null;
                if (tokenizer != null) {
                    range2 = tokenizer.getHighlightingRange(this.myElement, this.myOffset, range2);
                }
                assert (range2.getStartOffset() >= 0);
                if (this.myHolder.isOnTheFly()) {
                    SpellCheckingInspection.addRegularDescriptor(this.myElement, range2, this.myHolder, this.myUseRename, word);
                } else {
                    this.myAlreadyChecked.add(word);
                    SpellCheckingInspection.addBatchDescriptor(this.myElement, range2, this.myHolder);
                }
            }
        }
    }
}

