/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceUsageTransformer;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SliceUsage
extends UsageInfo2UsageAdapter {
    private final SliceUsage myParent;
    public final SliceAnalysisParams params;

    public SliceUsage(@NotNull PsiElement element2, @NotNull SliceUsage parent) {
        if (element2 == null) {
            SliceUsage.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            SliceUsage.$$$reportNull$$$0(1);
        }
        this(element2, parent, parent.params);
    }

    protected SliceUsage(@NotNull PsiElement element2, @NotNull SliceUsage parent, @NotNull SliceAnalysisParams params) {
        if (element2 == null) {
            SliceUsage.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            SliceUsage.$$$reportNull$$$0(3);
        }
        if (params == null) {
            SliceUsage.$$$reportNull$$$0(4);
        }
        super(new UsageInfo(element2));
        this.myParent = parent;
        this.params = params;
    }

    protected SliceUsage(@NotNull PsiElement element2, @NotNull SliceAnalysisParams params) {
        if (element2 == null) {
            SliceUsage.$$$reportNull$$$0(5);
        }
        if (params == null) {
            SliceUsage.$$$reportNull$$$0(6);
        }
        super(new UsageInfo(element2));
        this.myParent = null;
        this.params = params;
    }

    @NotNull
    private static Collection<SliceUsage> transformToLanguageSpecificUsage(@NotNull SliceUsage usage) {
        PsiElement element2;
        if (usage == null) {
            SliceUsage.$$$reportNull$$$0(7);
        }
        if ((element2 = usage.getElement()) == null) {
            List<SliceUsage> list2 = Collections.singletonList(usage);
            if (list2 == null) {
                SliceUsage.$$$reportNull$$$0(8);
            }
            return list2;
        }
        SliceLanguageSupportProvider provider2 = LanguageSlicing.getProvider(element2);
        if (!(provider2 instanceof SliceUsageTransformer)) {
            List<SliceUsage> list3 = Collections.singletonList(usage);
            if (list3 == null) {
                SliceUsage.$$$reportNull$$$0(9);
            }
            return list3;
        }
        Collection<SliceUsage> transformedUsages = ((SliceUsageTransformer)((Object)provider2)).transform(usage);
        Collection<SliceUsage> collection = transformedUsages != null ? transformedUsages : Collections.singletonList(usage);
        if (collection == null) {
            SliceUsage.$$$reportNull$$$0(10);
        }
        return collection;
    }

    public void processChildren(@NotNull Processor<? super SliceUsage> processor2) {
        if (processor2 == null) {
            SliceUsage.$$$reportNull$$$0(11);
        }
        PsiElement element2 = (PsiElement)ReadAction.compute(() -> ((SliceUsage)this).getElement());
        ProgressIndicator indicator2 = ProgressManager.getInstance().getProgressIndicator();
        indicator2.checkCanceled();
        HashingStrategy<SliceUsage> strategy = new HashingStrategy<SliceUsage>(){

            public int hashCode(SliceUsage object) {
                return object.getUsageInfo().hashCode();
            }

            public boolean equals(SliceUsage o1, SliceUsage o2) {
                return o1.getUsageInfo().equals((Object)o2.getUsageInfo());
            }
        };
        final class SliceUsageUniqueProcessor
        extends CommonProcessors.UniqueProcessor<SliceUsage> {
            private SliceUsageUniqueProcessor(Processor<? super SliceUsage> processor2, HashingStrategy<? super SliceUsage> strategy) {
                if (processor2 == null) {
                    SliceUsageUniqueProcessor.$$$reportNull$$$0(0);
                }
                super(processor2, strategy);
            }

            public boolean process(SliceUsage usage) {
                PsiElement psiElement;
                SliceValueFilter filter = usage.params.valueFilter;
                if (filter != null && (psiElement = usage.getElement()) != null && !filter.allowed(psiElement)) {
                    return true;
                }
                return ContainerUtil.and(SliceUsage.transformToLanguageSpecificUsage(usage), x$0 -> super.process(x$0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUsage$1SliceUsageUniqueProcessor", "<init>"));
            }
        }
        SliceUsageUniqueProcessor uniqueProcessor = new SliceUsageUniqueProcessor(processor2, (HashingStrategy<? super SliceUsage>)strategy);
        Runnable processUsagesFlow = () -> {
            if (this.params.dataFlowToThis) {
                this.processUsagesFlownDownTo(element2, (Processor<? super SliceUsage>)uniqueProcessor);
            } else {
                this.processUsagesFlownFromThe(element2, (Processor<? super SliceUsage>)uniqueProcessor);
            }
        };
        ReadAction.nonBlocking((Runnable)processUsagesFlow).executeSynchronously();
    }

    protected abstract void processUsagesFlownFromThe(PsiElement var1, Processor<? super SliceUsage> var2);

    protected abstract void processUsagesFlownDownTo(PsiElement var1, Processor<? super SliceUsage> var2);

    public SliceUsage getParent() {
        return this.myParent;
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.params.scope;
        if (analysisScope == null) {
            SliceUsage.$$$reportNull$$$0(12);
        }
        return analysisScope;
    }

    @NotNull
    protected abstract SliceUsage copy();

    public boolean canBeLeaf() {
        return this.getElement() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceUsage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceUsage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "transformToLanguageSpecificUsage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "transformToLanguageSpecificUsage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

