/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceTreeStructure;
import com.intellij.slicer.SliceUsage;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceTreeBuilder
extends AbstractTreeBuilder {
    public final boolean splitByLeafExpressions;
    public final boolean dataFlowToThis;
    public volatile boolean analysisInProgress;
    public static final Comparator<NodeDescriptor<?>> SLICE_NODE_COMPARATOR = (o1, o2) -> {
        PsiFile file2;
        if (!(o1 instanceof SliceNode) || !(o2 instanceof SliceNode)) {
            return AlphaComparator.INSTANCE.compare(o1, o2);
        }
        SliceNode node1 = (SliceNode)o1;
        SliceNode node2 = (SliceNode)o2;
        SliceUsage usage1 = (SliceUsage)((Object)((Object)node1.getValue()));
        SliceUsage usage2 = (SliceUsage)((Object)((Object)node2.getValue()));
        PsiElement element1 = usage1.getElement();
        PsiElement element2 = usage2.getElement();
        PsiFile file1 = element1 == null ? null : element1.getContainingFile();
        PsiFile psiFile = file2 = element2 == null ? null : element2.getContainingFile();
        if (file1 == null) {
            return file2 == null ? 0 : 1;
        }
        if (file2 == null) {
            return -1;
        }
        if (file1 == file2) {
            return element1.getTextOffset() - element2.getTextOffset();
        }
        return Comparing.compare((Comparable)((Object)file1.getName()), (Comparable)((Object)file2.getName()));
    };

    SliceTreeBuilder(@NotNull JTree tree, @NotNull Project project, boolean dataFlowToThis, @NotNull SliceNode rootNode, boolean splitByLeafExpressions) {
        if (tree == null) {
            SliceTreeBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SliceTreeBuilder.$$$reportNull$$$0(1);
        }
        if (rootNode == null) {
            SliceTreeBuilder.$$$reportNull$$$0(2);
        }
        super(tree, (DefaultTreeModel)tree.getModel(), (AbstractTreeStructure)new SliceTreeStructure(project, rootNode), SLICE_NODE_COMPARATOR, false);
        this.dataFlowToThis = dataFlowToThis;
        this.splitByLeafExpressions = splitByLeafExpressions;
        this.initRootNode();
    }

    SliceNode getRootSliceNode() {
        return (SliceNode)this.getTreeStructure().getRootElement();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return false;
    }

    void switchToGroupedByLeavesNodes() {
        SliceLanguageSupportProvider provider2 = this.getRootSliceNode().getProvider();
        if (provider2 == null) {
            return;
        }
        this.analysisInProgress = true;
        provider2.startAnalyzeLeafValues(this.getTreeStructure(), () -> {
            this.analysisInProgress = false;
        });
    }

    public void switchToLeafNulls() {
        SliceLanguageSupportProvider provider2 = this.getRootSliceNode().getProvider();
        if (provider2 == null) {
            return;
        }
        this.analysisInProgress = true;
        provider2.startAnalyzeNullness(this.getTreeStructure(), () -> {
            this.analysisInProgress = false;
        });
    }

    @Nullable
    protected ProgressIndicator createProgressIndicator() {
        return new ProgressIndicatorBase(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "rootNode";
                break;
            }
        }
        objectArray[1] = "com/intellij/slicer/SliceTreeBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

