/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.serviceContainer.BaseComponentAdapter;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.serviceContainer.ConstructorParameterResolverKt;
import com.intellij.serviceContainer.ContainerUtilKt;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\t\u001a\u00020\nH\u0002JJ\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fJD\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/serviceContainer/ConstructorParameterResolver;", "", "()V", "handleUnsatisfiedDependency", "componentManager", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "requestorClass", "Ljava/lang/Class;", "expectedType", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "isResolvable", "", "requestorKey", "requestorConstructor", "Ljava/lang/reflect/Constructor;", "isExtensionSupported", "resolveInstance", "intellij.platform.serviceContainer"})
public final class ConstructorParameterResolver {
    public final boolean isResolvable(@NotNull ComponentManagerImpl componentManager, @NotNull Object requestorKey, @NotNull Class<?> requestorClass, @NotNull Constructor<?> requestorConstructor, @NotNull Class<?> expectedType, @NotNull PluginId pluginId, boolean isExtensionSupported) {
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)requestorKey, (String)"requestorKey");
        Intrinsics.checkNotNullParameter(requestorClass, (String)"requestorClass");
        Intrinsics.checkNotNullParameter(requestorConstructor, (String)"requestorConstructor");
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        if (expectedType == ComponentManager.class || ConstructorParameterResolverKt.access$findTargetAdapter(componentManager, expectedType, requestorKey, requestorClass, requestorConstructor, pluginId) != null) {
            return true;
        }
        return isExtensionSupported && componentManager.getExtensionArea().findExtensionByClass(expectedType) != null;
    }

    @Nullable
    public final Object resolveInstance(@NotNull ComponentManagerImpl componentManager, @NotNull Object requestorKey, @NotNull Class<?> requestorClass, @NotNull Constructor<?> requestorConstructor, @NotNull Class<?> expectedType, @NotNull PluginId pluginId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)requestorKey, (String)"requestorKey");
        Intrinsics.checkNotNullParameter(requestorClass, (String)"requestorClass");
        Intrinsics.checkNotNullParameter(requestorConstructor, (String)"requestorConstructor");
        Intrinsics.checkNotNullParameter(expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        if (expectedType == ComponentManager.class) {
            return componentManager;
        }
        if (ContainerUtilKt.isLightService(expectedType)) {
            throw (Throwable)new PluginException("Do not use constructor injection for light services (requestorClass=" + requestorClass + ", requestedService=" + expectedType + ')', pluginId);
        }
        ComponentAdapter componentAdapter2 = ConstructorParameterResolverKt.access$findTargetAdapter(componentManager, expectedType, requestorKey, requestorClass, requestorConstructor, pluginId);
        if (componentAdapter2 == null) {
            return this.handleUnsatisfiedDependency(componentManager, requestorClass, expectedType, pluginId);
        }
        ComponentAdapter adapter = componentAdapter2;
        if (adapter instanceof BaseComponentAdapter) {
            object = BaseComponentAdapter.getInstance$default((BaseComponentAdapter)adapter, ((BaseComponentAdapter)adapter).getComponentManager$intellij_platform_serviceContainer(), null, false, null, 12, null);
        } else if (componentManager.getParent$intellij_platform_serviceContainer() == null) {
            object = adapter.getComponentInstance((PicoContainer)componentManager);
        } else {
            Object object2 = adapter.getComponentKey();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"adapter.componentKey");
            object = componentManager.getComponentInstance(object2);
        }
        return object;
    }

    private final Object handleUnsatisfiedDependency(ComponentManagerImpl componentManager, Class<?> requestorClass, Class<?> expectedType, PluginId pluginId) {
        Object object = componentManager.getExtensionArea().findExtensionByClass(expectedType);
        if (object == null) {
            return null;
        }
        Object extension2 = object;
        String message2 = "Do not use constructor injection to get extension instance (requestorClass=" + requestorClass.getName() + ", extensionClass=" + expectedType.getName() + ')';
        Application app = componentManager.getApplication();
        if (app != null && app.isUnitTestMode() && Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)"org.jetbrains.kotlin") ^ true && Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)"Lombook Plugin") ^ true) {
            throw (Throwable)new PluginException(message2, pluginId);
        }
        ComponentManagerImplKt.getLOG().warn(message2);
        return extension2;
    }
}

