/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.Binding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.WriteContext;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010\u0003\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/serialization/Int2IntMapBinding;", "Lcom/intellij/serialization/Binding;", "()V", "deserialize", "", "context", "Lcom/intellij/serialization/ReadContext;", "hostObject", "", "property", "Lcom/intellij/serialization/MutableAccessor;", "doRead", "reader", "Lcom/amazon/ion/IonReader;", "Lcom/intellij/serialization/ValueReader;", "size", "", "result", "Lit/unimi/dsi/fastutil/ints/Int2IntMap;", "readMap", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "serialize", "obj", "Lcom/intellij/serialization/WriteContext;", "intellij.platform.objectSerializer"})
public final class Int2IntMapBinding
implements Binding {
    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Int2IntMap map2 = (Int2IntMap)obj2;
        IonWriter writer = context2.getWriter();
        if (context2.getFilter().getSkipEmptyMap() && map2.isEmpty()) {
            writer.writeInt(0L);
            return;
        }
        IonWriter $this$list$iv = writer;
        boolean $i$f$list = false;
        $this$list$iv.stepIn(IonType.LIST);
        boolean bl = false;
        writer.writeInt((long)map2.size());
        if (context2.getConfiguration().getOrderMapEntriesByKeys()) {
            int[] keys2 = ((IntSet)map2.keySet()).toIntArray();
            Intrinsics.checkNotNullExpressionValue((Object)keys2, (String)"keys");
            ArraysKt.sort((int[])keys2);
            for (int key : keys2) {
                writer.writeInt((long)key);
                writer.writeInt((long)map2.get(key));
            }
        } else {
            ObjectSet entrySet = map2.int2IntEntrySet();
            ObjectIterator objectIterator = entrySet.iterator();
            while (objectIterator.hasNext()) {
                Int2IntMap.Entry entry2;
                Int2IntMap.Entry entry3 = entry2 = (Int2IntMap.Entry)objectIterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)entry3, (String)"entry");
                writer.writeInt((long)entry3.getIntKey());
                writer.writeInt((long)entry2.getIntValue());
            }
        }
        $this$list$iv.stepOut();
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property2, @NotNull ReadContext context2) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getReader().getType() == IonType.NULL) {
            property2.set(hostObject, null);
            return;
        }
        Int2IntMap result2 = (Int2IntMap)property2.readUnsafe(hostObject);
        if (result2 == null) {
            property2.set(hostObject, (Object)this.readMap(context2.getReader()));
            return;
        }
        result2.clear();
        IonReader reader = context2.getReader();
        if (reader.getType() == IonType.INT) {
            ObjectSerializerKt.getLOG().assertTrue(reader.intValue() == 0);
        } else {
            IonReader $this$list$iv = reader;
            boolean $i$f$list = false;
            $this$list$iv.stepIn();
            boolean bl = false;
            reader.next();
            int size = reader.intValue();
            this.doRead(reader, size, result2);
            Unit result$iv = Unit.INSTANCE;
            $this$list$iv.stepOut();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doRead(IonReader reader, int size, Int2IntMap result2) {
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i2;
            reader.next();
            int k = reader.intValue();
            reader.next();
            int v = reader.intValue();
            result2.put(k, v);
            ++i2;
        }
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull ReadContext context2, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.readMap(context2.getReader());
    }

    private final Int2IntOpenHashMap readMap(IonReader reader) {
        if (reader.getType() == IonType.INT) {
            ObjectSerializerKt.getLOG().assertTrue(reader.intValue() == 0);
            return new Int2IntOpenHashMap();
        }
        IonReader $this$list$iv = reader;
        boolean $i$f$list = false;
        $this$list$iv.stepIn();
        boolean bl = false;
        reader.next();
        int size = reader.intValue();
        Int2IntOpenHashMap result2 = new Int2IntOpenHashMap(size);
        this.doRead(reader, size, (Int2IntMap)result2);
        Int2IntOpenHashMap result$iv = result2;
        $this$list$iv.stepOut();
        return result$iv;
    }

    @Override
    public void serialize(@NotNull Object hostObject, @NotNull MutableAccessor property2, @NotNull WriteContext context2) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Binding.DefaultImpls.serialize(this, hostObject, property2, context2);
    }

    @Override
    @NotNull
    public Type createCacheKey(@Nullable Class<?> aClass, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Binding.DefaultImpls.createCacheKey(this, aClass, type);
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull BindingInitializationContext context2) {
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Binding.DefaultImpls.init(this, originalType, context2);
    }
}

