/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.BaseCollectionBinding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ObjectSerializerKt;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.WriteContext;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\"\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00102\u0006\u0010\u0004\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0016J \u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00102\u0006\u0010\u0004\u001a\u00020\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0018H\u0016R\u0017\u0010\u0007\u001a\u000b\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/serialization/CollectionBinding;", "Lcom/intellij/serialization/BaseCollectionBinding;", "type", "Ljava/lang/reflect/ParameterizedType;", "context", "Lcom/intellij/serialization/BindingInitializationContext;", "(Ljava/lang/reflect/ParameterizedType;Lcom/intellij/serialization/BindingInitializationContext;)V", "collectionClass", "Ljava/lang/Class;", "Lorg/jetbrains/annotations/NotNull;", "createCollection", "", "", "propertyForDebugPurposes", "Lcom/intellij/serialization/MutableAccessor;", "deserialize", "", "Lcom/intellij/serialization/ReadContext;", "hostObject", "", "property", "readEmptyCollection", "serialize", "obj", "Lcom/intellij/serialization/WriteContext;", "intellij.platform.objectSerializer"})
public final class CollectionBinding
extends BaseCollectionBinding {
    private final Class<?> collectionClass;

    @Override
    @NotNull
    public Collection<Object> deserialize(@NotNull ReadContext context2, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getReader().getType() == IonType.INT) {
            return this.readEmptyCollection(context2);
        }
        Collection result2 = CollectionBinding.createCollection$default(this, null, 1, null);
        this.readInto(hostObject, result2, context2);
        return result2;
    }

    private final Collection<Object> readEmptyCollection(ReadContext context2) {
        Collection collection;
        switch (context2.getReader().intValue()) {
            case 1: {
                List list2 = Collections.EMPTY_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"Collections.EMPTY_LIST");
                collection = list2;
                break;
            }
            case 3: {
                collection = CollectionsKt.emptyList();
                break;
            }
            case 2: {
                Set set2 = Collections.EMPTY_SET;
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"Collections.EMPTY_SET");
                collection = set2;
                break;
            }
            case 4: {
                collection = SetsKt.emptySet();
                break;
            }
            default: {
                collection = Set.class.isAssignableFrom(this.collectionClass) ? (Collection)SetsKt.emptySet() : (Collection)CollectionsKt.emptyList();
            }
        }
        return collection;
    }

    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context2) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IonWriter writer = context2.getWriter();
        Collection collection = (Collection)obj2;
        if (context2.getFilter().getSkipEmptyCollection() && collection.isEmpty()) {
            writer.writeInt(0L);
            return;
        }
        if (collection == Collections.EMPTY_LIST) {
            writer.writeInt(1L);
        } else if (collection == CollectionsKt.emptyList()) {
            writer.writeInt((long)3);
        } else if (collection == Collections.EMPTY_SET) {
            writer.writeInt((long)2);
        } else if (collection == CollectionsKt.emptyList()) {
            writer.writeInt((long)4);
        } else {
            writer.stepIn(IonType.LIST);
            collection.forEach(this.createItemConsumer(context2));
            writer.stepOut();
        }
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property2, @NotNull ReadContext context2) {
        Collection result2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IonType type = context2.getReader().getType();
        Collection<Object> emptyResult = null;
        if (type == IonType.NULL) {
            property2.set(hostObject, null);
            return;
        }
        if (type == IonType.INT) {
            emptyResult = this.readEmptyCollection(context2);
        }
        if (!TypeIntrinsics.isMutableCollection((Object)(object = property2.readUnsafe(hostObject)))) {
            object = null;
        }
        if ((result2 = (Collection)object) != null && ClassUtil.isMutableCollection((Object)result2)) {
            result2.clear();
            if (emptyResult != null) {
                return;
            }
        } else {
            if (emptyResult != null) {
                property2.set(hostObject, emptyResult);
                return;
            }
            result2 = CollectionBinding.createCollection$default(this, null, 1, null);
            property2.set(hostObject, (Object)result2);
        }
        this.readInto(hostObject, result2, context2);
    }

    private final Collection<Object> createCollection(MutableAccessor propertyForDebugPurposes) {
        if (this.collectionClass.isInterface()) {
            Class<?> clazz = this.collectionClass;
            if (Intrinsics.areEqual(clazz, Set.class)) {
                return new HashSet();
            }
            if (Intrinsics.areEqual(clazz, List.class) || Intrinsics.areEqual(clazz, Collection.class)) {
                return new ArrayList();
            }
        } else {
            Collection collection;
            Class<?> clazz = this.collectionClass;
            if (Intrinsics.areEqual(clazz, HashSet.class)) {
                collection = new HashSet();
            } else if (Intrinsics.areEqual(clazz, ArrayList.class)) {
                collection = new ArrayList();
            } else if (Intrinsics.areEqual(clazz, THashSet.class)) {
                collection = (Collection)new THashSet();
            } else if (Intrinsics.areEqual(clazz, SmartList.class)) {
                collection = (Collection)new SmartList();
            } else {
                Object object = ReflectionUtil.newInstance(this.collectionClass, (boolean)false);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<kotlin.Any?>");
                }
                collection = TypeIntrinsics.asMutableCollection((Object)object);
            }
            return collection;
        }
        ObjectSerializerKt.getLOG().warn("Unknown collection type interface: " + this.collectionClass + " (property: " + propertyForDebugPurposes + ')');
        return new ArrayList();
    }

    static /* synthetic */ Collection createCollection$default(CollectionBinding collectionBinding, MutableAccessor mutableAccessor, int n, Object object) {
        if ((n & 1) != 0) {
            mutableAccessor = null;
        }
        return collectionBinding.createCollection(mutableAccessor);
    }

    public CollectionBinding(@NotNull ParameterizedType type, @NotNull BindingInitializationContext context2) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Type type2 = type.getActualTypeArguments()[0];
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type.actualTypeArguments[0]");
        super(type2, context2);
        Class clazz = ClassUtil.typeToClass((Type)type);
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"ClassUtil.typeToClass(type)");
        this.collectionClass = clazz;
    }
}

