/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersServiceViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowMessagePanel;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNodeSelector;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionListener;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import com.intellij.util.Alarm;
import com.intellij.util.containers.CollectionFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteServersDeploymentManager {
    private static final int POLL_DEPLOYMENTS_DELAY = 2000;
    private final Project myProject;
    private final ServersTreeNodeSelector myNodeSelector;
    private final Map<RemoteServersServiceViewContributor, Boolean> myContributors;
    private final Map<RemoteServer<?>, MessagePanel> myServerToContent;

    public static RemoteServersDeploymentManager getInstance(Project project) {
        return (RemoteServersDeploymentManager)project.getService(RemoteServersDeploymentManager.class);
    }

    public RemoteServersDeploymentManager(@NotNull Project project) {
        if (project == null) {
            RemoteServersDeploymentManager.$$$reportNull$$$0(0);
        }
        this.myContributors = CollectionFactory.createConcurrentWeakMap();
        this.myServerToContent = new HashMap();
        this.myProject = project;
        this.myNodeSelector = new ServersTreeNodeSelectorImpl(project);
        this.initListeners();
        RemoteServersView.getInstance(project).registerTreeNodeSelector(this.myNodeSelector, connection -> this.myContributors.keySet().stream().anyMatch(contributor -> contributor.accept(connection.getServer())));
    }

    private void initListeners() {
        this.myProject.getMessageBus().connect().subscribe(ServerConnectionListener.TOPIC, (Object)new ServerConnectionListener(){
            private final Set<ServerConnection<?>> myConnectionsToExpand = new HashSet();

            public void onConnectionCreated(@NotNull ServerConnection<?> connection) {
                RemoteServersServiceViewContributor contributor;
                if (connection == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((contributor = RemoteServersDeploymentManager.this.findContributor(connection.getServer())) != null) {
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                }
            }

            public void onConnectionStatusChanged(@NotNull ServerConnection<?> connection) {
                RemoteServer server;
                RemoteServersServiceViewContributor contributor;
                if (connection == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((contributor = RemoteServersDeploymentManager.this.findContributor(server = connection.getServer())) != null) {
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                    RemoteServersDeploymentManager.updateServerContent(RemoteServersDeploymentManager.this.myServerToContent.get(server), connection);
                    if (connection.getStatus() == ConnectionStatus.CONNECTED) {
                        if (connection.getStatusText() == connection.getStatus().getPresentableText()) {
                            this.myConnectionsToExpand.add(connection);
                            RemoteServersDeploymentManager.pollDeployments(connection);
                        }
                    } else {
                        this.myConnectionsToExpand.remove(connection);
                    }
                }
            }

            public void onDeploymentsChanged(@NotNull ServerConnection<?> connection) {
                RemoteServer server;
                RemoteServersServiceViewContributor contributor;
                if (connection == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((contributor = RemoteServersDeploymentManager.this.findContributor(server = connection.getServer())) != null) {
                    ServiceEventListener.ServiceEvent event = contributor.createDeploymentsChangedEvent(connection);
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(event);
                    RemoteServersDeploymentManager.updateServerContent(RemoteServersDeploymentManager.this.myServerToContent.get(server), connection);
                    if (this.myConnectionsToExpand.remove(connection)) {
                        ServersTreeStructure.RemoteServerNode serverNode = new ServersTreeStructure.RemoteServerNode(RemoteServersDeploymentManager.this.myProject, connection.getServer(), contributor);
                        ServiceViewManager.getInstance((Project)RemoteServersDeploymentManager.this.myProject).expand((Object)serverNode, contributor.getClass());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "connection";
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/RemoteServersDeploymentManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConnectionCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onConnectionStatusChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onDeploymentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                RemoteServersServiceViewContributor contributor;
                if (server == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((contributor = RemoteServersDeploymentManager.this.findContributor(server)) != null) {
                    RemoteServersDeploymentManager.this.myServerToContent.put(server, RemoteServersDeploymentManager.createMessagePanel());
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                }
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                RemoteServersServiceViewContributor contributor;
                if (server == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((contributor = RemoteServersDeploymentManager.this.findContributor(server)) != null) {
                    ((ServiceEventListener)RemoteServersDeploymentManager.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(contributor.getClass()));
                }
                RemoteServersDeploymentManager.this.myServerToContent.remove(server);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "server";
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/RemoteServersDeploymentManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serverAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "serverRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void registerContributor(@NotNull RemoteServersServiceViewContributor contributor) {
        if (contributor == null) {
            RemoteServersDeploymentManager.$$$reportNull$$$0(1);
        }
        if (this.myContributors.put(contributor, Boolean.TRUE) == null) {
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.myProject)).submit(() -> {
                for (RemoteServer server : RemoteServersManager.getInstance().getServers()) {
                    if (!contributor.accept(server)) continue;
                    this.myServerToContent.put(server, RemoteServersDeploymentManager.createMessagePanel());
                }
            });
        }
    }

    @NotNull
    public ServersTreeNodeSelector getNodeSelector() {
        ServersTreeNodeSelector serversTreeNodeSelector = this.myNodeSelector;
        if (serversTreeNodeSelector == null) {
            RemoteServersDeploymentManager.$$$reportNull$$$0(2);
        }
        return serversTreeNodeSelector;
    }

    public JComponent getServerContent(RemoteServer<?> server) {
        MessagePanel messagePanel = this.myServerToContent.get(server);
        if (messagePanel == null) {
            return null;
        }
        RemoteServersDeploymentManager.updateServerContent(messagePanel, ServerConnectionManager.getInstance().getConnection(server));
        return messagePanel.getComponent();
    }

    private static void updateServerContent(@Nullable MessagePanel messagePanel, @Nullable ServerConnection<?> connection) {
        if (messagePanel == null) {
            return;
        }
        if (connection == null) {
            messagePanel.setEmptyText(CloudBundle.message((String)"cloud.status.double.click.to.connect", (Object[])new Object[0]));
        } else {
            Object text2 = connection.getStatusText();
            if (((String)text2).contains("<br/>") && !((String)text2).startsWith("<html>")) {
                text2 = "<html><center>" + (String)text2 + "</center></html>";
            }
            messagePanel.setEmptyText((String)text2);
        }
    }

    @Nullable
    private RemoteServersServiceViewContributor findContributor(@NotNull RemoteServer<?> server) {
        if (server == null) {
            RemoteServersDeploymentManager.$$$reportNull$$$0(3);
        }
        for (RemoteServersServiceViewContributor contributor : this.myContributors.keySet()) {
            if (!contributor.accept(server)) continue;
            return contributor;
        }
        return null;
    }

    private static void pollDeployments(@NotNull ServerConnection<?> connection) {
        if (connection == null) {
            RemoteServersDeploymentManager.$$$reportNull$$$0(4);
        }
        connection.computeDeployments(() -> new Alarm().addRequest(() -> {
            if (connection == ServerConnectionManager.getInstance().getConnection(connection.getServer())) {
                RemoteServersDeploymentManager.pollDeployments(connection);
            }
        }, 2000, ModalityState.any()));
    }

    @Nullable
    public static ServersTreeNodeSelector getNodeSelector(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RemoteServersDeploymentManager.$$$reportNull$$$0(5);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        return RemoteServersDeploymentManager.getInstance(project).getNodeSelector();
    }

    public static MessagePanel createMessagePanel() {
        return new ServersToolWindowMessagePanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/ui/RemoteServersDeploymentManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/ui/RemoteServersDeploymentManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerContributor";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContributor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pollDeployments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodeSelector";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ServersTreeNodeSelectorImpl
    implements ServersTreeNodeSelector {
        private final Project myProject;

        ServersTreeNodeSelectorImpl(Project project) {
            this.myProject = project;
        }

        @Override
        public void select(@NotNull ServerConnection<?> connection) {
            RemoteServersServiceViewContributor contributor;
            if (connection == null) {
                ServersTreeNodeSelectorImpl.$$$reportNull$$$0(0);
            }
            if ((contributor = RemoteServersDeploymentManager.getInstance(this.myProject).findContributor(connection.getServer())) == null) {
                return;
            }
            ServersTreeStructure.RemoteServerNode serverNode = new ServersTreeStructure.RemoteServerNode(this.myProject, connection.getServer(), contributor);
            ServiceViewManager.getInstance((Project)this.myProject).select((Object)serverNode, contributor.getClass(), true, true);
        }

        @Override
        public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName) {
            RemoteServersServiceViewContributor contributor;
            if (connection == null) {
                ServersTreeNodeSelectorImpl.$$$reportNull$$$0(1);
            }
            if (deploymentName == null) {
                ServersTreeNodeSelectorImpl.$$$reportNull$$$0(2);
            }
            if ((contributor = RemoteServersDeploymentManager.getInstance(this.myProject).findContributor(connection.getServer())) == null) {
                return;
            }
            AbstractTreeNode<?> deploymentNode = this.findDeployment(contributor, connection, deploymentName);
            if (deploymentNode != null) {
                ServiceViewManager.getInstance((Project)this.myProject).select(deploymentNode, contributor.getClass(), true, false);
            }
        }

        @Override
        public void select(@NotNull ServerConnection<?> connection, @NotNull String deploymentName, @NotNull String logName) {
            RemoteServersServiceViewContributor contributor;
            if (connection == null) {
                ServersTreeNodeSelectorImpl.$$$reportNull$$$0(3);
            }
            if (deploymentName == null) {
                ServersTreeNodeSelectorImpl.$$$reportNull$$$0(4);
            }
            if (logName == null) {
                ServersTreeNodeSelectorImpl.$$$reportNull$$$0(5);
            }
            if ((contributor = RemoteServersDeploymentManager.getInstance(this.myProject).findContributor(connection.getServer())) == null) {
                return;
            }
            AbstractTreeNode<?> deploymentNode = this.findDeployment(contributor, connection, deploymentName);
            if (deploymentNode != null) {
                contributor.selectLog(deploymentNode, logName);
            }
        }

        private AbstractTreeNode<?> findDeployment(RemoteServersServiceViewContributor contributor, ServerConnection<?> connection, String deploymentName) {
            ServersTreeStructure.RemoteServerNode serverNode = new ServersTreeStructure.RemoteServerNode(this.myProject, connection.getServer(), contributor);
            RemoteServersServiceViewContributor.RemoteServerNodeServiceViewContributor serverContributor = contributor.createNodeContributor(serverNode);
            ((ServiceEventListener)this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_STRUCTURE_CHANGED, (Object)serverContributor, contributor.getClass()));
            for (Deployment deployment : connection.getDeployments()) {
                if (!deployment.getName().equals(deploymentName)) continue;
                return contributor.createDeploymentNode(connection, serverNode, deployment);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deploymentName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "logName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/remoteServer/impl/runtime/ui/RemoteServersDeploymentManager$ServersTreeNodeSelectorImpl";
            objectArray[2] = "select";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface MessagePanel {
        public void setEmptyText(@NotNull String var1);

        @NotNull
        public JComponent getComponent();
    }
}

