/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.OutdatedCredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Pair;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CredentialsManager {
    private static final String WSL_PATH_TO_REMOVE = "wsl://";

    public static CredentialsManager getInstance() {
        return (CredentialsManager)ApplicationManager.getApplication().getService(CredentialsManager.class);
    }

    public abstract List<CredentialsType<?>> getAllTypes();

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static void fixWslPrefix(@NotNull Sdk sdk2) {
        String path2;
        if (sdk2 == null) {
            CredentialsManager.$$$reportNull$$$0(0);
        }
        if (sdk2 instanceof ProjectJdkImpl && (path2 = sdk2.getHomePath()) != null && path2.startsWith(WSL_PATH_TO_REMOVE)) {
            ((ProjectJdkImpl)sdk2).setHomePath("\\\\wsl$\\" + path2.substring(WSL_PATH_TO_REMOVE.length()));
        }
    }

    public abstract void loadCredentials(String var1, @Nullable Element var2, RemoteSdkAdditionalData var3);

    public static void updateOutdatedSdk(@NotNull RemoteSdkAdditionalData<?> data2, @Nullable Project project) {
        if (data2 == null) {
            CredentialsManager.$$$reportNull$$$0(1);
        }
        if (!(data2.getRemoteConnectionType() instanceof OutdatedCredentialsType)) {
            return;
        }
        Pair pair = ((OutdatedCredentialsType)((Object)data2.getRemoteConnectionType())).transformToNewerType(data2.connectionCredentials().getCredentials(), project);
        data2.setCredentials(((CredentialsType)pair.getFirst()).getCredentialsKey(), pair.getSecond());
    }

    public static void recogniseCredentialType(@NotNull Stream<? extends SdkAdditionalData> additionalData, @NotNull CredentialsType<?> credentialsType) {
        if (additionalData == null) {
            CredentialsManager.$$$reportNull$$$0(2);
        }
        if (credentialsType == null) {
            CredentialsManager.$$$reportNull$$$0(3);
        }
        additionalData.forEach(data2 -> CredentialsManager.recogniseCredentialType(data2, credentialsType));
    }

    private static void recogniseCredentialType(@Nullable SdkAdditionalData additionalData, @NotNull CredentialsType credentialsType) {
        if (credentialsType == null) {
            CredentialsManager.$$$reportNull$$$0(4);
        }
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return;
        }
        RemoteSdkAdditionalData data2 = (RemoteSdkAdditionalData)additionalData;
        if (data2.getRemoteConnectionType() != CredentialsType.UNKNOWN) {
            return;
        }
        String credentialsId = data2.connectionCredentials().getId();
        if (!credentialsType.hasPrefix(credentialsId)) {
            return;
        }
        Element root = new Element("root");
        data2.connectionCredentials().save(root);
        Object credentials2 = credentialsType.createCredentials();
        credentialsType.getHandler(credentials2).load(root);
        data2.setCredentials(credentialsType.getCredentialsKey(), credentials2);
    }

    public static void forgetCredentialType(@NotNull Stream<? extends SdkAdditionalData> additionalData, @NotNull CredentialsType<?> credentialsType) {
        if (additionalData == null) {
            CredentialsManager.$$$reportNull$$$0(5);
        }
        if (credentialsType == null) {
            CredentialsManager.$$$reportNull$$$0(6);
        }
        additionalData.forEach(data2 -> CredentialsManager.forgetCredentialType(data2, credentialsType));
    }

    private static void forgetCredentialType(@Nullable SdkAdditionalData additionalData, @NotNull CredentialsType<?> credentialsType) {
        if (credentialsType == null) {
            CredentialsManager.$$$reportNull$$$0(7);
        }
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return;
        }
        RemoteSdkAdditionalData data2 = (RemoteSdkAdditionalData)additionalData;
        if (data2.getRemoteConnectionType() != credentialsType) {
            return;
        }
        Element root = new Element("root");
        data2.connectionCredentials().save(root);
        UnknownCredentialsHolder unknownCredentials = CredentialsType.UNKNOWN.createCredentials();
        unknownCredentials.setSdkId(data2.getSdkId());
        CredentialsType.UNKNOWN.getHandler(unknownCredentials).load(root);
        data2.setCredentials(CredentialsType.UNKNOWN.getCredentialsKey(), unknownCredentials);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remote/ext/CredentialsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fixWslPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOutdatedSdk";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "recogniseCredentialType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "forgetCredentialType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

