/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.EnableDisableAction;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMemberSelectionTable<T extends PsiElement, M extends MemberInfoBase<T>>
extends JBTable
implements DataProvider {
    protected static final int CHECKED_COLUMN = 0;
    protected static final int DISPLAY_NAME_COLUMN = 1;
    protected static final int ABSTRACT_COLUMN = 2;
    protected static final Icon EMPTY_OVERRIDE_ICON = IconManager.getInstance().createEmptyIcon(AllIcons.General.OverridingMethod);
    protected static final int OVERRIDE_ICON_POSITION = 2;
    protected static final int VISIBILITY_ICON_POSITION = 1;
    protected static final int MEMBER_ICON_POSITION = 0;
    protected final @NlsContexts.ColumnName String myAbstractColumnHeader;
    protected List<M> myMemberInfos;
    protected final boolean myAbstractEnabled;
    protected MemberInfoModel<T, M> myMemberInfoModel;
    protected MyTableModel<T, M> myTableModel;

    public AbstractMemberSelectionTable(Collection<M> memberInfos, @Nullable MemberInfoModel<T, M> memberInfoModel, @Nullable @NlsContexts.ColumnName String abstractColumnHeader) {
        this.myAbstractEnabled = abstractColumnHeader != null;
        this.myAbstractColumnHeader = abstractColumnHeader;
        this.myTableModel = new MyTableModel(this);
        this.myMemberInfos = new ArrayList<M>(memberInfos);
        this.myMemberInfoModel = memberInfoModel != null ? memberInfoModel : new DefaultMemberInfoModel();
        this.setModel(this.myTableModel);
        TableColumnModel model2 = this.getColumnModel();
        model2.getColumn(1).setCellRenderer((TableCellRenderer)((Object)new MyTableRenderer(this)));
        TableColumn checkBoxColumn = model2.getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkBoxColumn);
        checkBoxColumn.setCellRenderer(new MyBooleanRenderer(this));
        if (this.myAbstractEnabled) {
            int width = (int)(1.3 * (double)this.getFontMetrics(this.getFont()).charsWidth(this.myAbstractColumnHeader.toCharArray(), 0, this.myAbstractColumnHeader.length()));
            model2.getColumn(2).setMaxWidth(width);
            model2.getColumn(2).setPreferredWidth(width);
            model2.getColumn(2).setCellRenderer(new MyBooleanRenderer(this));
        }
        this.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)400, (int)-1));
        this.setVisibleRowCount(12);
        this.getSelectionModel().setSelectionMode(2);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        new MyEnableDisableAction().register();
        new TableSpeedSearch((JTable)((Object)this));
    }

    public Collection<M> getSelectedMemberInfos() {
        ArrayList<MemberInfoBase> list2 = new ArrayList<MemberInfoBase>(this.myMemberInfos.size());
        for (MemberInfoBase info2 : this.myMemberInfos) {
            if (!this.isMemberInfoSelected(info2)) continue;
            list2.add(info2);
        }
        return list2;
    }

    private boolean isMemberInfoSelected(M info2) {
        boolean memberEnabled = this.myMemberInfoModel.isMemberEnabled(info2);
        return memberEnabled && info2.isChecked() || !memberEnabled && this.myMemberInfoModel.isCheckedWhenDisabled(info2);
    }

    public MemberInfoModel<T, M> getMemberInfoModel() {
        return this.myMemberInfoModel;
    }

    public void setMemberInfoModel(MemberInfoModel<T, M> memberInfoModel) {
        this.myMemberInfoModel = memberInfoModel;
    }

    public void fireExternalDataChange() {
        this.myTableModel.fireTableDataChanged();
    }

    public void redraw() {
        this.myTableModel.redraw(this.getSelectedMemberInfos());
        this.myTableModel.fireTableDataChanged();
    }

    public void setMemberInfos(Collection<M> memberInfos) {
        this.myMemberInfos = new ArrayList<M>(memberInfos);
        this.fireMemberInfoChange(memberInfos);
        this.myTableModel.fireTableDataChanged();
    }

    public void addMemberInfoChangeListener(MemberInfoChangeListener<T, M> l) {
        this.listenerList.add(MemberInfoChangeListener.class, l);
    }

    protected void fireMemberInfoChange(Collection<M> changedMembers) {
        Object[] list2 = this.listenerList.getListenerList();
        MemberInfoChange event = new MemberInfoChange(changedMembers);
        for (Object element2 : list2) {
            if (!(element2 instanceof MemberInfoChangeListener)) continue;
            MemberInfoChangeListener changeListener = (MemberInfoChangeListener)element2;
            changeListener.memberInfoChanged(event);
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            AbstractMemberSelectionTable.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            MemberInfoBase item = (MemberInfoBase)ContainerUtil.getFirstItem(this.getSelectedMemberInfos());
            return item == null ? null : item.getMember();
        }
        return null;
    }

    public void scrollSelectionInView() {
        for (int i2 = 0; i2 < this.myMemberInfos.size(); ++i2) {
            if (!this.isMemberInfoSelected((MemberInfoBase)this.myMemberInfos.get(i2))) continue;
            Rectangle rc = this.getCellRect(i2, 0, false);
            this.scrollRectToVisible(rc);
            break;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.scrollSelectionInView();
    }

    @Nullable
    protected abstract Object getAbstractColumnValue(M var1);

    protected abstract boolean isAbstractColumnEditable(int var1);

    protected void setVisibilityIcon(M memberInfo, com.intellij.ui.RowIcon icon2) {
        throw new AbstractMethodError();
    }

    protected void setVisibilityIcon(M memberInfo, RowIcon icon2) {
        this.setVisibilityIcon(memberInfo, (com.intellij.ui.RowIcon)icon2);
    }

    protected abstract Icon getOverrideIcon(M var1);

    protected Icon getMemberIcon(M memberInfo, @Iconable.IconFlags int flags) {
        return memberInfo.getMember().getIcon(flags);
    }

    @NlsContexts.ColumnName
    protected static String getDisplayNameColumnHeader() {
        return RefactoringBundle.message((String)"member.column");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/refactoring/ui/AbstractMemberSelectionTable", "getData"));
    }

    private static class MyBooleanRenderer<T extends PsiElement, M extends MemberInfoBase<T>>
    extends BooleanTableCellRenderer {
        private final AbstractMemberSelectionTable<T, M> myTable;

        MyBooleanRenderer(AbstractMemberSelectionTable<T, M> table) {
            this.myTable = table;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column2);
            if (component2 instanceof JCheckBox) {
                int modelColumn = this.myTable.convertColumnIndexToModel(column2);
                MemberInfoBase memberInfo = (MemberInfoBase)this.myTable.myMemberInfos.get(row2);
                component2.setEnabled(modelColumn == 0 && this.myTable.myMemberInfoModel.isMemberEnabled(memberInfo) || modelColumn == 2 && memberInfo.isChecked() && this.myTable.isAbstractColumnEditable(row2));
            }
            return component2;
        }
    }

    private static class MyTableRenderer<T extends PsiElement, M extends MemberInfoBase<T>>
    extends ColoredTableCellRenderer {
        private final AbstractMemberSelectionTable<T, M> myTable;

        MyTableRenderer(AbstractMemberSelectionTable<T, M> table) {
            this.myTable = table;
        }

        public void customizeCellRenderer(@NotNull JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            if (table == null) {
                MyTableRenderer.$$$reportNull$$$0(0);
            }
            int modelColumn = this.myTable.convertColumnIndexToModel(column2);
            MemberInfoBase memberInfo = (MemberInfoBase)this.myTable.myMemberInfos.get(row2);
            this.setToolTipText(this.myTable.myMemberInfoModel.getTooltipText(memberInfo));
            if (modelColumn == 1) {
                Icon memberIcon = this.myTable.getMemberIcon(memberInfo, 0);
                Icon overrideIcon = this.myTable.getOverrideIcon(memberInfo);
                RowIcon icon2 = IconManager.getInstance().createRowIcon(3);
                icon2.setIcon(memberIcon, 0);
                this.myTable.setVisibilityIcon(memberInfo, icon2);
                icon2.setIcon(overrideIcon, 2);
                this.setIcon((Icon)icon2);
            } else {
                this.setIcon(null);
            }
            this.setIconOpaque(false);
            this.setOpaque(false);
            boolean cellEditable = this.myTable.myMemberInfoModel.isMemberEnabled(memberInfo);
            this.setEnabled(cellEditable);
            if (value2 == null) {
                return;
            }
            int problem = this.myTable.myMemberInfoModel.checkForProblems(memberInfo);
            JBColor c = null;
            if (problem == 2) {
                c = JBColor.RED;
            } else if (problem == 1 && !isSelected) {
                c = JBColor.BLUE;
            }
            this.append((String)value2, new SimpleTextAttributes(0, (Color)c));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/refactoring/ui/AbstractMemberSelectionTable$MyTableRenderer", "customizeCellRenderer"));
        }
    }

    private class MyEnableDisableAction
    extends EnableDisableAction {
        private MyEnableDisableAction() {
        }

        @Override
        protected JTable getTable() {
            return AbstractMemberSelectionTable.this;
        }

        @Override
        protected void applyValue(int[] rows, boolean valueToBeSet) {
            ArrayList<MemberInfoBase> changedInfo = new ArrayList<MemberInfoBase>();
            for (int row2 : rows) {
                MemberInfoBase memberInfo = (MemberInfoBase)AbstractMemberSelectionTable.this.myMemberInfos.get(row2);
                memberInfo.setChecked(valueToBeSet);
                changedInfo.add(memberInfo);
            }
            AbstractMemberSelectionTable.this.fireMemberInfoChange(changedInfo);
            int[] selectedRows = AbstractMemberSelectionTable.this.getSelectedRows();
            AbstractMemberSelectionTable.this.myTableModel.fireTableDataChanged();
            ListSelectionModel selectionModel = AbstractMemberSelectionTable.this.getSelectionModel();
            for (int selectedRow : selectedRows) {
                selectionModel.addSelectionInterval(selectedRow, selectedRow);
            }
        }

        @Override
        protected boolean isRowChecked(int row2) {
            return ((MemberInfoBase)AbstractMemberSelectionTable.this.myMemberInfos.get(row2)).isChecked();
        }
    }

    protected static class MyTableModel<T extends PsiElement, M extends MemberInfoBase<T>>
    extends AbstractTableModel {
        private final AbstractMemberSelectionTable<T, M> myTable;

        public MyTableModel(AbstractMemberSelectionTable<T, M> table) {
            this.myTable = table;
        }

        @Override
        public int getColumnCount() {
            if (this.myTable.myAbstractEnabled) {
                return 3;
            }
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myTable.myMemberInfos.size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0 || columnIndex == 2) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MemberInfoBase memberInfo = (MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (this.myTable.myMemberInfoModel.isMemberEnabled(memberInfo)) {
                        return memberInfo.isChecked();
                    }
                    return this.myTable.myMemberInfoModel.isCheckedWhenDisabled(memberInfo);
                }
                case 2: {
                    return this.myTable.getAbstractColumnValue(memberInfo);
                }
                case 1: {
                    return memberInfo.getDisplayName();
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public String getColumnName(int column2) {
            switch (column2) {
                case 0: {
                    return " ";
                }
                case 2: {
                    return this.myTable.myAbstractColumnHeader;
                }
                case 1: {
                    return AbstractMemberSelectionTable.getDisplayNameColumnHeader();
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.myTable.myMemberInfoModel.isMemberEnabled((MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex));
                }
                case 2: {
                    return this.myTable.isAbstractColumnEditable(rowIndex);
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex)).setChecked(((Boolean)aValue).booleanValue());
            } else if (columnIndex == 2) {
                ((MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex)).setToAbstract(((Boolean)aValue).booleanValue());
            }
            List<MemberInfoBase> changed2 = Collections.singletonList((MemberInfoBase)this.myTable.myMemberInfos.get(rowIndex));
            this.redraw(changed2);
        }

        public void redraw(Collection<M> changed2) {
            this.myTable.fireMemberInfoChange(changed2);
            this.fireTableDataChanged();
        }
    }

    private static class DefaultMemberInfoModel<T extends PsiElement, M extends MemberInfoBase<T>>
    implements MemberInfoModel<T, M> {
        private DefaultMemberInfoModel() {
        }

        public boolean isMemberEnabled(M member) {
            return true;
        }

        public boolean isCheckedWhenDisabled(M member) {
            return false;
        }

        public boolean isAbstractEnabled(M member) {
            return true;
        }

        public boolean isAbstractWhenDisabled(M member) {
            return false;
        }

        public int checkForProblems(@NotNull M member) {
            if (member == null) {
                DefaultMemberInfoModel.$$$reportNull$$$0(0);
            }
            return 0;
        }

        public void memberInfoChanged(@NotNull MemberInfoChange<T, M> event) {
            if (event == null) {
                DefaultMemberInfoModel.$$$reportNull$$$0(1);
            }
        }

        public Boolean isFixedAbstract(M member) {
            return null;
        }

        public String getTooltipText(M member) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/ui/AbstractMemberSelectionTable$DefaultMemberInfoModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForProblems";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "memberInfoChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

