/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.PsiIntroduceTarget;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntroduceTargetChooser {
    private IntroduceTargetChooser() {
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback2, @NotNull Function<? super T, String> renderer) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(0);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(1);
        }
        if (callback2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(3);
        }
        IntroduceTargetChooser.showChooser(editor, expressions, callback2, renderer, RefactoringBundle.message((String)"introduce.target.chooser.expressions.title"));
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback2, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title2) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(4);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(5);
        }
        if (callback2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(6);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(7);
        }
        if (title2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(8);
        }
        IntroduceTargetChooser.showChooser(editor, expressions, callback2, renderer, title2, ScopeHighlighter.NATURAL_RANGER);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback2, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title2, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(9);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(10);
        }
        if (callback2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(11);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(12);
        }
        if (title2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(13);
        }
        if (ranger == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(14);
        }
        IntroduceTargetChooser.showChooser(editor, expressions, callback2, renderer, title2, -1, ranger);
    }

    public static <T extends PsiElement> void showChooser(@NotNull Editor editor, @NotNull List<? extends T> expressions, @NotNull Pass<? super T> callback2, @NotNull Function<? super T, String> renderer, @NotNull @NlsContexts.PopupTitle String title2, int selection, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(15);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(16);
        }
        if (callback2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(17);
        }
        if (renderer == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(18);
        }
        if (title2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(19);
        }
        if (ranger == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(20);
        }
        List targets2 = ContainerUtil.map(expressions, t -> new MyIntroduceTarget<PsiElement>((PsiElement)t, (NotNullFunction<PsiElement, TextRange>)ranger, (Function<PsiElement, String>)renderer));
        IntroduceTargetChooser.showIntroduceTargetChooser(editor, targets2, target2 -> callback2.pass(target2.getPlace()), title2, selection);
    }

    public static <T extends IntroduceTarget> void showIntroduceTargetChooser(@NotNull Editor editor, @NotNull List<T> expressions, @NotNull Consumer<? super T> callback2, @NotNull @NlsContexts.PopupTitle String title2, int selection) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(21);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(22);
        }
        if (callback2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(23);
        }
        if (title2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(24);
        }
        IntroduceTargetChooser.showIntroduceTargetChooser(editor, expressions, Pass.create(callback2), title2, null, selection);
    }

    public static <T extends IntroduceTarget> void showIntroduceTargetChooser(@NotNull Editor editor, @NotNull List<T> expressions, @NotNull Pass<? super T> callback2, @NotNull @NlsContexts.PopupTitle String title2, @Nullable JComponent southComponent, int selection) {
        if (editor == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(25);
        }
        if (expressions == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(26);
        }
        if (callback2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(27);
        }
        if (title2 == null) {
            IntroduceTargetChooser.$$$reportNull$$$0(28);
        }
        final AtomicReference<ScopeHighlighter> highlighter = new AtomicReference<ScopeHighlighter>(new ScopeHighlighter(editor));
        IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(expressions).setSelectionMode(0).setSelectedValue((Object)((IntroduceTarget)expressions.get(selection > -1 ? selection : 0)), true).setAccessibleName(title2).setTitle(title2).setMovable(false).setResizable(false).setRequestFocus(true).setItemSelectedCallback(expr -> {
            ScopeHighlighter h = (ScopeHighlighter)highlighter.get();
            if (h == null) {
                return;
            }
            h.dropHighlight();
            if (expr != null && expr.isValid()) {
                TextRange range2 = expr.getTextRange();
                h.highlight((Pair<TextRange, List<TextRange>>)Pair.create((Object)range2, Collections.singletonList(range2)));
            }
        }).setItemChosenCallback(expr -> {
            if (expr.isValid()) {
                callback2.pass(expr);
            }
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((ScopeHighlighter)highlighter.getAndSet(null)).dropHighlight();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/IntroduceTargetChooser$2", "onClosed"));
            }
        }).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index2, isSelected, cellHasFocus);
                IntroduceTarget expr = (IntroduceTarget)value2;
                if (expr.isValid()) {
                    String text2;
                    int firstNewLinePos = (text2 = expr.render()).indexOf(10);
                    Object trimmedText = text2.substring(0, firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text2.length()));
                    if (((String)trimmedText).length() != text2.length()) {
                        trimmedText = (String)trimmedText + " ...";
                    }
                    this.setText((String)trimmedText);
                } else {
                    this.setForeground((Color)JBColor.RED);
                    this.setText(IdeBundle.message((String)"invalid.node.text", (Object[])new Object[0]));
                }
                return rendererComponent;
            }
        });
        if (southComponent != null && builder2 instanceof PopupChooserBuilder) {
            ((PopupChooserBuilder)builder2).setSouthComponent(southComponent);
        }
        JBPopup popup2 = builder2.createPopup();
        popup2.showInBestPositionFor(editor);
        Project project = editor.getProject();
        if (project != null && !popup2.isDisposed()) {
            NavigationUtil.hidePopupIfDumbModeStarts(popup2, project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 17: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranger";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/IntroduceTargetChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showChooser";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "showIntroduceTargetChooser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyIntroduceTarget<T extends PsiElement>
    extends PsiIntroduceTarget<T> {
        private final NotNullFunction<? super PsiElement, ? extends TextRange> myRanger;
        private final Function<? super T, String> myRenderer;

        MyIntroduceTarget(@NotNull T psi, @NotNull NotNullFunction<? super PsiElement, ? extends TextRange> ranger, @NotNull Function<? super T, String> renderer) {
            if (psi == null) {
                MyIntroduceTarget.$$$reportNull$$$0(0);
            }
            if (ranger == null) {
                MyIntroduceTarget.$$$reportNull$$$0(1);
            }
            if (renderer == null) {
                MyIntroduceTarget.$$$reportNull$$$0(2);
            }
            super(psi);
            this.myRanger = ranger;
            this.myRenderer = renderer;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = (TextRange)this.myRanger.fun(this.getPlace());
            if (textRange == null) {
                MyIntroduceTarget.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @Override
        @NotNull
        public String render() {
            String string = (String)this.myRenderer.fun(this.getPlace());
            if (string == null) {
                MyIntroduceTarget.$$$reportNull$$$0(4);
            }
            return string;
        }

        public String toString() {
            return this.isValid() ? this.render() : "invalid";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranger";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/IntroduceTargetChooser$MyIntroduceTarget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "render";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

