/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.templateLanguages.OuterLanguageElementImpl;
import com.intellij.psi.templateLanguages.RangeCollectorImpl;
import com.intellij.psi.templateLanguages.SimpleTreePatcher;
import com.intellij.psi.templateLanguages.TemplateDataModifications;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TreePatcher;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionUtil;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateDataElementType
extends IFileElementType
implements ITemplateDataElementType {
    private static final Logger LOG = Logger.getInstance(TemplateDataElementType.class);
    private static final int CHECK_PROGRESS_AFTER_TOKENS = 1000;
    public static final LanguageExtension<TreePatcher> TREE_PATCHER = new LanguageExtension("com.intellij.lang.treePatcher", (Object)new SimpleTreePatcher());
    @NotNull
    private final IElementType myTemplateElementType;
    @NotNull
    final IElementType myOuterElementType;
    private final NotNullLazyValue<Boolean> REQUIRES_OLD_CREATE_TEMPLATE_TEXT;

    public TemplateDataElementType(@NonNls String debugName, Language language, @NotNull IElementType templateElementType, @NotNull IElementType outerElementType) {
        if (templateElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(0);
        }
        if (outerElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(1);
        }
        super(debugName, language);
        this.REQUIRES_OLD_CREATE_TEMPLATE_TEXT = NotNullLazyValue.volatileLazy(() -> {
            Class implementationClass = ReflectionUtil.getMethodDeclaringClass(((Object)((Object)this)).getClass(), (String)"appendCurrentTemplateToken", (Class[])new Class[]{StringBuilder.class, CharSequence.class, Lexer.class, RangeCollector.class});
            return implementationClass != TemplateDataElementType.class;
        });
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    protected Lexer createBaseLexer(TemplateLanguageFileViewProvider viewProvider) {
        return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(viewProvider.getBaseLanguage())).createLexer(viewProvider.getManager().getProject());
    }

    protected LanguageFileType createTemplateFakeFileType(Language language) {
        return new TemplateFileType(language);
    }

    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        if (chameleon == null) {
            TemplateDataElementType.$$$reportNull$$$0(2);
        }
        CharTable charTable = SharedImplUtil.findCharTableByTree(chameleon);
        FileElement fileElement = TreeUtil.getFileElement((TreeElement)chameleon);
        PsiFile psiFile = (PsiFile)fileElement.getPsi();
        PsiFile originalPsiFile = psiFile.getOriginalFile();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)originalPsiFile.getViewProvider();
        Language templateLanguage = this.getTemplateFileLanguage(viewProvider);
        CharSequence sourceCode = chameleon.getChars();
        RangeCollectorImpl collector = new RangeCollectorImpl(this);
        PsiFile templatePsiFile = this.createTemplateFile(psiFile, templateLanguage, sourceCode, viewProvider, collector);
        FileElement templateFileElement = ((PsiFileImpl)templatePsiFile).calcTreeElement();
        return (ASTNode)DebugUtil.performPsiModification("template language parsing", () -> {
            collector.insertOuterElementsAndRemoveRanges(templateFileElement, sourceCode, charTable, templateFileElement.getPsi().getLanguage());
            TreeElement childNode = templateFileElement.getFirstChildNode();
            DebugUtil.checkTreeStructure(templateFileElement);
            DebugUtil.checkTreeStructure(chameleon);
            if (fileElement != chameleon) {
                DebugUtil.checkTreeStructure((ASTNode)psiFile.getNode());
                DebugUtil.checkTreeStructure((ASTNode)originalPsiFile.getNode());
            }
            return childNode;
        });
    }

    protected Language getTemplateFileLanguage(TemplateLanguageFileViewProvider viewProvider) {
        return viewProvider.getTemplateDataLanguage();
    }

    protected PsiFile createTemplateFile(PsiFile psiFile, Language templateLanguage, CharSequence sourceCode, TemplateLanguageFileViewProvider viewProvider, @NotNull RangeCollector rangeCollector) {
        if (rangeCollector == null) {
            TemplateDataElementType.$$$reportNull$$$0(3);
        }
        CharSequence templateSourceCode = this.createTemplateText(sourceCode, this.createBaseLexer(viewProvider), rangeCollector);
        if (rangeCollector instanceof RangeCollectorImpl) {
            ((RangeCollectorImpl)rangeCollector).prepareFileForParsing(templateLanguage, sourceCode, templateSourceCode);
        }
        return this.createPsiFileFromSource(templateLanguage, templateSourceCode, psiFile.getManager());
    }

    protected CharSequence createTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull RangeCollector rangeCollector) {
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(4);
        }
        if (baseLexer == null) {
            TemplateDataElementType.$$$reportNull$$$0(5);
        }
        if (rangeCollector == null) {
            TemplateDataElementType.$$$reportNull$$$0(6);
        }
        if (((Boolean)this.REQUIRES_OLD_CREATE_TEMPLATE_TEXT.getValue()).booleanValue()) {
            return this.oldCreateTemplateText(sourceCode, baseLexer, rangeCollector);
        }
        TemplateDataModifications modifications = this.collectTemplateModifications(sourceCode, baseLexer);
        return ((RangeCollectorImpl)rangeCollector).applyTemplateDataModifications(sourceCode, modifications);
    }

    private CharSequence oldCreateTemplateText(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer, @NotNull RangeCollector rangeCollector) {
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(7);
        }
        if (baseLexer == null) {
            TemplateDataElementType.$$$reportNull$$$0(8);
        }
        if (rangeCollector == null) {
            TemplateDataElementType.$$$reportNull$$$0(9);
        }
        StringBuilder result2 = new StringBuilder(sourceCode.length());
        baseLexer.start(sourceCode);
        TextRange currentRange = TextRange.EMPTY_RANGE;
        int tokenCounter = 0;
        while (baseLexer.getTokenType() != null) {
            if (++tokenCounter % 1000 == 0) {
                ProgressManager.checkCanceled();
            }
            TextRange newRange = TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd());
            assert (currentRange.getEndOffset() == newRange.getStartOffset()) : "Inconsistent tokens stream from " + baseLexer + ": " + TemplateDataElementType.getRangeDump(currentRange, sourceCode) + " followed by " + TemplateDataElementType.getRangeDump(newRange, sourceCode);
            currentRange = newRange;
            if (baseLexer.getTokenType() == this.myTemplateElementType) {
                this.appendCurrentTemplateToken(result2, sourceCode, baseLexer, rangeCollector);
            } else {
                rangeCollector.addOuterRange(currentRange);
            }
            baseLexer.advance();
        }
        return result2;
    }

    @NotNull
    protected TemplateDataModifications collectTemplateModifications(@NotNull CharSequence sourceCode, @NotNull Lexer baseLexer) {
        if (sourceCode == null) {
            TemplateDataElementType.$$$reportNull$$$0(10);
        }
        if (baseLexer == null) {
            TemplateDataElementType.$$$reportNull$$$0(11);
        }
        TemplateDataModifications modifications = new TemplateDataModifications();
        baseLexer.start(sourceCode);
        TextRange currentRange = TextRange.EMPTY_RANGE;
        int tokenCounter = 0;
        while (baseLexer.getTokenType() != null) {
            if (++tokenCounter % 1000 == 0) {
                ProgressManager.checkCanceled();
            }
            TextRange newRange = TextRange.create((int)baseLexer.getTokenStart(), (int)baseLexer.getTokenEnd());
            assert (currentRange.getEndOffset() == newRange.getStartOffset()) : "Inconsistent tokens stream from " + baseLexer + ": " + TemplateDataElementType.getRangeDump(currentRange, sourceCode) + " followed by " + TemplateDataElementType.getRangeDump(newRange, sourceCode);
            currentRange = newRange;
            if (baseLexer.getTokenType() == this.myTemplateElementType) {
                TemplateDataModifications tokenModifications = this.appendCurrentTemplateToken(baseLexer.getTokenEnd(), baseLexer.getTokenSequence());
                modifications.addAll(tokenModifications);
            } else {
                modifications.addOuterRange(currentRange, this.isInsertionToken(baseLexer.getTokenType(), baseLexer.getTokenSequence()));
            }
            baseLexer.advance();
        }
        TemplateDataModifications templateDataModifications = modifications;
        if (templateDataModifications == null) {
            TemplateDataElementType.$$$reportNull$$$0(12);
        }
        return templateDataModifications;
    }

    @NotNull
    private static String getRangeDump(@NotNull TextRange range2, @NotNull CharSequence sequence) {
        if (range2 == null) {
            TemplateDataElementType.$$$reportNull$$$0(13);
        }
        if (sequence == null) {
            TemplateDataElementType.$$$reportNull$$$0(14);
        }
        String string = "'" + StringUtil.escapeLineBreak((String)range2.subSequence(sequence).toString()) + "' " + range2;
        if (string == null) {
            TemplateDataElementType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Deprecated
    protected void appendCurrentTemplateToken(@NotNull StringBuilder result2, @NotNull CharSequence buf, @NotNull Lexer lexer, @NotNull RangeCollector collector) {
        if (result2 == null) {
            TemplateDataElementType.$$$reportNull$$$0(16);
        }
        if (buf == null) {
            TemplateDataElementType.$$$reportNull$$$0(17);
        }
        if (lexer == null) {
            TemplateDataElementType.$$$reportNull$$$0(18);
        }
        if (collector == null) {
            TemplateDataElementType.$$$reportNull$$$0(19);
        }
        result2.append(buf, lexer.getTokenStart(), lexer.getTokenEnd());
    }

    @NotNull
    protected TemplateDataModifications appendCurrentTemplateToken(int tokenEndOffset, @NotNull CharSequence tokenText) {
        if (tokenText == null) {
            TemplateDataElementType.$$$reportNull$$$0(20);
        }
        TemplateDataModifications templateDataModifications = TemplateDataModifications.EMPTY;
        if (templateDataModifications == null) {
            TemplateDataElementType.$$$reportNull$$$0(21);
        }
        return templateDataModifications;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    protected TokenSet getTemplateDataInsertionTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            TemplateDataElementType.$$$reportNull$$$0(22);
        }
        return tokenSet;
    }

    protected boolean isInsertionToken(@Nullable IElementType tokenType, @NotNull CharSequence tokenSequence) {
        if (tokenSequence == null) {
            TemplateDataElementType.$$$reportNull$$$0(23);
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected OuterLanguageElementImpl createOuterLanguageElement(@NotNull CharSequence internedTokenText, @NotNull IElementType outerElementType) {
        LeafElement factoryCreatedElement;
        if (internedTokenText == null) {
            TemplateDataElementType.$$$reportNull$$$0(24);
        }
        if (outerElementType == null) {
            TemplateDataElementType.$$$reportNull$$$0(25);
        }
        if ((factoryCreatedElement = ASTFactory.leaf(outerElementType, internedTokenText)) instanceof OuterLanguageElementImpl) {
            return (OuterLanguageElementImpl)factoryCreatedElement;
        }
        LOG.error("Wrong element created by ASTFactory. See method documentation for details. Here is what we have: elementType: " + outerElementType + "; language: " + outerElementType.getLanguage() + "; element from factory: " + factoryCreatedElement);
        return new OuterLanguageElementImpl(outerElementType, internedTokenText);
    }

    protected PsiFile createPsiFileFromSource(final Language language, CharSequence sourceCode, PsiManager manager2) {
        @NonNls LightVirtualFile virtualFile2 = new LightVirtualFile("foo", (FileType)this.createTemplateFakeFileType(language), sourceCode, LocalTimeCounter.currentTime());
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(manager2, (VirtualFile)virtualFile2, false){

            @Override
            @NotNull
            public Language getBaseLanguage() {
                Language language2 = language;
                if (language2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return language2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateDataElementType$1", "getBaseLanguage"));
            }
        };
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)virtualFile2);
        return viewProvider.getPsi(language);
    }

    @NotNull
    public static ASTNode parseWithOuterAndRemoveRangesApplied(@NotNull ASTNode chameleon, @NotNull Language language, @NotNull @NotNull Function<? super @NotNull CharSequence, ? extends @NotNull ASTNode> parser) {
        RangeCollectorImpl collector;
        if (chameleon == null) {
            TemplateDataElementType.$$$reportNull$$$0(26);
        }
        if (language == null) {
            TemplateDataElementType.$$$reportNull$$$0(27);
        }
        if (parser == null) {
            TemplateDataElementType.$$$reportNull$$$0(28);
        }
        ASTNode aSTNode = (collector = (RangeCollectorImpl)chameleon.getUserData(RangeCollectorImpl.OUTER_ELEMENT_RANGES)) != null ? collector.applyRangeCollectorAndExpandChameleon(chameleon, language, parser) : parser.apply(chameleon.getChars());
        if (aSTNode == null) {
            TemplateDataElementType.$$$reportNull$$$0(29);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateElementType";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElementType";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeCollector";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceCode";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/templateLanguages/TemplateDataElementType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSequence";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internedTokenText";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataElementType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTemplateModifications";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeDump";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCurrentTemplateToken";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataInsertionTokens";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWithOuterAndRemoveRangesApplied";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseContents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "oldCreateTemplateText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectTemplateModifications";
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 29: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRangeDump";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendCurrentTemplateToken";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInsertionToken";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createOuterLanguageElement";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseWithOuterAndRemoveRangesApplied";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 22: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface OuterLanguageRangePatcher {
        @ApiStatus.Internal
        public static final LanguageExtension<OuterLanguageRangePatcher> EXTENSION = new LanguageExtension("com.intellij.outerLanguageRangePatcher");

        @Nullable
        public String getTextForOuterLanguageInsertionRange(@NotNull TemplateDataElementType var1, @NotNull CharSequence var2);
    }

    public static interface TemplateAwareElementType
    extends ILazyParseableElementTypeBase {
        @NotNull
        public TreeElement createTreeElement(@NotNull CharSequence var1);
    }

    public static abstract class RangeCollector {
        public void addOuterRange(@NotNull TextRange newRange) {
            if (newRange == null) {
                RangeCollector.$$$reportNull$$$0(0);
            }
        }

        public abstract void addOuterRange(@NotNull TextRange var1, boolean var2);

        public void addRangeToRemove(@NotNull TextRange rangeToRemove) {
            if (rangeToRemove == null) {
                RangeCollector.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeToRemove";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/templateLanguages/TemplateDataElementType$RangeCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOuterRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRangeToRemove";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class TemplateFileType
    extends LanguageFileType {
        private final Language myLanguage;

        protected TemplateFileType(Language language) {
            super(language);
            this.myLanguage = language;
        }

        @NotNull
        public String getDefaultExtension() {
            return "";
        }

        @NotNull
        @NonNls
        public String getDescription() {
            String string = "fake for language" + this.myLanguage.getID();
            if (string == null) {
                TemplateFileType.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }

        @NotNull
        @NonNls
        public String getName() {
            String string = this.myLanguage.getID();
            if (string == null) {
                TemplateFileType.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/psi/templateLanguages/TemplateDataElementType$TemplateFileType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

