/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.AbstractStringEnumerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

final class LazyStubData {
    private final AbstractStringEnumerator myStorage;
    private final MostlyUShortIntList myParentsAndStarts;
    private final byte[] mySerializedStubs;
    private final BitSet myAllStarts;

    LazyStubData(AbstractStringEnumerator storage2, MostlyUShortIntList parentsAndStarts, byte[] serializedStubs, BitSet allStarts) {
        this.myStorage = storage2;
        this.myParentsAndStarts = parentsAndStarts;
        this.mySerializedStubs = serializedStubs;
        this.myAllStarts = allStarts;
    }

    int getParentIndex(int index2) {
        return this.myParentsAndStarts.get(index2 * 2);
    }

    private int getDataStart(int index2) {
        return this.myParentsAndStarts.get(index2 * 2 + 1);
    }

    StubBase<?> deserializeStub(int index2, StubBase<?> parent, IStubElementType<?, ?> type) throws IOException {
        StubInputStream stream = new StubInputStream((InputStream)this.stubBytes(index2), this.myStorage);
        StubBase stub = (StubBase)type.deserialize(stream, parent);
        int available = stream.available();
        if (available > 0) {
            if (available != 1) {
                throw new AssertionError((Object)LazyStubData.getSerializeDeserializerMismatchMessage(type));
            }
            stub.markDangling();
        }
        return stub;
    }

    private ByteArrayInputStream stubBytes(int index2) {
        int start2 = this.getDataStart(index2);
        if (start2 == 0) {
            return new ByteArrayInputStream(ArrayUtilRt.EMPTY_BYTE_ARRAY);
        }
        int end = this.myAllStarts.nextSetBit(start2 + 1);
        if (end < 0) {
            end = this.mySerializedStubs.length + 1;
        }
        return new ByteArrayInputStream(this.mySerializedStubs, start2 - 1, end - start2);
    }

    @NotNull
    private static String getSerializeDeserializerMismatchMessage(@NotNull IStubElementType<?, ?> type) {
        if (type == null) {
            LazyStubData.$$$reportNull$$$0(0);
        }
        String string = "Stub serializer/deserialize mismatch for StubElementType: name = " + type.getDebugName() + ", language = " + type.getLanguage();
        if (string == null) {
            LazyStubData.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/LazyStubData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/LazyStubData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializeDeserializerMismatchMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSerializeDeserializerMismatchMessage";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

