/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.icons.AllIcons;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.IntersectionPackageSet;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedPackageSetReference;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.PackageSetParserExtension;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import com.intellij.psi.search.scope.packageSet.lexer.ScopeTokenTypes;
import com.intellij.psi.search.scope.packageSet.lexer.ScopesLexer;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageSetFactoryImpl
extends PackageSetFactory {
    private static final Logger LOG = Logger.getInstance(PackageSetFactoryImpl.class);

    public PackageSetFactoryImpl() {
        PackageSetParserExtension.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<PackageSetParserExtension>(){

            public void extensionAdded(@NotNull PackageSetParserExtension extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
                        ServiceKt.getStateStore((ComponentManager)project).reloadState(holder.getClass());
                        holder.fireScopeListeners();
                    }
                }
            }

            public void extensionRemoved(@NotNull PackageSetParserExtension extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ClassLoader pluginClassLoader = pluginDescriptor.getPluginClassLoader();
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
                        boolean changed2 = false;
                        NamedScope[] scopes = holder.getScopes();
                        for (int i2 = 0; i2 < scopes.length; ++i2) {
                            NamedScope scope2 = scopes[i2];
                            PackageSet value2 = scope2.getValue();
                            if (value2 == null || value2.getClass().getClassLoader() != pluginClassLoader) continue;
                            String presentableName = scope2.getPresentableName();
                            scopes[i2] = new NamedScope(scope2.getScopeId(), () -> presentableName, AllIcons.Ide.LocalScope, (PackageSet)new InvalidPackageSet(value2.getText()));
                            changed2 = true;
                        }
                        if (!changed2) continue;
                        holder.setScopes(scopes);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/PackageSetFactoryImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    public PackageSet compile(String text2) throws ParsingException {
        ScopesLexer lexer = new ScopesLexer();
        lexer.start(text2);
        return new Parser((Lexer)lexer).parse();
    }

    private static class Parser {
        private final Lexer myLexer;

        Parser(Lexer lexer) {
            this.myLexer = lexer;
        }

        public PackageSet parse() throws ParsingException {
            PackageSet set2 = this.parseUnion();
            if (this.myLexer.getTokenType() != null) {
                this.error(CodeInsightBundle.message((String)"error.package.set.token.expectations", (Object[])new Object[]{this.getTokenText()}));
            }
            return set2;
        }

        private PackageSet parseUnion() throws ParsingException {
            ArrayList<PackageSet> sets = new ArrayList<PackageSet>();
            PackageSet set2 = this.parseIntersection();
            sets.add(set2);
            while (this.myLexer.getTokenType() == ScopeTokenTypes.OROR) {
                this.myLexer.advance();
                sets.add(this.parseIntersection());
            }
            return UnionPackageSet.create((PackageSet[])sets.toArray(new PackageSet[0]));
        }

        private PackageSet parseIntersection() throws ParsingException {
            PackageSet set2 = this.parseTerm();
            ArrayList<PackageSet> sets = new ArrayList<PackageSet>();
            sets.add(set2);
            while (this.myLexer.getTokenType() == ScopeTokenTypes.ANDAND) {
                this.myLexer.advance();
                sets.add(this.parseTerm());
            }
            return IntersectionPackageSet.create((PackageSet[])sets.toArray(new PackageSet[0]));
        }

        private PackageSet parseTerm() throws ParsingException {
            if (this.myLexer.getTokenType() == ScopeTokenTypes.EXCL) {
                this.myLexer.advance();
                return new ComplementPackageSet(this.parseTerm());
            }
            if (this.myLexer.getTokenType() == ScopeTokenTypes.LPARENTH) {
                return this.parseParenthesized();
            }
            if (this.myLexer.getTokenType() == ScopeTokenTypes.IDENTIFIER && this.myLexer.getBufferSequence().charAt(this.myLexer.getTokenStart()) == '$') {
                NamedPackageSetReference namedPackageSetReference = new NamedPackageSetReference(this.getTokenText());
                this.myLexer.advance();
                return namedPackageSetReference;
            }
            return this.parsePattern();
        }

        private PackageSet parsePattern() throws ParsingException {
            PackageSetParserExtension extension2;
            String scope2 = null;
            Iterator iterator2 = PackageSetParserExtension.EP_NAME.getExtensionList().iterator();
            while (iterator2.hasNext() && (scope2 = (extension2 = (PackageSetParserExtension)iterator2.next()).parseScope(this.myLexer)) == null) {
            }
            if (scope2 == null) {
                this.error("Unknown scope type");
            }
            String modulePattern = this.parseModulePattern();
            if (this.myLexer.getTokenType() == ScopeTokenTypes.COLON) {
                this.myLexer.advance();
            }
            for (PackageSetParserExtension extension3 : PackageSetParserExtension.EP_NAME.getExtensionList()) {
                PackageSet packageSet = extension3.parsePackageSet(this.myLexer, scope2, modulePattern);
                if (packageSet == null) continue;
                return packageSet;
            }
            this.error("Unknown scope type");
            return null;
        }

        private String getTokenText() {
            int start2 = this.myLexer.getTokenStart();
            int end = this.myLexer.getTokenEnd();
            return this.myLexer.getBufferSequence().subSequence(start2, end).toString();
        }

        @Nullable
        private String parseModulePattern() throws ParsingException {
            if (this.myLexer.getTokenType() != ScopeTokenTypes.LBRACKET) {
                return null;
            }
            this.myLexer.advance();
            StringBuilder pattern = new StringBuilder();
            while (true) {
                if (this.myLexer.getTokenType() == ScopeTokenTypes.RBRACKET || this.myLexer.getTokenType() == null) break;
                if (this.myLexer.getTokenType() == ScopeTokenTypes.ASTERISK) {
                    pattern.append("*");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.IDENTIFIER || this.myLexer.getTokenType() == TokenType.WHITE_SPACE || this.myLexer.getTokenType() == ScopeTokenTypes.INTEGER_LITERAL) {
                    pattern.append(this.getTokenText());
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.DOT) {
                    pattern.append(".");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.MINUS) {
                    pattern.append("-");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.TILDE) {
                    pattern.append("~");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.SHARP) {
                    pattern.append("#");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.COLON) {
                    pattern.append(":");
                } else {
                    pattern.append(this.getTokenText());
                }
                this.myLexer.advance();
            }
            this.myLexer.advance();
            if (pattern.length() == 0) {
                this.error(CodeInsightBundle.message((String)"error.package.set.pattern.expectations", (Object[])new Object[0]));
            }
            return pattern.toString();
        }

        private PackageSet parseParenthesized() throws ParsingException {
            LOG.assertTrue(this.myLexer.getTokenType() == ScopeTokenTypes.LPARENTH);
            this.myLexer.advance();
            PackageSet result2 = this.parseUnion();
            if (this.myLexer.getTokenType() != ScopeTokenTypes.RPARENTH) {
                this.error(CodeInsightBundle.message((String)"error.package.set.rparen.expected", (Object[])new Object[0]));
            }
            this.myLexer.advance();
            return result2;
        }

        private void error(@NotNull String message2) throws ParsingException {
            if (message2 == null) {
                Parser.$$$reportNull$$$0(0);
            }
            throw new ParsingException(CodeInsightBundle.message((String)"error.package.set.position.parsing.error", (Object[])new Object[]{message2, this.myLexer.getTokenStart() + 1}));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/psi/search/scope/packageSet/PackageSetFactoryImpl$Parser", "error"));
        }
    }
}

