/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.injected.XmlTextLiteralEscaper;
import com.intellij.psi.impl.source.xml.LanguageXmlPsiPolicy;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlPsiPolicy;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTextImpl
extends XmlElementImpl
implements XmlText,
PsiLanguageInjectionHost {
    private static final Logger LOG = Logger.getInstance(XmlTextImpl.class);
    private volatile String myDisplayText;
    private volatile int[] myGapDisplayStarts;
    private volatile int[] myGapPhysicalStarts;

    public XmlTextImpl() {
        super(XmlElementType.XML_TEXT);
    }

    @Override
    public String toString() {
        return "XmlText";
    }

    public boolean isValidHost() {
        return true;
    }

    @Nullable
    public XmlText split(int displayIndex) {
        try {
            return this._splitText(displayIndex);
        }
        catch (IncorrectOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getValue() {
        String text2;
        String displayText = this.myDisplayText;
        if (displayText != null) {
            return displayText;
        }
        StringBuilder buffer = new StringBuilder();
        TreeElement child2 = this.getFirstChildNode();
        IntArrayList gapsStarts = new IntArrayList();
        IntArrayList gapsShifts = new IntArrayList();
        while (child2 != null) {
            ASTNode next;
            int start2 = buffer.length();
            IElementType elementType = child2.getElementType();
            if (elementType == XmlElementType.XML_CDATA) {
                TreeElement cdata = child2;
                child2 = cdata.getFirstChildNode();
            } else if (elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                String text3 = child2.getText();
                buffer.append(XmlUtil.getCharFromEntityRef(text3));
            } else if (elementType == XmlTokenType.XML_WHITE_SPACE || elementType == XmlTokenType.XML_DATA_CHARACTERS || elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || elementType == TokenType.ERROR_ELEMENT || elementType == TokenType.NEW_LINE_INDENT) {
                buffer.append(child2.getText());
            }
            int end = buffer.length();
            int originalLength = child2.getTextLength();
            if (end - start2 != originalLength) {
                gapsStarts.add(end);
                gapsShifts.add(originalLength - (end - start2));
            }
            if ((next = child2.getTreeNext()) == null && child2.getTreeParent().getElementType() == XmlElementType.XML_CDATA) {
                child2 = child2.getTreeParent().getTreeNext();
                continue;
            }
            child2 = next;
        }
        int[] gapDisplayStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int[] gapPhysicalStarts = ArrayUtil.newIntArray((int)gapsShifts.size());
        int currentGapsSum = 0;
        for (int i2 = 0; i2 < gapDisplayStarts.length; ++i2) {
            gapDisplayStarts[i2] = gapsStarts.getInt(i2);
            gapPhysicalStarts[i2] = gapDisplayStarts[i2] + (currentGapsSum += gapsShifts.getInt(i2));
        }
        this.myGapDisplayStarts = gapDisplayStarts;
        this.myGapPhysicalStarts = gapPhysicalStarts;
        this.myDisplayText = text2 = buffer.toString();
        return text2;
    }

    public int physicalToDisplay(int physicalIndex) {
        int prevDisplayGapStart;
        this.getValue();
        if (this.myGapPhysicalStarts.length == 0) {
            return physicalIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapPhysicalStarts, physicalIndex);
        if (bsResult >= 0) {
            return this.myGapDisplayStarts[bsResult];
        }
        int insertionIndex = -bsResult - 1;
        int prevPhysGapStart = insertionIndex > 0 ? this.myGapPhysicalStarts[insertionIndex - 1] : 0;
        int n = prevDisplayGapStart = insertionIndex > 0 ? this.myGapDisplayStarts[insertionIndex - 1] : 0;
        if (insertionIndex < this.myGapDisplayStarts.length) {
            int prevDisplayGapLength;
            int n2 = prevDisplayGapLength = insertionIndex > 0 ? this.myGapDisplayStarts[insertionIndex] - this.myGapDisplayStarts[insertionIndex - 1] : this.myGapDisplayStarts[0];
            if (physicalIndex - prevPhysGapStart > prevDisplayGapLength) {
                return this.myGapDisplayStarts[insertionIndex];
            }
        }
        return physicalIndex - prevPhysGapStart + prevDisplayGapStart;
    }

    public int displayToPhysical(int displayIndex) {
        this.getValue();
        if (this.myGapDisplayStarts.length == 0) {
            return displayIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapDisplayStarts, displayIndex);
        if (bsResult >= 0) {
            return this.myGapPhysicalStarts[bsResult];
        }
        int insertionIndex = -bsResult - 1;
        int prevPhysGapStart = insertionIndex > 0 ? this.myGapPhysicalStarts[insertionIndex - 1] : 0;
        int prevDisplayGapStart = insertionIndex > 0 ? this.myGapDisplayStarts[insertionIndex - 1] : 0;
        return displayIndex - prevDisplayGapStart + prevPhysGapStart;
    }

    public void setValue(String s) throws IncorrectOperationException {
        this.doSetValue(s, this.getPolicy());
    }

    public void doSetValue(String s, XmlPsiPolicy policy) throws IncorrectOperationException {
        ASTNode firstEncodedElement = policy.encodeXmlTextContents(s, this);
        if (firstEncodedElement == null) {
            this.delete();
        } else {
            this.replaceAllChildrenToChildrenOf(firstEncodedElement.getTreeParent());
        }
        this.clearCaches();
    }

    public XmlElement insertAtOffset(XmlElement element2, int displayOffset) throws IncorrectOperationException {
        if (element2 instanceof XmlText) {
            this.insertText(((XmlText)element2).getValue(), displayOffset);
        } else {
            XmlTag tag2 = this.getParentTag();
            assert (tag2 != null);
            XmlText rightPart = this._splitText(displayOffset);
            if (rightPart != null) {
                tag2.addBefore((PsiElement)element2, (PsiElement)rightPart);
            } else {
                tag2.addAfter((PsiElement)element2, (PsiElement)this);
            }
        }
        return this;
    }

    private XmlPsiPolicy getPolicy() {
        return (XmlPsiPolicy)LanguageXmlPsiPolicy.INSTANCE.forLanguage(this.getLanguage());
    }

    public void insertText(String text2, int displayOffset) throws IncorrectOperationException {
        IElementType elementType;
        if (text2 == null || text2.isEmpty()) {
            return;
        }
        int physicalOffset = this.displayToPhysical(displayOffset);
        PsiElement psiElement = this.findElementAt(physicalOffset);
        IElementType iElementType = elementType = psiElement != null ? psiElement.getNode().getElementType() : null;
        if (elementType == XmlTokenType.XML_DATA_CHARACTERS) {
            int insertOffset = physicalOffset - psiElement.getStartOffsetInParent();
            String oldElementText = psiElement.getText();
            String newElementText = oldElementText.substring(0, insertOffset) + text2 + oldElementText.substring(insertOffset);
            ASTNode e = this.getPolicy().encodeXmlTextContents(newElementText, this);
            ASTNode node = psiElement.getNode();
            ASTNode treeNext = node.getTreeNext();
            this.addChildren(e, null, treeNext);
            this.deleteChildInternal(node);
            this.clearCaches();
        } else {
            this.setValue(new StringBuffer(this.getValue()).insert(displayOffset, text2).toString());
        }
    }

    public void removeText(int displayStart, int displayEnd) throws IncorrectOperationException {
        String value2 = this.getValue();
        int physicalStart = this.displayToPhysical(displayStart);
        PsiElement psiElement = this.findElementAt(physicalStart);
        if (psiElement != null) {
            IElementType elementType = psiElement.getNode().getElementType();
            int elementDisplayEnd = this.physicalToDisplay(psiElement.getStartOffsetInParent() + psiElement.getTextLength());
            int elementDisplayStart = this.physicalToDisplay(psiElement.getStartOffsetInParent());
            if ((elementType == XmlTokenType.XML_DATA_CHARACTERS || elementType == TokenType.WHITE_SPACE) && elementDisplayEnd >= displayEnd && elementDisplayStart <= displayStart) {
                int physicalEnd;
                for (physicalEnd = physicalStart; physicalEnd < this.getTextRange().getLength() && this.physicalToDisplay(physicalEnd) != displayEnd; ++physicalEnd) {
                }
                int removeStart = physicalStart - psiElement.getStartOffsetInParent();
                int removeEnd = physicalEnd - psiElement.getStartOffsetInParent();
                String oldElementText = psiElement.getText();
                String newElementText = oldElementText.substring(0, removeStart) + oldElementText.substring(removeEnd);
                if (!newElementText.isEmpty()) {
                    ASTNode e = this.getPolicy().encodeXmlTextContents(newElementText, this);
                    this.replaceChild(psiElement.getNode(), e);
                } else {
                    psiElement.delete();
                }
                this.clearCaches();
                return;
            }
        }
        if (displayStart == 0 && displayEnd == value2.length()) {
            this.delete();
        } else {
            this.setValue(new StringBuffer(this.getValue()).replace(displayStart, displayEnd, "").toString());
        }
    }

    public XmlTag getParentTag() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        throw new RuntimeException("Clients must not use operations with direct children of XmlText!");
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlTextImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlText((XmlText)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myDisplayText = null;
        this.myGapDisplayStarts = null;
        this.myGapPhysicalStarts = null;
    }

    public TextRange getCDATAInterior() {
        ASTNode startNode;
        ASTNode startNode2;
        PsiElement[] elements = this.getChildren();
        int first = 0;
        if (elements.length > 0 && elements[0] instanceof PsiWhiteSpace) {
            ++first;
        }
        int start2 = 0;
        if (elements.length > first && elements[first].getNode().getElementType() == XmlElementType.XML_CDATA && (startNode2 = elements[first].getNode().findChildByType(XmlTokenType.XML_CDATA_START)) != null) {
            start2 = startNode2.getTextRange().getEndOffset() - this.getTextRange().getStartOffset();
        }
        int end = this.getTextLength();
        int last = elements.length - 1;
        if (last > 0 && elements[last] instanceof PsiWhiteSpace) {
            --last;
        }
        if (last >= 0 && elements[last].getNode().getElementType() == XmlElementType.XML_CDATA && (startNode = elements[last].getNode().findChildByType(XmlTokenType.XML_CDATA_END)) != null) {
            end = startNode.getTextRange().getStartOffset() - this.getTextRange().getStartOffset();
        }
        return new TextRange(start2, end);
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            XmlTextImpl.$$$reportNull$$$0(1);
        }
        try {
            this.doSetValue(text2, new DefaultXmlPsiPolicy());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return this;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        PsiElement parent = this.getParent();
        Language language = parent != null ? parent.getLanguage() : super.getLanguage();
        if (language == null) {
            XmlTextImpl.$$$reportNull$$$0(2);
        }
        return language;
    }

    @Nullable
    private XmlText _splitText(int displayOffset) throws IncorrectOperationException {
        XmlTextImpl result2;
        XmlTag xmlTag = (XmlTag)this.getParent();
        if (displayOffset == 0) {
            return this;
        }
        int length = this.getValue().length();
        if (displayOffset >= length) {
            return null;
        }
        int physicalOffset = this.displayToPhysical(displayOffset);
        PsiElement childElement = this.findElementAt(physicalOffset);
        if (childElement != null && childElement.getNode().getElementType() == XmlTokenType.XML_DATA_CHARACTERS) {
            FileElement holder = DummyHolderFactory.createHolder(this.getManager(), null).getTreeElement();
            int splitOffset = physicalOffset - childElement.getStartOffsetInParent();
            result2 = (XmlTextImpl)ASTFactory.composite(XmlElementType.XML_TEXT);
            CodeEditUtil.setNodeGenerated(result2, true);
            holder.rawAddChildren(result2);
            for (PsiElement e = childElement; e != null; e = e.getNextSibling()) {
                CodeEditUtil.setNodeGenerated(e.getNode(), true);
            }
            String leftText = childElement.getText().substring(0, splitOffset);
            String rightText = childElement.getText().substring(splitOffset);
            LeafElement rightElement = ASTFactory.leaf(XmlTokenType.XML_DATA_CHARACTERS, holder.getCharTable().intern((CharSequence)rightText));
            CodeEditUtil.setNodeGenerated(rightElement, true);
            LeafElement leftElement = ASTFactory.leaf(XmlTokenType.XML_DATA_CHARACTERS, holder.getCharTable().intern((CharSequence)leftText));
            CodeEditUtil.setNodeGenerated(leftElement, true);
            this.rawInsertAfterMe(result2);
            result2.rawAddChildren(rightElement);
            if (childElement.getNextSibling() != null) {
                result2.rawAddChildren((TreeElement)childElement.getNextSibling());
            }
            DebugUtil.performPsiModification("xmlText split", () -> ((TreeElement)childElement).rawRemove());
            this.rawAddChildren(leftElement);
        } else {
            PsiFile containingFile = xmlTag.getContainingFile();
            FileElement holder = DummyHolderFactory.createHolder(containingFile.getManager(), null, ((PsiFileImpl)containingFile).getTreeElement().getCharTable()).getTreeElement();
            XmlTextImpl rightText = (XmlTextImpl)ASTFactory.composite(XmlElementType.XML_TEXT);
            CodeEditUtil.setNodeGenerated(rightText, true);
            holder.rawAddChildren(rightText);
            ((ASTNode)xmlTag).addChild((ASTNode)rightText, (ASTNode)this.getTreeNext());
            String value2 = this.getValue();
            this.setValue(value2.substring(0, displayOffset));
            rightText.setValue(value2.substring(displayOffset));
            CodeEditUtil.setNodeGenerated(rightText, true);
            result2 = rightText;
        }
        this.clearCaches();
        result2.clearCaches();
        return result2;
    }

    @NotNull
    public LiteralTextEscaper<XmlTextImpl> createLiteralTextEscaper() {
        return this.getParentTag() instanceof HtmlTag ? LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this) : new XmlTextLiteralEscaper(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlTextImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlTextImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

