/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DtdResolveUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlContentParticle;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlElementDescriptor;

public class XmlContentParticleImpl
implements XmlContentParticle,
XmlTokenType {
    private final XmlToken myToken;

    public XmlContentParticleImpl(XmlToken token2) {
        this.myToken = token2;
    }

    public XmlContentParticle.Type getType() {
        return XmlContentParticle.Type.ELEMENT;
    }

    public XmlContentParticle.Quantifier getQuantifier() {
        return XmlContentParticleImpl.getQuantifierImpl((PsiElement)this.myToken);
    }

    public static XmlContentParticle.Quantifier getQuantifierImpl(PsiElement element2) {
        PsiElement nextSibling = element2.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        if (nextSibling instanceof XmlToken) {
            IElementType tokenType = ((XmlToken)nextSibling).getTokenType();
            if (tokenType == XML_PLUS) {
                return XmlContentParticle.Quantifier.ONE_OR_MORE;
            }
            if (tokenType == XML_STAR) {
                return XmlContentParticle.Quantifier.ZERO_OR_MORE;
            }
            if (tokenType == XML_QUESTION) {
                return XmlContentParticle.Quantifier.OPTIONAL;
            }
        }
        return XmlContentParticle.Quantifier.REQUIRED;
    }

    public XmlContentParticle[] getSubParticles() {
        return new XmlContentParticle[0];
    }

    public XmlElementDescriptor getElementDescriptor() {
        return DtdResolveUtil.resolveElementReference(this.myToken.getText(), (XmlElement)this.myToken);
    }
}

