/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.html.impl.RelaxedHtmlFromSchemaElementDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class TagNameVariantCollector {
    public static List<XmlElementDescriptor> getTagDescriptors(XmlTag element2, Collection<String> namespaces, @Nullable List<? super String> nsInfo) {
        XmlElementDescriptor elementDescriptor = null;
        String elementNamespace = element2.getNamespacePrefix().isEmpty() ? null : element2.getNamespace();
        HashMap<String, XmlElementDescriptor> descriptorsMap = new HashMap<String, XmlElementDescriptor>();
        PsiElement context2 = element2.getParent();
        PsiElement curElement = element2.getParent();
        while (curElement instanceof XmlTag) {
            XmlElementDescriptor descriptor3;
            XmlTag declarationTag = (XmlTag)curElement;
            String namespace = declarationTag.getNamespace();
            if (!descriptorsMap.containsKey(namespace) && (descriptor3 = declarationTag.getDescriptor()) != null) {
                descriptorsMap.put(namespace, descriptor3);
                if (elementDescriptor == null) {
                    elementDescriptor = descriptor3;
                    if (elementNamespace == null) {
                        elementNamespace = namespace;
                    }
                }
            }
            curElement = curElement.getContext();
        }
        HashSet visited = new HashSet();
        XmlExtension extension2 = XmlExtension.getExtension(element2.getContainingFile());
        ArrayList variants = new ArrayList();
        for (String namespace : namespaces) {
            int initialSize = variants.size();
            TagNameVariantCollector.processVariantsInNamespace(namespace, element2, variants, elementDescriptor, elementNamespace, descriptorsMap, visited, context2 instanceof XmlTag ? (XmlTag)context2 : element2, extension2);
            if (nsInfo == null) continue;
            for (int i2 = initialSize; i2 < variants.size(); ++i2) {
                XmlElementDescriptor descriptor4 = (XmlElementDescriptor)variants.get(i2);
                nsInfo.add(descriptor4 instanceof XmlElementDescriptorImpl && !(descriptor4 instanceof RelaxedHtmlFromSchemaElementDescriptor) ? ((XmlElementDescriptorImpl)descriptor4).getNamespaceByContext((PsiElement)element2) : namespace);
            }
        }
        boolean hasPrefix = StringUtil.isNotEmpty((String)element2.getNamespacePrefix());
        return ContainerUtil.filter(variants, descriptor2 -> {
            if (descriptor2 instanceof AnyXmlElementDescriptor) {
                return false;
            }
            return !hasPrefix || !(descriptor2 instanceof XmlElementDescriptorImpl) || namespaces.contains(((XmlElementDescriptorImpl)descriptor2).getNamespace());
        });
    }

    private static void processVariantsInNamespace(String namespace, XmlTag element2, List<? super XmlElementDescriptor> variants, XmlElementDescriptor elementDescriptor, String elementNamespace, Map<String, XmlElementDescriptor> descriptorsMap, Set<? super XmlNSDescriptor> visited, XmlTag parent, XmlExtension extension2) {
        if (descriptorsMap.containsKey(namespace)) {
            XmlElementDescriptor descriptor2 = descriptorsMap.get(namespace);
            if (TagNameVariantCollector.isAcceptableNs(element2, elementDescriptor, elementNamespace, namespace)) {
                for (XmlElementDescriptor containedDescriptor : descriptor2.getElementsDescriptors(parent)) {
                    if (containedDescriptor == null) continue;
                    variants.add((XmlElementDescriptor)containedDescriptor);
                }
            }
            if (element2 instanceof HtmlTag) {
                HtmlUtil.addHtmlSpecificCompletions(descriptor2, element2, variants);
            }
            visited.add((XmlNSDescriptor)descriptor2.getNSDescriptor());
        } else {
            if (namespace == null) {
                return;
            }
            if (namespace.isEmpty() && !visited.isEmpty()) {
                return;
            }
            XmlNSDescriptor nsDescriptor = TagNameVariantCollector.getDescriptor(element2, namespace, true, extension2);
            if (nsDescriptor == null) {
                if (!descriptorsMap.isEmpty()) {
                    return;
                }
                nsDescriptor = TagNameVariantCollector.getDescriptor(element2, namespace, false, extension2);
            }
            if (nsDescriptor != null && !visited.contains(nsDescriptor) && TagNameVariantCollector.isAcceptableNs(element2, elementDescriptor, elementNamespace, namespace)) {
                XmlElementDescriptor parentDescriptor;
                visited.add((XmlNSDescriptor)nsDescriptor);
                XmlElementDescriptor[] rootElementsDescriptors = nsDescriptor.getRootElementsDescriptors((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlDocument.class));
                XmlTag parentTag = extension2.getParentTagForNamespace(element2, nsDescriptor);
                if (parentTag == element2.getParentTag()) {
                    parentDescriptor = elementDescriptor;
                } else {
                    assert (parentTag != null);
                    parentDescriptor = parentTag.getDescriptor();
                }
                for (XmlElementDescriptor candidateDescriptor : rootElementsDescriptors) {
                    if (candidateDescriptor == null || !TagNameVariantCollector.couldContainDescriptor(parentTag, parentDescriptor, candidateDescriptor, namespace, false)) continue;
                    variants.add((XmlElementDescriptor)candidateDescriptor);
                }
            }
        }
    }

    private static XmlNSDescriptor getDescriptor(XmlTag element2, String namespace, boolean strict, XmlExtension extension2) {
        return extension2.getNSDescriptor(element2, namespace, strict);
    }

    static boolean couldContainDescriptor(XmlTag parentTag, XmlElementDescriptor parentDescriptor, XmlElementDescriptor childDescriptor, String childNamespace, boolean strict) {
        if (XmlUtil.nsFromTemplateFramework(childNamespace)) {
            return true;
        }
        if (parentTag == null) {
            return true;
        }
        if (parentDescriptor == null) {
            return false;
        }
        XmlTag childTag = parentTag.createChildTag(childDescriptor.getName(), childNamespace, null, false);
        childTag.putUserData(XmlElement.INCLUDING_ELEMENT, (Object)parentTag);
        XmlElementDescriptor descriptor2 = parentDescriptor.getElementDescriptor(childTag, parentTag);
        return descriptor2 != null && (!strict || !(descriptor2 instanceof AnyXmlElementDescriptor));
    }

    private static boolean isAcceptableNs(XmlTag element2, XmlElementDescriptor elementDescriptor, String elementNamespace, String namespace) {
        return !(elementDescriptor instanceof XmlElementDescriptorAwareAboutChildren) || elementNamespace == null || elementNamespace.equals(namespace) || ((XmlElementDescriptorAwareAboutChildren)elementDescriptor).allowElementsFromNamespace(namespace, element2.getParentTag());
    }

    public static boolean couldContain(XmlTag parent, XmlTag child2) {
        return TagNameVariantCollector.couldContainDescriptor(parent, parent.getDescriptor(), child2.getDescriptor(), child2.getNamespace(), true);
    }
}

