/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html;

import com.intellij.lang.ASTNode;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFileImpl
extends XmlFileImpl
implements FileReferenceResolver,
HtmlCompatibleFile {
    public HtmlFileImpl(FileViewProvider provider2) {
        this(provider2, XmlElementType.HTML_FILE);
    }

    public HtmlFileImpl(FileViewProvider provider2, IFileElementType type) {
        super(provider2, (IElementType)type);
    }

    @Override
    public String toString() {
        return "HtmlFile:" + this.getName();
    }

    @Override
    public XmlDocument getDocument() {
        FileElement treeElement = this.calcTreeElement();
        ASTNode node = treeElement.findChildByType(XmlElementType.HTML_DOCUMENT);
        return node != null ? (XmlDocument)node.getPsi() : null;
    }

    @Override
    @Nullable
    public PsiFileSystemItem resolveFileReference(@NotNull FileReference reference2, @NotNull String name) {
        VirtualFile file2;
        if (reference2 == null) {
            HtmlFileImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            HtmlFileImpl.$$$reportNull$$$0(1);
        }
        if (!((file2 = this.getVirtualFile()) instanceof HttpVirtualFile)) {
            return null;
        }
        VirtualFile parent = file2;
        if (!parent.isDirectory() && (parent = parent.getParent()) == null) {
            parent = file2;
        }
        VirtualFile childFile = parent.findChild(name);
        HttpFileSystem fileSystem = (HttpFileSystem)parent.getFileSystem();
        if (childFile == null) {
            childFile = fileSystem.createChild(parent, name, !reference2.isLast());
        }
        if (childFile.isDirectory()) {
            VirtualFile childParent = childFile;
            FileReference[] references = reference2.getFileReferenceSet().getAllReferences();
            int n = references.length;
            for (int i2 = reference2.getIndex() + 1; i2 < n; ++i2) {
                FileReference childReference = references[i2];
                childParent = fileSystem.createChild(childParent, childReference.decode(childReference.getText()), i2 != n - 1);
            }
            return this.getManager().findDirectory(childFile);
        }
        return this.getManager().findFile(childFile);
    }

    @Override
    public Collection<Object> getVariants(@NotNull FileReference reference2) {
        if (reference2 == null) {
            HtmlFileImpl.$$$reportNull$$$0(2);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/html/HtmlFileImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFileReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

