/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.xml.AbstractSyntheticBlock;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagBlock
extends AbstractXmlBlock {
    private final Indent myIndent;

    public XmlTagBlock(ASTNode node, Wrap wrap2, Alignment alignment, XmlFormattingPolicy policy, Indent indent) {
        super(node, wrap2, alignment, policy, false);
        this.myIndent = indent;
    }

    public XmlTagBlock(ASTNode node, Wrap wrap2, Alignment alignment, XmlFormattingPolicy policy, Indent indent, boolean preserveSpace) {
        super(node, wrap2, alignment, policy, preserveSpace);
        this.myIndent = indent;
    }

    @Override
    protected List<Block> buildChildren() {
        ASTNode child2 = this.myNode.getFirstChildNode();
        Wrap attrWrap = Wrap.createWrap((WrapType)XmlTagBlock.getWrapType(this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false);
        Wrap textWrap = Wrap.createWrap((WrapType)XmlTagBlock.getWrapType(this.myXmlFormattingPolicy.getTextWrap(this.getTag())), (boolean)true);
        Wrap tagBeginWrap = this.createTagBeginWrapping(this.getTag());
        Alignment attrAlignment = Alignment.createAlignment();
        Alignment textAlignment = Alignment.createAlignment();
        ArrayList<Block> result2 = new ArrayList<Block>(3);
        ArrayList<Object> localResult = new ArrayList<Block>(1);
        boolean insideTag = true;
        while (child2 != null) {
            if (!XmlTagBlock.containsWhiteSpacesOnly(child2) && child2.getTextLength() > 0) {
                Wrap wrap2 = this.chooseWrap(child2, tagBeginWrap, attrWrap, textWrap);
                Alignment alignment = this.chooseAlignment(child2, attrAlignment, textAlignment);
                if (child2.getElementType() == XmlTokenType.XML_TAG_END) {
                    child2 = this.processChild(localResult, child2, wrap2, alignment, this.myXmlFormattingPolicy.getTagEndIndent());
                    result2.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                    insideTag = true;
                } else if (child2.getElementType() == XmlTokenType.XML_START_TAG_START) {
                    insideTag = false;
                    if (!localResult.isEmpty()) {
                        result2.add(this.createTagContentNode(localResult));
                    }
                    localResult = new ArrayList(1);
                    child2 = this.processChild(localResult, child2, wrap2, alignment, null);
                } else if (child2.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    insideTag = false;
                    if (!localResult.isEmpty()) {
                        result2.add(this.createTagContentNode(localResult));
                        localResult = new ArrayList(1);
                    }
                    child2 = this.processChild(localResult, child2, wrap2, alignment, null);
                } else if (child2.getElementType() == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    child2 = this.processChild(localResult, child2, wrap2, alignment, this.myXmlFormattingPolicy.getTagEndIndent());
                    result2.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                } else if (this.isTagListStart(child2.getElementType())) {
                    child2 = this.processChild(localResult, child2, wrap2, alignment, null);
                    result2.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                    insideTag = true;
                } else if (this.isTagListEnd(child2.getElementType())) {
                    insideTag = false;
                    if (!localResult.isEmpty()) {
                        result2.add(this.createTagContentNode(localResult));
                        localResult = new ArrayList(1);
                    }
                    child2 = this.processChild(localResult, child2, wrap2, alignment, this.myXmlFormattingPolicy.getTagEndIndent());
                    result2.add(this.createTagDescriptionNode(localResult));
                    localResult = new ArrayList(1);
                } else if (this.isJspxJavaContainingNode(child2)) {
                    this.createJspTextNode(localResult, child2, this.getChildIndent());
                } else {
                    Object indent = this.isJspResult(localResult) ? this.getChildrenIndent() : (!insideTag ? null : this.getChildrenIndent());
                    child2 = this.processChild((List<Block>)localResult, child2, wrap2, alignment, (Indent)indent);
                }
            }
            if (child2 == null) continue;
            child2 = child2.getTreeNext();
        }
        if (!localResult.isEmpty()) {
            result2.add(this.createTagContentNode(localResult));
        }
        return result2;
    }

    protected boolean isTagListEnd(IElementType elementType) {
        return false;
    }

    protected boolean isTagListStart(IElementType elementType) {
        return false;
    }

    protected boolean isJspResult(ArrayList<Block> localResult) {
        return false;
    }

    @Override
    @Nullable
    protected ASTNode processChild(List<Block> result2, ASTNode child2, Wrap wrap2, Alignment alignment, Indent indent) {
        IElementType type = child2.getElementType();
        if (type == XmlElementType.XML_TEXT) {
            SmartList injections = new SmartList();
            if (this.buildInjectedPsiBlocks((List<Block>)injections, child2, wrap2, alignment, indent)) {
                SmartList regular = new SmartList();
                this.createXmlTextBlocks((List<Block>)regular, child2, wrap2, alignment);
                this.combineRegularBlocksWithInjected(child2, result2, (List<Block>)injections, (List<Block>)regular);
                return child2;
            }
            return this.createXmlTextBlocks(result2, child2, wrap2, alignment);
        }
        if (type == XmlElementType.HTML_RAW_TEXT) {
            return this.createXmlTextBlocks(result2, child2, wrap2, alignment);
        }
        if (type == XmlElementType.XML_COMMENT) {
            if (this.buildInjectedPsiBlocks(result2, child2, wrap2, alignment, indent)) {
                return child2;
            }
            return super.processChild(result2, child2, wrap2, alignment, indent);
        }
        return super.processChild(result2, child2, wrap2, alignment, indent);
    }

    private void combineRegularBlocksWithInjected(@NotNull ASTNode injectionHost, @NotNull List<Block> result2, @NotNull List<Block> withInjections, @NotNull List<Block> regularBlocks) {
        if (injectionHost == null) {
            XmlTagBlock.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            XmlTagBlock.$$$reportNull$$$0(1);
        }
        if (withInjections == null) {
            XmlTagBlock.$$$reportNull$$$0(2);
        }
        if (regularBlocks == null) {
            XmlTagBlock.$$$reportNull$$$0(3);
        }
        int i2 = 0;
        int j = 0;
        int injectionHostOffset = injectionHost.getStartOffset();
        ArrayList<TextRange> injectedRanges = new ArrayList<TextRange>(withInjections.size());
        Int2ObjectOpenHashMap injectedBlocksMap = new Int2ObjectOpenHashMap();
        boolean lastInjected = true;
        int lastOffset = 0;
        for (Block block : withInjections) {
            TextRange range2 = block.getTextRange();
            if (block instanceof AnotherLanguageBlockWrapper) {
                injectedRanges.add(range2);
                injectedBlocksMap.put(range2.getStartOffset(), (Object)block);
                lastInjected = true;
                continue;
            }
            if (!lastInjected) {
                int offset = range2.getStartOffset();
                injectedRanges.add(new TextRange(lastOffset, offset));
            }
            lastOffset = range2.getEndOffset();
            lastInjected = false;
        }
        int injectedRangesCount = injectedRanges.size();
        while (i2 < regularBlocks.size()) {
            Block reg = regularBlocks.get(i2);
            if (j < injectedRangesCount) {
                TextRange nextRange;
                TextRange injRange = (TextRange)injectedRanges.get(j);
                TextRange regRange = reg.getTextRange();
                if (regRange.getEndOffset() <= injRange.getStartOffset()) {
                    result2.add(reg);
                    ++i2;
                    continue;
                }
                if (injRange.getStartOffset() <= regRange.getStartOffset() && regRange.getEndOffset() <= injRange.getEndOffset()) {
                    ++i2;
                    continue;
                }
                if (regRange.getStartOffset() < injRange.getStartOffset()) {
                    ASTNode node = (ASTNode)ObjectUtils.notNull((Object)injectionHost.findLeafElementAt(injRange.getStartOffset() - 1 - injectionHostOffset), (Object)injectionHost);
                    result2.add((Block)this.createSimpleChild(node, reg.getIndent(), reg.getWrap(), reg.getAlignment(), new TextRange(regRange.getStartOffset(), injRange.getStartOffset())));
                    if (regRange.getEndOffset() <= injRange.getEndOffset()) {
                        ++i2;
                        continue;
                    }
                }
                ContainerUtil.addIfNotNull(result2, (Object)((Block)injectedBlocksMap.get(injRange.getStartOffset())));
                ++j;
                if (regRange.getStartOffset() >= injRange.getEndOffset()) continue;
                int lastInjection = injRange.getEndOffset();
                while (j < injectedRangesCount && (nextRange = (TextRange)injectedRanges.get(j)).getStartOffset() < regRange.getEndOffset()) {
                    if (lastInjection < nextRange.getStartOffset()) {
                        ASTNode node = (ASTNode)ObjectUtils.notNull((Object)injectionHost.findLeafElementAt(lastInjection - injectionHostOffset), (Object)injectionHost);
                        result2.add((Block)this.createSimpleChild(node, reg.getIndent(), null, reg.getAlignment(), new TextRange(lastInjection, nextRange.getStartOffset())));
                    }
                    if ((lastInjection = nextRange.getEndOffset()) > regRange.getEndOffset()) break;
                    ContainerUtil.addIfNotNull(result2, (Object)((Block)injectedBlocksMap.get(nextRange.getStartOffset())));
                    ++j;
                }
                if (lastInjection < regRange.getEndOffset()) {
                    ASTNode node = (ASTNode)ObjectUtils.notNull((Object)injectionHost.findLeafElementAt(lastInjection - injectionHostOffset), (Object)injectionHost);
                    result2.add((Block)this.createSimpleChild(node, reg.getIndent(), null, reg.getAlignment(), new TextRange(lastInjection, regRange.getEndOffset())));
                }
                ++i2;
                continue;
            }
            result2.add(reg);
            ++i2;
        }
        while (j < injectedRangesCount) {
            ContainerUtil.addIfNotNull(result2, (Object)((Block)injectedBlocksMap.get(((TextRange)injectedRanges.get(j++)).getStartOffset())));
        }
    }

    protected Indent getChildrenIndent() {
        return this.myXmlFormattingPolicy.indentChildrenOf(this.getTag()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    private ASTNode createXmlTextBlocks(List<Block> list2, @NotNull ASTNode textNode, Wrap wrap2, Alignment alignment) {
        if (textNode == null) {
            XmlTagBlock.$$$reportNull$$$0(4);
        }
        ASTNode child2 = textNode.getFirstChildNode();
        return this.createXmlTextBlocks(list2, textNode, child2, wrap2, alignment);
    }

    private ASTNode createXmlTextBlocks(List<Block> list2, ASTNode textNode, ASTNode child2, Wrap wrap2, Alignment alignment) {
        while (child2 != null) {
            if (!AbstractXmlBlock.containsWhiteSpacesOnly(child2) && child2.getTextLength() > 0) {
                Indent indent = this.getChildrenIndent();
                if ((child2 = this.processChild(list2, child2, wrap2, alignment, indent)) == null) {
                    return null;
                }
                if (child2.getTreeParent() != textNode) {
                    if (child2.getTreeParent() != this.myNode) {
                        return this.createXmlTextBlocks(list2, child2.getTreeParent(), child2.getTreeNext(), wrap2, alignment);
                    }
                    return child2;
                }
            }
            child2 = child2.getTreeNext();
        }
        return textNode;
    }

    private Block createTagContentNode(ArrayList<Block> localResult) {
        return this.createSyntheticBlock(localResult, this.getChildrenIndent());
    }

    protected Block createSyntheticBlock(ArrayList<Block> localResult, Indent childrenIndent) {
        return new SyntheticBlock(localResult, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, childrenIndent);
    }

    private Block createTagDescriptionNode(ArrayList<Block> localResult) {
        return this.createSyntheticBlock(localResult, null);
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            XmlTagBlock.$$$reportNull$$$0(5);
        }
        if (this.isPreserveSpace()) {
            return Spacing.getReadOnlySpacing();
        }
        if (child1 instanceof AbstractSyntheticBlock && child2 instanceof AbstractSyntheticBlock) {
            return this.getSpacing((AbstractSyntheticBlock)child1, (AbstractSyntheticBlock)child2);
        }
        return null;
    }

    protected Spacing getSpacing(AbstractSyntheticBlock syntheticBlock1, AbstractSyntheticBlock syntheticBlock2) {
        boolean saveSpacesBetweenTagAndText;
        XmlTag startTag;
        if (syntheticBlock2.startsWithCDATA() || syntheticBlock1.endsWithCDATA()) {
            return Spacing.getReadOnlySpacing();
        }
        if (syntheticBlock1.containsCDATA() && syntheticBlock2.isTagDescription() || syntheticBlock1.isTagDescription() && syntheticBlock2.containsCDATA()) {
            int lineFeeds = 0;
            switch (this.myXmlFormattingPolicy.getWhiteSpaceAroundCDATAOption()) {
                case 1: {
                    break;
                }
                case 2: {
                    lineFeeds = 1;
                    break;
                }
                case 0: {
                    return Spacing.getReadOnlySpacing();
                }
                default: {
                    assert (false) : "Unexpected whitespace around CDATA code style option.";
                    break;
                }
            }
            return Spacing.createSpacing((int)0, (int)0, (int)lineFeeds, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.isJspTextBlock() || syntheticBlock1.isJspTextBlock()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.isJspxTextBlock() || syntheticBlock1.isJspxTextBlock()) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(this.getTag())) {
            return Spacing.getReadOnlySpacing();
        }
        if (this.myXmlFormattingPolicy.getShouldKeepWhiteSpaces()) {
            return Spacing.getReadOnlySpacing();
        }
        if (syntheticBlock2.startsWithTag() && this.myXmlFormattingPolicy.keepWhiteSpacesInsideTag(startTag = syntheticBlock2.getStartTag()) && startTag.textContains('\n')) {
            return this.getChildrenIndent() != Indent.getNoneIndent() ? Spacing.getReadOnlySpacing() : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        boolean bl = saveSpacesBetweenTagAndText = this.myXmlFormattingPolicy.shouldSaveSpacesBetweenTagAndText() && syntheticBlock1.getTextRange().getEndOffset() < syntheticBlock2.getTextRange().getStartOffset();
        if (syntheticBlock1.endsWithTextElement() && syntheticBlock2.startsWithTextElement()) {
            return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.endsWithText()) {
            if (syntheticBlock1.insertLineFeedAfter()) {
                return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.getTag().getTextRange(), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            if (saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.isTagDescription() && syntheticBlock2.isTagDescription()) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock2.startsWithText()) {
            if (saveSpacesBetweenTagAndText) {
                return Spacing.createSafeSpacing((boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.isTagDescription() && syntheticBlock2.startsWithTag()) {
            return Spacing.createSpacing((int)0, (int)0, (int)(this.myXmlFormattingPolicy.insertLineBreakAfterTagBegin(this.getTag()) ? 2 : 0), (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.insertLineFeedAfter()) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (syntheticBlock1.endsWithTag() && syntheticBlock2.isTagDescription()) {
            return Spacing.createSpacing((int)0, (int)0, (int)(this.myXmlFormattingPolicy.insertLineBreakAfterTagBegin(this.getTag()) ? 2 : 0), (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return this.createDefaultSpace(true, true);
    }

    @Override
    public boolean insertLineBreakBeforeTag() {
        return this.myXmlFormattingPolicy.insertLineBreakBeforeTag(this.getTag());
    }

    @Override
    public int getBlankLinesBeforeTag() {
        return this.myXmlFormattingPolicy.getBlankLinesBeforeTag(this.getTag());
    }

    @Override
    public boolean removeLineBreakBeforeTag() {
        return this.myXmlFormattingPolicy.removeLineBreakBeforeTag(this.getTag());
    }

    @Override
    public boolean isTextElement() {
        return this.myXmlFormattingPolicy.isTextElement(this.getTag());
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.isAfterAttribute(newChildIndex)) {
            List<Block> subBlocks = this.getSubBlocks();
            Block subBlock = subBlocks.get(newChildIndex - 1);
            int prevSubBlockChildrenCount = subBlock.getSubBlocks().size();
            ChildAttributes childAttributes = subBlock.getChildAttributes(prevSubBlockChildrenCount);
            if (childAttributes == null) {
                XmlTagBlock.$$$reportNull$$$0(6);
            }
            return childAttributes;
        }
        if (this.myXmlFormattingPolicy.indentChildrenOf(this.getTag())) {
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        return new ChildAttributes(Indent.getNoneIndent(), null);
    }

    private boolean isAfterAttribute(int newChildIndex) {
        int index2 = newChildIndex - 1;
        List<Block> subBlocks = this.getSubBlocks();
        Block prevBlock = index2 < subBlocks.size() ? subBlocks.get(index2) : null;
        return prevBlock instanceof SyntheticBlock && ((SyntheticBlock)prevBlock).endsWithAttribute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withInjections";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regularBlocks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/xml/XmlTagBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/xml/XmlTagBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "combineRegularBlocksWithInjected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createXmlTextBlocks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

