/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.DelegatingFormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlInjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlBlock
extends AbstractBlock {
    protected XmlFormattingPolicy myXmlFormattingPolicy;
    protected final XmlInjectedLanguageBlockBuilder myInjectedBlockBuilder;
    private final boolean myPreserveSpace;
    private static final Logger LOG = Logger.getInstance(AbstractXmlBlock.class);

    protected AbstractXmlBlock(ASTNode node, Wrap wrap2, Alignment alignment, XmlFormattingPolicy policy) {
        this(node, wrap2, alignment, policy, false);
    }

    protected AbstractXmlBlock(ASTNode node, Wrap wrap2, Alignment alignment, XmlFormattingPolicy policy, boolean preserveSpace) {
        super(node, wrap2, alignment);
        this.myXmlFormattingPolicy = policy;
        if (node.getTreeParent() == null) {
            this.myXmlFormattingPolicy.setRootBlock(node, (Block)this);
        }
        this.myInjectedBlockBuilder = new XmlInjectedLanguageBlockBuilder(this.myXmlFormattingPolicy);
        this.myPreserveSpace = AbstractXmlBlock.shouldPreserveSpace(node, preserveSpace);
    }

    private static boolean shouldPreserveSpace(ASTNode node, boolean defaultValue) {
        XmlAttribute spaceAttr;
        XmlTag tag2;
        if (node.getPsi() instanceof XmlTag && (tag2 = (XmlTag)node.getPsi()) != null && (spaceAttr = tag2.getAttribute("xml:space")) != null) {
            String value2 = spaceAttr.getValue();
            if ("preserve".equals(value2)) {
                return true;
            }
            if ("default".equals(value2)) {
                return false;
            }
        }
        return defaultValue;
    }

    public boolean isPreserveSpace() {
        return this.myPreserveSpace;
    }

    public static WrapType getWrapType(int type) {
        if (type == 0) {
            return WrapType.NONE;
        }
        if (type == 2) {
            return WrapType.ALWAYS;
        }
        if (type == 1) {
            return WrapType.NORMAL;
        }
        return WrapType.CHOP_DOWN_IF_LONG;
    }

    protected boolean isTextNode(IElementType elementType) {
        return elementType == XmlElementType.XML_TEXT || elementType == XmlElementType.HTML_RAW_TEXT;
    }

    protected Alignment chooseAlignment(ASTNode child2, Alignment attrAlignment, Alignment textAlignment) {
        if (this.isTextNode(this.myNode.getElementType())) {
            return this.getAlignment();
        }
        IElementType elementType = child2.getElementType();
        if (this.isAttributeElementType(elementType) && this.myXmlFormattingPolicy.getShouldAlignAttributes()) {
            return attrAlignment;
        }
        if (this.isTextNode(elementType) && this.myXmlFormattingPolicy.getShouldAlignText()) {
            return textAlignment;
        }
        return null;
    }

    private Wrap getTagEndWrapping(XmlTag parent) {
        return Wrap.createWrap((WrapType)this.myXmlFormattingPolicy.getWrappingTypeForTagEnd(parent), (boolean)true);
    }

    protected Wrap chooseWrap(ASTNode child2, Wrap tagBeginWrap, Wrap attrWrap, Wrap textWrap) {
        if (this.isTextNode(this.myNode.getElementType())) {
            return textWrap;
        }
        IElementType elementType = child2.getElementType();
        if (this.isAttributeElementType(elementType)) {
            return attrWrap;
        }
        if (elementType == XmlTokenType.XML_START_TAG_START) {
            return tagBeginWrap;
        }
        if (elementType == XmlTokenType.XML_END_TAG_START) {
            XmlTag tag2;
            PsiElement parent = SourceTreeToPsiMap.treeElementToPsi(child2.getTreeParent());
            if (parent instanceof XmlTag && this.canWrapTagEnd(tag2 = (XmlTag)parent)) {
                return this.getTagEndWrapping(tag2);
            }
            return null;
        }
        if (this.isTextNode(elementType) || elementType == XmlTokenType.XML_DATA_CHARACTERS) {
            ASTNode previous = FormatterUtil.getPreviousNonWhitespaceSibling(child2);
            if (previous == null || !this.isTextNode(previous.getElementType())) {
                return this.myXmlFormattingPolicy.allowWrapBeforeText() ? textWrap : null;
            }
            return textWrap;
        }
        return null;
    }

    protected boolean canWrapTagEnd(XmlTag tag2) {
        return AbstractXmlBlock.hasSubTags(tag2);
    }

    static boolean hasSubTags(XmlTag tag2) {
        for (PsiElement child2 = tag2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            if (!(child2 instanceof XmlTag)) continue;
            return true;
        }
        return false;
    }

    protected XmlTag getTag() {
        return AbstractXmlBlock.getTag(this.myNode);
    }

    protected static XmlTag getTag(ASTNode node) {
        PsiElement element2 = SourceTreeToPsiMap.treeElementToPsi(node);
        if (element2 instanceof XmlTag) {
            return (XmlTag)element2;
        }
        return null;
    }

    protected Wrap createTagBeginWrapping(XmlTag tag2) {
        return Wrap.createWrap((WrapType)this.myXmlFormattingPolicy.getWrappingTypeForTagBegin(tag2), (boolean)true);
    }

    @Nullable
    protected ASTNode processChild(List<Block> result2, ASTNode child2, Wrap wrap2, Alignment alignment, Indent indent) {
        PsiElement childPsi;
        Language childLanguage;
        Language myLanguage = this.myNode.getPsi().getLanguage();
        if (this.useMyFormatter(myLanguage, childLanguage = (childPsi = child2.getPsi()).getLanguage(), childPsi)) {
            XmlTag tag2 = this.getAnotherTreeTag(child2);
            if (tag2 != null && this.containsTag((PsiElement)tag2) && this.doesNotIntersectSubTagsWith((PsiElement)tag2)) {
                ASTNode currentChild = this.createAnotherTreeNode(result2, child2, (PsiElement)tag2, indent, wrap2, alignment);
                if (currentChild == null) {
                    return null;
                }
                while (currentChild != null && currentChild.getTreeParent() != this.myNode && currentChild.getTreeParent() != child2.getTreeParent()) {
                    if ((currentChild = this.processAllChildrenFrom(result2, currentChild, wrap2, alignment, indent)) != null && (currentChild.getTreeParent() == this.myNode || currentChild.getTreeParent() == child2.getTreeParent())) {
                        return currentChild;
                    }
                    if (currentChild == null) continue;
                    currentChild = currentChild.getTreeParent();
                }
                return currentChild;
            }
            this.processSimpleChild(child2, indent, result2, wrap2, alignment);
            return child2;
        }
        if (!this.isBuildIndentsOnly()) {
            this.myInjectedBlockBuilder.addInjectedLanguageBlockWrapper(result2, child2, indent, 0, null);
        }
        return child2;
    }

    protected boolean doesNotIntersectSubTagsWith(PsiElement tag2) {
        TextRange tagRange = tag2.getTextRange();
        for (XmlTag subTag : JBIterable.of((Object[])this.myNode.getPsi().getChildren()).filter(XmlTag.class)) {
            TextRange subTagRange = subTag.getTextRange();
            if (subTagRange.getEndOffset() < tagRange.getStartOffset()) continue;
            if (subTagRange.getStartOffset() > tagRange.getEndOffset()) {
                return true;
            }
            if (tagRange.getStartOffset() > subTagRange.getStartOffset() && tagRange.getEndOffset() < subTagRange.getEndOffset()) {
                return false;
            }
            if (tagRange.getEndOffset() <= subTagRange.getStartOffset() || tagRange.getEndOffset() >= subTagRange.getEndOffset()) continue;
            return false;
        }
        return true;
    }

    protected boolean containsTag(PsiElement tag2) {
        ASTNode closingTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(this.myNode);
        ASTNode startTagStart = XmlChildRole.START_TAG_END_FINDER.findChild(this.myNode);
        if (closingTagStart == null && startTagStart == null) {
            return tag2.getTextRange().getEndOffset() <= this.myNode.getTextRange().getEndOffset();
        }
        if (closingTagStart == null) {
            return false;
        }
        return tag2.getTextRange().getEndOffset() <= closingTagStart.getTextRange().getEndOffset();
    }

    private ASTNode processAllChildrenFrom(List<Block> result2, @NotNull ASTNode child2, Wrap wrap2, Alignment alignment, Indent indent) {
        if (child2 == null) {
            AbstractXmlBlock.$$$reportNull$$$0(0);
        }
        ASTNode resultNode = child2;
        ASTNode currentChild = child2.getTreeNext();
        while (currentChild != null && currentChild.getElementType() != XmlTokenType.XML_END_TAG_START) {
            if (!AbstractXmlBlock.containsWhiteSpacesOnly(currentChild)) {
                resultNode = currentChild = this.processChild(result2, currentChild, wrap2, alignment, indent);
            }
            if (currentChild == null) continue;
            currentChild = currentChild.getTreeNext();
        }
        return resultNode;
    }

    protected void processSimpleChild(ASTNode child2, Indent indent, List<? super Block> result2, Wrap wrap2, Alignment alignment) {
        if (this.isXmlTag(child2)) {
            result2.add((Block)this.createTagBlock(child2, indent != null ? indent : Indent.getNoneIndent(), wrap2, alignment));
        } else if (child2.getElementType() == XmlElementType.XML_DOCTYPE) {
            result2.add((Block)new XmlBlock(child2, wrap2, alignment, this.myXmlFormattingPolicy, indent, null, this.isPreserveSpace()){

                @Override
                protected Wrap getDefaultWrap(ASTNode node) {
                    IElementType type = node.getElementType();
                    return type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN ? Wrap.createWrap((WrapType)1.getWrapType(this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false) : null;
                }
            });
        } else {
            result2.add((Block)this.createSimpleChild(child2, indent, wrap2, alignment, null));
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    protected XmlBlock createSimpleChild(ASTNode child2, Indent indent, Wrap wrap2, Alignment alignment) {
        return null;
    }

    @NotNull
    protected XmlBlock createSimpleChild(@NotNull ASTNode child2, @Nullable Indent indent, @Nullable Wrap wrap2, @Nullable Alignment alignment, @Nullable TextRange range2) {
        XmlBlock blockFromDeprecatedCall;
        if (child2 == null) {
            AbstractXmlBlock.$$$reportNull$$$0(1);
        }
        if ((blockFromDeprecatedCall = this.createSimpleChild(child2, indent, wrap2, alignment)) != null) {
            XmlBlock xmlBlock = blockFromDeprecatedCall;
            if (xmlBlock == null) {
                AbstractXmlBlock.$$$reportNull$$$0(2);
            }
            return xmlBlock;
        }
        return new XmlBlock(child2, wrap2, alignment, this.myXmlFormattingPolicy, indent, range2, this.isPreserveSpace());
    }

    protected XmlTagBlock createTagBlock(ASTNode child2, Indent indent, Wrap wrap2, Alignment alignment) {
        return new XmlTagBlock(child2, wrap2, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace());
    }

    @Nullable
    protected XmlTag findXmlTagAt(ASTNode child2, int startOffset) {
        return null;
    }

    @Nullable
    protected ASTNode createAnotherTreeNode(List<? super Block> result2, ASTNode child2, PsiElement tag2, Indent indent, Wrap wrap2, Alignment alignment) {
        return null;
    }

    @Nullable
    protected Block createAnotherTreeTagBlock(PsiElement tag2, Indent childIndent) {
        return null;
    }

    protected XmlFormattingPolicy createPolicyFor() {
        return this.myXmlFormattingPolicy;
    }

    @Nullable
    protected XmlTag getAnotherTreeTag(ASTNode child2) {
        return null;
    }

    protected boolean isAttributeElementType(IElementType elementType) {
        return elementType instanceof IXmlAttributeElementType;
    }

    protected boolean isXmlTag(ASTNode child2) {
        return this.isXmlTag(child2.getPsi());
    }

    protected boolean isXmlTag(PsiElement psi) {
        return psi instanceof XmlTag;
    }

    protected boolean useMyFormatter(Language myLanguage, Language childLanguage, PsiElement childPsi) {
        if (myLanguage == childLanguage || childLanguage == HtmlFileType.INSTANCE.getLanguage() || childLanguage == XHtmlFileType.INSTANCE.getLanguage() || childLanguage == XmlFileType.INSTANCE.getLanguage()) {
            return true;
        }
        FormattingModelBuilder childFormatter = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(childLanguage);
        return childFormatter == null || childFormatter instanceof DelegatingFormattingModelBuilder && ((DelegatingFormattingModelBuilder)childFormatter).dontFormatMyModel(childPsi);
    }

    protected boolean isJspxJavaContainingNode(ASTNode child2) {
        return false;
    }

    public abstract boolean insertLineBreakBeforeTag();

    public int getBlankLinesBeforeTag() {
        return this.insertLineBreakBeforeTag() ? 1 : 0;
    }

    public abstract boolean removeLineBreakBeforeTag();

    protected Spacing createDefaultSpace(boolean forceKeepLineBreaks, boolean inText) {
        boolean shouldKeepLineBreaks = this.getShouldKeepLineBreaks(inText, forceKeepLineBreaks);
        return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)shouldKeepLineBreaks, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
    }

    private boolean getShouldKeepLineBreaks(boolean inText, boolean forceKeepLineBreaks) {
        if (forceKeepLineBreaks) {
            return true;
        }
        if (inText && this.myXmlFormattingPolicy.getShouldKeepLineBreaksInText()) {
            return true;
        }
        return !inText && this.myXmlFormattingPolicy.getShouldKeepLineBreaks();
    }

    public abstract boolean isTextElement();

    protected void createJspTextNode(List<? super Block> localResult, ASTNode child2, Indent indent) {
    }

    @Nullable
    protected static ASTNode findChildAfter(@NotNull ASTNode child2, int endOffset) {
        FileElement fileNode;
        LeafElement leaf;
        if (child2 == null) {
            AbstractXmlBlock.$$$reportNull$$$0(3);
        }
        if ((leaf = ((TreeElement)(fileNode = TreeUtil.getFileElement((TreeElement)child2))).findLeafElementAt(endOffset)) != null && leaf.getStartOffset() == endOffset && endOffset > 0) {
            return ((TreeElement)fileNode).findLeafElementAt(endOffset - 1);
        }
        return leaf;
    }

    public boolean isLeaf() {
        return AbstractXmlBlock.isComment(this.myNode) || this.myNode.getElementType() == TokenType.WHITE_SPACE || this.myNode.getElementType() == XmlTokenType.XML_DATA_CHARACTERS || this.myNode.getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
    }

    private static boolean isComment(ASTNode node) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(node);
        if (psiElement instanceof PsiComment) {
            return true;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(psiElement.getLanguage());
        if (parserDefinition == null) {
            return false;
        }
        TokenSet commentTokens = parserDefinition.getCommentTokens();
        return commentTokens.contains(node.getElementType());
    }

    public void setXmlFormattingPolicy(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myXmlFormattingPolicy = xmlFormattingPolicy;
    }

    protected boolean buildInjectedPsiBlocks(List<Block> result2, ASTNode child2, Wrap wrap2, Alignment alignment, Indent indent) {
        if (this.isBuildIndentsOnly()) {
            return false;
        }
        if (this.myInjectedBlockBuilder.addInjectedBlocks(result2, child2, wrap2, alignment, indent)) {
            return true;
        }
        PsiFile containingFile = child2.getPsi().getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
            Language templateLanguage = ((TemplateLanguageFileViewProvider)fileViewProvider).getTemplateDataLanguage();
            PsiElement at = fileViewProvider.findElementAt(child2.getStartOffset(), templateLanguage);
            if (at instanceof XmlToken) {
                at = at.getParent();
            }
            if (at instanceof PsiComment && at.getTextRange().equals((Object)child2.getTextRange()) && at.getNode() != child2) {
                return this.buildInjectedPsiBlocks(result2, at.getNode(), wrap2, alignment, indent);
            }
        }
        return false;
    }

    public boolean isCDATAStart() {
        return this.myNode.getElementType() == XmlTokenType.XML_CDATA_START;
    }

    public boolean isCDATAEnd() {
        return this.myNode.getElementType() == XmlTokenType.XML_CDATA_END;
    }

    public static boolean containsWhiteSpacesOnly(@NotNull ASTNode node) {
        PsiElement psiElement;
        if (node == null) {
            AbstractXmlBlock.$$$reportNull$$$0(4);
        }
        if ((psiElement = node.getPsi()) instanceof PsiWhiteSpace) {
            return true;
        }
        Language nodeLang = psiElement.getLanguage();
        if (!nodeLang.isKindOf((Language)XMLLanguage.INSTANCE) || AbstractXmlBlock.isTextOnlyNode(node) || node.getElementType() == XmlElementType.XML_PROLOG) {
            WhiteSpaceFormattingStrategy strategy = WhiteSpaceFormattingStrategyFactory.getStrategy(nodeLang);
            int length = node.getTextLength();
            return strategy.check(node.getChars(), 0, length) >= length;
        }
        return false;
    }

    private static boolean isTextOnlyNode(@NotNull ASTNode node) {
        if (node == null) {
            AbstractXmlBlock.$$$reportNull$$$0(5);
        }
        if (node.getPsi() instanceof XmlText || node.getElementType() == XmlElementType.HTML_RAW_TEXT) {
            return true;
        }
        ASTNode firstChild = node.getFirstChildNode();
        ASTNode lastChild = node.getLastChildNode();
        return firstChild != null && firstChild == lastChild && firstChild.getPsi() instanceof XmlText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/xml/AbstractXmlBlock";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/xml/AbstractXmlBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllChildrenFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleChild";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findChildAfter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsWhiteSpacesOnly";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTextOnlyNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

