/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.DefaultInjectedLanguageBlockBuilder;
import com.intellij.psi.formatter.common.ExtraRangesProvider;
import com.intellij.psi.formatter.common.NodeIndentRangesCalculator;
import com.intellij.psi.formatter.common.SettingsAwareBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlock
implements ASTBlock,
ExtraRangesProvider {
    public static final List<Block> EMPTY = Collections.emptyList();
    @NotNull
    protected final ASTNode myNode;
    @Nullable
    protected final Wrap myWrap;
    @Nullable
    protected final Alignment myAlignment;
    private List<Block> mySubBlocks;
    private Boolean myIncomplete;
    private boolean myBuildIndentsOnly;

    protected AbstractBlock(@NotNull ASTNode node, @Nullable Wrap wrap2, @Nullable Alignment alignment) {
        if (node == null) {
            AbstractBlock.$$$reportNull$$$0(0);
        }
        this.myBuildIndentsOnly = false;
        this.myNode = node;
        this.myWrap = wrap2;
        this.myAlignment = alignment;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            AbstractBlock.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            List<Block> list2 = this.buildChildren();
            if (list2.isEmpty()) {
                list2 = this.buildInjectedBlocks();
            }
            this.mySubBlocks = !list2.isEmpty() ? list2 : EMPTY;
        }
        List<Block> list3 = this.mySubBlocks;
        if (list3 == null) {
            AbstractBlock.$$$reportNull$$$0(2);
        }
        return list3;
    }

    public void setBuildIndentsOnly(boolean value2) {
        this.myBuildIndentsOnly = value2;
    }

    protected boolean isBuildIndentsOnly() {
        return this.myBuildIndentsOnly;
    }

    @NotNull
    private List<Block> buildInjectedBlocks() {
        if (this.myBuildIndentsOnly) {
            List<Block> list2 = EMPTY;
            if (list2 == null) {
                AbstractBlock.$$$reportNull$$$0(3);
            }
            return list2;
        }
        if (!(this instanceof SettingsAwareBlock)) {
            List<Block> list3 = EMPTY;
            if (list3 == null) {
                AbstractBlock.$$$reportNull$$$0(4);
            }
            return list3;
        }
        PsiElement psi = this.myNode.getPsi();
        if (psi == null) {
            List<Block> list4 = EMPTY;
            if (list4 == null) {
                AbstractBlock.$$$reportNull$$$0(5);
            }
            return list4;
        }
        PsiFile file2 = psi.getContainingFile();
        if (file2 == null) {
            List<Block> list5 = EMPTY;
            if (list5 == null) {
                AbstractBlock.$$$reportNull$$$0(6);
            }
            return list5;
        }
        TextRange blockRange = this.myNode.getTextRange();
        List documentWindows = InjectedLanguageManager.getInstance((Project)file2.getProject()).getCachedInjectedDocumentsInRange(file2, blockRange);
        if (documentWindows.isEmpty()) {
            List<Block> list6 = EMPTY;
            if (list6 == null) {
                AbstractBlock.$$$reportNull$$$0(7);
            }
            return list6;
        }
        for (DocumentWindow documentWindow : documentWindows) {
            PsiFile injected;
            int endOffset;
            int startOffset = documentWindow.injectedToHost(0);
            if (!blockRange.containsRange(startOffset, endOffset = startOffset + documentWindow.getTextLength()) || (injected = PsiDocumentManager.getInstance((Project)psi.getProject()).getCachedPsiFile((Document)documentWindow)) == null) continue;
            ArrayList<Block> result2 = new ArrayList<Block>();
            DefaultInjectedLanguageBlockBuilder builder2 = new DefaultInjectedLanguageBlockBuilder(((SettingsAwareBlock)((Object)this)).getSettings());
            builder2.addInjectedBlocks(result2, this.myNode, this.getWrap(), this.getAlignment(), this.getIndent());
            ArrayList<Block> arrayList = result2;
            if (arrayList == null) {
                AbstractBlock.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        List<Block> list7 = EMPTY;
        if (list7 == null) {
            AbstractBlock.$$$reportNull$$$0(9);
        }
        return list7;
    }

    protected abstract List<Block> buildChildren();

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return null;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            AbstractBlock.$$$reportNull$$$0(10);
        }
        return aSTNode;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(this.getChildIndent(), this.getFirstChildAlignment());
    }

    @Nullable
    private Alignment getFirstChildAlignment() {
        List<Block> subBlocks = this.getSubBlocks();
        for (Block subBlock : subBlocks) {
            Alignment alignment = subBlock.getAlignment();
            if (alignment == null) continue;
            return alignment;
        }
        return null;
    }

    @Nullable
    protected Indent getChildIndent() {
        return null;
    }

    public boolean isIncomplete() {
        if (this.myIncomplete == null) {
            this.myIncomplete = FormatterUtil.isIncomplete(this.getNode());
        }
        return this.myIncomplete;
    }

    @Override
    @Nullable
    public List<TextRange> getExtraRangesToFormat(@NotNull FormattingRangesInfo info2) {
        if (info2 == null) {
            AbstractBlock.$$$reportNull$$$0(11);
        }
        return info2.isOnInsertedLine(this.getTextRange().getStartOffset()) && this.myNode.textContains('\n') ? new NodeIndentRangesCalculator(this.myNode).calculateExtraRanges() : null;
    }

    public String toString() {
        return this.myNode.getText() + " " + this.getTextRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/common/AbstractBlock";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/common/AbstractBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInjectedBlocks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExtraRangesToFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

