/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.position;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ReflectionUtil;

public class XmlTokenTypeFilter
implements ElementFilter {
    private IElementType myType = null;

    public XmlTokenTypeFilter() {
    }

    public XmlTokenTypeFilter(IElementType type) {
        this.myType = type;
    }

    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionUtil.isAssignable(XmlToken.class, (Class)hintClass);
    }

    public boolean isAcceptable(Object element2, PsiElement context2) {
        if (element2 instanceof PsiElement) {
            ASTNode node = ((PsiElement)element2).getNode();
            return node != null && node.getElementType() == this.myType;
        }
        if (element2 instanceof ASTNode) {
            return ((ASTNode)element2).getElementType() == this.myType;
        }
        return false;
    }

    public String toString() {
        return "token-type(" + this.myType + ")";
    }
}

