/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.AppInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProjectInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.VisibleTreeState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.lang.LangBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPane;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPaneKt;
import com.intellij.profile.codeInspection.ui.EmptyInspectionTreeActionProvider;
import com.intellij.profile.codeInspection.ui.InspectionProfileActionProvider;
import com.intellij.profile.codeInspection.ui.InspectionUiUtilKt;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.ScopesChooser;
import com.intellij.profile.codeInspection.ui.ScopesOrderDialog;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.filter.InspectionFilterAction;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.DefaultTreeTableExpander;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleInspectionProfilePanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(SingleInspectionProfilePanel.class);
    @NonNls
    private static final String INSPECTION_FILTER_HISTORY = "INSPECTION_FILTER_HISTORY";
    private static final float DIVIDER_PROPORTION_DEFAULT = 0.5f;
    private static final int SECTION_GAP = 20;
    private final Map<String, ToolDescriptors> myInitialToolDescriptors;
    private final InspectionConfigTreeNode myRoot;
    private final Alarm myAlarm;
    private final ProjectInspectionProfileManager myProjectProfileManager;
    @NotNull
    private final InspectionProfileModifiableModel myProfile;
    private DescriptionEditorPane myDescription;
    private JBLabel myOptionsLabel;
    private JPanel myOptionsPanel;
    private JPanel myInspectionProfilePanel;
    private FilterComponent myProfileFilter;
    private final InspectionsFilter myInspectionsFilter;
    private boolean myModified;
    private InspectionsConfigTreeTable myTreeTable;
    private TreeExpander myTreeExpander;
    private boolean myIsInRestore;
    private DefaultActionGroup myCreateInspectionActions;
    private List<String> myInitialScopesOrder;
    private Disposable myDisposable;

    public SingleInspectionProfilePanel(@NotNull ProjectInspectionProfileManager projectProfileManager, @NotNull InspectionProfileModifiableModel profile) {
        if (projectProfileManager == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myInitialToolDescriptors = new HashMap<String, ToolDescriptors>();
        this.myRoot = new InspectionConfigTreeNode.Group(InspectionsBundle.message((String)"inspection.root.node.title", (Object[])new Object[0]));
        this.myAlarm = new Alarm();
        this.myInspectionsFilter = new InspectionsFilter(){

            @Override
            protected void filterChanged() {
                SingleInspectionProfilePanel.this.filterTree();
                SingleInspectionProfilePanel.this.updateEmptyText();
            }
        };
        this.myDisposable = Disposer.newDisposable();
        this.myProjectProfileManager = projectProfileManager;
        this.myProfile = profile;
    }

    public boolean differsFromDefault() {
        return this.myRoot.isProperSetting();
    }

    public void performProfileReset() {
        TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).traverse().processEach(n -> {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)n;
            if (node instanceof InspectionConfigTreeNode.Tool && node.isProperSetting()) {
                ((InspectionConfigTreeNode.Tool)node).getDefaultDescriptor().loadConfig();
            }
            return true;
        });
        this.getProfile().resetToBase(this.getProject());
        this.loadDescriptorsConfigs(true);
        this.postProcessModification();
        this.updateModificationMarker();
        this.myRoot.dropCache();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProjectProfileManager.getProject();
        if (project == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(2);
        }
        return project;
    }

    private static VisibleTreeState getExpandedNodes(InspectionProfileImpl profile) {
        if (profile.isProjectLevel()) {
            return ProjectInspectionProfilesVisibleTreeState.getInstance(((ProjectInspectionProfileManager)profile.getProfileManager()).getProject()).getVisibleTreeState(profile);
        }
        return AppInspectionProfilesVisibleTreeState.getInstance().getVisibleTreeState(profile);
    }

    private static InspectionConfigTreeNode findGroupNodeByPath(String @NotNull [] path2, int idx, @NotNull InspectionConfigTreeNode node) {
        if (node == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(4);
        }
        if (path2.length == idx) {
            return node;
        }
        String currentKey = path2[idx];
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            InspectionConfigTreeNode currentNode = (InspectionConfigTreeNode)node.getChildAt(i2);
            if (!(currentNode instanceof InspectionConfigTreeNode.Group) || !((InspectionConfigTreeNode.Group)currentNode).getGroupName().equals(currentKey)) continue;
            return SingleInspectionProfilePanel.findGroupNodeByPath(path2, ++idx, currentNode);
        }
        return null;
    }

    @Nullable
    private static InspectionConfigTreeNode findNodeByKey(String name, InspectionConfigTreeNode root) {
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            InspectionConfigTreeNode child2 = (InspectionConfigTreeNode)root.getChildAt(i2);
            if (child2 instanceof InspectionConfigTreeNode.Tool) {
                if (!((InspectionConfigTreeNode.Tool)child2).getKey().toString().equals(name)) continue;
                return child2;
            }
            InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name, child2);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Nls
    public static String renderSeverity(HighlightSeverity severity) {
        if (HighlightSeverity.INFORMATION.equals((Object)severity)) {
            return LangBundle.message((String)"single.inspection.profile.panel.no.highlighting.only.fix", (Object[])new Object[0]);
        }
        return severity.getDisplayCapitalizedName();
    }

    private static boolean isDescriptorAccepted(Descriptor descriptor2, @NonNls String filter, boolean forceInclude, List<Set<String>> keySetList, Set<String> quoted) {
        filter = StringUtil.toLowerCase((String)filter);
        if (StringUtil.containsIgnoreCase((String)descriptor2.getText(), (String)filter)) {
            return true;
        }
        String[] groupPath = descriptor2.getGroup();
        for (String group2 : groupPath) {
            if (!StringUtil.containsIgnoreCase((String)group2, (String)filter)) continue;
            return true;
        }
        for (String string : quoted) {
            if (StringUtil.containsIgnoreCase((String)descriptor2.getText(), (String)string)) {
                return true;
            }
            for (String group3 : groupPath) {
                if (!StringUtil.containsIgnoreCase((String)group3, (String)string)) continue;
                return true;
            }
            String description = descriptor2.getToolWrapper().loadDescription();
            if (description != null && StringUtil.containsIgnoreCase((String)StringUtil.toLowerCase((String)description), (String)string)) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        for (Set set2 : keySetList) {
            if (set2.contains(descriptor2.getKey().toString())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    private void setConfigPanel(JPanel configPanelAnchor, ScopeToolState state) {
        configPanelAnchor.removeAll();
        JComponent additionalConfigPanel = state.getAdditionalConfigPanel();
        if (additionalConfigPanel != null) {
            additionalConfigPanel.setBorder(InspectionUiUtilKt.getBordersForOptions(additionalConfigPanel));
            configPanelAnchor.add(InspectionUiUtilKt.addScrollPaneIfNecessary(additionalConfigPanel));
        }
        if (this.myOptionsLabel != null) {
            this.myOptionsLabel.setText(AnalysisBundle.message((String)"inspections.settings.options.title.specific.scope", (Object[])new Object[]{state.getScopeName() == CustomScopesProviderEx.getAllScope().getScopeId() ? LangBundle.message((String)"scopes.table.everywhere.else", (Object[])new Object[0]) : state.getScopeName()}));
        }
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String[] groupPath) {
        InspectionConfigTreeNode currentRoot = root;
        for (String group2 : groupPath) {
            currentRoot = SingleInspectionProfilePanel.getGroupNode(currentRoot, group2);
        }
        return currentRoot;
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String group2) {
        int childCount = root.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            InspectionConfigTreeNode child2 = (InspectionConfigTreeNode)root.getChildAt(i2);
            if (!group2.equals(child2.getUserObject())) continue;
            return child2;
        }
        InspectionConfigTreeNode.Group child3 = new InspectionConfigTreeNode.Group(group2);
        root.add(child3);
        return child3;
    }

    private static void copyUsedSeveritiesIfUndefined(InspectionProfileImpl selectedProfile, BaseInspectionProfileManager profileManager) {
        SeverityRegistrar registrar = profileManager.getSeverityRegistrar();
        Set<HighlightSeverity> severities = selectedProfile.getUsedSeverities();
        severities.removeIf(severity -> registrar.isSeverityValid(severity.getName()));
        if (!severities.isEmpty()) {
            SeverityRegistrar oppositeRegister = selectedProfile.getProfileManager().getSeverityRegistrar();
            for (HighlightSeverity severity2 : severities) {
                TextAttributesKey attributesKey = TextAttributesKey.find((String)severity2.getName());
                TextAttributes textAttributes = oppositeRegister.getTextAttributesBySeverity(severity2);
                if (textAttributes == null) continue;
                HighlightInfoType.HighlightInfoTypeImpl info2 = new HighlightInfoType.HighlightInfoTypeImpl(severity2, attributesKey);
                registrar.registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info2), textAttributes.getErrorStripeColor());
            }
        }
    }

    private void initUI() {
        this.myInspectionProfilePanel = this.createInspectionProfileSettingsPanel();
        this.add((Component)this.myInspectionProfilePanel, "Center");
        UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
        userActivityWatcher.addUserActivityListener(() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.updateProperSettingsForSelection();
            this.updateModificationMarker();
        }));
        userActivityWatcher.register((Component)this.myOptionsPanel);
        this.updateSelectedProfileState();
        this.reset();
        this.getProject().getMessageBus().connect(this.myDisposable).subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (SingleInspectionProfilePanel.this.myProfile == profile) {
                    SingleInspectionProfilePanel.this.initToolStates();
                    SingleInspectionProfilePanel.this.filterTree();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$2", "profileChanged"));
            }
        });
    }

    private void updateSelectedProfileState() {
        if (this.isDisposed()) {
            return;
        }
        this.restoreTreeState();
        this.repaintTableData();
        this.updateSelection();
    }

    public void updateSelection() {
        TreePath selectionPath;
        if (this.myTreeTable != null && (selectionPath = this.myTreeTable.getTree().getSelectionPath()) != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)((TreeNode)selectionPath.getLastPathComponent()));
            int rowForPath = this.myTreeTable.getTree().getRowForPath(selectionPath);
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), (int[])new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void loadDescriptorsConfigs(boolean onlyModified) {
        this.myInitialToolDescriptors.values().stream().flatMap(ToolDescriptors::getDescriptors).forEach(d -> {
            if (!onlyModified || this.myProfile.isProperSetting(d.getKey().toString())) {
                d.loadConfig();
            }
        });
    }

    private void updateModificationMarker() {
        this.myModified = this.myInitialToolDescriptors.values().stream().flatMap(ToolDescriptors::getDescriptors).anyMatch(descriptor2 -> {
            Element oldConfig = descriptor2.getConfig();
            if (oldConfig == null) {
                return false;
            }
            ScopeToolState state = descriptor2.getState();
            Element newConfig = Descriptor.createConfigElement(state.getTool());
            if (!JDOMUtil.areElementsEqual((Element)oldConfig, (Element)newConfig)) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myTreeTable.repaint(), 300);
                return true;
            }
            return false;
        });
    }

    private void updateProperSettingsForSelection() {
        InspectionConfigTreeNode node;
        TreePath selectionPath = this.myTreeTable.getTree().getSelectionPath();
        if (selectionPath != null && (node = (InspectionConfigTreeNode)selectionPath.getLastPathComponent()) instanceof InspectionConfigTreeNode.Tool) {
            boolean properSetting = this.myProfile.isProperSetting(((InspectionConfigTreeNode.Tool)node).getKey().toString());
            if (node.isProperSetting() != properSetting) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myTreeTable.repaint(), 300);
                InspectionConfigTreeNode.updateUpHierarchy(node);
            }
        }
    }

    private void initToolStates() {
        if (this.isDisposed()) {
            return;
        }
        this.myInitialToolDescriptors.clear();
        Project project = this.getProject();
        for (ScopeToolState state : this.myProfile.getDefaultStates(this.getProject())) {
            if (!this.accept(state.getTool())) continue;
            ToolDescriptors descriptors2 = ToolDescriptors.fromScopeToolState(state, this.myProfile, project);
            this.myInitialToolDescriptors.put(descriptors2.getDefaultDescriptor().getShortName(), descriptors2);
        }
        this.myInitialScopesOrder = this.myProfile.getScopesOrder();
    }

    private boolean isDisposed() {
        return this.myDisposable == null;
    }

    protected boolean accept(InspectionToolWrapper entry2) {
        return !entry2.getDefaultLevel().isNonSwitchable();
    }

    private void postProcessModification() {
        this.updateModificationMarker();
        for (ScopeToolState state : this.myProfile.getAllTools()) {
            state.resetConfigPanel();
        }
        this.fillTreeData(this.myProfileFilter.getFilter(), true);
        this.repaintTableData();
        this.updateOptionsAndDescriptionPanel();
    }

    public void setFilter(String filter) {
        this.myProfileFilter.setFilter(filter);
    }

    private void filterTree() {
        String filter;
        String string = filter = this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null;
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.fillTreeData(filter, true);
            this.reloadModel();
            this.restoreTreeState();
            if (this.myTreeTable.getTree().getSelectionPath() == null) {
                TreeUtil.promiseSelectFirst((JTree)this.myTreeTable.getTree());
            }
        }
    }

    private void reloadModel() {
        try {
            this.myIsInRestore = true;
            ((DefaultTreeModel)this.myTreeTable.getTree().getModel()).reload();
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private void restoreTreeState() {
        try {
            this.myIsInRestore = true;
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).restoreVisibleState((Tree)this.myTreeTable.getTree());
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private ActionToolbar createTreeToolbarPanel() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultActionGroup actions2 = new DefaultActionGroup();
        actions2.add((AnAction)new InspectionFilterAction(this.myProfile, this.myInspectionsFilter, this.getProject(), this.myProfileFilter));
        actions2.addSeparator();
        actions2.add(actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions2.add(actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions2.add((AnAction)new DumbAwareAction(InspectionsBundle.messagePointer((String)"action.DumbAware.SingleInspectionProfilePanel.text.reset.to.empty", (Object[])new Object[0]), InspectionsBundle.messagePointer((String)"action.DumbAware.SingleInspectionProfilePanel.description.reset.to.empty", (Object[])new Object[0]), AllIcons.Actions.Unselectall){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!SingleInspectionProfilePanel.this.isDisposed() && SingleInspectionProfilePanel.this.myProfile.isExecutable(SingleInspectionProfilePanel.this.getProject()));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                SingleInspectionProfilePanel.this.myProfile.resetToEmpty(SingleInspectionProfilePanel.this.getProject());
                SingleInspectionProfilePanel.this.loadDescriptorsConfigs(false);
                SingleInspectionProfilePanel.this.postProcessModification();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (InspectionProfileActionProvider provider2 : InspectionProfileActionProvider.EP_NAME.getExtensionList()) {
            for (AnAction action2 : provider2.getActions(this)) {
                actions2.add(action2);
            }
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SingleInspectionProfile", (ActionGroup)actions2, true);
        actionToolbar.setTargetComponent((JComponent)this);
        return actionToolbar;
    }

    private void repaintTableData() {
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.reloadModel();
            this.restoreTreeState();
        }
    }

    public void selectInspectionTool(String name) {
        this.selectNode(SingleInspectionProfilePanel.findNodeByKey(name, this.myRoot));
    }

    public void selectInspectionGroup(String[] path2) {
        InspectionConfigTreeNode node = SingleInspectionProfilePanel.findGroupNodeByPath(path2, 0, this.myRoot);
        this.selectNode(node);
        if (node != null) {
            this.myTreeTable.getTree().expandPath(new TreePath(node.getPath()));
        }
    }

    private void selectNode(InspectionConfigTreeNode node) {
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)node);
            int rowForPath = this.myTreeTable.getTree().getRowForPath(new TreePath(node.getPath()));
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), (int[])new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void scrollToCenter() {
        ListSelectionModel selectionModel = this.myTreeTable.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, this.myTreeTable.getColumnModel().getSelectionModel().getMinSelectionIndex());
        Rectangle maxCellRect = this.myTreeTable.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = maxCellRect.getLocation();
        int allHeight = this.myTreeTable.getVisibleRect().height;
        this.myTreeTable.scrollRectToVisible(new Rectangle(new Point(0, Math.max(0, selectPoint.y - allHeight / 2)), new Dimension(0, allHeight)));
    }

    private JScrollPane initTreeScrollPane() {
        this.fillTreeData(null, true);
        InspectionsConfigTreeRenderer renderer = new InspectionsConfigTreeRenderer(){

            @Override
            protected String getFilter() {
                return SingleInspectionProfilePanel.this.myProfileFilter != null ? SingleInspectionProfilePanel.this.myProfileFilter.getFilter() : null;
            }
        };
        this.myTreeTable = InspectionsConfigTreeTable.create(new InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings(this.myRoot, this.getProject()){

            @Override
            protected void onChanged(@NotNull InspectionConfigTreeNode node) {
                if (node == null) {
                    5.$$$reportNull$$$0(0);
                }
                InspectionConfigTreeNode.updateUpHierarchy(node);
            }

            @Override
            public void updateRightPanel() {
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
            }

            @Override
            @NotNull
            public InspectionProfileImpl getInspectionProfile() {
                InspectionProfileModifiableModel inspectionProfileModifiableModel = SingleInspectionProfilePanel.this.myProfile;
                if (inspectionProfileModifiableModel == null) {
                    5.$$$reportNull$$$0(1);
                }
                return inspectionProfileModifiableModel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInspectionProfile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onChanged";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, this.myDisposable);
        this.myTreeTable.setTreeCellRenderer((TreeCellRenderer)((Object)renderer));
        this.myTreeTable.setRootVisible(false);
        this.myCreateInspectionActions = new DefaultActionGroup();
        for (EmptyInspectionTreeActionProvider provider2 : EmptyInspectionTreeActionProvider.EP_NAME.getExtensionList()) {
            this.myCreateInspectionActions.addAll(provider2.getActions(this));
        }
        this.updateEmptyText();
        TreeTableTree tree = this.myTreeTable.getTree();
        tree.putClientProperty(DefaultTreeUI.LARGE_MODEL_ALLOWED, (Object)true);
        tree.setRowHeight(renderer.getTreeCellRendererComponent((JTree)tree, (Object)"xxx", (boolean)true, (boolean)true, (boolean)false, (int)0, (boolean)true).getPreferredSize().height);
        tree.setLargeModel(true);
        tree.addTreeSelectionListener(__ -> {
            if (this.myTreeTable.getTree().getSelectionPaths() != null) {
                this.updateOptionsAndDescriptionPanel();
            } else {
                this.initOptionsAndDescriptionPanel();
            }
            if (!this.myIsInRestore && !this.isDisposed()) {
                InspectionProfileImpl baseProfile = this.myProfile.getSource();
                SingleInspectionProfilePanel.getExpandedNodes(baseProfile).setSelectionPaths(this.myTreeTable.getTree().getSelectionPaths());
                SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).setSelectionPaths(this.myTreeTable.getTree().getSelectionPaths());
            }
        });
        this.myTreeTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                TreeTableTree tree = SingleInspectionProfilePanel.this.myTreeTable.getTree();
                int[] selectionRows = tree.getSelectionRows();
                if (selectionRows != null && tree.getPathForLocation(x, y) != null && Arrays.binarySearch(selectionRows, tree.getRowForLocation(x, y)) > -1) {
                    SingleInspectionProfilePanel.this.compoundPopup().show(comp, x, y);
                }
            }
        });
        new TreeSpeedSearch((Tree)tree, (Convertor<? super TreePath, String>)((Convertor)o -> {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)o.getLastPathComponent();
            return InspectionsConfigTreeComparator.getDisplayTextToSort(node.getText());
        }));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeTable));
        tree.setShowsRootHandles(true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        TreeUtil.collapseAll((JTree)tree, (int)1);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                InspectionProfileModifiableModel selected2 = SingleInspectionProfilePanel.this.myProfile;
                SingleInspectionProfilePanel.getExpandedNodes(selected2.getSource()).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
                SingleInspectionProfilePanel.getExpandedNodes(selected2).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (!SingleInspectionProfilePanel.this.isDisposed()) {
                    InspectionConfigTreeNode node = (InspectionConfigTreeNode)event.getPath().getLastPathComponent();
                    SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile.getSource()).expandNode(node);
                    SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile).expandNode(node);
                }
            }
        });
        this.myTreeExpander = new DefaultTreeTableExpander((TreeTable)this.myTreeTable);
        this.myProfileFilter = new MyFilterComponent();
        return scrollPane;
    }

    private JPopupMenu compoundPopup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        SeverityRegistrar severityRegistrar = this.myProfile.getProfileManager().getSeverityRegistrar();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(severityRegistrar, this.includeDoNotShow())) {
            final HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            group2.add(new AnAction(SingleInspectionProfilePanel.renderSeverity(severity), SingleInspectionProfilePanel.renderSeverity(severity), level.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    SingleInspectionProfilePanel.this.setNewHighlightingLevel(level);
                }

                public boolean isDumbAware() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$8", "actionPerformed"));
                }
            });
        }
        group2.add((AnAction)Separator.getInstance());
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group2);
        return menu.getComponent();
    }

    private boolean includeDoNotShow() {
        TreePath[] paths = this.myTreeTable.getTree().getSelectionPaths();
        if (paths == null) {
            return true;
        }
        return this.includeDoNotShow(this.myTreeTable.getSelectedToolNodes());
    }

    private boolean includeDoNotShow(Collection<InspectionConfigTreeNode.Tool> nodes) {
        Project project = this.getProject();
        return !ContainerUtil.exists(nodes, node -> {
            InspectionToolWrapper tool = this.myProfile.getToolDefaultState(node.getKey().toString(), project).getTool();
            return tool instanceof GlobalInspectionToolWrapper && ((GlobalInspectionToolWrapper)tool).getSharedLocalInspectionToolWrapper() == null;
        });
    }

    private void fillTreeData(@Nullable String filter, boolean forceInclude) {
        Set filters;
        if (this.isDisposed()) {
            return;
        }
        this.myRoot.removeAllChildren();
        this.myRoot.dropCache();
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        HashSet<String> quoted = new HashSet<String>();
        if (filter != null && !filter.isEmpty()) {
            keySetList.addAll(SearchUtil.findKeys(filter, quoted));
        }
        Project project = this.getProject();
        boolean emptyFilter = this.myInspectionsFilter.isEmptyFilter();
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors.values()) {
            Descriptor descriptor2 = toolDescriptors.getDefaultDescriptor();
            if (filter != null && !filter.isEmpty() && !SingleInspectionProfilePanel.isDescriptorAccepted(descriptor2, filter, forceInclude, keySetList, quoted)) continue;
            String shortName = toolDescriptors.getDefaultDescriptor().getShortName();
            InspectionConfigTreeNode.Tool node = new InspectionConfigTreeNode.Tool(() -> this.myInitialToolDescriptors.get(shortName));
            if (!emptyFilter && !this.myInspectionsFilter.matches(this.myProfile.getTools(shortName, project), node)) continue;
            SingleInspectionProfilePanel.getGroupNode(this.myRoot, toolDescriptors.getDefaultDescriptor().getGroup()).add(node);
        }
        if (filter != null && forceInclude && this.myRoot.getChildCount() == 0 && ((filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter)).size() > 1 || !quoted.isEmpty())) {
            this.fillTreeData(filter, false);
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, InspectionsConfigTreeComparator.INSTANCE);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static void readHTML(JEditorPane browser2, String text2) {
        DescriptionEditorPaneKt.readHTML(browser2, text2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static String toHTML(JEditorPane browser2, @Nls String text2, boolean miniFontSize) {
        return DescriptionEditorPaneKt.toHTML(browser2, text2, miniFontSize);
    }

    private void updateOptionsAndDescriptionPanel() {
        if (this.isDisposed()) {
            return;
        }
        final Collection<InspectionConfigTreeNode.Tool> nodes = this.myTreeTable.getSelectedToolNodes();
        if (!nodes.isEmpty()) {
            ScopesAndSeveritiesTable scopesAndScopesAndSeveritiesTable;
            double severityPanelWeightY;
            boolean showDefaultConfigurationOptions;
            final Project project = this.getProject();
            InspectionConfigTreeNode.Tool singleNode = this.myTreeTable.getStrictlySelectedToolNode();
            ScopeToolState toolState = singleNode != null ? this.myProfile.getToolDefaultState(singleNode.getDefaultDescriptor().getKey().toString(), project) : null;
            boolean bl = showDefaultConfigurationOptions = toolState == null || toolState.getTool().getTool().showDefaultConfigurationOptions();
            if (singleNode != null) {
                Descriptor descriptor2 = singleNode.getDefaultDescriptor();
                if (descriptor2.loadDescription() != null) {
                    Descriptor defaultDescriptor = singleNode.getDefaultDescriptor();
                    String description = defaultDescriptor.loadDescription();
                    try {
                        DescriptionEditorPaneKt.readHTML(this.myDescription, SearchUtil.markup(DescriptionEditorPaneKt.toHTML(this.myDescription, description, false), this.myProfileFilter.getFilter()));
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to load description for: " + defaultDescriptor.getToolWrapper().getTool().getClass() + "; description: " + description, t);
                    }
                } else {
                    DescriptionEditorPaneKt.readHTML(this.myDescription, DescriptionEditorPaneKt.toHTML(this.myDescription, AnalysisBundle.message((String)"inspections.settings.no.description.warning", (Object[])new Object[0]), false));
                }
            } else {
                DescriptionEditorPaneKt.readHTML(this.myDescription, DescriptionEditorPaneKt.toHTML(this.myDescription, AnalysisBundle.message((String)"inspections.settings.multiple.inspections.warning", (Object[])new Object[0]), false));
            }
            this.myOptionsPanel.removeAll();
            JPanel severityPanel = new JPanel(new GridBagLayout());
            final JPanel configPanelAnchor = new JPanel(new GridLayout());
            HashSet<String> scopesNames = new HashSet<String>();
            for (InspectionConfigTreeNode.Tool node2 : nodes) {
                List<ScopeToolState> nonDefaultTools = this.myProfile.getNonDefaultTools(node2.getDefaultDescriptor().getKey().toString(), project);
                for (ScopeToolState tool : nonDefaultTools) {
                    scopesNames.add(tool.getScopeName());
                }
            }
            this.myOptionsLabel = new JBLabel(AnalysisBundle.message((String)"inspections.settings.options.title", (Object[])new Object[0]));
            if (scopesNames.isEmpty()) {
                LevelChooserAction severityLevelChooser = new LevelChooserAction(this.myProfile.getProfileManager().getSeverityRegistrar(), this.includeDoNotShow(nodes)){

                    @Override
                    protected void onChosen(HighlightSeverity severity) {
                        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
                        SmartList toUpdate = new SmartList();
                        for (InspectionConfigTreeNode.Tool node : nodes) {
                            NamedScope scope2;
                            HighlightDisplayKey key = node.getDefaultDescriptor().getKey();
                            boolean doUpdate2 = SingleInspectionProfilePanel.this.myProfile.getErrorLevel(key, scope2 = node.getDefaultDescriptor().getScope(), project) != level;
                            if (!doUpdate2) continue;
                            SingleInspectionProfilePanel.this.myProfile.setErrorLevel(key, level, null, project);
                            toUpdate.add(node);
                        }
                        SingleInspectionProfilePanel.this.updateRecursively((Collection<? extends InspectionConfigTreeNode>)toUpdate, false);
                        SingleInspectionProfilePanel.this.myTreeTable.updateUI();
                    }
                };
                HighlightSeverity severity = ScopesAndSeveritiesTable.getSeverity(ContainerUtil.map(nodes, node -> node.getDefaultDescriptor().getState()));
                severityLevelChooser.setChosen(severity);
                ScopesChooser scopesChooser = new ScopesChooser(ContainerUtil.map(nodes, node -> node.getDefaultDescriptor()), this.myProfile, project, null){

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopeAdded(@NotNull String scopeName) {
                        if (scopeName == null) {
                            10.$$$reportNull$$$0(0);
                        }
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$10", "onScopeAdded"));
                    }
                };
                JLabel severityLabel = new JLabel(InspectionsBundle.message((String)"inspection.severity", (Object[])new Object[0]));
                severityPanel.add((Component)severityLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, (Insets)JBInsets.create((int)10, (int)0), 0, 0));
                final JComponent severityLevelChooserComponent = severityLevelChooser.createCustomComponent(severityLevelChooser.getTemplatePresentation(), "unknown");
                severityPanel.add((Component)severityLevelChooserComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 1, (Insets)JBInsets.create((int)10, (int)0), 0, 0));
                severityLevelChooserComponent.getInputMap(2).put(KeyStroke.getKeyStroke(86, MnemonicHelper.getFocusAcceleratorKeyMask()), "changeSeverity");
                severityLevelChooserComponent.getActionMap().put("changeSeverity", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JPanel panel2 = (JPanel)severityLevelChooserComponent;
                        ComboBoxAction.ComboBoxButton button4 = (ComboBoxAction.ComboBoxButton)panel2.getComponent(0);
                        button4.showPopup();
                    }
                });
                JComponent scopesChooserComponent = scopesChooser.createCustomComponent(scopesChooser.getTemplatePresentation(), "unknown");
                severityPanel.add((Component)scopesChooserComponent, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 1, (Insets)JBInsets.create((int)10, (int)0), 0, 0));
                JLabel label2 = new JLabel("", 4);
                severityPanel.add((Component)label2, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 1, (Insets)JBInsets.create((int)2, (int)0), 0, 0));
                severityPanelWeightY = 0.0;
                if (toolState != null) {
                    if (!showDefaultConfigurationOptions) {
                        severityLabel.setVisible(false);
                        severityLevelChooserComponent.setVisible(false);
                        scopesChooserComponent.setVisible(false);
                        label2.setVisible(false);
                    }
                    this.setConfigPanel(configPanelAnchor, toolState);
                    this.myOptionsLabel.setText(AnalysisBundle.message((String)"inspections.settings.options.title", (Object[])new Object[0]));
                }
                scopesAndScopesAndSeveritiesTable = null;
            } else {
                if (singleNode != null) {
                    for (Descriptor descriptor3 : singleNode.getDescriptors().getNonDefaultDescriptors()) {
                        descriptor3.loadConfig();
                    }
                }
                ScopesAndSeveritiesTable.TableSettings tableSettings = new ScopesAndSeveritiesTable.TableSettings(nodes, this.myProfile, project){

                    @Override
                    protected void onScopeChosen(@NotNull ScopeToolState state) {
                        if (state == null) {
                            12.$$$reportNull$$$0(0);
                        }
                        SingleInspectionProfilePanel.this.setConfigPanel(configPanelAnchor, state);
                        configPanelAnchor.revalidate();
                        configPanelAnchor.repaint();
                    }

                    @Override
                    protected void onSettingsChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, false);
                    }

                    @Override
                    protected void onScopeAdded() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, false);
                    }

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopeRemoved(int scopesCount) {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, scopesCount == 1);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$12", "onScopeChosen"));
                    }
                };
                scopesAndScopesAndSeveritiesTable = new ScopesAndSeveritiesTable(tableSettings);
                ToolbarDecorator wrappedTable = ToolbarDecorator.createDecorator((JTable)((Object)scopesAndScopesAndSeveritiesTable)).disableUpDownActions().setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setRemoveActionUpdater(__ -> {
                    int selectedRow = scopesAndScopesAndSeveritiesTable.getSelectedRow();
                    int rowCount = scopesAndScopesAndSeveritiesTable.getRowCount();
                    return rowCount - 1 != selectedRow;
                }).addExtraAction(new AnActionButton(IdeBundle.messagePointer((String)"action.Anonymous.text.edit.scopes.order", (Object[])new Object[0]), AllIcons.General.GearPlain, tableSettings){
                    final /* synthetic */ 12 val$tableSettings;
                    {
                        this.val$tableSettings = var6_6;
                        super(arg0, arg1);
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        ScopesOrderDialog dlg;
                        if (e == null) {
                            13.$$$reportNull$$$0(0);
                        }
                        if ((dlg = new ScopesOrderDialog((Component)((Object)scopesAndScopesAndSeveritiesTable), SingleInspectionProfilePanel.this.myProfile, project)).showAndGet()) {
                            this.val$tableSettings.onScopesOrderChanged();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$13", "actionPerformed"));
                    }
                });
                JPanel panel2 = wrappedTable.createPanel();
                panel2.setMinimumSize(new Dimension(this.getMinimumSize().width, 3 * scopesAndScopesAndSeveritiesTable.getRowHeight()));
                severityPanel = UI.PanelFactory.panel((JComponent)panel2).withLabel(InspectionsBundle.message((String)"inspection.scopes.and.severities", (Object[])new Object[0])).moveLabelOnTop().resizeY(true).createPanel();
                severityPanelWeightY = 0.3;
            }
            this.myOptionsPanel.add((Component)severityPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, severityPanelWeightY, 17, 1, (Insets)JBUI.insetsTop((int)20), 0, 0));
            GuiUtils.enableChildren((Component)this.myOptionsPanel, (boolean)this.isThoughOneNodeEnabled(nodes), (JComponent[])new JComponent[0]);
            if (configPanelAnchor.getComponentCount() != 0) {
                if (showDefaultConfigurationOptions) {
                    this.myOptionsPanel.add((Component)new ToolOptionsSeparator(configPanelAnchor, scopesAndScopesAndSeveritiesTable), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
                }
                this.myOptionsPanel.add((Component)configPanelAnchor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.emptyInsets(), 0, 0));
            } else if (scopesNames.isEmpty()) {
                this.myOptionsPanel.add((Component)configPanelAnchor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.emptyInsets(), 0, 0));
            }
            this.myOptionsPanel.revalidate();
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.myOptionsPanel.repaint();
    }

    private void updateRecursively(Collection<? extends InspectionConfigTreeNode> nodes, boolean updateOptionsAndDescriptionPanel) {
        InspectionConfigTreeNode.updateUpHierarchy(nodes);
        this.myTreeTable.repaint();
        if (updateOptionsAndDescriptionPanel) {
            this.updateOptionsAndDescriptionPanel();
        }
    }

    private boolean isThoughOneNodeEnabled(Collection<InspectionConfigTreeNode.Tool> nodes) {
        Project project = this.getProject();
        for (InspectionConfigTreeNode.Tool node : nodes) {
            String toolId = node.getKey().toString();
            if (!this.myProfile.getTools(toolId, project).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void initOptionsAndDescriptionPanel() {
        this.myOptionsPanel.removeAll();
        DescriptionEditorPaneKt.readHTML(this.myDescription, "<html><body></body></html>");
        this.myOptionsPanel.validate();
        this.myOptionsPanel.repaint();
    }

    @NotNull
    public InspectionProfileModifiableModel getProfile() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = this.myProfile;
        if (inspectionProfileModifiableModel == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(5);
        }
        return inspectionProfileModifiableModel;
    }

    public InspectionToolWrapper<?, ?> getSelectedTool() {
        InspectionConfigTreeNode.Tool node = this.myTreeTable.getStrictlySelectedToolNode();
        if (node == null) {
            return null;
        }
        return node.getDefaultDescriptor().getToolWrapper();
    }

    public void removeSelectedRow() {
        InspectionConfigTreeNode.Tool node = this.myTreeTable.getStrictlySelectedToolNode();
        if (node != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            TreePath path2 = this.myTreeTable.getTree().getSelectionPath();
            assert (path2 != null);
            TreePath newPath = path2.getParentPath().pathByAddingChild(node.getPreviousNode());
            this.myTreeTable.removeSelectedPath(path2);
            this.myTreeTable.addSelectedPath(newPath);
            this.restoreTreeState();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    public void disposeUI() {
        if (this.myInspectionProfilePanel == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myProfileFilter.dispose();
        for (ScopeToolState state : this.myProfile.getAllTools()) {
            state.resetConfigPanel();
        }
        Disposer.dispose((Disposable)this.myDisposable);
        this.myDisposable = null;
    }

    public static HyperlinkAdapter createSettingsHyperlinkListener(final Project project) {
        return new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                try {
                    URI url = new URI(e.getDescription());
                    if (url.getScheme().equals("settings")) {
                        DataContext context2 = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult();
                        if (context2 != null) {
                            Settings settings2 = Settings.KEY.getData(context2);
                            SearchTextField searchTextField2 = (SearchTextField)SearchTextField.KEY.getData(context2);
                            String configId = url.getHost();
                            String search2 = url.getQuery();
                            if (settings2 != null) {
                                Configurable configurable2 = settings2.find(configId);
                                settings2.select(configurable2).doWhenDone(() -> {
                                    if (searchTextField2 != null && search2 != null) {
                                        searchTextField2.setText(search2);
                                    }
                                });
                            } else {
                                ShowSettingsUtilImpl.showSettingsDialog(project, configId, search2);
                            }
                        }
                    } else {
                        BrowserUtil.browse((URI)url);
                    }
                }
                catch (URISyntaxException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        };
    }

    private JPanel createInspectionProfileSettingsPanel() {
        this.myDescription = new DescriptionEditorPane();
        this.myDescription.addHyperlinkListener((HyperlinkListener)SingleInspectionProfilePanel.createSettingsHyperlinkListener(this.getProject()));
        this.initToolStates();
        this.fillTreeData(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null, true);
        JBSplitter rightSplitter = new JBSplitter(true, "SingleInspectionProfilePanel.HORIZONTAL_DIVIDER_PROPORTION", 0.5f);
        JBScrollPane descriptionPanel = new JBScrollPane((Component)this.myDescription);
        descriptionPanel.setBorder((Border)JBUI.Borders.empty());
        rightSplitter.setFirstComponent((JComponent)descriptionPanel);
        this.myOptionsPanel = new JPanel(new GridBagLayout());
        this.initOptionsAndDescriptionPanel();
        rightSplitter.setSecondComponent((JComponent)this.myOptionsPanel);
        rightSplitter.setHonorComponentsMinimumSize(true);
        JScrollPane tree = this.initTreeScrollPane();
        JPanel northPanel = new JPanel(new GridBagLayout());
        northPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        this.myProfileFilter.setPreferredSize(new Dimension(20, this.myProfileFilter.getPreferredSize().height));
        northPanel.add((Component)this.myProfileFilter, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 768, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        northPanel.add((Component)this.createTreeToolbarPanel().getComponent(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 512, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        JBSplitter mainSplitter = new JBSplitter(false, 0.5f, 0.01f, 0.99f);
        mainSplitter.setSplitterProportionKey("SingleInspectionProfilePanel.VERTICAL_DIVIDER_PROPORTION");
        mainSplitter.setFirstComponent((JComponent)tree);
        mainSplitter.setSecondComponent((JComponent)rightSplitter);
        mainSplitter.setHonorComponentsMinimumSize(false);
        mainSplitter.setDividerWidth(20);
        JPanel inspectionTreePanel = new JPanel(new BorderLayout());
        inspectionTreePanel.add((Component)northPanel, "North");
        inspectionTreePanel.add((Component)mainSplitter, "Center");
        JBCheckBox disableNewInspectionsCheckBox = new JBCheckBox(AnalysisBundle.message((String)"inspections.settings.disable.new.inspections.by.default.checkbox", (Object[])new Object[0]), this.getProfile().isProfileLocked());
        JPanel panel2 = new JPanel(new BorderLayout(10, 12));
        panel2.add((Component)inspectionTreePanel, "Center");
        panel2.add((Component)disableNewInspectionsCheckBox, "South");
        disableNewInspectionsCheckBox.addItemListener(__ -> {
            boolean enabled = disableNewInspectionsCheckBox.isSelected();
            if (!this.isDisposed()) {
                InspectionProfileModifiableModel profile = this.getProfile();
                profile.lockProfile(enabled);
            }
        });
        return panel2;
    }

    public boolean isModified() {
        if (this.myTreeTable == null) {
            return false;
        }
        if (this.myModified) {
            return true;
        }
        if (this.myProfile.isChanged()) {
            return true;
        }
        if (this.myProfile.getSource().isProjectLevel() != this.myProfile.isProjectLevel()) {
            return true;
        }
        if (!Comparing.strEqual((String)this.myProfile.getSource().getName(), (String)this.myProfile.getName())) {
            return true;
        }
        if (!this.myInitialScopesOrder.equals(this.myProfile.getScopesOrder())) {
            return true;
        }
        return this.descriptorsAreChanged();
    }

    public void reset() {
        this.myModified = false;
        this.filterTree();
        String filter = this.myProfileFilter.getFilter();
        this.myProfileFilter.reset();
        this.myProfileFilter.setSelectedItem(filter);
        this.myProfile.setName(this.myProfile.getSource().getName());
        this.myProfile.setProjectLevel(this.myProfile.getSource().isProjectLevel());
    }

    public void apply() {
        boolean modified = this.isModified();
        if (!modified) {
            return;
        }
        InspectionProfileModifiableModel selectedProfile = this.myProfile;
        BaseInspectionProfileManager profileManager = selectedProfile.isProjectLevel() ? this.myProjectProfileManager : (BaseInspectionProfileManager)InspectionProfileManager.getInstance();
        InspectionProfileImpl source = selectedProfile.getSource();
        if (source.getProfileManager() != profileManager) {
            source.getProfileManager().deleteProfile(source);
        }
        if (selectedProfile.getProfileManager() != profileManager) {
            SingleInspectionProfilePanel.copyUsedSeveritiesIfUndefined(selectedProfile, profileManager);
            selectedProfile.setProfileManager(profileManager);
        }
        selectedProfile.commit();
        profileManager.addProfile(source);
        profileManager.fireProfileChanged(source);
        this.myModified = false;
        this.myRoot.dropCache();
        this.initToolStates();
        this.updateOptionsAndDescriptionPanel();
    }

    private boolean descriptorsAreChanged() {
        return ContainerUtil.exists(this.myInitialToolDescriptors.values(), toolDescriptors -> SingleInspectionProfilePanel.areToolDescriptorsChanged(this.getProject(), this.myProfile, toolDescriptors));
    }

    public static boolean areToolDescriptorsChanged(@NotNull Project project, @NotNull InspectionProfileModifiableModel profile, @NotNull ToolDescriptors toolDescriptors) {
        Descriptor desc;
        if (project == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(6);
        }
        if (profile == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(7);
        }
        if (toolDescriptors == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(8);
        }
        if (profile.isToolEnabled((desc = toolDescriptors.getDefaultDescriptor()).getKey(), null, project) != desc.isEnabled()) {
            return true;
        }
        if (profile.getErrorLevel(desc.getKey(), desc.getScope(), project) != desc.getLevel()) {
            return true;
        }
        List<Descriptor> descriptors2 = toolDescriptors.getNonDefaultDescriptors();
        for (Descriptor descriptor2 : descriptors2) {
            if (profile.isToolEnabled(descriptor2.getKey(), descriptor2.getScope(), project) != descriptor2.isEnabled()) {
                return true;
            }
            if (profile.getErrorLevel(descriptor2.getKey(), descriptor2.getScope(), project) == descriptor2.getLevel()) continue;
            return true;
        }
        List<ScopeToolState> tools = profile.getNonDefaultTools(desc.getKey().toString(), project);
        if (tools.size() != descriptors2.size()) {
            return true;
        }
        for (int i2 = 0; i2 < tools.size(); ++i2) {
            ScopeToolState pair = tools.get(i2);
            if (Comparing.equal((Object)pair.getScope(project), (Object)descriptors2.get(i2).getScope())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && this.myInspectionProfilePanel == null) {
            this.myProfile.initInspectionTools(this.myProjectProfileManager.getProject());
            this.initUI();
        }
        super.setVisible(aFlag);
    }

    private void setNewHighlightingLevel(@NotNull HighlightDisplayLevel level) {
        Collection<InspectionConfigTreeNode.Tool> tools;
        if (level == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(9);
        }
        if (!(tools = this.myTreeTable.getSelectedToolNodes()).isEmpty()) {
            for (InspectionConfigTreeNode.Tool tool : tools) {
                this.updateErrorLevel(tool, level);
            }
            this.updateOptionsAndDescriptionPanel();
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.repaintTableData();
    }

    private void updateErrorLevel(InspectionConfigTreeNode.Tool child2, @NotNull HighlightDisplayLevel level) {
        if (level == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(10);
        }
        HighlightDisplayKey key = child2.getKey();
        this.myProfile.setErrorLevel(key, level, null, this.getProject());
        child2.dropCache();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeTable;
    }

    private void updateEmptyText() {
        StatusText emptyText = this.myTreeTable.getEmptyText();
        emptyText.setText(AnalysisBundle.message((String)"inspections.settings.empty.text", (Object[])new Object[0]));
        if (!this.myInspectionsFilter.isEmptyFilter()) {
            emptyText.appendLine(AnalysisBundle.message((String)"inspections.settings.empty.text.filters.link", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.myInspectionsFilter.reset());
        } else if (this.myCreateInspectionActions.getChildrenCount() > 0) {
            emptyText.appendSecondaryText(AnalysisBundle.message((String)"inspections.settings.empty.text.inspection.link", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> JBPopupFactory.getInstance().createActionGroupPopup(AnalysisBundle.message((String)"inspections.settings.popup.title.create.inspection", (Object[])new Object[0]), (ActionGroup)this.myCreateInspectionActions, DataManager.getInstance().getDataContext((Component)this.myInspectionProfilePanel), null, true).show(new RelativePoint((Component)((Object)this.myTreeTable), this.myTreeTable.getEmptyText().getPointBelow())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolDescriptors";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findGroupNodeByPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areToolDescriptorsChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setNewHighlightingLevel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToolOptionsSeparator
    extends JPanel {
        private final ActionLink myResetLink;
        @Nullable
        private final ScopesAndSeveritiesTable myScopesAndSeveritiesTable;

        ToolOptionsSeparator(@Nullable JComponent options2, ScopesAndSeveritiesTable scopesAndSeveritiesTable) {
            this.myScopesAndSeveritiesTable = scopesAndSeveritiesTable;
            this.setLayout(new GridBagLayout());
            this.setBorder((Border)JBUI.Borders.emptyTop((int)20));
            GridBagConstraints optionsLabelConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0);
            this.add((Component)SingleInspectionProfilePanel.this.myOptionsLabel, optionsLabelConstraints);
            GridBagConstraints separatorConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, (Insets)JBUI.insets((int)2, (int)6, (int)0, (int)0), 0, 0);
            this.add((Component)new JSeparator(0), separatorConstraints);
            GridBagConstraints resetLabelConstraints = new GridBagConstraints(2, 0, 0, 1, 0.0, 1.0, 13, 0, (Insets)JBUI.insets((int)0, (int)6, (int)0, (int)0), 0, 0);
            UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
            userActivityWatcher.addUserActivityListener(() -> this.setupResetLinkVisibility());
            userActivityWatcher.register((Component)options2);
            this.myResetLink = new ActionLink(IdeBundle.message((String)"reset.action.text", (Object[])new Object[0]), e -> {
                ScopeToolState state = this.getSelectedState();
                if (state != null) {
                    state.resetConfigPanel();
                    Project project = SingleInspectionProfilePanel.this.getProject();
                    SingleInspectionProfilePanel.this.myProfile.resetToBase(state.getTool().getTool().getShortName(), state.getScope(project), project);
                    SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
                }
            });
            this.add((Component)this.myResetLink, resetLabelConstraints);
            this.setupResetLinkVisibility();
        }

        private void setupResetLinkVisibility() {
            if (SingleInspectionProfilePanel.this.myTreeTable == null || SingleInspectionProfilePanel.this.isDisposed()) {
                return;
            }
            InspectionConfigTreeNode.Tool node = SingleInspectionProfilePanel.this.myTreeTable.getStrictlySelectedToolNode();
            if (node != null) {
                ScopeToolState state = this.getSelectedState();
                if (state == null) {
                    return;
                }
                Project project = SingleInspectionProfilePanel.this.getProject();
                NamedScope scope2 = state.getScope(project);
                if (scope2 == null) {
                    return;
                }
                boolean canReset = !SingleInspectionProfilePanel.this.myProfile.isProperSetting(state.getTool().getTool().getShortName(), scope2, project);
                this.myResetLink.setVisible(canReset);
                this.revalidate();
                this.repaint();
            }
        }

        private ScopeToolState getSelectedState() {
            InspectionConfigTreeNode.Tool node = SingleInspectionProfilePanel.this.myTreeTable.getStrictlySelectedToolNode();
            if (node == null) {
                return null;
            }
            if (this.myScopesAndSeveritiesTable != null) {
                List<ScopeToolState> selectedStates = this.myScopesAndSeveritiesTable.getSelectedStates();
                LOG.assertTrue(selectedStates.size() == 1);
                return selectedStates.get(0);
            }
            return node.getDescriptors().getDefaultDescriptor().getState();
        }
    }

    private final class MyFilterComponent
    extends FilterComponent {
        private MyFilterComponent() {
            super(SingleInspectionProfilePanel.INSPECTION_FILTER_HISTORY, 10);
        }

        public void filter() {
            SingleInspectionProfilePanel.this.filterTree();
        }

        protected void onlineFilter() {
            if (SingleInspectionProfilePanel.this.isDisposed()) {
                return;
            }
            String filter = this.getFilter();
            SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            SingleInspectionProfilePanel.this.fillTreeData(filter, true);
            SingleInspectionProfilePanel.this.reloadModel();
            if (filter == null || filter.isEmpty()) {
                SingleInspectionProfilePanel.this.restoreTreeState();
            } else {
                TreeUtil.expandAll((JTree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }
        }
    }
}

