/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.presentation.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.presentation.FilePresentationService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/presentation/impl/FilePresentationServiceImpl;", "Lcom/intellij/presentation/FilePresentationService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getFileBackgroundColor", "Ljava/awt/Color;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.platform.ide.impl"})
public final class FilePresentationServiceImpl
implements FilePresentationService {
    private final Project project;

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public Color getFileBackgroundColor(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean bl = file2.isValid();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return VfsPresentationUtil.getFileBackgroundColor(this.project, file2);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    @Nullable
    public Color getFileBackgroundColor(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiUtilCore.ensureValid((PsiElement)element2);
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element2);
        if (file2 != null) {
            return this.getFileBackgroundColor(file2);
        }
        if (element2 instanceof PsiDirectory) {
            VirtualFile virtualFile2 = ((PsiDirectory)element2).getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"element.virtualFile");
            return this.getFileBackgroundColor(virtualFile2);
        }
        if (element2 instanceof PsiDirectoryContainer) {
            Color result2 = null;
            PsiDirectory[] psiDirectoryArray = ((PsiDirectoryContainer)element2).getDirectories();
            int n = psiDirectoryArray.length;
            for (int j = 0; j < n; ++j) {
                Color color;
                PsiDirectory dir;
                PsiDirectory psiDirectory = dir = psiDirectoryArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"dir");
                VirtualFile virtualFile3 = psiDirectory.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"dir.virtualFile");
                if (this.getFileBackgroundColor(virtualFile3) == null) {
                    continue;
                }
                if (result2 == null) {
                    result2 = color;
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)result2, (Object)color) ^ true)) continue;
                return null;
            }
            return result2;
        }
        return null;
    }

    public FilePresentationServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

