/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGeneratorBase;
import com.intellij.platform.templates.LocalArchivedTemplate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateProjectDirectoryGenerator<T>
extends DirectoryProjectGeneratorBase<T> {
    private final LocalArchivedTemplate myTemplate;
    private final ModuleBuilder myModuleBuilder;

    public TemplateProjectDirectoryGenerator(@NotNull LocalArchivedTemplate template) {
        if (template == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(0);
        }
        this.myTemplate = template;
        this.myModuleBuilder = this.myTemplate.createModuleBuilder();
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        String string = this.myTemplate.getName();
        if (string == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public Icon getLogo() {
        return this.myTemplate.getIcon();
    }

    @Override
    public void generateProject(@NotNull Project newProject, @NotNull VirtualFile baseDir, @NotNull T settings2, @NotNull Module module) {
        if (newProject == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(3);
        }
        if (settings2 == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(5);
        }
        throw new IllegalStateException("Isn't supposed to be invoked, use generateProject(String, String) instead.");
    }

    public void generateProject(String name, String path2) {
        try {
            this.myModuleBuilder.createProject(name, path2);
        }
        finally {
            this.myModuleBuilder.cleanup();
        }
    }

    @Override
    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(6);
        }
        String message2 = LangBundle.message((String)"dialog.message.invalid.settings", (Object[])new Object[0]);
        for (WizardInputField<?> field : this.myTemplate.getInputFields()) {
            try {
                if (field.validate()) {
                    continue;
                }
            }
            catch (ConfigurationException e) {
                message2 = e.getMessage();
            }
            return new ValidationResult(message2);
        }
        ValidationResult result2 = this.myTemplate.validate(baseDirPath);
        if (result2 != null) {
            ValidationResult validationResult = result2;
            if (validationResult == null) {
                TemplateProjectDirectoryGenerator.$$$reportNull$$$0(7);
            }
            return validationResult;
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(8);
        }
        return validationResult;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            TemplateProjectDirectoryGenerator.$$$reportNull$$$0(9);
        }
        for (WizardInputField<?> field : this.myTemplate.getInputFields()) {
            field.addToSettings(settingsStep);
        }
        if (this.myTemplate.getInputFields().isEmpty()) {
            settingsStep.addSettingsComponent((JComponent)new JLabel());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/TemplateProjectDirectoryGenerator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/TemplateProjectDirectoryGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildUI";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

