/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.util.Comparing;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeExpansionMonitor<T> {
    private final Set<TreePath> myExpandedPaths = new HashSet<TreePath>();
    private List<T> mySelectionNodes = new ArrayList<T>();
    private final JTree myTree;
    private boolean myFrozen = false;

    public static TreeExpansionMonitor<DefaultMutableTreeNode> install(JTree tree) {
        return TreeExpansionMonitor.install(tree, (o1, o2) -> Comparing.equal((Object)o1.getUserObject(), (Object)o2.getUserObject()));
    }

    public static TreeExpansionMonitor<DefaultMutableTreeNode> install(final JTree tree, final BiPredicate<? super DefaultMutableTreeNode, ? super DefaultMutableTreeNode> equality) {
        return new TreeExpansionMonitor<DefaultMutableTreeNode>(tree){

            @Override
            protected TreePath findPathByNode(DefaultMutableTreeNode node) {
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode child2;
                    TreeNode nextElement = enumeration.nextElement();
                    if (!(nextElement instanceof DefaultMutableTreeNode) || !equality.test(child2 = (DefaultMutableTreeNode)nextElement, node)) continue;
                    return new TreePath(child2.getPath());
                }
                return null;
            }
        };
    }

    protected TreeExpansionMonitor(JTree tree) {
        this.myTree = tree;
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreeExpansionMonitor.this.mySelectionNodes = new ArrayList();
                TreePath[] paths = TreeExpansionMonitor.this.myTree.getSelectionPaths();
                if (paths != null) {
                    for (TreePath path2 : paths) {
                        TreeExpansionMonitor.this.mySelectionNodes.add(path2.getLastPathComponent());
                    }
                }
            }
        });
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreePath path2 = event.getPath();
                if (path2 != null) {
                    TreeExpansionMonitor.this.myExpandedPaths.add(path2);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreePath path2 = event.getPath();
                if (path2 != null) {
                    TreePath[] allPaths;
                    for (TreePath treePath : allPaths = TreePathUtil.toTreePathArray(TreeExpansionMonitor.this.myExpandedPaths)) {
                        if (!treePath.equals(path2) && !path2.isDescendant(treePath)) continue;
                        TreeExpansionMonitor.this.myExpandedPaths.remove(treePath);
                    }
                }
            }
        });
    }

    public void freeze() {
        this.myFrozen = true;
    }

    public void unfreeze() {
        this.myFrozen = false;
    }

    public void restore() {
        this.freeze();
        for (TreePath myExpandedPath : this.myExpandedPaths) {
            this.myTree.expandPath(this.findPathByNode(myExpandedPath.getLastPathComponent()));
        }
        for (TreePath mySelectionNode : this.mySelectionNodes) {
            this.myTree.getSelectionModel().addSelectionPath(this.findPathByNode(mySelectionNode));
        }
        int selected2 = this.myTree.getLeadSelectionRow();
        if (selected2 != -1) {
            TreeUtil.showRowCentered((JTree)this.myTree, (int)selected2, (boolean)false);
        }
        this.myFrozen = false;
    }

    protected abstract TreePath findPathByNode(T var1);

    public boolean isFreeze() {
        return this.myFrozen;
    }
}

