/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEditServiceListener;
import com.intellij.ide.plugins.PluginDropHandler;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.idea.SplashManager;
import com.intellij.jdkEx.JdkEx;
import com.intellij.notification.NotificationsManager;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameDialogContent;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.DefaultFrameHeader;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionGroupPanelWrapper;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.TabbedWelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenActionsUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentFactory;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenFocusManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Path;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.miginfocom.swing.MigLayout;
import org.jdom.internal.SystemProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlatWelcomeFrame
extends JFrame
implements IdeFrame,
Disposable,
AccessibleContextAccessor {
    public static boolean USE_TABBED_WELCOME_SCREEN = Boolean.parseBoolean(SystemProperty.get((String)"use.tabbed.welcome.screen", (String)"true"));
    public static final String BOTTOM_PANEL = "BOTTOM_PANEL";
    public static final int DEFAULT_HEIGHT = USE_TABBED_WELCOME_SCREEN ? 600 : 460;
    public static final int MAX_DEFAULT_WIDTH = 800;
    private AbstractWelcomeScreen myScreen;
    private WelcomeBalloonLayoutImpl myBalloonLayout;
    private boolean myDisposed;

    public FlatWelcomeFrame() {
        SplashManager.hideBeforeShow(this);
        final JRootPane rootPane = this.getRootPane();
        this.myBalloonLayout = new WelcomeBalloonLayoutImpl(rootPane, (Insets)JBUI.insets((int)8));
        this.myScreen = USE_TABBED_WELCOME_SCREEN ? new TabbedWelcomeScreen() : new FlatWelcomeScreen();
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane){

            @Override
            public void addNotify() {
                super.addNotify();
                ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
            }
        };
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.updateComponentsAndResize();
        this.setAutoRequestFocus(false);
        UiNotifyConnector.doWhenFirstShown((Component)this, this::pack);
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)FlatWelcomeFrame.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$2", "projectOpened"));
            }
        });
        connection.subscribe(LightEditServiceListener.TOPIC, (Object)new LightEditServiceListener(){

            public void lightEditWindowOpened(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)FlatWelcomeFrame.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$3", "lightEditWindowOpened"));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                FlatWelcomeFrame.saveSizeAndLocation(FlatWelcomeFrame.this.getBounds());
            }
        });
        connection.subscribe(LafManagerListener.TOPIC, (Object)new LafManagerListener(){

            public void lookAndFeelChanged(@NotNull LafManager source) {
                if (source == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (FlatWelcomeFrame.this.myScreen != null) {
                    Disposer.dispose((Disposable)FlatWelcomeFrame.this.myScreen);
                }
                if (FlatWelcomeFrame.this.myBalloonLayout != null) {
                    Disposer.dispose((Disposable)FlatWelcomeFrame.this.myBalloonLayout);
                }
                FlatWelcomeFrame.this.myBalloonLayout = new WelcomeBalloonLayoutImpl(rootPane, (Insets)JBUI.insets((int)8));
                if (USE_TABBED_WELCOME_SCREEN) {
                    int selectedIndex = ((TabbedWelcomeScreen)FlatWelcomeFrame.this.myScreen).getSelectedIndex();
                    FlatWelcomeFrame.this.myScreen = new TabbedWelcomeScreen();
                    ((TabbedWelcomeScreen)FlatWelcomeFrame.this.myScreen).setSelectedIndex(selectedIndex);
                } else {
                    FlatWelcomeFrame.this.myScreen = new FlatWelcomeScreen();
                }
                FlatWelcomeFrame.this.updateComponentsAndResize();
                FlatWelcomeFrame.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$5", "lookAndFeelChanged"));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (WindowStateService.getInstance().getSize("WELCOME_SCREEN") != null) {
                    FlatWelcomeFrame.saveSizeAndLocation(FlatWelcomeFrame.this.getBounds());
                }
            }
        });
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        Disposer.register((Disposable)app, (Disposable)this);
        UIUtil.decorateWindowHeader((JRootPane)this.getRootPane());
        UIUtil.setCustomTitleBar((Window)this, (JRootPane)this.getRootPane(), runnable2 -> Disposer.register((Disposable)this, () -> runnable2.run()));
        app.invokeLater(() -> ((NotificationsManagerImpl)NotificationsManager.getNotificationsManager()).dispatchEarlyNotifications(), ModalityState.NON_MODAL);
    }

    private void updateComponentsAndResize() {
        int defaultHeight = DEFAULT_HEIGHT;
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            Color backgroundColor = UIManager.getColor("WelcomeScreen.background");
            DefaultFrameHeader header2 = new DefaultFrameHeader(this);
            if (backgroundColor != null) {
                header2.setBackground(backgroundColor);
            }
            JComponent holder = CustomFrameDialogContent.getCustomContentHolder(this, this.myScreen.getWelcomePanel(), header2);
            this.setContentPane(holder);
        } else {
            if (USE_TABBED_WELCOME_SCREEN && SystemInfoRt.isMac) {
                this.rootPane.setJMenuBar(new WelcomeFrameMenuBar());
            }
            this.setContentPane(this.myScreen.getWelcomePanel());
        }
        if (USE_TABBED_WELCOME_SCREEN) {
            JBDimension defaultSize = JBUI.size((int)800, (int)defaultHeight);
            this.setPreferredSize((Dimension)ObjectUtils.chooseNotNull((Object)WindowStateService.getInstance().getSize("WELCOME_SCREEN"), (Object)defaultSize));
            this.setMinimumSize((Dimension)defaultSize);
        } else {
            int width = RecentProjectListActionProvider.getInstance().getActions(false).size() == 0 ? 666 : 800;
            this.setPreferredSize((Dimension)JBUI.size((int)width, (int)defaultHeight));
        }
        this.setResizable(USE_TABBED_WELCOME_SCREEN);
        Dimension size = this.getPreferredSize();
        Point location = WindowStateService.getInstance().getLocation("WELCOME_SCREEN");
        Rectangle screenBounds = ScreenUtil.getScreenRectangle((Point)(location != null ? location : new Point(0, 0)));
        this.setBounds(screenBounds.x + (screenBounds.width - size.width) / 2, screenBounds.y + (screenBounds.height - size.height) / 3, size.width, size.height);
        UIUtil.decorateWindowHeader((JRootPane)this.getRootPane());
        this.setTitle("");
        this.setTitle(this.getWelcomeFrameTitle());
        AppUIUtil.updateWindowIcon(this);
    }

    @Override
    public void addNotify() {
        if (IdeFrameDecorator.isCustomDecorationActive()) {
            JdkEx.setHasCustomDecoration(this);
        }
        super.addNotify();
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        super.dispose();
        if (this.myBalloonLayout != null) {
            Disposer.dispose((Disposable)this.myBalloonLayout);
            this.myBalloonLayout = null;
        }
        Disposer.dispose((Disposable)this.myScreen);
        WelcomeFrame.resetInstance();
    }

    private static void saveSizeAndLocation(@NotNull Rectangle location) {
        if (location == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(0);
        }
        Point middle2 = new Point(location.x + location.width / 2, location.y + location.height / 2);
        WindowStateService.getInstance().putLocation("WELCOME_SCREEN", middle2);
        WindowStateService.getInstance().putSize("WELCOME_SCREEN", location.getSize());
    }

    @Nullable
    public StatusBar getStatusBar() {
        return null;
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    protected String getWelcomeFrameTitle() {
        return WelcomeScreenComponentFactory.getApplicationTitle();
    }

    @NotNull
    public static JComponent getPreferredFocusedComponent(@NotNull Pair<JPanel, JBList<AnAction>> pair) {
        JBTextField textField2;
        if (pair == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(1);
        }
        if (((JBList)pair.second).getModel().getSize() == 1 && (textField2 = (JBTextField)UIUtil.uiTraverser((Component)((Component)pair.first)).filter(JBTextField.class).first()) != null) {
            JBTextField jBTextField = textField2;
            if (jBTextField == null) {
                FlatWelcomeFrame.$$$reportNull$$$0(2);
            }
            return jBTextField;
        }
        JComponent jComponent = (JComponent)pair.second;
        if (jComponent == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    protected void extendActionsGroup(JPanel panel2) {
    }

    protected void onFirstActionShown(@NotNull Component action2) {
        if (action2 == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(4);
        }
    }

    @Nullable
    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    @NotNull
    public Rectangle suggestChildFrameBounds() {
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(5);
        }
        return rectangle;
    }

    @Nullable
    public Project getProject() {
        return ApplicationManager.getApplication().isDisposed() ? null : ProjectManager.getInstance().getDefaultProject();
    }

    public void setFrameTitle(String title2) {
        this.setTitle(title2);
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestChildFrameBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveSizeAndLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredFocusedComponent";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onFirstActionShown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WelcomeFrameMenuBar
    extends IdeMenuBar {
        private WelcomeFrameMenuBar() {
        }

        @Override
        @NotNull
        public ActionGroup getMainMenuActionGroup() {
            ActionManager manager2 = ActionManager.getInstance();
            return new DefaultActionGroup(new AnAction[]{manager2.getAction("FileMenu"), manager2.getAction("HelpMenu")});
        }
    }

    private final class FlatWelcomeScreen
    extends AbstractWelcomeScreen {
        private final DefaultActionGroup myTouchbarActions = new DefaultActionGroup();
        private boolean inDnd;

        FlatWelcomeScreen() {
            this.setBackground(WelcomeScreenUIManager.getMainBackground());
            if (RecentProjectListActionProvider.getInstance().getActions(false, true).size() > 0) {
                final JComponent recentProjects = WelcomeScreenComponentFactory.createRecentProjects((Disposable)this);
                this.add((Component)recentProjects, "West");
                final JList projectsList = (JList)UIUtil.findComponentOfType((JComponent)recentProjects, JList.class);
                if (projectsList != null) {
                    projectsList.getModel().addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            this.removeIfNeeded();
                        }

                        private void removeIfNeeded() {
                            if (RecentProjectListActionProvider.getInstance().getActions(false, true).size() == 0) {
                                FlatWelcomeScreen.this.remove(recentProjects);
                                FlatWelcomeScreen.this.revalidate();
                                FlatWelcomeScreen.this.repaint();
                            }
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            this.removeIfNeeded();
                        }
                    });
                    projectsList.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            projectsList.repaint();
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            projectsList.repaint();
                        }
                    });
                }
            }
            this.add((Component)this.createBody(), "Center");
            this.setDropTarget(new DropTarget(this, new DropTargetAdapter(){

                @Override
                public void dragEnter(DropTargetDragEvent e) {
                    this.setDnd(true);
                }

                @Override
                public void dragExit(DropTargetEvent e) {
                    this.setDnd(false);
                }

                @Override
                public void drop(DropTargetDropEvent e) {
                    this.setDnd(false);
                    e.acceptDrop(3);
                    Transferable transferable = e.getTransferable();
                    List<Path> list2 = FileCopyPasteUtil.getFiles(transferable);
                    if (list2 != null && list2.size() > 0) {
                        PluginDropHandler pluginHandler = new PluginDropHandler();
                        if (!pluginHandler.canHandle(transferable, null) || !pluginHandler.handleDrop(transferable, null, null)) {
                            ProjectUtil.tryOpenFiles(null, list2, "WelcomeFrame");
                        }
                        e.dropComplete(true);
                        return;
                    }
                    e.dropComplete(false);
                }

                private void setDnd(boolean dnd) {
                    FlatWelcomeScreen.this.inDnd = dnd;
                    FlatWelcomeScreen.this.repaint();
                }
            }));
            TouchbarDataKeys.putActionDescriptor((AnAction)this.myTouchbarActions).setShowText(true);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.inDnd) {
                Rectangle bounds2 = this.getBounds();
                g.setColor((Color)JBColor.namedColor((String)"DragAndDrop.areaBackground", (int)4029900, (int)4213335));
                g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                JBColor backgroundBorder = JBColor.namedColor((String)"DragAndDrop.areaBorderColor", (Color)new Color(137, 178, 222));
                g.setColor((Color)backgroundBorder);
                g.drawRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                g.drawRect(bounds2.x + 1, bounds2.y + 1, bounds2.width - 2, bounds2.height - 2);
                JBColor foreground = JBColor.namedColor((String)"DragAndDrop.areaForeground", (Color)Gray._120);
                g.setColor((Color)foreground);
                Font labelFont = StartupUiUtil.getLabelFont();
                Font font = labelFont.deriveFont((float)labelFont.getSize() + 5.0f);
                String drop = IdeBundle.message((String)"welcome.screen.drop.files.to.open.text", (Object[])new Object[0]);
                g.setFont(font);
                int dropWidth = g.getFontMetrics().stringWidth(drop);
                int dropHeight = g.getFontMetrics().getHeight();
                g.drawString(drop, bounds2.x + (bounds2.width - dropWidth) / 2, (int)((double)bounds2.y + (double)(bounds2.height - dropHeight) * 0.45));
            }
        }

        @NotNull
        private JComponent createBody() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            panel2.add((Component)WelcomeScreenComponentFactory.createLogo(), (Object)"North");
            this.myTouchbarActions.removeAll();
            ActionPanel actionPanel = this.createQuickStartActionPanel();
            panel2.add((Component)actionPanel, (Object)"Center");
            this.myTouchbarActions.addAll(actionPanel.getActions());
            panel2.add((Component)this.createSettingsAndDocsPanel(FlatWelcomeFrame.this), (Object)"South");
            NonOpaquePanel nonOpaquePanel = panel2;
            if (nonOpaquePanel == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(0);
            }
            return nonOpaquePanel;
        }

        private JComponent createSettingsAndDocsPanel(JFrame frame) {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            NonOpaquePanel toolbar = new NonOpaquePanel();
            toolbar.setLayout((LayoutManager)new BoxLayout((Container)toolbar, 0));
            toolbar.add((Component)WelcomeScreenComponentFactory.createErrorsLink((Disposable)this));
            toolbar.add(this.createEventsLink());
            toolbar.add((Component)WelcomeScreenComponentFactory.createActionLink(FlatWelcomeFrame.this, IdeBundle.message((String)"action.Anonymous.text.configure", (Object[])new Object[0]), "WelcomeScreen.Configure", AllIcons.General.GearPlain, UIUtil.findComponentOfType((JComponent)frame.getRootPane(), JList.class)));
            toolbar.add((Component)WelcomeScreenComponentFactory.createActionLink(FlatWelcomeFrame.this, IdeBundle.message((String)"action.GetHelp", (Object[])new Object[0]), "WelcomeScreen.Documentation", null, null));
            panel2.add((Component)toolbar, "East");
            panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)8, (int)11));
            return panel2;
        }

        private Component createEventsLink() {
            return WelcomeScreenComponentFactory.createEventLink(IdeBundle.message((String)"action.Events", (Object[])new Object[0]), FlatWelcomeFrame.this);
        }

        @NotNull
        private ActionPanel createQuickStartActionPanel() {
            DefaultActionGroup group2 = new DefaultActionGroup();
            ActionGroup quickStart = (ActionGroup)ActionManager.getInstance().getAction("WelcomeScreen.QuickStart");
            WelcomeScreenActionsUtil.collectAllActions(group2, quickStart);
            ActionPanel mainPanel = new ActionPanel((LayoutManager)new MigLayout("ins 0, novisualpadding, gap " + JBUI.scale((int)5) + ", flowy", "push[pref!, center]push"));
            mainPanel.setOpaque(false);
            JPanel panel2 = new JPanel((LayoutManager)((Object)new VerticalLayout(JBUI.scale((int)5)))){
                Component firstAction;
                {
                    this.firstAction = null;
                }

                @Override
                public Component add(Component comp) {
                    Component cmp = super.add(comp);
                    if (this.firstAction == null) {
                        this.firstAction = cmp;
                    }
                    return cmp;
                }

                @Override
                public void addNotify() {
                    super.addNotify();
                    if (this.firstAction != null) {
                        FlatWelcomeFrame.this.onFirstActionShown(this.firstAction);
                    }
                }
            };
            panel2.setOpaque(false);
            FlatWelcomeFrame.this.extendActionsGroup(mainPanel);
            mainPanel.add(panel2);
            for (AnAction action2 : group2.getChildren(null)) {
                Icon icon2;
                AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext((Component)this));
                action2.update(e);
                Presentation presentation2 = e.getPresentation();
                if (!presentation2.isVisible()) continue;
                String text2 = presentation2.getText();
                if (text2 != null && text2.endsWith("...")) {
                    text2 = text2.substring(0, text2.length() - 3);
                }
                if ((icon2 = presentation2.getIcon()) == null || icon2.getIconHeight() != JBUIScale.scale((int)16) || icon2.getIconWidth() != JBUIScale.scale((int)16)) {
                    icon2 = icon2 != null ? IconUtil.scale(icon2, null, 16.0f / (float)icon2.getIconWidth()) : JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)16));
                    icon2 = IconUtil.colorize(icon2, (Color)new JBColor(0x6E6E6E, 11514291));
                }
                action2 = ActionGroupPanelWrapper.wrapGroups(action2, (Disposable)this);
                ActionLink link2 = new ActionLink(text2, icon2, action2, null, "WelcomeScreen");
                link2.setFocusable(false);
                link2.setPaintUnderline(false);
                link2.setNormalColor(WelcomeScreenUIManager.getLinkNormalColor());
                WelcomeScreenComponentFactory.JActionLinkPanel button4 = new WelcomeScreenComponentFactory.JActionLinkPanel(link2);
                button4.setBorder((Border)JBUI.Borders.empty((int)8, (int)20));
                if (action2 instanceof WelcomePopupAction) {
                    button4.add((Component)WelcomeScreenComponentFactory.createArrow(link2), "East");
                    TouchbarDataKeys.putActionDescriptor((AnAction)action2).setContextComponent((JComponent)link2);
                }
                WelcomeScreenFocusManager.installFocusable(FlatWelcomeFrame.this, button4, action2, 40, 38, UIUtil.findComponentOfType((JComponent)FlatWelcomeFrame.this.getComponent(), JList.class));
                panel2.add(button4);
                mainPanel.addAction(action2);
            }
            ActionPanel actionPanel = mainPanel;
            if (actionPanel == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(1);
            }
            return actionPanel;
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                FlatWelcomeScreen.$$$reportNull$$$0(2);
            }
            return TouchbarDataKeys.ACTIONS_KEY.is(dataId) ? this.myTouchbarActions : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createBody";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQuickStartActionPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

