/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionsWithPanelProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenComponentListener;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Function;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionGroupPanelWrapper {
    private static final String ACTION_GROUP_KEY = "ACTION_GROUP_KEY";

    public static Pair<JPanel, JBList<AnAction>> createActionGroupPanel(ActionGroup action2, final Runnable backAction, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(0);
        }
        JPanel actionsListPanel = new JPanel(new BorderLayout());
        actionsListPanel.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        List<AnAction> groups2 = ActionGroupPanelWrapper.flattenActionGroups(action2);
        final DefaultListModel model2 = JBList.createDefaultListModel(groups2);
        JBList list2 = new JBList((ListModel)model2);
        for (AnAction group2 : groups2) {
            if (!(group2 instanceof Disposable)) continue;
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)group2));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                model2.clear();
            }
        });
        list2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        list2.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer<AnAction>((ListItemDescriptor)new ListItemDescriptorAdapter<AnAction>(){

            @Override
            @Nullable
            public String getTextFor(AnAction value2) {
                return value2.getTemplateText();
            }

            @Override
            @Nullable
            public String getCaptionAboveOf(AnAction value2) {
                return ActionGroupPanelWrapper.getParentGroupName(value2);
            }

            @Override
            public boolean hasSeparatorAboveOf(AnAction value2) {
                int index2 = model2.indexOf(value2);
                String parentGroupName = ActionGroupPanelWrapper.getParentGroupName(value2);
                if (index2 < 1) {
                    return parentGroupName != null;
                }
                AnAction upper = (AnAction)model2.get(index2 - 1);
                if (ActionGroupPanelWrapper.getParentGroupName(upper) == null && parentGroupName != null) {
                    return true;
                }
                return !Objects.equals(ActionGroupPanelWrapper.getParentGroupName(upper), parentGroupName);
            }
        }){

            @Override
            protected JComponent createItemComponent() {
                this.myTextLabel = new ErrorLabel();
                this.myTextLabel.setOpaque(true);
                this.myTextLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)7));
                return this.myTextLabel;
            }

            protected Color getBackground() {
                return WelcomeScreenUIManager.getProjectsBackground();
            }

            @Override
            protected void customizeComponent(JList<? extends AnAction> list2, AnAction value2, boolean isSelected) {
                if (this.myTextLabel != null) {
                    this.myTextLabel.setText(value2.getTemplateText());
                    this.myTextLabel.setIcon(value2.getTemplatePresentation().getIcon());
                }
            }
        });
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)list2, (boolean)true);
        pane2.setBackground(WelcomeScreenUIManager.getProjectsBackground());
        actionsListPanel.add((Component)pane2, "Center");
        int width = (int)MathUtil.clamp((long)Math.round(list2.getPreferredSize().getWidth()), (long)JBUIScale.scale((int)100), (long)JBUIScale.scale((int)200));
        pane2.setPreferredSize((Dimension)JBUI.size((int)(width + 14), (int)-1));
        boolean singleProjectGenerator = list2.getModel().getSize() == 1;
        Ref selected2 = Ref.create();
        NonOpaquePanel main2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        main2.add((Component)actionsListPanel, "West");
        NonOpaquePanel bottomPanel2 = new NonOpaquePanel((LayoutManager)new FlowLayout(2));
        bottomPanel2.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)new JBColor((Color)Gray._217, (Color)Gray._81)));
        main2.add((Component)bottomPanel2, "South");
        HashMap panelsMap = new HashMap();
        ListSelectionListener selectionListener2 = arg_0 -> ActionGroupPanelWrapper.lambda$createActionGroupPanel$1(selected2, (JPanel)main2, list2, panelsMap, (JPanel)bottomPanel2, backAction, arg_0);
        list2.addListSelectionListener(selectionListener2);
        if (backAction != null) {
            new DumbAwareAction(){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    e.getPresentation().setEnabled(!StackingPopupDispatcher.getInstance().isPopupFocused());
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    backAction.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ActionGroupPanelWrapper$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)main2, parentDisposable);
        }
        ActionGroupPanelWrapper.installQuickSearch((JBList<? extends AnAction>)list2);
        if (singleProjectGenerator) {
            actionsListPanel.setPreferredSize(new Dimension(0, 0));
        }
        return Pair.create((Object)main2, (Object)list2);
    }

    private static void updateBottomPanel(@NotNull JPanel currentPanel, @NotNull AbstractActionWithPanel actionWithPanel, @NotNull JPanel bottomPanel2, @Nullable Runnable backAction) {
        if (currentPanel == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(1);
        }
        if (actionWithPanel == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(2);
        }
        if (bottomPanel2 == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(3);
        }
        bottomPanel2.removeAll();
        if (SystemInfo.isMac) {
            ActionGroupPanelWrapper.addCancelButton(bottomPanel2, backAction);
            ActionGroupPanelWrapper.addActionButton(bottomPanel2, actionWithPanel, currentPanel);
        } else {
            ActionGroupPanelWrapper.addActionButton(bottomPanel2, actionWithPanel, currentPanel);
            ActionGroupPanelWrapper.addCancelButton(bottomPanel2, backAction);
        }
    }

    private static void addCancelButton(@NotNull JPanel bottomPanel2, @Nullable Runnable backAction) {
        JComponent cancelButton;
        if (bottomPanel2 == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(4);
        }
        if ((cancelButton = ActionGroupPanelWrapper.createCancelButton(backAction)) != null) {
            bottomPanel2.add(cancelButton);
        }
    }

    private static void addActionButton(@NotNull JPanel bottomPanel2, @NotNull AbstractActionWithPanel actionWithPanel, @NotNull JPanel currentPanel) {
        if (bottomPanel2 == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(5);
        }
        if (actionWithPanel == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(6);
        }
        if (currentPanel == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(7);
        }
        JButton actionButton = actionWithPanel.getActionButton();
        bottomPanel2.add(actionButton);
        currentPanel.getRootPane().setDefaultButton(actionButton);
    }

    @Nullable
    private static JComponent createCancelButton(@Nullable Runnable cancelAction) {
        if (cancelAction == null) {
            return null;
        }
        JButton cancelButton = new JButton(CommonBundle.getCancelButtonText());
        cancelButton.addActionListener(e -> cancelAction.run());
        return cancelButton;
    }

    public static void installQuickSearch(JBList<? extends AnAction> list2) {
        new ListSpeedSearch<AnAction>((JList<? extends AnAction>)list2, (Function<? extends AnAction, String>)((Function)o -> {
            if (o instanceof AbstractActionWithPanel) {
                return o.getTemplatePresentation().getText();
            }
            return null;
        }));
    }

    private static List<AnAction> flattenActionGroups(@NotNull ActionGroup action2) {
        if (action2 == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(8);
        }
        ArrayList<AnAction> groups2 = new ArrayList<AnAction>();
        for (AnAction anAction2 : action2.getChildren(null)) {
            if (anAction2 instanceof ActionGroup) {
                String groupName = anAction2.getTemplateText();
                for (AnAction childAction : ((ActionGroup)anAction2).getChildren(null)) {
                    if (groupName != null) {
                        ActionGroupPanelWrapper.setParentGroupName(groupName, childAction);
                    }
                    groups2.add(childAction);
                }
                continue;
            }
            groups2.add(anAction2);
        }
        return groups2;
    }

    @NlsContexts.Separator
    private static String getParentGroupName(@NotNull AnAction value2) {
        if (value2 == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(9);
        }
        return (String)value2.getTemplatePresentation().getClientProperty(ACTION_GROUP_KEY);
    }

    private static void setParentGroupName(@NotNull String groupName, @NotNull AnAction childAction) {
        if (groupName == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(10);
        }
        if (childAction == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(11);
        }
        childAction.getTemplatePresentation().putClientProperty(ACTION_GROUP_KEY, (Object)groupName);
    }

    public static AnAction wrapGroups(final @NotNull AnAction action2, @NotNull Disposable parentDisposable) {
        if (action2 == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            ActionGroupPanelWrapper.$$$reportNull$$$0(13);
        }
        if (!(action2 instanceof ActionGroup)) {
            return action2;
        }
        if (action2 instanceof ActionsWithPanelProvider) {
            AtomicReference<Component> createdPanel = new AtomicReference<Component>();
            final Pair<JPanel, JBList<AnAction>> panel2 = ActionGroupPanelWrapper.createActionGroupPanel((ActionGroup)action2, () -> ActionGroupPanelWrapper.goBack((Component)createdPanel.get()), parentDisposable);
            createdPanel.set((Component)panel2.first);
            final Runnable onDone = () -> {
                ListSelectionListener[] listeners2;
                if (action2.getTemplateText() != null) {
                    ActionGroupPanelWrapper.setTitle(StringUtil.removeEllipsisSuffix((String)action2.getTemplateText()));
                }
                JBList list2 = (JBList)panel2.second;
                ScrollingUtil.ensureSelectionExists((JList)list2);
                for (ListSelectionListener listener2 : listeners2 = (ListSelectionListener[])((DefaultListSelectionModel)list2.getSelectionModel()).getListeners(ListSelectionListener.class)) {
                    listener2.valueChanged(new ListSelectionEvent(list2, list2.getSelectedIndex(), list2.getSelectedIndex(), false));
                }
                JComponent toFocus = FlatWelcomeFrame.getPreferredFocusedComponent(panel2);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)toFocus, true));
            };
            ((JPanel)panel2.first).setName(action2.getClass().getName());
            Presentation p = action2.getTemplatePresentation();
            return new DumbAwareAction(p.getText(), p.getDescription(), p.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    ((WelcomeScreenComponentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WelcomeScreenComponentListener.COMPONENT_CHANGED)).attachComponent((Component)panel2.first, onDone);
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    action2.update(e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ActionGroupPanelWrapper$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return action2;
    }

    private static void goBack(@Nullable Component parentComponent) {
        if (parentComponent == null) {
            return;
        }
        ((WelcomeScreenComponentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WelcomeScreenComponentListener.COMPONENT_CHANGED)).detachComponent(parentComponent, null);
    }

    static void setTitle(@Nullable @NlsContexts.DialogTitle String title2) {
        JFrame frame = WindowManager.getInstance().findVisibleFrame();
        if (frame != null) {
            frame.setTitle(title2);
        }
    }

    private static /* synthetic */ void lambda$createActionGroupPanel$1(Ref selected2, JPanel main2, JBList list2, HashMap panelsMap, JPanel bottomPanel2, Runnable backAction, ListSelectionEvent e) {
        Object value2;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (!selected2.isNull()) {
            main2.remove((Component)selected2.get());
        }
        if ((value2 = list2.getSelectedValue()) instanceof AbstractActionWithPanel) {
            JPanel panel2 = panelsMap.computeIfAbsent(value2, o -> ((AbstractActionWithPanel)((Object)((Object)value2))).createPanel());
            ((AbstractActionWithPanel)((Object)value2)).onPanelSelected();
            panel2.setBorder((Border)JBUI.Borders.empty((int)7, (int)10));
            selected2.set((Object)panel2);
            main2.add((Component)selected2.get());
            ActionGroupPanelWrapper.updateBottomPanel(panel2, (AbstractActionWithPanel)((Object)value2), bottomPanel2, backAction);
            main2.revalidate();
            main2.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPanel";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionWithPanel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomPanel";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childAction";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/ActionGroupPanelWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createActionGroupPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateBottomPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addCancelButton";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addActionButton";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "flattenActionGroups";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentGroupName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setParentGroupName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapGroups";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

