/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowEventSource;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class ToolWindowsWidget
extends JLabel
implements CustomStatusBarWidget,
StatusBarWidget,
Disposable,
UISettingsListener,
PropertyChangeListener {
    private final Alarm myAlarm;
    private StatusBar myStatusBar;
    private JBPopup popup;
    private boolean wasExited;

    ToolWindowsWidget(@NotNull Disposable parent) {
        if (parent == null) {
            ToolWindowsWidget.$$$reportNull$$$0(0);
        }
        this.wasExited = false;
        this.setBorder((Border)JBUI.Borders.empty());
        new BaseButtonBehavior(this, TimedDeadzone.NULL){

            protected void execute(MouseEvent e) {
                ToolWindowsWidget.this.performAction();
            }
        }.setActionTrigger(501);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof MouseEvent) {
                this.dispatchMouseEvent((MouseEvent)e);
            }
            return false;
        }, parent);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(UISettingsListener.TOPIC, (Object)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        this.myAlarm = new Alarm(parent);
    }

    private void dispatchMouseEvent(MouseEvent e) {
        Component component2 = e.getComponent();
        if (component2 != null && SwingUtilities.isDescendingFrom(component2, SwingUtilities.getWindowAncestor(this))) {
            int id2 = e.getID();
            if (id2 == 503 && this.isShowing()) {
                this.mouseMoved(e);
            } else if (id2 == 505) {
                this.mouseExited(e.getLocationOnScreen());
            }
        }
    }

    private void mouseMoved(MouseEvent e) {
        Point p = e.getLocationOnScreen();
        Point screen = this.getLocationOnScreen();
        if (new Rectangle(screen.x - 4, screen.y - 2, this.getWidth() + 4, this.getHeight() + 4).contains(p)) {
            this.mouseEntered();
            this.wasExited = false;
        } else if (!this.wasExited) {
            this.wasExited = this.mouseExited(p);
        }
    }

    private boolean mouseExited(Point currentLocationOnScreen) {
        this.myAlarm.cancelAllRequests();
        if (this.popup != null && this.popup.isVisible()) {
            Point screen = this.popup.getLocationOnScreen();
            Rectangle popupScreenRect = new Rectangle(screen.x, screen.y, this.popup.getSize().width, this.popup.getSize().height);
            if (!popupScreenRect.contains(currentLocationOnScreen)) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> {
                    if (this.popup != null && this.popup.isVisible()) {
                        this.popup.cancel();
                    }
                }, 300);
                return true;
            }
        }
        return false;
    }

    private void mouseEntered() {
        boolean active = ApplicationManager.getApplication().isActive();
        if (!active) {
            return;
        }
        if (this.myAlarm.isEmpty()) {
            this.myAlarm.addRequest(() -> {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this));
                if (project == null) {
                    return;
                }
                UIEventLogger.ToolWindowsWidgetPopupShown.log(project);
                ArrayList<ToolWindow> toolWindows = new ArrayList<ToolWindow>();
                ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)project);
                for (String id2 : toolWindowManager.getToolWindowIds()) {
                    ToolWindow tw = toolWindowManager.getToolWindow(id2);
                    if (!tw.isAvailable() || !tw.isShowStripeButton()) continue;
                    toolWindows.add(tw);
                }
                toolWindows.sort((o1, o2) -> StringUtil.naturalCompare((String)o1.getStripeTitle(), (String)o2.getStripeTitle()));
                JBList list2 = new JBList(toolWindows);
                list2.setCellRenderer((ListCellRenderer)new ToolWindowsWidgetCellRenderer());
                Dimension size = list2.getPreferredSize();
                ToolWindowsWidget c = this;
                Insets padding = UIUtil.getListViewportPadding((boolean)false);
                RelativePoint point = new RelativePoint((Component)c, new Point(-4, -padding.top - padding.bottom - 4 - size.height + (SystemInfo.isMac ? 2 : 0)));
                if (this.popup != null && this.popup.isVisible()) {
                    return;
                }
                list2.setSelectedIndex(list2.getItemsCount() - 1);
                PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2);
                this.popup = builder2.setAutoselectOnMouseMove(true).setRequestFocus(false).setItemChosenCallback(selectedValue -> {
                    if (this.popup != null) {
                        this.popup.closeOk(null);
                    }
                    toolWindowManager.activateToolWindow(selectedValue.getId(), null, true, ToolWindowEventSource.ToolWindowsWidget);
                }).createPopup();
                list2.setVisibleRowCount(30);
                this.popup.show(point);
            }, 300);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateIcon();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            ToolWindowsWidget.$$$reportNull$$$0(1);
        }
        this.updateIcon();
    }

    private void performAction() {
        if (this.isActive()) {
            UIEventLogger.ToolWindowsWidgetPopupClicked.log(this.myStatusBar.getProject());
            UISettings.getInstance().setHideToolStripes(!UISettings.getInstance().getHideToolStripes());
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private void updateIcon() {
        this.setToolTipText(null);
        if (this.isActive()) {
            Icon icon2;
            boolean changes = false;
            if (!this.isVisible()) {
                this.setVisible(true);
                changes = true;
            }
            Icon icon3 = icon2 = UISettings.getInstance().getHideToolStripes() ? AllIcons.General.TbShown : AllIcons.General.TbHidden;
            if (icon2 != this.getIcon()) {
                this.setIcon(icon2);
                changes = true;
            }
            if (changes) {
                this.revalidate();
                this.repaint();
            }
        } else {
            this.setVisible(false);
            this.setToolTipText(null);
        }
    }

    private boolean isActive() {
        return this.myStatusBar != null && this.myStatusBar.getProject() != null && Registry.is((String)"ide.windowSystem.showTooWindowButtonsSwitcher");
    }

    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public String ID() {
        return "ToolWindows Widget";
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    public void install(@NotNull StatusBar statusBar2) {
        if (statusBar2 == null) {
            ToolWindowsWidget.$$$reportNull$$$0(2);
        }
        this.myStatusBar = statusBar2;
        this.updateIcon();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
        this.myStatusBar = null;
        this.popup = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/ToolWindowsWidget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "uiSettingsChanged";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ToolWindowsWidgetCellRenderer
    implements ListCellRenderer<ToolWindow> {
        private final JPanel myPanel;
        private final JLabel myTextLabel = new JLabel();
        private final JLabel myShortcutLabel = new JLabel();

        private ToolWindowsWidgetCellRenderer() {
            this.myPanel = JBUI.Panels.simplePanel().addToLeft((Component)this.myTextLabel).addToRight((Component)this.myShortcutLabel);
            this.myShortcutLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)JBUIScale.scale((int)8), (int)1, (int)0));
            this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)10));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ToolWindow> list2, ToolWindow value2, int index2, boolean isSelected, boolean cellHasFocus) {
            UIUtil.setBackgroundRecursively((Component)this.myPanel, (Color)UIUtil.getListBackground((boolean)isSelected, (boolean)true));
            this.myTextLabel.setText(value2.getStripeTitle());
            this.myTextLabel.setIcon(value2.getIcon());
            this.myTextLabel.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)true));
            String activateActionId = ActivateToolWindowAction.getActionIdForToolWindow(value2.getId());
            KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut(activateActionId);
            if (shortcut != null) {
                this.myShortcutLabel.setText(KeymapUtil.getShortcutText((Shortcut)shortcut));
            } else {
                this.myShortcutLabel.setText("");
            }
            this.myShortcutLabel.setForeground(isSelected ? UIManager.getColor("MenuItem.acceleratorSelectionForeground") : UIManager.getColor("MenuItem.acceleratorForeground"));
            return this.myPanel;
        }
    }
}

