/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.openapi.wm.impl.status.ProgressButton;
import com.intellij.ui.TransparentPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class PresentationModeProgressPanel {
    private final InfoAndProgressPanel.MyInlineProgressIndicator myProgress;
    private final JBIterable<ProgressButton> myEastButtons;
    private JLabel myText;
    private JProgressBar myProgressBar;
    private JLabel myText2;
    private JPanel myRootPanel;
    private JPanel myButtonPanel;

    public PresentationModeProgressPanel(@NotNull InfoAndProgressPanel.MyInlineProgressIndicator progress2) {
        if (progress2 == null) {
            PresentationModeProgressPanel.$$$reportNull$$$0(0);
        }
        this.myProgress = progress2;
        this.$$$setupUI$$$();
        JBFont font = JBUI.Fonts.label((float)11.0f);
        this.myText.setFont((Font)font);
        this.myText2.setFont((Font)font);
        this.myText.setText(" ");
        this.myText2.setText(" ");
        this.myEastButtons = this.myProgress.createPresentationButtons();
        this.myButtonPanel.add(InlineProgressIndicator.createButtonPanel((Iterable<? extends JComponent>)this.myEastButtons.map(b -> b.button)));
        this.myRootPanel.setPreferredSize((Dimension)new JBDimension(250, 60));
        this.myProgressBar.setPreferredSize(new Dimension(JBUIScale.scale((int)250), this.myProgressBar.getPreferredSize().height));
    }

    @NotNull
    private static Color getTextForeground() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground();
        if (color == null) {
            PresentationModeProgressPanel.$$$reportNull$$$0(1);
        }
        return color;
    }

    void update() {
        Color color = PresentationModeProgressPanel.getTextForeground();
        this.myText.setForeground(color);
        this.myText2.setForeground(color);
        this.myProgressBar.setForeground(color);
        if (!StringUtil.equals((CharSequence)this.myText.getText(), (CharSequence)this.myProgress.getText())) {
            this.myText.setText(StringUtil.defaultIfEmpty((String)this.myProgress.getText(), (String)" "));
        }
        if (!StringUtil.equals((CharSequence)this.myText2.getText(), (CharSequence)this.myProgress.getText2())) {
            this.myText2.setText(StringUtil.defaultIfEmpty((String)this.myProgress.getText2(), (String)" "));
        }
        if ((this.myProgress.isIndeterminate() || this.myProgress.getFraction() == 0.0) != this.myProgressBar.isIndeterminate()) {
            this.myProgressBar.setIndeterminate(this.myProgress.isIndeterminate() || this.myProgress.getFraction() == 0.0);
            this.myProgressBar.revalidate();
        }
        if (!this.myProgressBar.isIndeterminate()) {
            this.myProgressBar.setValue((int)(this.myProgress.getFraction() * 99.0) + 1);
        }
        this.myEastButtons.forEach(b -> b.updateAction.run());
    }

    @NotNull
    public JComponent getProgressPanel() {
        JPanel jPanel2 = this.myRootPanel;
        if (jPanel2 == null) {
            PresentationModeProgressPanel.$$$reportNull$$$0(2);
        }
        return jPanel2;
    }

    private void createUIComponents() {
        this.myRootPanel = new TransparentPanel(0.5f){

            public boolean isVisible() {
                if (!PresentationModeProgressPanel.this.myProgress.showInPresentationMode()) {
                    return false;
                }
                UISettings ui2 = UISettings.getInstance();
                return ui2.getPresentationMode() || !ui2.getShowStatusBar() && Registry.is((String)"ide.show.progress.without.status.bar");
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/PresentationModeProgressPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/PresentationModeProgressPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForeground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel2;
        JProgressBar jProgressBar;
        this.createUIComponents();
        JPanel jPanel3 = this.myRootPanel;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setOpaque(false);
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        jProgressBar.setOpaque(false);
        jPanel3.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myButtonPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setOpaque(false);
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myText = jLabel2 = new JLabel();
        jLabel2.setAutoscrolls(true);
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(209, -1), new Dimension(209, -1), new Dimension(209, -1)));
        this.myText2 = jLabel = new JLabel();
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, new Dimension(209, -1), new Dimension(209, -1), new Dimension(209, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

