/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.BalloonHandler;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IconLikeCustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.MemoryUsagePanel;
import com.intellij.openapi.wm.impl.status.StatusBarUI;
import com.intellij.openapi.wm.impl.status.ToolWindowsWidget;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetWrapper;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.NotificationPopup;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeStatusBarImpl
extends JComponent
implements Accessible,
StatusBarEx,
IdeEventQueue.EventDispatcher,
DataProvider {
    private static final Logger LOG = Logger.getInstance(IdeStatusBarImpl.class);
    public static final DataKey<String> HOVERED_WIDGET_ID = DataKey.create("HOVERED_WIDGET_ID");
    private static final String WIDGET_ID = "STATUS_BAR_WIDGET_ID";
    private static final int MIN_ICON_HEIGHT = JBUI.scale((int)20);
    private final InfoAndProgressPanel myInfoAndProgressPanel;
    @NotNull
    private final IdeFrame myFrame;
    private static final String uiClassID = "IdeStatusBarUI";
    private final Map<String, WidgetBean> myWidgetMap;
    private JPanel myLeftPanel;
    private JPanel myRightPanel;
    private JPanel myCenterPanel;
    private Component myHoveredComponent;
    private @NlsContexts.StatusBarText String myInfo;
    private final List<String> myCustomComponentIds;
    private final Set<IdeStatusBarImpl> myChildren;

    public StatusBar findChild(Component c) {
        IdeFrame frame = null;
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (!(eachParent instanceof IdeFrame)) continue;
            frame = (IdeFrame)eachParent;
        }
        return frame != null ? frame.getStatusBar() : this;
    }

    private void updateChildren(@NotNull Consumer<? super IdeStatusBarImpl> consumer) {
        if (consumer == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(0);
        }
        for (IdeStatusBarImpl child2 : this.myChildren) {
            consumer.accept(child2);
        }
    }

    @NotNull
    public StatusBar createChild(@NotNull IdeFrame frame) {
        if (frame == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        IdeStatusBarImpl bar2 = new IdeStatusBarImpl(frame, false);
        bar2.setVisible(this.isVisible());
        this.myChildren.add(bar2);
        Disposer.register((Disposable)this, (Disposable)bar2);
        Disposer.register((Disposable)bar2, () -> this.myChildren.remove(bar2));
        for (WidgetBean eachBean : this.myWidgetMap.values()) {
            if (!(eachBean.widget instanceof StatusBarWidget.Multiframe)) continue;
            StatusBarWidget copy2 = ((StatusBarWidget.Multiframe)eachBean.widget).copy();
            bar2.addWidget(copy2, eachBean.position, eachBean.anchor);
        }
        bar2.repaint();
        IdeStatusBarImpl ideStatusBarImpl = bar2;
        if (ideStatusBarImpl == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(2);
        }
        return ideStatusBarImpl;
    }

    public JComponent getComponent() {
        return this;
    }

    @ApiStatus.Internal
    public IdeStatusBarImpl(@NotNull IdeFrame frame, boolean addToolWindowsWidget) {
        if (frame == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(3);
        }
        this.myWidgetMap = new LinkedHashMap();
        this.myCustomComponentIds = new ArrayList<String>();
        this.myChildren = new HashSet<IdeStatusBarImpl>();
        this.myFrame = frame;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 6));
        this.myInfoAndProgressPanel = new InfoAndProgressPanel();
        this.addWidget((StatusBarWidget)this.myInfoAndProgressPanel, Position.CENTER, "__IGNORED__");
        this.setOpaque(true);
        this.updateUI();
        if (addToolWindowsWidget) {
            this.addWidget((StatusBarWidget)new ToolWindowsWidget((Disposable)this), Position.LEFT, "__IGNORED__");
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        IdeEventQueue.getInstance().addDispatcher(this, (Disposable)this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size == null) {
            return null;
        }
        Insets insets = this.getInsets();
        int minHeight = insets.top + insets.bottom + MIN_ICON_HEIGHT;
        return new Dimension(size.width, Math.max(size.height, minHeight));
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(4);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.getProject();
        }
        if (PlatformDataKeys.STATUS_BAR.is(dataId)) {
            return this;
        }
        if (HOVERED_WIDGET_ID.is(dataId)) {
            return this.myHoveredComponent instanceof JComponent ? ((JComponent)this.myHoveredComponent).getClientProperty(WIDGET_ID) : null;
        }
        return null;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        for (IdeStatusBarImpl child2 : this.myChildren) {
            child2.setVisible(aFlag);
        }
    }

    public void addWidget(@NotNull StatusBarWidget widget) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(5);
        }
        this.addWidget(widget, "__AUTODETECT__");
    }

    public void addWidget(@NotNull StatusBarWidget widget, @NotNull String anchor2) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(6);
        }
        if (anchor2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(7);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.addWidget(widget, Position.RIGHT, anchor2));
    }

    public void addWidget(@NotNull StatusBarWidget widget, @NotNull Disposable parentDisposable) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(9);
        }
        this.addWidget(widget);
        String id2 = widget.ID();
        Disposer.register((Disposable)parentDisposable, () -> this.removeWidget(id2));
    }

    public void addWidget(@NotNull StatusBarWidget widget, @NotNull String anchor2, @NotNull Disposable parentDisposable) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(10);
        }
        if (anchor2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(12);
        }
        this.addWidget(widget, anchor2);
        String id2 = widget.ID();
        Disposer.register((Disposable)parentDisposable, () -> this.removeWidget(id2));
    }

    public void addWidgetToLeft(@NotNull StatusBarWidget widget, @NotNull Disposable parentDisposable) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(13);
        }
        if (parentDisposable == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(14);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.addWidget(widget, Position.LEFT, "__IGNORED__"));
        String id2 = widget.ID();
        Disposer.register((Disposable)parentDisposable, () -> this.removeWidget(id2));
    }

    public void addCustomIndicationComponent(final @NotNull JComponent c) {
        if (c == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(15);
        }
        final String customId = c.getClass().getName() + new Random().nextLong();
        this.addWidget((StatusBarWidget)new CustomStatusBarWidget(){

            @NotNull
            public String ID() {
                String string = customId;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public StatusBarWidget.WidgetPresentation getPresentation() {
                return null;
            }

            public void install(@NotNull StatusBar statusBar2) {
                if (statusBar2 == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            public void dispose() {
            }

            public JComponent getComponent() {
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statusBar";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "ID";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "install";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.myCustomComponentIds.add(customId);
    }

    public void removeCustomIndicationComponent(@NotNull JComponent c) {
        String[] keys2;
        if (c == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Set<String> keySet = this.myWidgetMap.keySet();
        for (String key : keys2 = ArrayUtilRt.toStringArray(keySet)) {
            WidgetBean value2 = this.myWidgetMap.get(key);
            if (!(value2.widget instanceof CustomStatusBarWidget) || value2.component != c) continue;
            this.removeWidget(key);
            this.myCustomComponentIds.remove(key);
        }
    }

    public void dispose() {
        this.removeCustomIndicationComponents();
        this.myWidgetMap.clear();
        this.myChildren.clear();
        if (this.myLeftPanel != null) {
            this.myLeftPanel.removeAll();
        }
        if (this.myRightPanel != null) {
            this.myRightPanel.removeAll();
        }
        if (this.myCenterPanel != null) {
            this.myCenterPanel.removeAll();
        }
    }

    private void removeCustomIndicationComponents() {
        for (String id2 : this.myCustomComponentIds) {
            this.removeWidget(id2);
        }
        this.myCustomComponentIds.clear();
    }

    private void addWidget(@NotNull StatusBarWidget widget, @NotNull Position position, @NotNull String anchor2) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(17);
        }
        if (position == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(18);
        }
        if (anchor2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JComponent c = IdeStatusBarImpl.wrap(widget);
        JPanel panel2 = this.getTargetPanel(position);
        if (position == Position.LEFT && panel2.getComponentCount() == 0) {
            c.setBorder((Border)(SystemInfo.isMac ? JBUI.Borders.empty((int)2, (int)0, (int)2, (int)4) : JBUI.Borders.empty()));
        }
        panel2.add((Component)c, this.getPositionIndex(position, anchor2));
        this.myWidgetMap.put(widget.ID(), WidgetBean.create(widget, position, c, anchor2));
        if (c instanceof StatusBarWidgetWrapper) {
            ((StatusBarWidgetWrapper)((Object)c)).beforeUpdate();
        }
        widget.install((StatusBar)this);
        panel2.revalidate();
        Disposer.register((Disposable)this, (Disposable)widget);
        if (widget instanceof StatusBarWidget.Multiframe) {
            StatusBarWidget.Multiframe multiFrameWidget = (StatusBarWidget.Multiframe)widget;
            this.updateChildren(child2 -> child2.addWidget(multiFrameWidget.copy(), position, anchor2));
        }
    }

    private int getPositionIndex(@NotNull Position position, @NotNull String anchor2) {
        if (position == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(20);
        }
        if (anchor2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(21);
        }
        if (Position.RIGHT == position && this.myRightPanel.getComponentCount() > 0) {
            WidgetBean widgetAnchor = null;
            boolean before = false;
            List parts = StringUtil.split((String)anchor2, (String)" ");
            if (parts.size() > 1) {
                widgetAnchor = this.myWidgetMap.get(parts.get(1));
                before = "before".equalsIgnoreCase((String)parts.get(0));
            }
            if (widgetAnchor == null) {
                widgetAnchor = this.myWidgetMap.get("Notifications");
                if (widgetAnchor == null) {
                    widgetAnchor = this.myWidgetMap.get("FatalError");
                }
                before = true;
            }
            if (widgetAnchor != null) {
                int anchorIndex = ArrayUtil.indexOf((Object[])this.myRightPanel.getComponents(), (Object)widgetAnchor.component);
                return before ? anchorIndex : anchorIndex + 1;
            }
        }
        return -1;
    }

    @NotNull
    private JPanel getTargetPanel(@NotNull Position position) {
        if (position == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(22);
        }
        if (position == Position.RIGHT) {
            return this.rightPanel();
        }
        if (position == Position.LEFT) {
            return this.leftPanel();
        }
        return this.centerPanel();
    }

    @NotNull
    private JPanel centerPanel() {
        if (this.myCenterPanel == null) {
            this.myCenterPanel = JBUI.Panels.simplePanel().andTransparent();
            this.myCenterPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)1));
            this.add((Component)this.myCenterPanel, "Center");
        }
        JPanel jPanel2 = this.myCenterPanel;
        if (jPanel2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(23);
        }
        return jPanel2;
    }

    @NotNull
    private JPanel rightPanel() {
        if (this.myRightPanel == null) {
            this.myRightPanel = new JPanel();
            this.myRightPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)1));
            this.myRightPanel.setLayout(new BoxLayout(this.myRightPanel, 0){

                @Override
                public void layoutContainer(Container target2) {
                    super.layoutContainer(target2);
                    for (Component component2 : target2.getComponents()) {
                        if (!(component2 instanceof MemoryUsagePanel)) continue;
                        Rectangle r = component2.getBounds();
                        r.y = 0;
                        r.width = r.width + (SystemInfo.isMac ? 4 : 0);
                        r.height = target2.getHeight();
                        component2.setBounds(r);
                    }
                }
            });
            this.myRightPanel.setOpaque(false);
            this.add((Component)this.myRightPanel, "East");
        }
        JPanel jPanel2 = this.myRightPanel;
        if (jPanel2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(24);
        }
        return jPanel2;
    }

    @NotNull
    private JPanel leftPanel() {
        if (this.myLeftPanel == null) {
            this.myLeftPanel = new JPanel();
            this.myLeftPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)0, (int)1));
            this.myLeftPanel.setLayout(new BoxLayout(this.myLeftPanel, 0));
            this.myLeftPanel.setOpaque(false);
            this.add((Component)this.myLeftPanel, "West");
        }
        JPanel jPanel2 = this.myLeftPanel;
        if (jPanel2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(25);
        }
        return jPanel2;
    }

    public void setInfo(@Nullable String s) {
        this.setInfo(s, null);
    }

    public void setInfo(@Nullable @Nls String s, @Nullable String requestor) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myInfoAndProgressPanel != null) {
                this.myInfo = (String)this.myInfoAndProgressPanel.setText((String)s, (String)requestor).first;
            }
        });
    }

    @NlsContexts.StatusBarText
    public String getInfo() {
        return this.myInfo;
    }

    @Override
    public void addProgress(@NotNull ProgressIndicatorEx indicator2, @NotNull TaskInfo info2) {
        if (indicator2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(26);
        }
        if (info2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(27);
        }
        this.myInfoAndProgressPanel.addProgress(indicator2, info2);
    }

    @Override
    public List<Pair<TaskInfo, ProgressIndicator>> getBackgroundProcesses() {
        return this.myInfoAndProgressPanel.getBackgroundProcesses();
    }

    @Override
    public void setProcessWindowOpen(boolean open2) {
        this.myInfoAndProgressPanel.setProcessWindowOpen(open2);
    }

    @Override
    public boolean isProcessWindowOpen() {
        return this.myInfoAndProgressPanel.isProcessWindowOpen();
    }

    @Override
    public void startRefreshIndication(String tooltipText) {
        this.myInfoAndProgressPanel.setRefreshToolTipText(tooltipText);
        this.myInfoAndProgressPanel.setRefreshVisible(true);
        this.updateChildren(child2 -> child2.startRefreshIndication(tooltipText));
    }

    @Override
    public void stopRefreshIndication() {
        this.myInfoAndProgressPanel.setRefreshVisible(false);
        this.updateChildren(IdeStatusBarImpl::stopRefreshIndication);
    }

    @Override
    public BalloonHandler notifyProgressByBalloon(@NotNull MessageType type, @NotNull @NlsContexts.PopupContent String htmlBody) {
        if (type == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(28);
        }
        if (htmlBody == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(29);
        }
        return this.notifyProgressByBalloon(type, htmlBody, null, null);
    }

    @Override
    public BalloonHandler notifyProgressByBalloon(@NotNull MessageType type, @NotNull @NlsContexts.PopupContent String htmlBody, @Nullable Icon icon2, @Nullable HyperlinkListener listener2) {
        if (type == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(30);
        }
        if (htmlBody == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(31);
        }
        return this.myInfoAndProgressPanel.notifyByBalloon(type, htmlBody, icon2, listener2);
    }

    public void fireNotificationPopup(@NotNull JComponent content2, Color backgroundColor) {
        if (content2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(32);
        }
        new NotificationPopup(this, content2, backgroundColor);
    }

    public static JComponent wrap(@NotNull StatusBarWidget widget) {
        if (widget == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(33);
        }
        if (widget instanceof CustomStatusBarWidget) {
            JComponent component2 = ((CustomStatusBarWidget)widget).getComponent();
            if (component2.getBorder() == null) {
                component2.setBorder(widget instanceof IconLikeCustomStatusBarWidget ? StatusBarWidget.WidgetBorder.ICON : StatusBarWidget.WidgetBorder.INSTANCE);
            }
            JComponent result2 = component2 instanceof JLabel ? new NonOpaquePanel((LayoutManager)new BorderLayout(), component2) : component2;
            result2.putClientProperty(WIDGET_ID, widget.ID());
            return result2;
        }
        StatusBarWidget.WidgetPresentation presentation2 = widget.getPresentation();
        if (presentation2 == null) {
            LOG.error("Widget " + widget + " getPresentation() method must not return null");
        }
        JComponent wrapper2 = StatusBarWidgetWrapper.wrap(Objects.requireNonNull(presentation2));
        wrapper2.putClientProperty(WIDGET_ID, widget.ID());
        wrapper2.putClientProperty("ToCenterTooltip", Boolean.TRUE);
        return wrapper2;
    }

    private void hoverComponent(@Nullable Component component2) {
        if (this.myHoveredComponent == component2) {
            return;
        }
        this.myHoveredComponent = component2;
        if (this.myHoveredComponent != null) {
            this.myHoveredComponent.setBackground(null);
        }
        if (component2 != null && component2.isEnabled()) {
            component2.setBackground(JBUI.CurrentTheme.StatusBar.hoverBackground());
        }
        this.repaint();
    }

    private void paintHoveredComponentBackground(Graphics g) {
        if (this.myHoveredComponent == null || !this.myHoveredComponent.isEnabled()) {
            return;
        }
        if (!UIUtil.isAncestor((Component)this, (Component)this.myHoveredComponent)) {
            return;
        }
        if (this.myHoveredComponent instanceof MemoryUsagePanel) {
            return;
        }
        Rectangle bounds2 = this.myHoveredComponent.getBounds();
        Point point = new RelativePoint((Component)this.myHoveredComponent.getParent(), bounds2.getLocation()).getPoint((Component)this);
        g.setColor(JBUI.CurrentTheme.StatusBar.hoverBackground());
        g.fillRect(point.x, point.y, bounds2.width, bounds2.height);
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.paintHoveredComponentBackground(g);
        super.paintChildren(g);
    }

    @Override
    public boolean dispatch(@NotNull AWTEvent e) {
        if (e == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(34);
        }
        if (e instanceof MouseEvent) {
            return this.dispatchMouseEvent((MouseEvent)e);
        }
        return false;
    }

    private boolean dispatchMouseEvent(@NotNull MouseEvent e) {
        ActionManager actionManager;
        ActionGroup group2;
        Project project;
        if (e == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(35);
        }
        if (this.myRightPanel == null || this.myCenterPanel == null || !this.myRightPanel.isVisible()) {
            return false;
        }
        Component component2 = e.getComponent();
        if (component2 == null) {
            return false;
        }
        if (ComponentUtil.getWindow((Component)this.myFrame.getComponent()) != ComponentUtil.getWindow((Component)component2)) {
            this.hoverComponent(null);
            return false;
        }
        Point point = SwingUtilities.convertPoint(component2, e.getPoint(), this.myRightPanel);
        Component widget = this.myRightPanel.getComponentAt(point);
        if (e.getClickCount() == 0) {
            this.hoverComponent(widget != this.myRightPanel ? widget : null);
        }
        if (e.isConsumed() || widget == null) {
            return false;
        }
        if (e.isPopupTrigger() && (e.getID() == 501 || e.getID() == 502) && (project = this.getProject()) != null && (group2 = (ActionGroup)ObjectUtils.tryCast((Object)(actionManager = ActionManager.getInstance()).getAction("ViewStatusBarWidgetsGroup"), ActionGroup.class)) != null) {
            ActionPopupMenu menu = actionManager.createActionPopupMenu("StatusBarPlace", group2);
            menu.setTargetComponent((JComponent)this);
            menu.getComponent().show(this.myRightPanel, point.x, point.y);
            e.consume();
            return true;
        }
        return false;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(new StatusBarUI());
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
    }

    public void removeWidget(@NotNull String id2) {
        if (id2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(36);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            WidgetBean bean = this.myWidgetMap.remove(id2);
            if (bean != null) {
                JPanel targetPanel = this.getTargetPanel(bean.position);
                targetPanel.remove(bean.component);
                targetPanel.revalidate();
                Disposer.dispose((Disposable)bean.widget);
            }
            this.updateChildren(child2 -> child2.removeWidget(id2));
        });
    }

    public void updateWidget(@NotNull String id2) {
        if (id2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(37);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            JComponent widgetComponent = this.getWidgetComponent(id2);
            if (widgetComponent != null) {
                if (widgetComponent instanceof StatusBarWidgetWrapper) {
                    ((StatusBarWidgetWrapper)((Object)widgetComponent)).beforeUpdate();
                }
                widgetComponent.repaint();
            }
            this.updateChildren(child2 -> child2.updateWidget(id2));
        });
    }

    @Nullable
    public StatusBarWidget getWidget(String id2) {
        WidgetBean bean = this.myWidgetMap.get(id2);
        return bean == null ? null : bean.widget;
    }

    @ApiStatus.Internal
    @Nullable
    public JComponent getWidgetComponent(@NotNull String id2) {
        WidgetBean bean;
        if (id2 == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(38);
        }
        return (bean = this.myWidgetMap.get(id2)) == null ? null : bean.component;
    }

    @NotNull
    public IdeFrame getFrame() {
        IdeFrame ideFrame = this.myFrame;
        if (ideFrame == null) {
            IdeStatusBarImpl.$$$reportNull$$$0(39);
        }
        return ideFrame;
    }

    @Nullable
    public Project getProject() {
        return this.myFrame.getProject();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIdeStatusBarImpl();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 25: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 25: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 7: 
            case 11: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlBody";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "centerPanel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "rightPanel";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "leftPanel";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateChildren";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 25: 
            case 39: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addWidget";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addWidgetToLeft";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addCustomIndicationComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomIndicationComponent";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPositionIndex";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPanel";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addProgress";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "notifyProgressByBalloon";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fireNotificationPopup";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "dispatchMouseEvent";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeWidget";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updateWidget";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 25: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleIdeStatusBarImpl
    extends JComponent.AccessibleJComponent {
        protected AccessibleIdeStatusBarImpl() {
            super(IdeStatusBarImpl.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private static final class WidgetBean {
        JComponent component;
        Position position;
        StatusBarWidget widget;
        String anchor;

        private WidgetBean() {
        }

        static WidgetBean create(@NotNull StatusBarWidget widget, @NotNull Position position, @NotNull JComponent component2, @NotNull String anchor2) {
            if (widget == null) {
                WidgetBean.$$$reportNull$$$0(0);
            }
            if (position == null) {
                WidgetBean.$$$reportNull$$$0(1);
            }
            if (component2 == null) {
                WidgetBean.$$$reportNull$$$0(2);
            }
            if (anchor2 == null) {
                WidgetBean.$$$reportNull$$$0(3);
            }
            WidgetBean bean = new WidgetBean();
            bean.widget = widget;
            bean.position = position;
            bean.component = component2;
            bean.anchor = anchor2;
            return bean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "widget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "position";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/status/IdeStatusBarImpl$WidgetBean";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Position {
        LEFT,
        RIGHT,
        CENTER;

    }
}

