/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.FrameHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.title.CustomHeaderTitle;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\b\u0010\u001b\u001a\u00020\u0019H\u0014J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/MenuFrameHeader;", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/FrameHeader;", "frame", "Ljavax/swing/JFrame;", "headerTitle", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/title/CustomHeaderTitle;", "myIdeMenu", "Lcom/intellij/openapi/wm/impl/IdeMenuBar;", "(Ljavax/swing/JFrame;Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/title/CustomHeaderTitle;Lcom/intellij/openapi/wm/impl/IdeMenuBar;)V", "changeListener", "Ljavax/swing/event/ChangeListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "getHeaderTitle", "()Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/title/CustomHeaderTitle;", "mainMenuUpdater", "Lcom/intellij/ide/ui/UISettingsListener;", "menuHolder", "Ljavax/swing/JComponent;", "getMyIdeMenu", "()Lcom/intellij/openapi/wm/impl/IdeMenuBar;", "getHitTestSpots", "", "Lcom/intellij/ui/awt/RelativeRectangle;", "installListeners", "", "uninstallListeners", "updateActive", "updateMenuActions", "forceRebuild", "", "intellij.platform.ide.impl"})
public final class MenuFrameHeader
extends FrameHeader {
    private final JComponent menuHolder;
    private ChangeListener changeListener;
    private final UISettingsListener mainMenuUpdater;
    private Disposable disposable;
    @NotNull
    private final CustomHeaderTitle headerTitle;
    @NotNull
    private final IdeMenuBar myIdeMenu;

    public final void updateMenuActions(boolean forceRebuild) {
        this.myIdeMenu.updateMenuActions(forceRebuild);
    }

    @Override
    protected void updateActive() {
        super.updateActive();
        this.headerTitle.setActive(this.getMyActive());
    }

    @Override
    protected void installListeners() {
        this.myIdeMenu.getSelectionModel().addChangeListener(this.changeListener);
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
        Disposable disp2 = disposable2;
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)disp2);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect(disp2).subscribe(UISettingsListener.TOPIC, (Object)this.mainMenuUpdater);
        this.mainMenuUpdater.uiSettingsChanged(UISettings.Companion.getInstance());
        this.disposable = disp2;
        super.installListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.myIdeMenu.getSelectionModel().removeChangeListener(this.changeListener);
        Disposable disposable2 = this.disposable;
        if (disposable2 != null) {
            Disposable disposable3 = disposable2;
            boolean bl = false;
            boolean bl2 = false;
            Disposable it = disposable3;
            boolean bl3 = false;
            if (!Disposer.isDisposed((Disposable)it)) {
                Disposer.dispose((Disposable)it);
            }
            this.disposable = null;
        }
        super.uninstallListeners();
    }

    @Override
    @NotNull
    public List<RelativeRectangle> getHitTestSpots() {
        List hitTestSpots = CollectionsKt.toMutableList((Collection)super.getHitTestSpots());
        if (this.menuHolder.isVisible()) {
            Rectangle menuRect = new Rectangle(this.menuHolder.getSize());
            int state = this.getFrame().getExtendedState();
            if (state != 4 && state != 6) {
                int topGap = MathKt.roundToInt((float)(menuRect.height / 3));
                menuRect.y += topGap;
                menuRect.height -= topGap;
            }
            hitTestSpots.add(new RelativeRectangle((Component)this.menuHolder, menuRect));
        }
        hitTestSpots.addAll((Collection)this.headerTitle.getBoundList());
        return hitTestSpots;
    }

    @NotNull
    public final CustomHeaderTitle getHeaderTitle() {
        return this.headerTitle;
    }

    @NotNull
    public final IdeMenuBar getMyIdeMenu() {
        return this.myIdeMenu;
    }

    public MenuFrameHeader(@NotNull JFrame frame, @NotNull CustomHeaderTitle headerTitle, @NotNull IdeMenuBar myIdeMenu) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)headerTitle, (String)"headerTitle");
        Intrinsics.checkNotNullParameter((Object)myIdeMenu, (String)"myIdeMenu");
        super(frame);
        this.headerTitle = headerTitle;
        this.myIdeMenu = myIdeMenu;
        this.setLayout((LayoutManager)new MigLayout("novisualpadding, fillx, ins 0, gap 0, top, hidemode 2", "[pref!][][grow][pref!]"));
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)CustomHeader.Companion.getV(), (int)CustomHeader.Companion.getH(), (int)CustomHeader.Companion.getV(), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"JBUI.Borders.empty(V, H, V, 0)");
        JBEmptyBorder empty = jBEmptyBorder;
        this.getProductIcon().setBorder((Border)empty);
        this.add(this.getProductIcon());
        this.changeListener = new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent it) {
                this.updateCustomDecorationHitTestSpots();
            }
        };
        this.headerTitle.setOnBoundsChanged((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.windowStateChanged();
            }
        }));
        this.menuHolder = new JPanel((LayoutManager)new MigLayout("filly, ins 0, novisualpadding, hidemode 3", "[pref!]" + JBUI.scale((int)10)));
        ((JPanel)this.menuHolder).setBorder((Border)JBUI.Borders.empty((int)0, (int)(CustomHeader.Companion.getH() - 1), (int)0, (int)0));
        ((JPanel)this.menuHolder).setOpaque(false);
        this.menuHolder.add((Component)this.myIdeMenu, "wmin 0, wmax pref, top, growy");
        this.add((Component)this.menuHolder, "wmin 0, top, growy, pushx");
        JComponent jComponent = this.headerTitle.getView();
        boolean bl = false;
        boolean bl2 = false;
        JComponent $this$apply = jComponent;
        boolean bl3 = false;
        $this$apply.setBorder((Border)empty);
        JComponent view = jComponent;
        this.add((Component)view, "left, growx, gapbottom 1");
        this.add((Component)this.getButtonPanes().getView(), "top, wmin pref");
        this.setCustomFrameTopBorder((Function0<Boolean>)((Function0)new Function0<Boolean>(){

            public final boolean invoke() {
                return this.getMyState() != 4 && this.getMyState() != 6;
            }
        }), (Function0<Boolean>)((Function0)4.INSTANCE));
        this.mainMenuUpdater = new UISettingsListener(){

            public final void uiSettingsChanged(@NotNull UISettings it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((JPanel)menuHolder).setVisible(UISettings.Companion.getInstance().getShowMainMenu());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        this.updateCustomDecorationHitTestSpots();
                    }
                });
            }
        };
        ((JPanel)this.menuHolder).setVisible(UISettings.Companion.getInstance().getShowMainMenu());
    }
}

