/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.rd.GraphicsExKt;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ComboIcon;
import com.intellij.openapi.wm.impl.content.ContentLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ContentComboLabel
extends ContentLabel {
    private final PopupState<JBPopup> myPopupState;
    private final ComboIcon myComboIcon;
    private final ComboContentLayout myLayout;

    ContentComboLabel(@NotNull ComboContentLayout layout) {
        if (layout == null) {
            ContentComboLabel.$$$reportNull$$$0(0);
        }
        super(layout.myUi, true);
        this.myPopupState = PopupState.forPopup();
        this.myComboIcon = new ComboIcon(){

            @Override
            public Rectangle getIconRec() {
                return new Rectangle(ContentComboLabel.this.getWidth() - this.getIconWidth() - ContentLabel.ICONS_GAP, 0, this.getIconWidth(), ContentComboLabel.this.getHeight());
            }

            @Override
            public boolean isActive() {
                return ContentComboLabel.this.myUi.window.isActive();
            }
        };
        this.myLayout = layout;
        this.addMouseListener(new MouseAdapter(){});
        if (ScreenReader.isActive()) {
            this.setFocusable(true);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                        ToolWindowContentUi.toggleContentPopup(ContentComboLabel.this.myUi, ContentComboLabel.this.myUi.getContentManager());
                    }
                    super.keyPressed(e);
                }
            });
        }
    }

    @Override
    @Nullable
    protected String getOriginalText() {
        Content content2 = this.getContent();
        return content2 != null ? content2.getDisplayName() : null;
    }

    @Override
    protected void handleMouseClick(@NotNull MouseEvent e) {
        if (e == null) {
            ContentComboLabel.$$$reportNull$$$0(1);
        }
        if (e.getID() == 502) {
            this.handleActionsClick(e);
        }
        if (e.getID() == 501) {
            if (this.findHoveredIcon() != null) {
                return;
            }
            if (UIUtil.isActionClick((MouseEvent)e)) {
                if (this.myPopupState.isRecentlyHidden()) {
                    return;
                }
                ToolWindowContentUi.toggleContentPopup(this.myUi, this.myUi.getContentManager(), this.myPopupState);
            }
        }
    }

    void update() {
        this.setBorder((Border)(this.isToDrawCombo() ? JBUI.Borders.empty((int)0, (int)8) : JBUI.Borders.empty()));
        this.updateTextAndIcon(this.getContent(), true);
        this.updateAdditionalActions();
    }

    @Override
    protected boolean allowEngravement() {
        return this.myUi == null || this.myUi.window.isActive();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        if (!this.isMinimumSizeSet()) {
            Insets insets;
            size.width = this.isToDrawCombo() ? this.myComboIcon.getIconWidth() : 0;
            Icon icon2 = this.getIcon();
            if (icon2 != null) {
                size.width += icon2.getIconWidth() + this.getIconTextGap();
            }
            if ((insets = this.getInsets()) != null) {
                size.width += insets.left + insets.right;
            }
        }
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (!this.isPreferredSizeSet() && this.isToDrawCombo()) {
            if (this.hasActiveIcons()) {
                size.width -= ICONS_GAP;
            }
            size.width += this.myComboIcon.getIconWidth();
        }
        return size;
    }

    private boolean isToDrawCombo() {
        return this.myLayout.isToDrawCombo();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color bgColor = this.getTabColor();
        if (bgColor != null) {
            int borderThickness = JBUIScale.scale((int)1);
            Dimension size = this.getSize();
            Rectangle rect = new Rectangle(0, borderThickness, size.width, size.height - 2 * borderThickness);
            GraphicsExKt.fill2DRect((Graphics2D)((Graphics2D)g), (Rectangle)rect, (Color)bgColor);
        }
        super.paintComponent(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isToDrawCombo()) {
            this.myComboIcon.paintIcon(this, g);
            g.setColor(Gray._255.withAlpha(100));
        }
    }

    @Override
    @Nullable
    public Content getContent() {
        return this.myUi.getContentManager().getSelectedContent();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleContentComboLabel();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/content/ContentComboLabel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleMouseClick";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class AccessibleContentComboLabel
    extends BaseLabel.AccessibleBaseLabel
    implements AccessibleAction {
        private AccessibleContentComboLabel() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index2) {
            return index2 == 0 ? UIManager.getString("ComboBox.togglePopupText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index2) {
            if (index2 == 0) {
                ToolWindowContentUi.toggleContentPopup(ContentComboLabel.this.myUi, ContentComboLabel.this.myUi.getContentManager());
                return true;
            }
            return false;
        }
    }
}

