/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.InternalDecoratorImpl;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowDragHelper;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002FGB\u001f\u0012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0011H\u0014J\b\u0010!\u001a\u00020\u0017H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0011H\u0014J\u0012\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\u000f2\b\u0010)\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\rH\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010+\u001a\u00020\rH\u0002J\n\u0010-\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010-\u001a\u0004\u0018\u00010\u001c2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0011H\u0002J \u00100\u001a\u00020\u00172\u0006\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011H\u0014J\u0012\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000103H\u0016J \u00107\u001a\u0002052\u0006\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u0011H\u0014J\u0018\u00108\u001a\u0002052\u0006\u00102\u001a\u0002032\u0006\u00109\u001a\u00020\u0017H\u0014J(\u0010:\u001a\u0002052\u0006\u00102\u001a\u0002032\u0006\u00101\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00112\u0006\u0010;\u001a\u00020\u0017H\u0014J\u0010\u0010<\u001a\u0002052\u0006\u00102\u001a\u000203H\u0014J\u0010\u0010=\u001a\u0002052\u0006\u00102\u001a\u000203H\u0014J\u0010\u0010>\u001a\u0002052\u0006\u00102\u001a\u000203H\u0002J\u0010\u0010?\u001a\u0002052\u0006\u0010@\u001a\u00020\u0017H\u0002J\u0010\u0010A\u001a\u0002052\u0006\u00102\u001a\u000203H\u0002J\b\u0010B\u001a\u000205H\u0016J\b\u0010C\u001a\u000205H\u0002J\u001c\u0010D\u001a\u00020E*\u00020\u001c2\u0006\u0010+\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0011H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowDragHelper;", "Lcom/intellij/ui/MouseDragHelper;", "Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "parent", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "pane", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/wm/impl/ToolWindowsPane;)V", "myDialog", "Lcom/intellij/openapi/wm/impl/ToolWindowDragHelper$MyDialog;", "myHighlighter", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "myInitialAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "myInitialButton", "Lcom/intellij/openapi/wm/impl/StripeButton;", "myInitialOffset", "Ljava/awt/Point;", "myInitialSize", "Ljava/awt/Dimension;", "myLastStripe", "Lcom/intellij/openapi/wm/impl/Stripe;", "mySourceIsHeader", "", "getPane", "()Lcom/intellij/openapi/wm/impl/ToolWindowsPane;", "toolWindowRef", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "canStartDragging", "dragComponent", "Ljavax/swing/JComponent;", "dragComponentPoint", "cancelDragging", "getDragStartDeadzone", "", "pressedScreenPoint", "draggedScreenPoint", "getStripe", "screenPoint", "getStripeButton", "window", "getStripeHeight", "anchor", "getStripeWidth", "getToolWindow", "startScreenPoint", "Lcom/intellij/ui/awt/RelativePoint;", "isDragOut", "dragToScreenPoint", "event", "Ljava/awt/event/MouseEvent;", "mouseReleased", "", "e", "processDrag", "processDragFinish", "willDragOutStart", "processDragOut", "justStarted", "processDragOutFinish", "processMousePressed", "relocate", "setDragOut", "dragOut", "startDrag", "stop", "stopDrag", "getBoundsOnScreen", "Ljava/awt/Rectangle;", "Companion", "MyDialog", "intellij.platform.ide.impl"})
public final class ToolWindowDragHelper
extends MouseDragHelper<ToolWindowsPane> {
    private WeakReference<ToolWindowImpl> toolWindowRef;
    private ToolWindowAnchor myInitialAnchor;
    private StripeButton myInitialButton;
    private Dimension myInitialSize;
    private Stripe myLastStripe;
    private MyDialog myDialog;
    private final NonOpaquePanel myHighlighter;
    private final Point myInitialOffset;
    private boolean mySourceIsHeader;
    @NotNull
    private final ToolWindowsPane pane;
    public static final int THUMB_SIZE = 220;
    public static final float THUMB_OPACITY = 0.85f;
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected boolean isDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        return this.isDragOut(dragToScreenPoint);
    }

    private final boolean isDragOut(Point dragToScreenPoint) {
        ToolWindowImpl toolWindow = this.getToolWindow();
        if (toolWindow != null && this.getBoundsOnScreen(toolWindow, toolWindow.getAnchor(), dragToScreenPoint).contains(dragToScreenPoint)) {
            return false;
        }
        return this.myLastStripe == null;
    }

    protected boolean canStartDragging(@NotNull JComponent dragComponent, @NotNull Point dragComponentPoint) {
        Intrinsics.checkNotNullParameter((Object)dragComponent, (String)"dragComponent");
        Intrinsics.checkNotNullParameter((Object)dragComponentPoint, (String)"dragComponentPoint");
        return this.getToolWindow(new RelativePoint((Component)dragComponent, dragComponentPoint)) != null;
    }

    @Nullable
    public final ToolWindowImpl getToolWindow(@NotNull RelativePoint startScreenPoint) {
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        ArrayList decorators = new ArrayList(ComponentUtil.findComponentsOfType((JComponent)((JComponent)((Object)this.pane)), InternalDecoratorImpl.class));
        Iterator iterator2 = decorators.iterator();
        while (iterator2.hasNext()) {
            InternalDecoratorImpl decorator;
            InternalDecoratorImpl internalDecoratorImpl = decorator = (InternalDecoratorImpl)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)internalDecoratorImpl, (String)"decorator");
            Rectangle bounds2 = internalDecoratorImpl.getHeaderScreenBounds();
            if (bounds2 == null || !bounds2.contains(startScreenPoint.getScreenPoint())) continue;
            Point point = startScreenPoint.getPoint((Component)decorator);
            Component child2 = SwingUtilities.getDeepestComponentAt(decorator, point.x, point.y);
            if (!MouseDragHelper.isComponentDraggable((Component)child2) || ComponentUtil.findParentByCondition((Component)child2, (Predicate)getToolWindow.1.INSTANCE) == null) continue;
            ToolWindowImpl toolWindowImpl = decorator.getToolWindow();
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"decorator.toolWindow");
            if (!(Intrinsics.areEqual((Object)toolWindowImpl.getAnchor(), (Object)ToolWindowAnchor.BOTTOM) ^ true) && decorator.getLocationOnScreen().y > startScreenPoint.getScreenPoint().y - ToolWindowsPane.getHeaderResizeArea()) continue;
            return decorator.getToolWindow();
        }
        Point point = startScreenPoint.getPoint((Component)((Object)this.pane));
        Component component2 = SwingUtilities.getDeepestComponentAt((Component)((Object)this.pane), point.x, point.y);
        if (component2 instanceof StripeButton) {
            return ((StripeButton)component2).toolWindow;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void processMousePressed(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        relativePoint = new RelativePoint(event);
        toolWindow = this.getToolWindow(relativePoint);
        if (toolWindow == null) {
            return;
        }
        decorator = toolWindow.isVisible() != false ? toolWindow.getDecorator() : null;
        this.toolWindowRef = new WeakReference<ToolWindowImpl>(toolWindow);
        this.myInitialAnchor = toolWindow.getAnchor();
        this.myLastStripe = this.pane.getStripeFor(toolWindow.getAnchor());
        this.myInitialButton = this.pane.getStripeFor(toolWindow.getAnchor()).getButtonFor(toolWindow.getId());
        v0 = toolWindow.getAnchor();
        v1 = relativePoint.getScreenPoint();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"relativePoint.screenPoint");
        v2 = this.getBoundsOnScreen(toolWindow, v0, v1).getSize();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toolWindow.getBoundsOnSc\u2026vePoint.screenPoint).size");
        this.myInitialSize = v2;
        if (decorator == null) ** GOTO lbl-1000
        v3 = decorator.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"decorator.bounds");
        if (!v3.isEmpty()) {
            v4 = com.intellij.openapi.wm.impl.ToolWindowDragHelper$Companion.createDragImage$default(ToolWindowDragHelper.Companion, decorator, 0, 2, null);
        } else lbl-1000:
        // 2 sources

        {
            v4 = dragOutImage = null;
        }
        if (this.myInitialButton != null) {
            v5 = this.myInitialButton;
            Intrinsics.checkNotNull((Object)v5);
            v6 = v5.createDragImage();
        } else {
            v6 = dragOutImage;
        }
        dragImage = v6;
        point = relativePoint.getPoint((Component)this.pane);
        component = SwingUtilities.getDeepestComponentAt((Component)this.pane, point.x, point.y);
        this.mySourceIsHeader = true;
        if (component instanceof StripeButton) {
            this.myInitialOffset.setLocation(relativePoint.getPoint(component));
            this.mySourceIsHeader = false;
        } else if (dragImage != null) {
            this.myInitialOffset.setLocation(new Point(dragImage.getWidth((ImageObserver)this.pane) / 4, dragImage.getHeight((ImageObserver)this.pane) / 4));
        }
        if (dragImage != null) {
            this.myDialog = new MyDialog((JComponent)this.pane, this, dragImage, dragOutImage);
        }
    }

    public void mouseReleased(@Nullable MouseEvent e) {
        super.mouseReleased(e);
        this.stopDrag();
    }

    protected void processDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint, boolean justStarted) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        this.relocate(event);
        event.consume();
    }

    protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
        Stripe stripe;
        ToolWindowImpl window;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (willDragOutStart) {
                    this.setDragOut(true);
                    return;
                }
                Point screenPoint = event.getLocationOnScreen();
                window = this.getToolWindow();
                if (window == null) break block6;
                if (willDragOutStart) break block7;
                ToolWindowAnchor toolWindowAnchor = this.myInitialAnchor;
                Intrinsics.checkNotNull((Object)toolWindowAnchor);
                if (this.pane.getStripeFor(screenPoint, this.pane.getStripeFor(toolWindowAnchor)) != null) break block7;
                ToolWindowAnchor toolWindowAnchor2 = this.myInitialAnchor;
                Intrinsics.checkNotNull((Object)toolWindowAnchor2);
                Point point = screenPoint;
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"screenPoint");
                if (!this.getBoundsOnScreen(window, toolWindowAnchor2, point).contains(screenPoint)) break block7;
            }
            this.cancelDragging();
            return;
        }
        if ((stripe = this.myLastStripe) != null) {
            stripe.finishDrop(window.getToolWindowManager());
        } else {
            window.getToolWindowManager().setToolWindowType(window.getId(), ToolWindowType.FLOATING);
            window.getToolWindowManager().activateToolWindow(window.getId(), new Runnable(this, window, event){
                final /* synthetic */ ToolWindowDragHelper this$0;
                final /* synthetic */ ToolWindowImpl $window;
                final /* synthetic */ MouseEvent $event;

                public final void run() {
                    Window w = UIUtil.getWindow((Component)this.$window.getComponent());
                    if (w instanceof JDialog) {
                        Rectangle bounds2;
                        Point locationOnScreen = this.$event.getLocationOnScreen();
                        if (ToolWindowDragHelper.access$getMySourceIsHeader$p(this.this$0)) {
                            InternalDecoratorImpl decorator = (InternalDecoratorImpl)ComponentUtil.getParentOfType(InternalDecoratorImpl.class, (Component)this.$window.getComponent());
                            if (decorator != null) {
                                Point shift = SwingUtilities.convertPoint(decorator, decorator.getLocation(), w);
                                locationOnScreen.translate(-shift.x, -shift.y);
                            }
                            locationOnScreen.translate(-ToolWindowDragHelper.access$getMyInitialOffset$p((ToolWindowDragHelper)this.this$0).x, -ToolWindowDragHelper.access$getMyInitialOffset$p((ToolWindowDragHelper)this.this$0).y);
                        }
                        ((JDialog)w).setLocation(locationOnScreen);
                        Rectangle rectangle = bounds2 = ((JDialog)w).getBounds();
                        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"bounds");
                        rectangle.setSize(ToolWindowDragHelper.access$getMyInitialSize$p(this.this$0));
                        ScreenUtil.fitToScreen((Rectangle)bounds2);
                        ((JDialog)w).setBounds(bounds2);
                    }
                }
                {
                    this.this$0 = toolWindowDragHelper;
                    this.$window = toolWindowImpl;
                    this.$event = mouseEvent;
                }
            }, true, null);
        }
    }

    private final ToolWindowImpl getToolWindow() {
        WeakReference<ToolWindowImpl> weakReference = this.toolWindowRef;
        return weakReference != null ? (ToolWindowImpl)weakReference.get() : null;
    }

    protected void processDragOutFinish(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processDragFinish(event, false);
    }

    public boolean cancelDragging() {
        if (super.cancelDragging()) {
            this.stopDrag();
            return true;
        }
        return false;
    }

    public void stop() {
        super.stop();
        this.stopDrag();
    }

    private final void stopDrag() {
        ToolWindowImpl window = this.getToolWindow();
        StripeButton stripeButton = this.getStripeButton(window);
        if (stripeButton != null) {
            stripeButton.setVisible(true);
        }
        this.pane.stopDrag();
        JRootPane jRootPane = this.pane.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"pane.rootPane");
        Component component2 = jRootPane.getGlassPane();
        if (component2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        JComponent jComponent = (JComponent)component2;
        boolean bl = false;
        boolean bl2 = false;
        JComponent $this$with = jComponent;
        boolean bl3 = false;
        $this$with.remove((Component)this.myHighlighter);
        $this$with.revalidate();
        $this$with.repaint();
        MyDialog myDialog = this.myDialog;
        if (myDialog != null) {
            myDialog.dispose();
        }
        this.myDialog = null;
        this.toolWindowRef = null;
        this.myInitialAnchor = null;
        if (this.myLastStripe != null) {
            Stripe stripe = this.myLastStripe;
            Intrinsics.checkNotNull((Object)stripe);
            stripe.resetDrop();
            this.myLastStripe = null;
        }
        this.myInitialButton = null;
    }

    protected void processDrag(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
        Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
        if (!MouseDragHelper.checkModifiers((InputEvent)event)) {
            return;
        }
        if (this.isDragJustStarted()) {
            this.startDrag(event);
        } else {
            this.relocate(event);
        }
    }

    protected int getDragStartDeadzone(@NotNull Point pressedScreenPoint, @NotNull Point draggedScreenPoint) {
        Intrinsics.checkNotNullParameter((Object)pressedScreenPoint, (String)"pressedScreenPoint");
        Intrinsics.checkNotNullParameter((Object)draggedScreenPoint, (String)"draggedScreenPoint");
        Point point = new RelativePoint(pressedScreenPoint).getPoint((Component)((Object)this.pane));
        if (SwingUtilities.getDeepestComponentAt((Component)((Object)this.pane), point.x, point.y) instanceof StripeButton) {
            return super.getDragStartDeadzone(pressedScreenPoint, draggedScreenPoint);
        }
        return JBUI.scale((int)Registry.intValue((String)"ide.new.tool.window.start.drag.deadzone", (int)7, (int)0, (int)100));
    }

    private final void startDrag(MouseEvent event) {
        this.relocate(event);
        if (this.myInitialButton != null) {
            StripeButton stripeButton = this.myInitialButton;
            Intrinsics.checkNotNull((Object)stripeButton);
            stripeButton.setVisible(false);
        }
        MyDialog myDialog = this.myDialog;
        if (myDialog != null) {
            myDialog.setVisible(true);
        }
        JRootPane jRootPane = this.pane.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"pane.rootPane");
        Component component2 = jRootPane.getGlassPane();
        if (component2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
        }
        JComponent jComponent = (JComponent)component2;
        boolean bl = false;
        boolean bl2 = false;
        JComponent $this$with = jComponent;
        boolean bl3 = false;
        $this$with.add((Component)this.myHighlighter);
        $this$with.revalidate();
        $this$with.repaint();
        this.pane.startDrag();
    }

    private final Rectangle getBoundsOnScreen(ToolWindowImpl $this$getBoundsOnScreen, ToolWindowAnchor anchor2, Point screenPoint) {
        ToolWindowAnchor toolWindowAnchor = this.myInitialAnchor;
        Intrinsics.checkNotNull((Object)toolWindowAnchor);
        Stripe trueStripe = this.pane.getStripeFor(screenPoint, this.pane.getStripeFor(toolWindowAnchor));
        Point location = this.pane.getLocationOnScreen();
        int n = location.x;
        ToolWindowAnchor toolWindowAnchor2 = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor2, (String)"LEFT");
        location.x = n + this.getStripeWidth(toolWindowAnchor2);
        int n2 = location.y;
        ToolWindowAnchor toolWindowAnchor3 = ToolWindowAnchor.TOP;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor3, (String)"TOP");
        location.y = n2 + this.getStripeHeight(toolWindowAnchor3);
        int n3 = this.pane.getWidth();
        ToolWindowAnchor toolWindowAnchor4 = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor4, (String)"LEFT");
        int n4 = n3 - this.getStripeWidth(toolWindowAnchor4);
        ToolWindowAnchor toolWindowAnchor5 = ToolWindowAnchor.RIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor5, (String)"RIGHT");
        int width = n4 - this.getStripeWidth(toolWindowAnchor5);
        int n5 = this.pane.getHeight();
        ToolWindowAnchor toolWindowAnchor6 = ToolWindowAnchor.TOP;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor6, (String)"TOP");
        int n6 = n5 - this.getStripeHeight(toolWindowAnchor6);
        ToolWindowAnchor toolWindowAnchor7 = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor7, (String)"BOTTOM");
        int height = n6 - this.getStripeHeight(toolWindowAnchor7);
        if (anchor2 == this.myInitialAnchor && trueStripe == null && $this$getBoundsOnScreen.isVisible()) {
            if (anchor2.isHorizontal()) {
                JRootPane jRootPane = this.pane.getRootPane();
                Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"pane.rootPane");
                height = (int)((float)jRootPane.getHeight() * $this$getBoundsOnScreen.getWindowInfo().getWeight());
            } else {
                JRootPane jRootPane = this.pane.getRootPane();
                Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"pane.rootPane");
                width = (int)((float)jRootPane.getWidth() * $this$getBoundsOnScreen.getWindowInfo().getWeight());
            }
        } else if (anchor2.isHorizontal()) {
            height = 200;
        } else {
            width = 200;
        }
        ToolWindowAnchor toolWindowAnchor8 = anchor2;
        if (Intrinsics.areEqual((Object)toolWindowAnchor8, (Object)ToolWindowAnchor.BOTTOM)) {
            int n7 = this.pane.getLocationOnScreen().y + this.pane.getHeight() - height;
            ToolWindowAnchor toolWindowAnchor9 = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor9, (String)"BOTTOM");
            location.y = n7 - this.getStripeHeight(toolWindowAnchor9);
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor8, (Object)ToolWindowAnchor.RIGHT)) {
            int n8 = this.pane.getLocationOnScreen().x + this.pane.getWidth() - width;
            ToolWindowAnchor toolWindowAnchor10 = ToolWindowAnchor.RIGHT;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor10, (String)"RIGHT");
            location.x = n8 - this.getStripeWidth(toolWindowAnchor10);
        }
        return new Rectangle(location.x, location.y, width, height);
    }

    private final int getStripeWidth(ToolWindowAnchor anchor2) {
        Stripe stripe = this.pane.getStripeFor(anchor2);
        boolean bl = false;
        boolean bl2 = false;
        Stripe $this$with = stripe;
        boolean bl3 = false;
        return $this$with.isVisible() && $this$with.isShowing() ? $this$with.getWidth() : 0;
    }

    private final int getStripeHeight(ToolWindowAnchor anchor2) {
        Stripe stripe = this.pane.getStripeFor(anchor2);
        boolean bl = false;
        boolean bl2 = false;
        Stripe $this$with = stripe;
        boolean bl3 = false;
        return $this$with.isVisible() && $this$with.isShowing() ? $this$with.getHeight() : 0;
    }

    private final StripeButton getStripeButton(ToolWindowImpl window) {
        if (window == null) {
            return null;
        }
        return this.pane.getStripeFor(window.getAnchor()).getButtonFor(window.getId());
    }

    private final void relocate(MouseEvent event) {
        Point screenPoint = event.getLocationOnScreen();
        MyDialog dialog2 = this.myDialog;
        ToolWindowImpl toolWindow = this.getToolWindow();
        if (dialog2 == null || toolWindow == null) {
            return;
        }
        Point point = screenPoint;
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"screenPoint");
        boolean dragOut = this.isDragOut(point);
        dialog2.setLocation(screenPoint.x - this.myInitialOffset.x, screenPoint.y - this.myInitialOffset.y);
        this.setDragOut(dragOut);
        Stripe stripe = this.getStripe(screenPoint);
        if (this.myLastStripe != null && Intrinsics.areEqual((Object)this.myLastStripe, (Object)stripe) ^ true) {
            Stripe stripe2 = this.myLastStripe;
            Intrinsics.checkNotNull((Object)stripe2);
            stripe2.resetDrop();
        }
        this.myHighlighter.setVisible(stripe != null);
        if (stripe != null && this.myInitialButton != null) {
            StripeButton stripeButton = this.myInitialButton;
            if (stripeButton == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.StripeButton");
            }
            Container container = dialog2.getContentPane();
            if (container == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
            }
            stripe.processDropButton(stripeButton, (JComponent)container, screenPoint);
            SwingUtilities.invokeLater(new Runnable(this, toolWindow, stripe, screenPoint){
                final /* synthetic */ ToolWindowDragHelper this$0;
                final /* synthetic */ ToolWindowImpl $toolWindow;
                final /* synthetic */ Stripe $stripe;
                final /* synthetic */ Point $screenPoint;

                public final void run() {
                    ToolWindowAnchor toolWindowAnchor = this.$stripe.getAnchor();
                    Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"stripe.anchor");
                    Point point = this.$screenPoint;
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"screenPoint");
                    Rectangle bounds2 = ToolWindowDragHelper.access$getBoundsOnScreen(this.this$0, this.$toolWindow, toolWindowAnchor, point);
                    Point p = bounds2.getLocation();
                    JRootPane jRootPane = this.this$0.getPane().getRootPane();
                    Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"pane.rootPane");
                    SwingUtilities.convertPointFromScreen(p, jRootPane.getLayeredPane());
                    bounds2.setLocation(p);
                    Boolean dropToSide = this.$stripe.getDropToSide();
                    if (dropToSide != null) {
                        ToolWindowAnchor toolWindowAnchor2 = this.$stripe.getAnchor();
                        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor2, (String)"stripe.anchor");
                        int half = toolWindowAnchor2.isHorizontal() ? bounds2.width / 2 : bounds2.height / 2;
                        ToolWindowAnchor toolWindowAnchor3 = this.$stripe.getAnchor();
                        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor3, (String)"stripe.anchor");
                        if (!toolWindowAnchor3.isHorizontal()) {
                            bounds2.height -= half;
                            if (dropToSide.booleanValue()) {
                                bounds2.y += half;
                            }
                        } else {
                            bounds2.width -= half;
                            if (dropToSide.booleanValue()) {
                                bounds2.x += half;
                            }
                        }
                    }
                    ToolWindowDragHelper.access$getMyHighlighter$p(this.this$0).setBounds(bounds2);
                }
                {
                    this.this$0 = toolWindowDragHelper;
                    this.$toolWindow = toolWindowImpl;
                    this.$stripe = stripe;
                    this.$screenPoint = point;
                }
            });
        }
        this.myLastStripe = stripe;
    }

    private final Stripe getStripe(Point screenPoint) {
        ToolWindowAnchor toolWindowAnchor = this.myInitialAnchor;
        Intrinsics.checkNotNull((Object)toolWindowAnchor);
        Stripe stripe = this.pane.getStripeFor(screenPoint, this.pane.getStripeFor(toolWindowAnchor));
        if (stripe == null) {
            ToolWindowImpl toolWindowImpl = this.getToolWindow();
            Intrinsics.checkNotNull((Object)toolWindowImpl);
            ToolWindowAnchor toolWindowAnchor2 = this.myInitialAnchor;
            Intrinsics.checkNotNull((Object)toolWindowAnchor2);
            if (this.getBoundsOnScreen(toolWindowImpl, toolWindowAnchor2, screenPoint).contains(screenPoint)) {
                ToolWindowAnchor toolWindowAnchor3 = this.myInitialAnchor;
                Intrinsics.checkNotNull((Object)toolWindowAnchor3);
                stripe = this.pane.getStripeFor(toolWindowAnchor3);
            }
        }
        Stripe stripe2 = stripe;
        if (Intrinsics.areEqual((Object)(stripe2 != null ? stripe2.getAnchor() : null), (Object)ToolWindowAnchor.TOP)) {
            return null;
        }
        return stripe;
    }

    private final void setDragOut(boolean dragOut) {
        MyDialog myDialog = this.myDialog;
        if (myDialog != null) {
            myDialog.setDragOut(dragOut);
        }
        this.myHighlighter.setVisible(!dragOut);
    }

    @NotNull
    public final ToolWindowsPane getPane() {
        return this.pane;
    }

    public ToolWindowDragHelper(@NotNull Disposable parent, @NotNull ToolWindowsPane pane2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)pane2), (String)"pane");
        super(parent, (JComponent)((Object)pane2));
        this.pane = pane2;
        this.toolWindowRef = null;
        this.myInitialAnchor = null;
        this.myInitialButton = null;
        this.myInitialSize = new Dimension();
        this.myLastStripe = null;
        this.myDialog = null;
        this.myHighlighter = Companion.createHighlighterComponent();
        this.myInitialOffset = new Point();
    }

    public static final /* synthetic */ boolean access$getMySourceIsHeader$p(ToolWindowDragHelper $this) {
        return $this.mySourceIsHeader;
    }

    public static final /* synthetic */ void access$setMySourceIsHeader$p(ToolWindowDragHelper $this, boolean bl) {
        $this.mySourceIsHeader = bl;
    }

    public static final /* synthetic */ Point access$getMyInitialOffset$p(ToolWindowDragHelper $this) {
        return $this.myInitialOffset;
    }

    public static final /* synthetic */ Dimension access$getMyInitialSize$p(ToolWindowDragHelper $this) {
        return $this.myInitialSize;
    }

    public static final /* synthetic */ void access$setMyInitialSize$p(ToolWindowDragHelper $this, Dimension dimension) {
        $this.myInitialSize = dimension;
    }

    public static final /* synthetic */ Rectangle access$getBoundsOnScreen(ToolWindowDragHelper $this, ToolWindowImpl $this$access_u24getBoundsOnScreen, ToolWindowAnchor anchor2, Point screenPoint) {
        return $this.getBoundsOnScreen($this$access_u24getBoundsOnScreen, anchor2, screenPoint);
    }

    public static final /* synthetic */ NonOpaquePanel access$getMyHighlighter$p(ToolWindowDragHelper $this) {
        return $this.myHighlighter;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowDragHelper$MyDialog;", "Ljavax/swing/JDialog;", "owner", "Ljavax/swing/JComponent;", "helper", "Lcom/intellij/openapi/wm/impl/ToolWindowDragHelper;", "stripeButtonImage", "Ljava/awt/image/BufferedImage;", "toolWindowThumbnailImage", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/wm/impl/ToolWindowDragHelper;Ljava/awt/image/BufferedImage;Ljava/awt/image/BufferedImage;)V", "getHelper", "()Lcom/intellij/openapi/wm/impl/ToolWindowDragHelper;", "myDragOut", "", "getMyDragOut", "()Ljava/lang/Boolean;", "setMyDragOut", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getStripeButtonImage", "()Ljava/awt/image/BufferedImage;", "getToolWindowThumbnailImage", "setDragOut", "", "dragOut", "updateIcon", "image", "intellij.platform.ide.impl"})
    public static final class MyDialog
    extends JDialog {
        @Nullable
        private Boolean myDragOut;
        @NotNull
        private final ToolWindowDragHelper helper;
        @NotNull
        private final BufferedImage stripeButtonImage;
        @Nullable
        private final BufferedImage toolWindowThumbnailImage;

        @Nullable
        public final Boolean getMyDragOut() {
            return this.myDragOut;
        }

        public final void setMyDragOut(@Nullable Boolean bl) {
            this.myDragOut = bl;
        }

        public final void setDragOut(boolean dragOut) {
            if (Intrinsics.areEqual((Object)dragOut, (Object)this.myDragOut)) {
                return;
            }
            this.myDragOut = dragOut;
            BufferedImage image = dragOut && this.toolWindowThumbnailImage != null ? this.toolWindowThumbnailImage : this.stripeButtonImage;
            this.updateIcon(image);
        }

        public final void updateIcon(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Container container = this.getContentPane();
            if (container == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.JLabel");
            }
            JLabel jLabel = (JLabel)container;
            boolean bl = false;
            boolean bl2 = false;
            JLabel $this$with = jLabel;
            boolean bl3 = false;
            $this$with.setIcon((Icon)IconUtil.createImageIcon((Image)image));
            $this$with.revalidate();
            this.pack();
            $this$with.repaint();
        }

        @NotNull
        public final ToolWindowDragHelper getHelper() {
            return this.helper;
        }

        @NotNull
        public final BufferedImage getStripeButtonImage() {
            return this.stripeButtonImage;
        }

        @Nullable
        public final BufferedImage getToolWindowThumbnailImage() {
            return this.toolWindowThumbnailImage;
        }

        public MyDialog(@NotNull JComponent owner, @NotNull ToolWindowDragHelper helper, @NotNull BufferedImage stripeButtonImage, @Nullable BufferedImage toolWindowThumbnailImage) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)((Object)helper), (String)"helper");
            Intrinsics.checkNotNullParameter((Object)stripeButtonImage, (String)"stripeButtonImage");
            super(UIUtil.getWindow((Component)owner), null, Dialog.ModalityType.MODELESS);
            this.helper = helper;
            this.stripeButtonImage = stripeButtonImage;
            this.toolWindowThumbnailImage = toolWindowThumbnailImage;
            this.myDragOut = null;
            this.setUndecorated(true);
            try {
                this.setOpacity(0.85f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setAlwaysOnTop(true);
            this.setContentPane(new JLabel());
            this.getContentPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(@Nullable MouseEvent e) {
                    this.getHelper().mouseReleased(e);
                }

                @Override
                public void mouseDragged(@Nullable MouseEvent e) {
                    ToolWindowDragHelper toolWindowDragHelper = this.getHelper();
                    MouseEvent mouseEvent = e;
                    Intrinsics.checkNotNull((Object)mouseEvent);
                    toolWindowDragHelper.relocate(mouseEvent);
                }
            });
            this.setDragOut(false);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u0007J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/wm/impl/ToolWindowDragHelper$Companion;", "", "()V", "THUMB_OPACITY", "", "THUMB_SIZE", "", "createDragImage", "Ljava/awt/image/BufferedImage;", "component", "Ljavax/swing/JComponent;", "thumbSize", "createHighlighterComponent", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @Nullable
        @NotNull
        public final BufferedImage createDragImage(@NotNull JComponent component2, int thumbSize) {
            Graphics graphics;
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            BufferedImage bufferedImage = UIUtil.createImage((Component)component2, (int)component2.getWidth(), (int)component2.getHeight(), (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"UIUtil.createImage(compo\u2026fferedImage.TYPE_INT_RGB)");
            BufferedImage image = bufferedImage;
            Graphics graphics2 = graphics = image.getGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2, (String)"graphics");
            graphics2.setColor(UIUtil.getBgFillColor((Component)component2));
            RectanglePainter.FILL.paint((Graphics2D)graphics, 0, 0, component2.getWidth(), component2.getHeight(), null);
            component2.paint(graphics);
            graphics.dispose();
            double width = image.getWidth(null);
            double height = image.getHeight(null);
            if (thumbSize == -1 || width <= (double)thumbSize && height <= (double)thumbSize) {
                return image;
            }
            double ratio = width > height ? (double)thumbSize / width : (double)thumbSize / height;
            Image image2 = ImageUtil.scaleImage((Image)image, (int)((int)(width * ratio)), (int)((int)(height * ratio)));
            if (image2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.image.BufferedImage");
            }
            return (BufferedImage)image2;
        }

        public static /* synthetic */ BufferedImage createDragImage$default(Companion companion, JComponent jComponent, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = JBUI.scale((int)220);
            }
            return companion.createDragImage(jComponent, n);
        }

        @NotNull
        public final NonOpaquePanel createHighlighterComponent() {
            return new NonOpaquePanel(){

                public void paint(@NotNull Graphics g) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    g.setColor((Color)JBColor.namedColor((String)"DragAndDrop.areaBackground", (int)4029900, (int)4213335));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

