/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.openapi.wm.ext.LibrarySearchHelper;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LibraryDependentToolWindowManager
implements StartupActivity {
    private static final Executor ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"LibraryDependentToolWindowManager");

    LibraryDependentToolWindowManager() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(0);
        }
        ModuleRootListener rootListener = new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LibraryDependentToolWindowManager.this.checkToolWindowStatuses(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager$1", "rootsChanged"));
            }
        };
        this.checkToolWindowStatuses(project);
        SimpleMessageBusConnection connection = project.getMessageBus().simpleConnect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)rootListener);
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (presentableLibraryName, oldRoots, newRoots, libraryNameForDebug) -> this.checkToolWindowStatuses(project));
        LibraryDependentToolWindow.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LibraryDependentToolWindow>(){

            public void extensionAdded(@NotNull LibraryDependentToolWindow extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                LibraryDependentToolWindowManager.this.checkToolWindowStatuses(project, extension2.id);
            }

            public void extensionRemoved(@NotNull LibraryDependentToolWindow extension2, @NotNull PluginDescriptor pluginDescriptor) {
                ToolWindow window;
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((window = ToolWindowManager.getInstance((Project)project).getToolWindow(extension2.id)) != null) {
                    window.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private void checkToolWindowStatuses(@NotNull Project project) {
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(1);
        }
        this.checkToolWindowStatuses(project, null);
    }

    private void checkToolWindowStatuses(@NotNull Project project, @Nullable String extensionId) {
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(2);
        }
        ModalityState currentModalityState = ModalityState.current();
        ReadAction.nonBlocking(() -> {
            List extensions2 = LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList();
            if (extensionId != null) {
                extensions2 = ContainerUtil.filter((Collection)extensions2, ltw -> Objects.equals(ltw.id, extensionId));
            }
            HashSet<LibraryDependentToolWindow> existing = new HashSet<LibraryDependentToolWindow>(ContainerUtil.findAll((Collection)extensions2, ltw -> {
                LibrarySearchHelper helper = ltw.getLibrarySearchHelper();
                return helper != null && helper.isLibraryExists(project);
            }));
            return new LibraryWindowsState(project, extensions2, existing);
        }).inSmartMode(project).coalesceBy(new Object[]{this, project}).finishOnUiThread(currentModalityState, LibraryDependentToolWindowManager::applyWindowsState).submit(ourExecutor);
    }

    private static void applyWindowsState(LibraryWindowsState state) {
        ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(state.project);
        for (LibraryDependentToolWindow libraryToolWindow : state.extensions) {
            ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(libraryToolWindow.id);
            if (state.existing.contains(libraryToolWindow)) {
                WindowInfoImpl windowInfo;
                if (toolWindow != null) continue;
                toolWindowManagerEx.initToolWindow((ToolWindowEP)libraryToolWindow);
                if (libraryToolWindow.showOnStripeByDefault || (toolWindow = toolWindowManagerEx.getToolWindow(libraryToolWindow.id)) == null || (windowInfo = toolWindowManagerEx.getLayout().getInfo(libraryToolWindow.id)) == null || windowInfo.isFromPersistentSettings()) continue;
                toolWindow.setShowStripeButton(false);
                continue;
            }
            if (toolWindow == null) continue;
            toolWindow.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkToolWindowStatuses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LibraryWindowsState {
        @NotNull
        final Project project;
        final List<LibraryDependentToolWindow> extensions;
        final Set<LibraryDependentToolWindow> existing;

        private LibraryWindowsState(@NotNull Project project, List<LibraryDependentToolWindow> extensions2, Set<LibraryDependentToolWindow> existing) {
            if (project == null) {
                LibraryWindowsState.$$$reportNull$$$0(0);
            }
            this.project = project;
            this.extensions = extensions2;
            this.existing = existing;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager$LibraryWindowsState", "<init>"));
        }
    }
}

