/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSPaths;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.io.storage.RefCountingContentStorage;
import com.intellij.util.io.storage.Storage;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PersistentFSConnection {
    private static final Logger LOG = Logger.getInstance(PersistentFSConnection.class);
    static final int RESERVED_ATTR_ID = FSRecords.bulkAttrReadSupport ? 1 : 0;
    static final AttrPageAwareCapacityAllocationPolicy REASONABLY_SMALL = new AttrPageAwareCapacityAllocationPolicy();
    private static final int FIRST_ATTR_ID_OFFSET = FSRecords.bulkAttrReadSupport ? RESERVED_ATTR_ID : 0;
    private final IntList myFreeRecords;
    @NotNull
    private final VfsDependentEnum<String> myAttributesList;
    @NotNull
    private final PersistentFSPaths myPersistentFSPaths;
    @NotNull
    private final Storage myAttributes;
    @NotNull
    private final RefCountingContentStorage myContents;
    @NotNull
    private final PersistentFSRecordsStorage myRecords;
    @Nullable
    private final ContentHashEnumerator myContentHashesEnumerator;
    private final PersistentStringEnumerator myNames;
    private volatile int myLocalModificationCount;
    private volatile boolean myDirty;
    private final ScheduledFuture<?> myFlushingFuture;
    private boolean myCorrupted;

    PersistentFSConnection(@NotNull PersistentFSPaths paths, @NotNull PersistentFSRecordsStorage records, @NotNull PersistentStringEnumerator names2, @NotNull Storage attributes2, @NotNull RefCountingContentStorage contents, @Nullable ContentHashEnumerator contentHashesEnumerator, @NotNull IntList freeRecords, boolean markDirty2) throws IOException {
        if (paths == null) {
            PersistentFSConnection.$$$reportNull$$$0(0);
        }
        if (records == null) {
            PersistentFSConnection.$$$reportNull$$$0(1);
        }
        if (names2 == null) {
            PersistentFSConnection.$$$reportNull$$$0(2);
        }
        if (attributes2 == null) {
            PersistentFSConnection.$$$reportNull$$$0(3);
        }
        if (contents == null) {
            PersistentFSConnection.$$$reportNull$$$0(4);
        }
        if (freeRecords == null) {
            PersistentFSConnection.$$$reportNull$$$0(5);
        }
        this.myRecords = records;
        this.myNames = names2;
        this.myAttributes = attributes2;
        this.myContents = contents;
        this.myContentHashesEnumerator = contentHashesEnumerator;
        this.myPersistentFSPaths = paths;
        this.myFreeRecords = freeRecords;
        if (markDirty2) {
            this.markDirty();
        }
        this.myAttributesList = new VfsDependentEnum(this.getPersistentFSPaths(), "attrib", EnumeratorStringDescriptor.INSTANCE, 1);
        this.myFlushingFuture = FSRecords.backgroundVfsFlush ? FlushingDaemon.everyFiveSeconds(new Runnable(){
            private int lastModCount;

            @Override
            public void run() {
                if (this.lastModCount == PersistentFSConnection.this.myLocalModificationCount) {
                    PersistentFSConnection.this.flush();
                }
                this.lastModCount = PersistentFSConnection.this.myLocalModificationCount;
            }
        }) : null;
    }

    @NotNull(value="Content hash enumerator must be initialized")
    @NotNull(value="Content hash enumerator must be initialized") ContentHashEnumerator getContentHashesEnumerator() {
        ContentHashEnumerator contentHashEnumerator = this.myContentHashesEnumerator;
        if (contentHashEnumerator == null) {
            PersistentFSConnection.$$$reportNull$$$0(6);
        }
        return contentHashEnumerator;
    }

    @NotNull(value="Vfs must be initialized")
    @NotNull(value="Vfs must be initialized") RefCountingContentStorage getContents() {
        RefCountingContentStorage refCountingContentStorage = this.myContents;
        if (refCountingContentStorage == null) {
            PersistentFSConnection.$$$reportNull$$$0(7);
        }
        return refCountingContentStorage;
    }

    @NotNull(value="Vfs must be initialized")
    @NotNull(value="Vfs must be initialized") Storage getAttributes() {
        Storage storage2 = this.myAttributes;
        if (storage2 == null) {
            PersistentFSConnection.$$$reportNull$$$0(8);
        }
        return storage2;
    }

    @NotNull(value="Vfs must be initialized")
    @NotNull(value="Vfs must be initialized") PersistentStringEnumerator getNames() {
        PersistentStringEnumerator persistentStringEnumerator = this.myNames;
        if (persistentStringEnumerator == null) {
            PersistentFSConnection.$$$reportNull$$$0(9);
        }
        return persistentStringEnumerator;
    }

    @NotNull(value="Vfs must be initialized")
    @NotNull(value="Vfs must be initialized") PersistentFSRecordsStorage getRecords() {
        PersistentFSRecordsStorage persistentFSRecordsStorage = this.myRecords;
        if (persistentFSRecordsStorage == null) {
            PersistentFSConnection.$$$reportNull$$$0(10);
        }
        return persistentFSRecordsStorage;
    }

    @NotNull
    IntList getFreeRecords() {
        IntList intList = this.myFreeRecords;
        if (intList == null) {
            PersistentFSConnection.$$$reportNull$$$0(11);
        }
        return intList;
    }

    long getTimestamp() throws IOException {
        return this.myRecords.getTimestamp();
    }

    int getFreeRecord() {
        return this.myFreeRecords.isEmpty() ? 0 : this.myFreeRecords.removeInt(this.myFreeRecords.size() - 1);
    }

    void createBrokenMarkerFile(@Nullable Throwable reason) {
        File brokenMarker = this.myPersistentFSPaths.getCorruptionMarkerFile();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream stream = new PrintStream(out);){
            new Exception().printStackTrace(stream);
            if (reason != null) {
                stream.print("\nReason:\n");
                reason.printStackTrace(stream);
            }
        }
        LOG.info("Creating VFS corruption marker; Trace=\n" + out);
        try (FileWriter writer = new FileWriter(brokenMarker);){
            writer.write("These files are corrupted and must be rebuilt from the scratch on next startup");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    int getPersistentModCount() throws IOException {
        return this.myRecords.getGlobalModCount();
    }

    int incGlobalModCount() throws IOException {
        this.incLocalModCount();
        return this.myRecords.incGlobalModCount();
    }

    void markDirty() throws IOException {
        assert (FSRecords.lock.isWriteLocked());
        if (!this.myDirty) {
            this.myDirty = true;
            this.myRecords.setConnectionStatus(313341156);
        }
    }

    void incLocalModCount() throws IOException {
        this.markDirty();
        ++this.myLocalModificationCount;
    }

    int getLocalModificationCount() {
        return this.myLocalModificationCount;
    }

    void doForce() throws IOException {
        if (this.myNames != null && this.myFlushingFuture != null) {
            this.myNames.force();
            this.myAttributes.force();
            this.myContents.force();
            if (this.myContentHashesEnumerator != null) {
                this.myContentHashesEnumerator.force();
            }
            this.markClean();
            this.myRecords.force();
        }
    }

    private void flush() {
        if (this.isDirty() && !HeavyProcessLatch.INSTANCE.isRunning()) {
            FSRecords.readAndHandleErrors(() -> {
                this.doForce();
                return null;
            });
        }
    }

    public boolean isDirty() {
        return this.myDirty || this.myNames.isDirty() || this.myAttributes.isDirty() || this.myContents.isDirty() || this.myRecords.isDirty() || this.myContentHashesEnumerator != null && this.myContentHashesEnumerator.isDirty();
    }

    void closeFiles() throws IOException {
        if (this.myFlushingFuture != null) {
            this.myFlushingFuture.cancel(false);
        }
        this.markClean();
        PersistentFSConnection.closeStorages(this.myRecords, this.myNames, this.myAttributes, this.myContentHashesEnumerator, this.myContents);
    }

    @NotNull
    PersistentFSPaths getPersistentFSPaths() {
        PersistentFSPaths persistentFSPaths = this.myPersistentFSPaths;
        if (persistentFSPaths == null) {
            PersistentFSConnection.$$$reportNull$$$0(12);
        }
        return persistentFSPaths;
    }

    public void incModCount(int fileId) throws IOException {
        int count = this.incGlobalModCount();
        this.getRecords().setModCount(fileId, count);
    }

    static void closeStorages(@Nullable PersistentFSRecordsStorage records, @Nullable PersistentStringEnumerator names2, @Nullable Storage attributes2, @Nullable ContentHashEnumerator contentHashesEnumerator, @Nullable RefCountingContentStorage contents) throws IOException {
        if (names2 != null) {
            names2.close();
        }
        if (attributes2 != null) {
            Disposer.dispose((Disposable)attributes2);
        }
        if (contents != null) {
            Disposer.dispose((Disposable)contents);
        }
        if (contentHashesEnumerator != null) {
            contentHashesEnumerator.close();
        }
        if (records != null) {
            records.close();
        }
    }

    void markClean() throws IOException {
        assert (FSRecords.lock.isWriteLocked() || FSRecords.lock.getReadHoldCount() != 0);
        if (this.myDirty) {
            this.myDirty = false;
            this.myRecords.setConnectionStatus(this.myCorrupted ? -1412464769 : 523190095);
        }
    }

    int getAttributeId(@NotNull String attId) throws IOException {
        if (attId == null) {
            PersistentFSConnection.$$$reportNull$$$0(13);
        }
        return this.myAttributesList.getIdRaw(attId, false) + FIRST_ATTR_ID_OFFSET;
    }

    @Contract(value="_->fail")
    void handleError(@NotNull Throwable e) throws RuntimeException, Error {
        if (e == null) {
            PersistentFSConnection.$$$reportNull$$$0(14);
        }
        assert (FSRecords.lock.getReadHoldCount() == 0);
        try {
            FSRecords.write(() -> {
                if (!this.myCorrupted) {
                    this.createBrokenMarkerFile(e);
                    this.myCorrupted = true;
                    this.doForce();
                }
            });
        }
        catch (IOException ioException) {
            LOG.error((Throwable)ioException);
        }
        ExceptionUtil.rethrow((Throwable)e);
    }

    static void ensureIdIsValid(int id2) {
        assert (id2 > 0) : id2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "Content hash enumerator must be initialized";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Vfs must be initialized";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 0;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray = new Object[n2];
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[0] = "paths";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[0] = "records";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[0] = "names";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[0] = "attributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[0] = "contents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[0] = "freeRecords";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[0] = "attId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[1] = "getFreeRecords";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[1] = "getPersistentFSPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AttrPageAwareCapacityAllocationPolicy
    extends CapacityAllocationPolicy {
        boolean myAttrPageRequested;

        AttrPageAwareCapacityAllocationPolicy() {
        }

        public int calculateCapacity(int requiredLength) {
            return Math.max(this.myAttrPageRequested ? 8 : 32, Math.min((int)((double)requiredLength * 1.2), (requiredLength / 1024 + 1) * 1024));
        }
    }
}

